/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.OutFileStackElement;
import java.util.Enumeration;

public final class HNR
extends OutFileStackElement {
    short nr;
    private String name = "";
    short tart;
    short lart;
    short level;
    int minCol;
    int maxCol;
    short linPen;
    short bruchPen;
    short umPen;
    boolean station3D;
    boolean softColoring;
    String colorList = "";

    @Override
    public boolean equals(Object object) {
        if (object instanceof HNR) {
            HNR hNR = (HNR)object;
            if (this.name == null) {
                return hNR.name == null;
            }
            return this.name.equalsIgnoreCase(hNR.name);
        }
        return false;
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int n) {
        this.nr = (short)n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getLineArt() {
        return this.lart;
    }

    public void setLineArt(int n) {
        this.lart = (short)n;
    }

    public int getTextArt() {
        return this.tart;
    }

    public void setTextArt(int n) {
        this.tart = (short)n;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = (short)n;
    }

    public int getMinColor() {
        return this.minCol;
    }

    public void setMinColor(int n) {
        this.minCol = n;
    }

    public int getMaxColor() {
        return this.maxCol;
    }

    public void setMaxColor(int n) {
        this.maxCol = n;
    }

    public boolean isStation3D() {
        return this.station3D;
    }

    public void setStation3D(boolean bl) {
        this.station3D = bl;
    }

    public int getLinPen() {
        return this.linPen;
    }

    public void setLinPen(int n) {
        this.linPen = (short)n;
    }

    public int getBruchPen() {
        return this.bruchPen;
    }

    public void setBruchPen(int n) {
        this.bruchPen = (short)n;
    }

    public int getUmPen() {
        return this.umPen;
    }

    public void setUmPen(int n) {
        this.umPen = (short)n;
    }

    public boolean isSoftColoring() {
        return this.softColoring;
    }

    public void setSoftColoring(boolean bl) {
        this.softColoring = bl;
    }

    public String getColorList() {
        return this.colorList;
    }

    public void setColorList(String string) {
        this.colorList = string;
    }

    @Override
    public final int getIdentifier() {
        return 91;
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        HNR hNR = new HNR();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        hNR.nr = Short.parseShort(string);
                        break;
                    }
                    case 1: {
                        hNR.tart = Short.parseShort(string);
                        break;
                    }
                    case 2: {
                        hNR.lart = Short.parseShort(string);
                        break;
                    }
                    case 3: {
                        hNR.name = Constants.parseString(string);
                        break;
                    }
                    case 4: {
                        hNR.station3D = Short.parseShort(string) > 0;
                        break;
                    }
                    case 5: {
                        hNR.level = Short.parseShort(string);
                        break;
                    }
                    case 6: {
                        hNR.minCol = Constants.parseColor(string);
                        break;
                    }
                    case 7: {
                        hNR.maxCol = Constants.parseColor(string);
                        break;
                    }
                    case 8: {
                        hNR.linPen = Short.parseShort(string);
                        break;
                    }
                    case 9: {
                        hNR.bruchPen = Short.parseShort(string);
                        break;
                    }
                    case 10: {
                        hNR.umPen = Short.parseShort(string);
                        break;
                    }
                    case 11: {
                        hNR.softColoring = Short.parseShort(string) > 0;
                        break;
                    }
                    case 12: {
                        hNR.colorList = Constants.parseString(string);
                    }
                }
            }
            ++n;
        }
        return hNR;
    }

    @Override
    public String toOutLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.nr);
        stringBuffer.append(',');
        if (this.tart > 0) {
            stringBuffer.append(this.tart);
        }
        stringBuffer.append(',');
        if (this.lart > 0) {
            stringBuffer.append(this.lart);
        }
        stringBuffer.append(',');
        stringBuffer.append(Constants.quotedString(this.name));
        stringBuffer.append(',');
        stringBuffer.append(this.station3D ? 1 : 0);
        stringBuffer.append(',');
        if (this.level > 0) {
            stringBuffer.append(this.level);
        }
        stringBuffer.append(',');
        if (this.minCol > 0) {
            stringBuffer.append(Constants.toColorString(this.minCol));
        }
        stringBuffer.append(',');
        if (this.maxCol > 0) {
            stringBuffer.append(Constants.toColorString(this.maxCol));
        }
        stringBuffer.append(',');
        if (this.linPen != 0) {
            stringBuffer.append(this.linPen);
        }
        stringBuffer.append(',');
        if (this.bruchPen != 0) {
            stringBuffer.append(this.bruchPen);
        }
        stringBuffer.append(',');
        if (this.umPen != 0) {
            stringBuffer.append(this.umPen);
        }
        stringBuffer.append(',');
        stringBuffer.append(this.softColoring ? 1 : 0);
        stringBuffer.append(',');
        if (this.colorList.length() > 0) {
            stringBuffer.append(Constants.quotedString(this.colorList));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getContentString() {
        return this.nr + "," + this.name;
    }
}

