/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.DataElement;
import de.geocalc.ggout.objects.DataEntryElement;
import de.geocalc.ggout.objects.Entry;
import de.geocalc.ggout.objects.EntryEnumerator;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.VoidEnumerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class HashElement
extends DataElement
implements IntegerHashObject {
    public static final int UNCHANGED = 0;
    public static final int UPDATED = 1;
    public static final int CREATED = 2;
    private static final int FLAG_USED_BY_LINE = 1;
    private static final int FLAG_USED_BY_TEXT = 2;
    private static final int FLAG_USED_BY_OBJECT_DEF = 4;
    private static final int FLAG_USED_BY_OBJECT_AUS = 8;
    private static final int FLAG_USED_BY_MENGE = 16;
    private static final int FLAG_IS_HIDDEN = 32;
    private static final int FLAG_UUID_IS_CONST_PART = 64;
    private static final int FLAG_TEMP1 = 256;
    private static final int FLAG_TEMP2 = 512;
    private static final int FLAG_IS_ONLY_REFERENCE = 1024;
    private static final int FLAG_HAS_GROUP = 2048;
    private static final int FLAG_USED_BY_GROUP = 4096;
    private static final int FLAG_USED_BY_OBJECT = 12;
    private static final int FLAG_USED = 15;
    protected static final int FLAG_PK_NAME_NO_UNIQUE = 0x100000;
    protected static final int FLAG_PK_SIZE_IS_FACTOR = 0x200000;
    protected static final int FLAG_PK_DIG_TRAFO = 0x400000;
    protected static final int FLAG_PK_DIG_DOT = 0x800000;
    protected static final int FLAG_PK_DIG_AUS = 0x1000000;
    protected static final int FLAG_PK_DIG_RAND = 0x2000000;
    protected static final int FLAG_PK_DIG_SOLL = 0x4000000;
    protected static final int FLAG_PK_IS_ANGLE_SET = 0x8000000;
    protected static final int FLAG_LI_PAT_SIDE_CHANGE = 0x100000;
    protected static final int FLAG_LI_PAT_START_CHANGE = 0x200000;
    protected static final int FLAG_LI_SIZE_IS_FACTOR = 0x400000;
    protected static final int FLAG_TE_IS_CROSSOUT = 0x100000;
    protected static final int FLAG_TE_SIZE_IS_FACTOR = 0x200000;
    protected static final int FLAG_OO_IS_NAME_KEY = 0x100000;
    protected static final int FLAG_OO_IS_AREA = 0x200000;
    protected static final int FLAG_OO_IS_LINE = 0x400000;
    protected int flags = 0;
    protected String uuid = null;
    protected byte topicality = 0;
    private String extKey = null;
    private Entry firstData;
    protected int key;

    protected void copy(HashElement hashElement) {
        super.copy(hashElement);
        this.flags = hashElement.flags;
        this.uuid = hashElement.uuid;
        this.topicality = hashElement.topicality;
        this.extKey = hashElement.extKey;
        this.firstData = hashElement.firstData;
        this.key = hashElement.key;
    }

    public boolean isReferenced() {
        return (this.flags & 0xF) != 0;
    }

    public void setUsedByLine(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isUsedByLine() {
        return (this.flags & 1) != 0;
    }

    public void setUsedByText(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isUsedByText() {
        return (this.flags & 2) != 0;
    }

    public void setDescription(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isDescription() {
        return (this.flags & 2) != 0;
    }

    public void setUsedByObjectDef(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isUsedByObjectDef() {
        return (this.flags & 4) != 0;
    }

    public void setUsedByObjectAus(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isUsedByObjectAus() {
        return (this.flags & 8) != 0;
    }

    public boolean isUsedByObject() {
        return (this.flags & 0xC) != 0;
    }

    public void setUsedByMenge(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isUsedByMenge() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isHidden() {
        return (this.flags & 0x20) != 0;
    }

    public void setHidden(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean hasGroup() {
        return (this.flags & 0x800) != 0;
    }

    public void setGroup(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public boolean isUsedByGroup() {
        return (this.flags & 0x1000) != 0;
    }

    public void setUsedByGroup(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    public void setTempFlag1(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public boolean isTempFlag1() {
        return (this.flags & 0x100) != 0;
    }

    public void setTempFlag2(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean isTempFlag2() {
        return (this.flags & 0x200) != 0;
    }

    public void setOnlyReference(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isOnlyReference() {
        return (this.flags & 0x400) != 0;
    }

    private void setUuidIsConstPart(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public abstract int getMasterKey();

    public final void setKey(int n) {
        if (n >= 0 && n < 0x1000000) {
            n += this.getMasterKey();
        }
        this.key = n;
    }

    public final int getKey() {
        return this.key;
    }

    public final Integer getKeyObject() {
        return this.key;
    }

    public final String getHexKey() {
        return Integer.toHexString(this.key);
    }

    public final String getMaskedHexKey() {
        return "#" + Integer.toHexString(this.key) + "#";
    }

    public final int getSubKey() {
        return this.key < 0x1000000 ? this.key : this.key - this.getMasterKey();
    }

    @Override
    public final int intHashKey() {
        return this.getKey();
    }

    public final int hashCode() {
        return this.getKey();
    }

    public boolean equals(Object object) {
        return object instanceof HashElement && ((HashElement)object).hashCode() == this.hashCode();
    }

    public final void addExtKey(String string) {
        if (string == null) {
            return;
        }
        this.extKey = this.extKey == null ? string : this.extKey + "," + string;
    }

    public final void insertExtKey(String string) {
        if (string == null) {
            return;
        }
        this.extKey = this.extKey == null ? string : string + "," + this.extKey;
    }

    public boolean hasExtKeys() {
        return this.extKey != null && this.extKey.length() > 0;
    }

    public final int extKeyCount() {
        return this.extKey == null ? 0 : IFormat.countChar(this.extKey, ',') + 1;
    }

    public final Enumeration extKeys() {
        return this.extKey == null ? VoidEnumerator.instance() : new StringTokenizer(this.extKey, Character.toString(','));
    }

    private boolean isUuidIsConstPart() {
        return (this.flags & 0x40) != 0;
    }

    public void setUuid(String string) {
        this.uuid = string.toUpperCase();
    }

    public String getUuid() {
        return this.isUuidIsConstPart() ? IFormat.getRightString(this.getHexKey().toUpperCase(), 8, '0') + "-" + this.uuid : this.uuid;
    }

    public boolean hasUuid() {
        return this.uuid != null && this.uuid.length() > 0;
    }

    public void trimUuid(String string) {
        try {
            if (string != null && this.uuid != null && this.uuid.length() == 36 && Integer.parseInt(this.uuid.substring(0, 8), 16) == this.getKey() && this.uuid.substring(9).equalsIgnoreCase(string)) {
                this.uuid = string;
                this.setUuidIsConstPart(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTopicality(int n) {
        this.topicality = (byte)n;
    }

    public int getTopicality() {
        return this.topicality;
    }

    public abstract boolean hasExtendAttributes();

    public boolean hasData() {
        return this.firstData != null;
    }

    public final int dataCount() {
        int n = 0;
        Entry entry = this.firstData;
        while (entry != null) {
            entry = entry.getNext();
            ++n;
        }
        return n;
    }

    public final void addData(DataEntryElement dataEntryElement) {
        Entry entry = new Entry(dataEntryElement);
        if (this.firstData == null) {
            this.firstData = entry;
        } else {
            Entry entry2 = this.firstData;
            while (entry2.getNext() != null) {
                entry2 = entry2.getNext();
            }
            entry2.setNext(entry);
        }
    }

    public final DataEntryElement dataAt(int n) throws NoSuchElementException {
        Entry entry = this.firstData;
        for (int n2 = 0; n2 < n && entry != null; entry = entry.getNext(), ++n2) {
        }
        if (entry == null) {
            throw new NoSuchElementException("Keine Sachdaten am Index " + n + " vorhanden");
        }
        return (DataEntryElement)entry.getObject();
    }

    public final DataEntryElement getData(int n) {
        for (Entry entry = this.firstData; entry != null; entry = entry.getNext()) {
            DataEntryElement dataEntryElement = (DataEntryElement)entry.getObject();
            if (dataEntryElement.getArt() != n) continue;
            return dataEntryElement;
        }
        return null;
    }

    public final Enumeration datas() {
        return new EntryEnumerator(this.firstData);
    }

    public final void removeAllData() {
        Entry entry = this.firstData;
        while (entry != null) {
            Entry entry2 = entry.getNext();
            entry.setNext(null);
            entry = entry2;
        }
        this.firstData = null;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1000: {
                return new Integer(this.getKey());
            }
            case 1001: {
                return new Integer(this.getSubKey());
            }
            case 1050: {
                return this.getUuid();
            }
            case 1051: {
                return new Integer(this.getTopicality());
            }
            case 9012: {
                return new Integer(this.getTopicality());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1000: {
                this.setKey(Constants.parseInt(object));
            }
            case 1050: {
                this.uuid = Constants.parseString(object);
            }
            case 1051: {
                this.topicality = (byte)Constants.parseInt(object);
            }
            case 9012: {
                this.topicality = (byte)Constants.parseInt(object);
            }
        }
        super.setAttribute(n, object);
    }
}

