/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.OutFileVariableElement;
import java.util.Enumeration;

public final class KEY
extends OutFileVariableElement {
    public static final char EXTKEY_DELIM = ',';
    private String schluessel;
    private short akt;
    private int link;

    public KEY() {
    }

    public KEY(String string, int n, int n2) {
        this.schluessel = string;
        this.akt = (short)n;
        this.link = n2;
    }

    @Override
    public final int getIdentifier() {
        return 61;
    }

    public String getName() {
        return this.schluessel;
    }

    public void setName(String string) {
        this.schluessel = string;
    }

    public int getAkt() {
        return this.akt;
    }

    public void setAkt(int n) {
        this.akt = (short)n;
    }

    public int getLink() {
        return this.link;
    }

    public void setLink(int n) {
        this.link = n;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 9012: {
                return new Integer(this.getAkt());
            }
            case 9013: {
                return new Integer(this.getLink());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 9012: {
                this.setAkt(Constants.parseInt(object));
                break;
            }
            case 9013: {
                this.setLink(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        KEY kEY = new KEY();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        kEY.setName(Constants.parseString(string));
                        break;
                    }
                    case 1: {
                        kEY.setAkt(Integer.parseInt(string));
                        break;
                    }
                    case 2: {
                        kEY.setLink(Constants.parseKey(string));
                    }
                }
            }
            ++n;
        }
        return kEY;
    }

    @Override
    public String toOutLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.quotedString(this.getName()));
        stringBuffer.append(',');
        stringBuffer.append(this.getAkt());
        return stringBuffer.toString();
    }

    @Override
    public String getContentString() {
        return "\"" + this.getName() + "\"," + this.getAkt() + "," + Constants.toKeyString(this.getLink());
    }
}

