/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.ColorElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.PNR;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.REF;
import de.geocalc.ggout.objects.Referenz;
import de.geocalc.ggout.objects.SizeElement;
import de.geocalc.ggout.objects.SizePropElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class LI
extends OList
implements KatalogEbeneArtElement,
SizeElement,
SizePropElement,
ColorElement {
    private Object nr1;
    private Object nr2;
    private int art;
    private Extends ex = null;

    public static boolean isNummer(Object object) {
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return false;
    }

    public LI() {
        this("", "", 0, 0);
    }

    public LI(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public LI(int n, int n2) {
        this("", "", 0, 0);
        this.setRef1(n);
        this.setRef2(n2);
    }

    public LI(String string, String string2, int n, int n2) {
        this.nr1 = string;
        this.nr2 = string2;
        this.setEbene(n);
        this.art = n2;
    }

    @Override
    public final int getIdentifier() {
        return 200;
    }

    @Override
    public final int getMasterKey() {
        return 0x2000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return this.ex != null;
    }

    @Override
    public boolean isSizeIsFactor() {
        return (this.flags & 0x400000) != 0;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    public Object getName1() {
        return this.nr1;
    }

    public void setName1(Object object) {
        this.nr1 = object;
    }

    public void setRef1(int n) {
        this.nr1 = new Referenz(n);
    }

    public Object getName2() {
        return this.nr2;
    }

    public void setName2(Object object) {
        this.nr2 = object;
    }

    public void setRef2(int n) {
        this.nr2 = new Referenz(n);
    }

    public boolean hasBogenMitte() {
        return this.ex != null && this.ex.radius1 == 0.0 && this.ex.radius2 == 2.0 && this.ex.nr3 != null;
    }

    public Object getName3() {
        return this.ex != null ? this.ex.nr3 : null;
    }

    public void setName3(Object object) {
        if (this.ex != null) {
            this.ex.nr3 = object;
        } else if (object != null) {
            this.ex = new Extends(this);
            this.ex.nr3 = object;
        }
    }

    public void setRef3(int n) {
        if (this.ex != null) {
            this.ex.nr3 = new Referenz(n);
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.nr3 = new Referenz(n);
        }
    }

    public double getRadius1() {
        return this.ex != null ? this.ex.radius1 : 0.0;
    }

    public void setRadius1(double d) {
        if (this.ex != null) {
            this.ex.radius1 = d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.radius1 = d;
        }
    }

    public double getRadius2() {
        return this.ex != null ? this.ex.radius2 : 0.0;
    }

    public void setRadius2(double d) {
        if (this.ex != null) {
            this.ex.radius2 = d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.radius2 = d;
        }
    }

    public double getA() {
        return this.ex != null ? this.ex.a : 0.0;
    }

    public void setA(double d) {
        if (this.ex != null) {
            this.ex.a = d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.a = d;
        }
    }

    public boolean isPatternSideChange() {
        return (this.flags & 0x100000) != 0;
    }

    public void setPatternSideChange(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    public boolean isPatternStartChange() {
        return (this.flags & 0x200000) != 0;
    }

    public void setPatternStartChange(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    @Override
    public double getSize() {
        return this.ex != null ? (double)this.ex.size : 0.0;
    }

    @Override
    public void setSize(double d) {
        if (this.ex != null) {
            this.ex.size = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.size = (float)d;
        }
    }

    @Override
    public double getSize2() {
        return this.ex != null ? (double)this.ex.size : 0.0;
    }

    @Override
    public void setSize2(double d) {
    }

    public double getPatternDist() {
        return this.ex != null ? (double)this.ex.patOff : 0.0;
    }

    public void setPatternDist(double d) {
        if (this.ex != null) {
            this.ex.patOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.patOff = (float)d;
        }
    }

    @Override
    public int getColor() {
        return this.ex != null ? this.ex.color : 0;
    }

    @Override
    public void setColor(int n) {
        if (this.ex != null) {
            this.ex.color = n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.color = n;
        }
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1101: {
                return this.getName1();
            }
            case 1102: {
                return this.getName2();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 4101: {
                return new Double(this.getRadius1());
            }
            case 4102: {
                return new Double(this.getRadius2());
            }
            case 4151: {
                return new Double(this.getA());
            }
            case 5001: {
                return new Boolean(this.isPatternSideChange());
            }
            case 5002: {
                return new Boolean(this.isPatternStartChange());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 5004: {
                return new Double(this.getPatternDist());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1101: {
                this.setName1(Constants.parseString(object));
                break;
            }
            case 1102: {
                this.setName2(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 4101: {
                this.setRadius1(Constants.parseDouble(object));
                break;
            }
            case 4102: {
                this.setRadius2(Constants.parseDouble(object));
                break;
            }
            case 4151: {
                this.setA(Constants.parseDouble(object));
                break;
            }
            case 5001: {
                this.setPatternSideChange(Constants.parseBoolean(object));
                break;
            }
            case 5002: {
                this.setPatternStartChange(Constants.parseBoolean(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 5004: {
                this.setPatternDist(Constants.parseDouble(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getName1());
        stringBuffer.append(',');
        stringBuffer.append(this.getName2());
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        if (this.getRadius1() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getRadius1()));
        } else if (this.hasBogenMitte()) {
            stringBuffer.append(this.getName3());
        }
        stringBuffer.append(',');
        if (this.getRadius2() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getRadius2()));
        }
        stringBuffer.append(',');
        if (this.getA() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getA()));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.isPatternSideChange() ? 1 : 0);
        stringBuffer.append(',');
        stringBuffer.append(this.isPatternStartChange() ? 1 : 0);
        stringBuffer.append(',');
        if (this.getSize() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getSize() * (this.isSizeIsFactor() ? -1.0 : 1.0)));
        }
        stringBuffer.append(',');
        stringBuffer.append(',');
        if (this.getPatternDist() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getPatternDist()));
        }
        stringBuffer.append(',');
        if (this.getColor() != 0) {
            stringBuffer.append(Constants.toColorString(this.getColor()));
        }
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 416: {
                this.addElement(POS.parseOutLine(geografOutLine));
                break;
            }
            case 63: {
                this.addElement(REF.parseOutLine(geografOutLine));
                break;
            }
            case 417: {
                this.addElement(PNR.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Objekt: " + this.getOutKey());
            }
        }
    }

    public static LI parseOutLine(GeografOutLine geografOutLine) {
        LI lI = new LI();
        lI.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        lI.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        lI.setName1(Constants.parsePNR(string));
                        break;
                    }
                    case 1: {
                        lI.setName2(Constants.parsePNR(string));
                        break;
                    }
                    case 2: {
                        Constants.parseArts(string, lI);
                        break;
                    }
                    case 3: {
                        if (string.indexOf(".") > 0) {
                            lI.setRadius1(new Double(string));
                            break;
                        }
                        lI.setName3(Constants.parsePNR(string));
                        break;
                    }
                    case 4: {
                        lI.setRadius2(new Double(string));
                        break;
                    }
                    case 5: {
                        lI.setA(new Double(string));
                        break;
                    }
                    case 6: {
                        lI.setPatternSideChange(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 7: {
                        lI.setPatternStartChange(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 8: {
                        double d = Double.parseDouble(string);
                        lI.setSize(Math.abs(d));
                        lI.setSizeIsFactor(d < 0.0);
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        lI.setPatternDist(new Double(string));
                        break;
                    }
                    case 11: {
                        lI.setColor(Constants.parseColor(string));
                    }
                }
            }
            ++n;
        }
        return lI;
    }

    @Override
    public String getContentString() {
        return String.valueOf(this.getName1()) + "-" + String.valueOf(this.getName2()) + ":" + IFormat.i04.format(this.getEbene()) + ":" + IFormat.i05.format(this.getArt());
    }

    private class Extends {
        double radius1;
        double radius2;
        double a;
        Object nr3 = "";
        float size;
        float patOff;
        int color;

        private Extends(LI lI) {
        }
    }
}

