/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.MR;
import de.geocalc.ggout.objects.MasterElement;
import de.geocalc.ggout.objects.OutFileStackElement;
import de.geocalc.ggout.objects.OutFileSubElement;
import de.geocalc.util.IntegerHashList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class MA
extends OutFileStackElement
implements MasterElement {
    protected String name;
    protected String bez;
    protected short pen;
    private IntegerHashList elements = new IntegerHashList();

    public MA() {
        this("");
    }

    public MA(String string) {
        this.name = string;
    }

    @Override
    public final int getIdentifier() {
        return 850;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof MA) {
            MA mA = (MA)object;
            if (this.name == null) {
                return mA.name == null;
            }
            return this.name.equalsIgnoreCase(mA.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPen() {
        return this.pen;
    }

    public void setPen(int n) {
        this.pen = (short)n;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 5032: {
                return new Integer(this.getPen());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 5032: {
                this.setPen(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    public String toBlkLine() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(":");
        stringBuffer.append(this.getName());
        stringBuffer.append(",");
        stringBuffer.append(this.getPen());
        return stringBuffer.toString();
    }

    public static MA parseBlkLine(String string) {
        MA mA = new MA();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() != 0) {
                if (n == 0) {
                    mA.setName(string2);
                } else {
                    if (n != 1) break;
                    mA.setPen(Integer.parseInt(string2));
                }
            }
            ++n;
        }
        return mA;
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        MA mA = new MA();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        mA.setName(string);
                        break;
                    }
                    case 1: {
                        mA.setPen(Integer.parseInt(string));
                        break;
                    }
                    default: {
                        if (!string.startsWith("pen:")) break;
                        mA.setPen(Integer.parseInt(string.substring(4)));
                    }
                }
            }
            ++n;
        }
        return mA;
    }

    @Override
    public String toOutLine() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.name != null ? this.name : "");
        stringBuffer.append(',');
        stringBuffer.append(',');
        stringBuffer.append(Constants.quotedString(this.bez != null ? this.bez : ""));
        Enumeration enumeration = this.elements.sortedElements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n  ");
            ((OutFileSubElement)enumeration.nextElement()).appendToOutLine(stringBuffer, 0);
        }
        stringBuffer.append("\nME:");
        return stringBuffer.toString();
    }

    @Override
    public String getContentString() {
        return this.name;
    }

    public boolean contains(int n) {
        return this.elements.containsKey(n);
    }

    @Override
    public int elementCount() {
        return this.elements.size();
    }

    @Override
    public void addElement(Object object) {
        this.elements.put((MR)object);
    }

    @Override
    public Object elementAt(int n) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public Enumeration elements() {
        return this.elements.elements();
    }
}

