/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.OOX;
import de.geocalc.ggout.objects.XYElement;
import java.util.Enumeration;

public class OO
extends OOX
implements XYElement {
    protected double x;
    protected double y;
    private Extends ex = null;

    public OO() {
        this("", 0.0, 0.0, 0, 0, 0);
    }

    public OO(double d, double d2) {
        this("", d, d2, 0, 0, 0);
    }

    public OO(String string, double d, double d2, int n, int n2) {
        this(string, d, d2, n, n2, 0);
    }

    public OO(String string, double d, double d2, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.x = d;
        this.y = d2;
    }

    @Override
    public int getIdentifier() {
        return 600;
    }

    @Override
    public boolean hasExtendAttributes() {
        return this.ex != null;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    public double getXOff() {
        return this.ex != null ? (double)this.ex.xOff : 0.0;
    }

    public void setXOff(double d) {
        if (this.ex != null) {
            this.ex.xOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.xOff = (float)d;
        }
    }

    public double getYOff() {
        return this.ex != null ? (double)this.ex.yOff : 0.0;
    }

    public void setYOff(double d) {
        if (this.ex != null) {
            this.ex.yOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.yOff = (float)d;
        }
    }

    public int getAnsatz() {
        return this.ex != null ? this.ex.ansatz : 0;
    }

    public void setAnsatz(int n) {
        if (this.ex != null) {
            this.ex.ansatz = n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.ansatz = n;
        }
    }

    public int getLageStatus() {
        return this.ex != null ? (int)this.ex.statl : 2;
    }

    public void setLageStatus(int n) {
        if (this.ex != null) {
            this.ex.statl = (byte)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.statl = (byte)n;
        }
    }

    public int getOberObject() {
        return this.ex != null ? this.ex.ober : 0;
    }

    public void setOberObject(int n) {
        if (n > 0 && n < 0xA000000) {
            n += 0xA000000;
        }
        if (this.ex != null) {
            this.ex.ober = n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.ober = n;
        }
    }

    public String getAreaOska() {
        return this.ex != null ? this.ex.areaOska : null;
    }

    public void setAreaOska(String string) {
        if (this.ex != null) {
            this.ex.areaOska = string;
        } else if (string != null) {
            this.ex = new Extends(this);
            this.ex.areaOska = string;
        }
    }

    public boolean isNameKey() {
        return (this.flags & 0x100000) != 0;
    }

    public void setNameKey(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 2001: {
                return new Double(this.getX());
            }
            case 2002: {
                return new Double(this.getY());
            }
            case 2101: {
                return new Double(this.getXOff());
            }
            case 2102: {
                return new Double(this.getYOff());
            }
            case 9001: {
                return new Integer(this.getAnsatz());
            }
            case 2501: {
                return new Integer(this.getLageStatus());
            }
            case 9021: {
                return new Integer(this.getOberObject());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 2001: {
                this.setX(Constants.parseDouble(object));
                break;
            }
            case 2002: {
                this.setY(Constants.parseDouble(object));
                break;
            }
            case 2101: {
                this.setXOff(Constants.parseDouble(object));
                break;
            }
            case 2102: {
                this.setYOff(Constants.parseDouble(object));
                break;
            }
            case 9001: {
                this.setAnsatz(Constants.parseInt(object));
                break;
            }
            case 2501: {
                this.setLageStatus(Constants.parseInt(object));
                break;
            }
            case 9021: {
                this.setOberObject(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.quotedString(this.getName()));
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        if (this.getX() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getX()));
        }
        stringBuffer.append(',');
        if (this.getY() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getY()));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.getTyp());
        stringBuffer.append(',');
        if (this.getDatum() != null) {
            stringBuffer.append(this.getDatum());
        }
        stringBuffer.append(',');
        if (this.getAnsatz() != 0) {
            stringBuffer.append(this.getAnsatz());
        }
        stringBuffer.append(',');
        if (this.getXOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getYOff()));
        }
        stringBuffer.append(',');
        if (this.getYOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getXOff()));
        }
        stringBuffer.append(',');
        if (this.getLageStatus() != 2) {
            stringBuffer.append(this.getLageStatus());
        }
        stringBuffer.append(',');
        if (this.getOberObject() != 0) {
            stringBuffer.append(this.getOberObject() % 0xA000000);
        }
        stringBuffer.append(',');
        if (this.getAreaOska() != null) {
            stringBuffer.append(this.getAreaOska());
        }
        stringBuffer.append(',');
        stringBuffer.append(this.isNameKey() ? (char)'S' : 'T');
        stringBuffer.append(',');
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        OO oO = new OO();
        oO.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        oO.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        oO.setName(Constants.parseString(string));
                        break;
                    }
                    case 1: {
                        Constants.parseArts(string, oO);
                        break;
                    }
                    case 2: {
                        oO.setX(new Double(string));
                        break;
                    }
                    case 3: {
                        oO.setY(new Double(string));
                        break;
                    }
                    case 4: {
                        oO.setTyp(Integer.parseInt(string));
                        break;
                    }
                    case 5: {
                        oO.setDatum(string);
                        break;
                    }
                    case 6: {
                        oO.setAnsatz(Integer.parseInt(string));
                        break;
                    }
                    case 7: {
                        oO.setXOff(new Double(string));
                        break;
                    }
                    case 8: {
                        oO.setYOff(new Double(string));
                        break;
                    }
                    case 9: {
                        oO.setLageStatus(Integer.parseInt(string));
                        break;
                    }
                    case 10: {
                        oO.setOberObject(string.startsWith("{") || string.startsWith("OO") ? Constants.parseKey(string) : Integer.parseInt(string));
                        break;
                    }
                    case 11: {
                        oO.setAreaOska(string);
                        break;
                    }
                    case 12: {
                        oO.setNameKey(string.startsWith("S"));
                    }
                }
            }
            ++n;
        }
        return oO;
    }

    private class Extends {
        int ansatz;
        float xOff;
        float yOff;
        byte statl = (byte)2;
        int ober;
        String areaOska = null;

        private Extends(OO oO) {
        }
    }
}

