/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OR;
import de.geocalc.ggout.objects.OVector;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class OOX
extends OVector
implements KatalogEbeneArtElement {
    public static final int TYP_NORMAL = 0;
    public static final int TYP_SPLINE = 1;
    public static final int TYP_TEXT = 2;
    protected String name;
    protected int art;
    protected byte typ;
    protected String datum;

    public OOX() {
        this("", 0, 0, 0);
    }

    public OOX(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public OOX(String string, int n, int n2, int n3) {
        this.name = string;
        this.setEbene(n);
        this.art = n2;
        this.typ = (byte)n3;
    }

    @Override
    public int getIdentifier() {
        return 601;
    }

    @Override
    public final int getMasterKey() {
        return 0xA000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getTyp() {
        return this.typ;
    }

    public void setTyp(int n) {
        this.typ = (byte)n;
    }

    public String getDatum() {
        return this.datum;
    }

    public void setDatum(String string) {
        this.datum = string != null ? string.intern() : null;
    }

    public boolean isAreaType() {
        return (this.flags & 0x200000) != 0;
    }

    public void setAreaType(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    public boolean isLineType() {
        return (this.flags & 0x400000) != 0;
    }

    public void setLineType(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 1521: {
                return new Integer(this.getTyp());
            }
            case 9011: {
                return this.getDatum();
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 1521: {
                this.setTyp(Constants.parseInt(object));
                break;
            }
            case 9011: {
                this.setDatum(Constants.parseString(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        Object object = this.getName();
        object = object == null ? "" : "\"" + (String)object + "\"";
        stringBuffer.append((String)object);
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(this.getTyp());
        stringBuffer.append(',');
        if (this.getDatum() != null) {
            stringBuffer.append(this.getDatum());
        }
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 602: {
                this.addElement(OR.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Objekt: " + this.getOutKey());
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        OOX oOX = new OOX();
        oOX.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            string = string.substring(1, string.length() - 1);
                        }
                        oOX.setName(string);
                        break;
                    }
                    case 1: {
                        Constants.parseArts(string, oOX);
                        break;
                    }
                    case 2: {
                        oOX.setTyp(Integer.parseInt(string));
                        break;
                    }
                    case 3: {
                        oOX.setDatum(string);
                    }
                }
            }
            ++n;
        }
        return oOX;
    }

    @Override
    public String getContentString() {
        return this.getName() + ":" + IFormat.i04.format(this.getEbene()) + ":" + IFormat.i05.format(this.getArt());
    }
}

