/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AngleElement;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OutFileSubElement;
import de.geocalc.ggout.objects.SizeElement;
import de.geocalc.ggout.objects.SubElement;
import java.util.Enumeration;

public final class OS
extends OutFileSubElement
implements KatalogEbeneArtElement,
AngleElement,
SizeElement {
    protected short eb;
    protected short kat;
    protected int art;
    protected float abstand;
    protected double winkel;
    protected byte subTyp;
    protected int color;

    @Override
    public final int getIdentifier() {
        return 603;
    }

    @Override
    public final void setKatalog(int n) {
        this.kat = (short)n;
    }

    @Override
    public final int getKatalog() {
        return this.kat;
    }

    @Override
    public final void setEbene(int n) {
        this.eb = (short)n;
    }

    @Override
    public final int getEbene() {
        return this.eb;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public double getSize() {
        return this.abstand;
    }

    @Override
    public void setSize(double d) {
        this.abstand = (float)d;
    }

    @Override
    public double getAngle() {
        return this.winkel;
    }

    @Override
    public void setAngle(double d) {
        this.winkel = d;
    }

    @Override
    public boolean isAngleSet() {
        return true;
    }

    @Override
    public void setAngleSet(boolean bl) {
    }

    public int getSubTyp() {
        return this.subTyp;
    }

    public void setSubTyp(int n) {
        this.subTyp = (byte)n;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int outLineColumns() {
        return 6;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                return new Integer(this.getArt());
            }
            case 4001: {
                return new Double(this.getAngle());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 5021: {
                return new Integer(this.getSubTyp());
            }
            case 5031: {
                return new Integer(this.getColor());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 4001: {
                this.setAngle(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 5021: {
                this.setSubTyp(Constants.parseInt(object));
                break;
            }
            case 5031: {
                this.setColor(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    public static SubElement parseOutLine(GeografOutLine geografOutLine) {
        OS oS = new OS();
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        Constants.parseArts(string, oS);
                        break;
                    }
                    case 1: {
                        oS.abstand = new Float(string).floatValue();
                        break;
                    }
                    case 2: {
                        oS.winkel = new Double(string);
                        break;
                    }
                    case 3: {
                        oS.subTyp = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 4: {
                        oS.color = Constants.parseColor(string);
                    }
                }
            }
            ++n;
        }
        return oS;
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getOutKey(n));
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(this.abstand);
        stringBuffer.append(',');
        stringBuffer.append(this.winkel);
        stringBuffer.append(',');
        stringBuffer.append(this.subTyp);
        stringBuffer.append(',');
        if (this.color != 0) {
            stringBuffer.append(Constants.toColorString(this.color));
        }
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt();
    }
}

