/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.objects.OVectorEnumerator;
import de.geocalc.ggout.objects.OutFileSubElement;
import de.geocalc.ggout.objects.SuperElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class OVector
extends SuperElement
implements Cloneable {
    protected Object[] elementData;
    protected int elementCount;

    public OVector(int n) {
        this.elementData = new Object[n];
    }

    public OVector() {
        this(2);
    }

    @Override
    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    @Override
    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public final synchronized Enumeration elements() {
        return new OVectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    @Override
    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    @Override
    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    @Override
    public void removeFirstElement() {
        this.removeElementAt(0);
    }

    @Override
    public void removeLastElement() {
        this.removeElementAt(this.elementCount - 1);
    }

    public int removeDuplicates() {
        int n = 0;
        for (int i = this.elementCount - 1; i > 0; --i) {
            if (!this.elementData[i].equals(this.elementData[i - 1])) continue;
            this.removeElementAt(i);
            ++n;
        }
        this.trimToSize();
        return n;
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    @Override
    public final synchronized void addElement(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public final synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    @Override
    public synchronized Object clone() {
        try {
            OVector oVector = (OVector)super.clone();
            oVector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, oVector.elementData, 0, this.elementCount);
            return oVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int elementCount() {
        return this.size();
    }

    @Override
    public final void appendToOutLine(StringBuffer stringBuffer) {
        this.appendDefToOutLine(stringBuffer);
        for (int i = 0; i < this.elementCount; ++i) {
            stringBuffer.append("\n  ");
            Object object = this.elementData[i];
            if (object instanceof OutFileSubElement) {
                ((OutFileSubElement)object).appendToOutLine(stringBuffer, this.getSubKey());
                continue;
            }
            stringBuffer.append(this.toString());
        }
    }
}

