/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.NameElement;
import de.geocalc.ggout.objects.SingleElement;
import java.util.Enumeration;

public final class PB
extends SingleElement
implements KatalogEbeneArtElement,
NameElement {
    protected String name = "";
    protected int art;
    protected double lux;
    protected double luy;
    protected double rux;
    protected double ruy;
    protected double hoehe;

    @Override
    public final int getIdentifier() {
        return 81;
    }

    @Override
    public final int getMasterKey() {
        return 0xD000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PB) {
            PB pB = (PB)object;
            if (this.name == null) {
                return pB.name == null;
            }
            return this.name.equalsIgnoreCase(pB.name);
        }
        return false;
    }

    @Override
    public boolean hasName() {
        return this.name != null && this.name.length() > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = (short)n;
    }

    public double getXLU() {
        return this.lux;
    }

    public void setXLU(double d) {
        this.lux = d;
    }

    public double getYLU() {
        return this.luy;
    }

    public void setYLU(double d) {
        this.luy = d;
    }

    public double getXRU() {
        return this.rux;
    }

    public void setXRU(double d) {
        this.rux = d;
    }

    public double getYRU() {
        return this.ruy;
    }

    public void setYRU(double d) {
        this.ruy = d;
    }

    public double getHoehe() {
        return this.hoehe;
    }

    public void setHoehe(double d) {
        this.hoehe = d;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 2011: {
                return new Double(this.getXLU());
            }
            case 2012: {
                return new Double(this.getYLU());
            }
            case 2021: {
                return new Double(this.getXRU());
            }
            case 2022: {
                return new Double(this.getYRU());
            }
            case 4011: {
                return new Double(this.getHoehe());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 2011: {
                this.setXLU(Constants.parseDouble(object));
                break;
            }
            case 2012: {
                this.setYLU(Constants.parseDouble(object));
                break;
            }
            case 2021: {
                this.setXRU(Constants.parseDouble(object));
                break;
            }
            case 2022: {
                this.setYRU(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setHoehe(Constants.parseDouble(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getName());
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(this.getXLU());
        stringBuffer.append(',');
        stringBuffer.append(this.getYLU());
        stringBuffer.append(',');
        stringBuffer.append(this.getXRU());
        stringBuffer.append(',');
        stringBuffer.append(this.getYRU());
        stringBuffer.append(',');
        stringBuffer.append(this.getHoehe());
    }

    public static PB parseOutLine(GeografOutLine geografOutLine) {
        PB pB = new PB();
        pB.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        pB.setName(string);
                        break;
                    }
                    case 1: {
                        Constants.parseArts(string, pB);
                        break;
                    }
                    case 2: {
                        pB.setXLU(new Double(string));
                        break;
                    }
                    case 3: {
                        pB.setYLU(new Double(string));
                        break;
                    }
                    case 4: {
                        pB.setXRU(new Double(string));
                        break;
                    }
                    case 5: {
                        pB.setYRU(new Double(string));
                        break;
                    }
                    case 6: {
                        pB.setHoehe(new Double(string));
                    }
                }
            }
            ++n;
        }
        return pB;
    }

    @Override
    public String getContentString() {
        return this.name;
    }
}

