/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.geom.Koordinate3D;
import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.ColorElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KS;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.SymbolElement;
import de.geocalc.ggout.objects.XYZElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public final class PK
extends OList
implements KatalogEbeneArtElement,
XYZElement,
SymbolElement,
ColorElement,
Koordinate3D,
Cloneable {
    public static final int UNGENAU = 0;
    public static final int DIGITALISIERT = 1;
    public static final int GEMESSEN = 2;
    public static final int FEST = 3;
    private String nr;
    private int art;
    private double x;
    private double y;
    private double z;
    private byte statL = (byte)2;
    private byte statH = (byte)2;
    private int ansatz;
    private float angle;
    private String datum;
    private Extends ex = null;

    public PK() {
        this("", 0.0, 0.0, 0.0, 0, 0);
    }

    public PK(double d, double d2) {
        this("", d, d2, 0.0, 0, 0);
    }

    public PK(double d, double d2, double d3) {
        this("", d, d2, d3, 0, 0);
    }

    public PK(String string, double d, double d2) {
        this(string, d, d2, 0.0, 0, 0);
    }

    public PK(String string, double d, double d2, int n, int n2) {
        this(string, d, d2, 0.0, n, n2);
    }

    public PK(String string, double d, double d2, double d3, int n, int n2) {
        this.nr = string;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.setEbene(n);
        this.art = n2;
        this.setLageStatus(2);
        this.setHoeheStatus(2);
    }

    @Override
    public boolean hasExtendAttributes() {
        return this.ex != null;
    }

    public boolean isNameNoUnique() {
        return (this.flags & 0x100000) != 0;
    }

    public void setNameNoUnique(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    @Override
    public boolean isSizeIsFactor() {
        return (this.flags & 0x200000) != 0;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    @Override
    public boolean isAngleSet() {
        return (this.flags & 0x8000000) != 0;
    }

    @Override
    public void setAngleSet(boolean bl) {
        this.flags = bl ? (this.flags |= 0x8000000) : (this.flags &= 0xF7FFFFFF);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public final int getIdentifier() {
        return 100;
    }

    @Override
    public final int getMasterKey() {
        return 0x1000000;
    }

    public boolean isVoid() {
        return this.getKatalog() == 0 && this.getEbene() == 0 && this.getArt() == 0 && !this.hasName();
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    public boolean hasName() {
        return this.nr != null && this.nr.length() != 0;
    }

    public String getName() {
        return this.nr;
    }

    public void setName(String string) {
        int n;
        if (string != null && (n = string.length()) > 2 && string.charAt(0) == '#' && string.charAt(n - 1) == '#' && this.getKey() == Integer.parseInt(string.substring(1, n - 1), 16)) {
            return;
        }
        this.nr = string;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setZ(double d) {
        this.z = d;
    }

    public int getLageStatus() {
        return this.statL;
    }

    public void setLageStatus(int n) {
        this.statL = (byte)n;
    }

    public int getHoeheStatus() {
        return this.statH;
    }

    public void setHoeheStatus(int n) {
        this.statH = (byte)n;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double d) {
        this.setAngleSet(true);
        this.angle = (float)d;
    }

    @Override
    public double getSize() {
        return this.ex != null ? (double)this.ex.size : 0.0;
    }

    @Override
    public void setSize(double d) {
        if (this.ex != null) {
            this.ex.size = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.size = (float)d;
        }
    }

    @Override
    public double getSize2() {
        return this.ex != null ? (double)this.ex.size2 : 0.0;
    }

    @Override
    public void setSize2(double d) {
        if (this.ex != null) {
            this.ex.size2 = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.size2 = (float)d;
        }
    }

    public double getXOff() {
        return this.ex != null ? (double)this.ex.xOff : 0.0;
    }

    public void setXOff(double d) {
        if (this.ex != null) {
            this.ex.xOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.xOff = (float)d;
        }
    }

    public double getYOff() {
        return this.ex != null ? (double)this.ex.yOff : 0.0;
    }

    public void setYOff(double d) {
        if (this.ex != null) {
            this.ex.yOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.yOff = (float)d;
        }
    }

    public double getZOff() {
        return this.ex != null ? (double)this.ex.zOff : 0.0;
    }

    public void setZOff(double d) {
        if (this.ex != null) {
            this.ex.zOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.zOff = (float)d;
        }
    }

    public int getAnsatz() {
        return this.ansatz;
    }

    public void setAnsatz(int n) {
        this.ansatz = n;
    }

    public String getDatum() {
        return this.datum;
    }

    public void setDatum(String string) {
        this.datum = string != null ? string.intern() : null;
    }

    public boolean isDigTrafo() {
        return (this.flags & 0x400000) != 0;
    }

    public void setDigTrafo(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    public boolean isDigDot() {
        return (this.flags & 0x800000) != 0;
    }

    public void setDigDot(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800000) : (this.flags &= 0xFF7FFFFF);
    }

    public boolean isDigAus() {
        return (this.flags & 0x1000000) != 0;
    }

    public void setDigAus(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    public boolean isDigRand() {
        return (this.flags & 0x2000000) != 0;
    }

    public void setDigRand(boolean bl) {
        this.flags = bl ? (this.flags |= 0x2000000) : (this.flags &= 0xFDFFFFFF);
    }

    public boolean isDigSoll() {
        return (this.flags & 0x4000000) != 0;
    }

    public void setDigSoll(boolean bl) {
        this.flags = bl ? (this.flags |= 0x4000000) : (this.flags &= 0xFBFFFFFF);
    }

    public int getDigGew() {
        return this.ex != null ? (int)this.ex.digGew : 0;
    }

    public void setDigGew(int n) {
        if (this.ex != null) {
            this.ex.digGew = (short)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.digGew = (short)n;
        }
    }

    public int getLageGew() {
        return this.ex != null ? (int)this.ex.lGew : 1;
    }

    public void setLageGew(int n) {
        if (this.ex != null) {
            this.ex.lGew = (short)n;
        } else if (n > 1) {
            this.ex = new Extends(this);
            this.ex.lGew = (short)n;
        }
    }

    public int getHoeheGew() {
        return this.ex != null ? (int)this.ex.hGew : 1;
    }

    public void setHoeheGew(int n) {
        if (this.ex != null) {
            this.ex.hGew = (short)n;
        } else if (n > 1) {
            this.ex = new Extends(this);
            this.ex.hGew = (short)n;
        }
    }

    public int getLageCtrl() {
        return this.ex != null ? (int)this.ex.lCtrl : 0;
    }

    public void setLageCtrl(int n) {
        if (this.ex != null) {
            this.ex.lCtrl = (short)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.lCtrl = (short)n;
        }
    }

    public int getHoeheCtrl() {
        return this.ex != null ? (int)this.ex.hCtrl : 0;
    }

    public void setHoeheCtrl(int n) {
        if (this.ex != null) {
            this.ex.hCtrl = (short)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.hCtrl = (short)n;
        }
    }

    @Override
    public int getColor() {
        return this.ex != null ? this.ex.color : 0;
    }

    @Override
    public void setColor(int n) {
        if (this.ex != null) {
            this.ex.color = n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.color = n;
        }
    }

    @Override
    public int getSymbol() {
        return this.ex != null ? (int)this.ex.symbol : 0;
    }

    @Override
    public void setSymbol(int n) {
        if (this.ex != null) {
            this.ex.symbol = (short)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.symbol = (short)n;
        }
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 2001: {
                return new Double(this.getX());
            }
            case 2002: {
                return new Double(this.getY());
            }
            case 3001: {
                return new Double(this.getZ());
            }
            case 4001: {
                return new Double(this.getAngle());
            }
            case 2501: {
                return new Integer(this.getLageStatus());
            }
            case 3501: {
                return new Integer(this.getHoeheStatus());
            }
            case 2101: {
                return new Double(this.getXOff());
            }
            case 2102: {
                return new Double(this.getYOff());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 9001: {
                return new Integer(this.getAnsatz());
            }
            case 9011: {
                return this.getDatum();
            }
            case 2901: {
                return new Boolean(this.isDigTrafo());
            }
            case 2902: {
                return new Boolean(this.isDigDot());
            }
            case 2903: {
                return new Boolean(this.isDigAus());
            }
            case 2904: {
                return new Boolean(this.isDigRand());
            }
            case 2905: {
                return new Boolean(this.isDigSoll());
            }
            case 3101: {
                return new Double(this.getZOff());
            }
            case 2601: {
                return new Integer(this.getLageGew());
            }
            case 3601: {
                return new Integer(this.getHoeheGew());
            }
            case 2602: {
                return new Integer(this.getLageCtrl());
            }
            case 3602: {
                return new Integer(this.getHoeheCtrl());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 2001: {
                this.setX(Constants.parseDouble(object));
                break;
            }
            case 2002: {
                this.setY(Constants.parseDouble(object));
                break;
            }
            case 3001: {
                this.setZ(Constants.parseDouble(object));
                break;
            }
            case 4001: {
                this.setAngle(Constants.parseDouble(object));
                break;
            }
            case 2501: {
                this.setLageStatus(Constants.parseInt(object));
                break;
            }
            case 3501: {
                this.setHoeheStatus(Constants.parseInt(object));
                break;
            }
            case 2101: {
                this.setXOff(Constants.parseDouble(object));
                break;
            }
            case 2102: {
                this.setYOff(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 9001: {
                this.setAnsatz(Constants.parseInt(object));
                break;
            }
            case 9011: {
                this.setDatum(Constants.parseString(object));
                break;
            }
            case 2901: {
                this.setDigTrafo(Constants.parseBoolean(object));
                break;
            }
            case 2902: {
                this.setDigDot(Constants.parseBoolean(object));
                break;
            }
            case 2903: {
                this.setDigAus(Constants.parseBoolean(object));
                break;
            }
            case 2904: {
                this.setDigRand(Constants.parseBoolean(object));
                break;
            }
            case 2905: {
                this.setDigSoll(Constants.parseBoolean(object));
                break;
            }
            case 3101: {
                this.setZOff(Constants.parseDouble(object));
                break;
            }
            case 2601: {
                this.setLageGew(Constants.parseInt(object));
                break;
            }
            case 3601: {
                this.setHoeheGew(Constants.parseInt(object));
                break;
            }
            case 2602: {
                this.setLageCtrl(Constants.parseInt(object));
                break;
            }
            case 3602: {
                this.setHoeheCtrl(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public final void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getName() != null && !this.isNameNoUnique() ? this.getName() : "");
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getX()));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getY()));
        stringBuffer.append(',');
        if (this.getZ() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getZ()));
        }
        stringBuffer.append(',');
        if (this.isAngleSet()) {
            stringBuffer.append(Constants.doubleString(this.getAngle()));
        }
        stringBuffer.append(',');
        if (this.getLageStatus() != 2) {
            stringBuffer.append(this.getLageStatus());
        }
        stringBuffer.append(',');
        if (this.getHoeheStatus() != 2) {
            stringBuffer.append(this.getHoeheStatus());
        }
        stringBuffer.append(',');
        if (this.getXOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getXOff()));
        }
        stringBuffer.append(',');
        if (this.getYOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getYOff()));
        }
        stringBuffer.append(',');
        if (this.getSize() != 0.0 && !this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize()));
        }
        stringBuffer.append(',');
        if ((double)this.getAnsatz() != 0.0) {
            stringBuffer.append(this.getAnsatz());
        }
        stringBuffer.append(',');
        if (this.getDatum() != null) {
            stringBuffer.append(this.getDatum());
        }
        stringBuffer.append(',');
        stringBuffer.append(this.isDigTrafo() ? 1 : 0);
        stringBuffer.append(',');
        if (this.isDigDot()) {
            stringBuffer.append(1);
        }
        stringBuffer.append(',');
        stringBuffer.append(this.isDigAus() ? 1 : 0);
        stringBuffer.append(',');
        stringBuffer.append(this.isDigRand() ? 1 : 0);
        stringBuffer.append(',');
        stringBuffer.append(this.getDigGew());
        stringBuffer.append(',');
        stringBuffer.append(this.isDigSoll() ? 1 : 0);
        stringBuffer.append(',');
        if (this.getZOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getZOff()));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.getLageGew());
        stringBuffer.append(',');
        stringBuffer.append(this.getHoeheGew());
        stringBuffer.append(',');
        stringBuffer.append(this.getLageCtrl());
        stringBuffer.append(',');
        stringBuffer.append(this.getHoeheCtrl());
        stringBuffer.append(',');
        stringBuffer.append(this.getName() != null && this.isNameNoUnique() ? this.getName() : "");
        stringBuffer.append(',');
        if (this.getSize() != 0.0 && this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize()));
        }
        stringBuffer.append(',');
        if (this.getSize2() != 0.0 && !this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize2()));
        }
        stringBuffer.append(',');
        if (this.getSize2() != 0.0 && this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize2()));
        }
        stringBuffer.append(',');
        if (this.getColor() != 0) {
            stringBuffer.append(Constants.toColorString(this.getColor()));
        }
        stringBuffer.append(',');
        if (this.getSymbol() != 0) {
            stringBuffer.append(this.getSymbol());
        }
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 112: {
                this.addElement(KS.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Punkt: " + this.getOutKey());
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        PK pK = new PK();
        pK.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        pK.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        pK.setName(string);
                        break;
                    }
                    case 1: {
                        Constants.parseArts(string, pK);
                        break;
                    }
                    case 2: {
                        pK.setX(new Double(string));
                        break;
                    }
                    case 3: {
                        pK.setY(new Double(string));
                        break;
                    }
                    case 4: {
                        pK.setZ(new Double(string));
                        break;
                    }
                    case 5: {
                        pK.setAngle(new Double(string));
                        break;
                    }
                    case 6: {
                        pK.setLageStatus(Integer.parseInt(string));
                        break;
                    }
                    case 7: {
                        pK.setHoeheStatus((byte)Integer.parseInt(string));
                        break;
                    }
                    case 8: {
                        pK.setXOff(new Double(string));
                        break;
                    }
                    case 9: {
                        pK.setYOff(new Double(string));
                        break;
                    }
                    case 10: {
                        pK.setSize(new Double(string));
                        break;
                    }
                    case 11: {
                        pK.setAnsatz(Integer.parseInt(string));
                        break;
                    }
                    case 12: {
                        pK.setDatum(string);
                        break;
                    }
                    case 13: {
                        pK.setDigTrafo(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 14: {
                        pK.setDigDot(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 15: {
                        pK.setDigAus(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 16: {
                        pK.setDigRand(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 17: {
                        pK.setDigGew(Integer.parseInt(string));
                        break;
                    }
                    case 18: {
                        pK.setDigSoll(Integer.parseInt(string) != 0);
                        break;
                    }
                    case 19: {
                        pK.setZOff(new Double(string));
                        break;
                    }
                    case 20: {
                        pK.setLageGew(Integer.parseInt(string));
                        break;
                    }
                    case 21: {
                        pK.setHoeheGew(Integer.parseInt(string));
                        break;
                    }
                    case 22: {
                        pK.setLageCtrl(Integer.parseInt(string));
                        break;
                    }
                    case 23: {
                        pK.setHoeheCtrl(Integer.parseInt(string));
                        break;
                    }
                    case 24: {
                        pK.setName(string);
                        pK.setNameNoUnique(true);
                        break;
                    }
                    case 25: {
                        pK.setSize(Double.parseDouble(string));
                        pK.setSizeIsFactor(true);
                        break;
                    }
                    case 26: {
                        pK.setSize2(Double.parseDouble(string));
                        break;
                    }
                    case 27: {
                        pK.setSize2(Double.parseDouble(string));
                        pK.setSizeIsFactor(true);
                        break;
                    }
                    case 28: {
                        pK.setColor(Constants.parseColor(string));
                        break;
                    }
                    case 29: {
                        pK.setSymbol(Integer.parseInt(string));
                    }
                }
            }
            ++n;
        }
        return pK;
    }

    @Override
    public String getContentString() {
        return this.getName() + ":" + IFormat.i04.format(this.getEbene()) + ":" + IFormat.i05.format(this.getArt());
    }

    private class Extends {
        short digGew;
        short lGew = 1;
        short hGew = 1;
        short lCtrl;
        short hCtrl;
        short symbol;
        float xOff;
        float yOff;
        float zOff;
        float size;
        float size2;
        int color;

        private Extends(PK pK) {
        }
    }
}

