/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.OutFileSubElement;
import de.geocalc.ggout.objects.POS3d;
import de.geocalc.ggout.objects.SubElement;
import de.geocalc.ggout.objects.XYZElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class POS
extends OutFileSubElement
implements XYZElement {
    public static final double GEOM_BREAK = -1.0E100;
    public static final double GEOM_KREIS = 1.0E100;
    public static final double GEOM_BOG_N = 1.0E101;
    public static final double GEOM_BOG_I = 1.0E102;
    public static final double GEOM_CODE = 1.0E103;
    public static final double GEOM_BOG_3 = 1.0E104;
    private double x;
    private double y;

    public static POS create(double d, double d2, double d3) {
        return d3 != 0.0 ? new POS3d(d, d2, d3) : new POS(d, d2);
    }

    public static POS create(double d, double d2) {
        return new POS(d, d2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof POS) {
            POS pOS = (POS)object;
            return Constants.roundCoo(this.getX()) == Constants.roundCoo(pOS.getX()) && Constants.roundCoo(this.getY()) == Constants.roundCoo(pOS.getY()) && Constants.roundCoo(this.getZ()) == Constants.roundCoo(pOS.getZ());
        }
        return false;
    }

    protected POS() {
        this(0.0, 0.0);
    }

    protected POS(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    @Override
    public final int getIdentifier() {
        return 416;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    @Override
    public double getZ() {
        return 0.0;
    }

    @Override
    public void setZ(double d) {
        new Exception().printStackTrace();
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 2001: {
                return new Double(this.getX());
            }
            case 2002: {
                return new Double(this.getY());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 2001: {
                this.setX(Constants.parseDouble(object));
                break;
            }
            case 2002: {
                this.setY(Constants.parseDouble(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    public static SubElement parseOutLine(GeografOutLine geografOutLine) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        d = Double.parseDouble(string);
                        break;
                    }
                    case 1: {
                        d2 = Double.parseDouble(string);
                        break;
                    }
                    case 2: {
                        d3 = Double.parseDouble(string);
                    }
                }
            }
            ++n;
        }
        return POS.create(d, d2, d3);
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getOutKey(n));
        stringBuffer.append(Math.abs(this.getX()) >= 1.0E100 ? IFormat.e1.format(this.getX()) : Constants.doubleString(this.getX()));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getY()));
        if (this.getZ() != 0.0) {
            stringBuffer.append(',');
            stringBuffer.append(Constants.doubleString(this.getZ()));
        }
    }

    @Override
    public String getContentString() {
        return this.x + "," + this.y;
    }
}

