/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.EbeneArtElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.GeoRefElement;
import de.geocalc.ggout.objects.NameElement;
import de.geocalc.ggout.objects.SingleElement;
import java.util.Enumeration;

public class RA
extends SingleElement
implements EbeneArtElement,
NameElement,
GeoRefElement {
    protected static final int TYP_IMAGE = 0;
    protected static final int TYP_CAD = 1;
    protected static final int TYP_OLE = 2;
    protected static final int TYP_WMS = 3;
    protected static final int TYP_DGN = 4;
    protected static final int TYP_PLT = 5;
    protected static final int TYP_PDF = 6;
    protected String fName = "";
    protected short pen;
    protected byte trans;
    protected double geoLUX;
    protected double geoLUY;
    protected double geoROX;
    protected double geoROY;
    protected double bmpLUX;
    protected double bmpLUY;
    protected double bmpROX;
    protected double bmpROY;
    protected short ebene;
    protected short stufe;
    protected short dig;
    protected short color;

    @Override
    public int getIdentifier() {
        return 900;
    }

    @Override
    public final int getMasterKey() {
        return 0x8000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return 0;
    }

    @Override
    public void setArt(int n) {
    }

    public int getTyp() {
        return 100;
    }

    public void setTyp(int n) {
    }

    @Override
    public int contentType() {
        return 100;
    }

    @Override
    public boolean hasName() {
        return this.fName != null && this.fName.length() > 0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String string) {
        this.fName = string;
    }

    public int getPen() {
        return this.pen;
    }

    public void setPen(int n) {
        this.pen = (short)n;
    }

    public int getTransparenz() {
        return this.trans;
    }

    public void setTransparenz(int n) {
        this.trans = (byte)n;
    }

    @Override
    public double getGeoLUX() {
        return this.geoLUX;
    }

    public void setGeoLUX(double d) {
        this.geoLUX = d;
    }

    @Override
    public double getGeoLUY() {
        return this.geoLUY;
    }

    public void setGeoLUY(double d) {
        this.geoLUY = d;
    }

    @Override
    public double getGeoROX() {
        return this.geoROX;
    }

    public void setGeoROX(double d) {
        this.geoROX = d;
    }

    @Override
    public double getGeoROY() {
        return this.geoROY;
    }

    public void setGeoROY(double d) {
        this.geoROY = d;
    }

    @Override
    public double getDocLUX() {
        return this.bmpLUX;
    }

    public void setDocLUX(double d) {
        this.bmpLUX = d;
    }

    @Override
    public double getDocLUY() {
        return this.bmpLUY;
    }

    public void setDocLUY(double d) {
        this.bmpLUY = d;
    }

    @Override
    public double getDocROX() {
        return this.bmpROX;
    }

    public void setDocROX(double d) {
        this.bmpROX = d;
    }

    @Override
    public double getDocROY() {
        return this.bmpROY;
    }

    public void setDocROY(double d) {
        this.bmpROY = d;
    }

    public int getStufe() {
        return this.stufe;
    }

    public void setStufe(int n) {
        this.stufe = (short)n;
    }

    public int getSystem() {
        return this.dig;
    }

    public void setSystem(int n) {
        this.dig = (short)n;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = (short)n;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.fName;
            }
            case 4301: {
                return new Double(this.geoLUX);
            }
            case 4302: {
                return new Double(this.geoLUY);
            }
            case 4311: {
                return new Double(this.geoROX);
            }
            case 4312: {
                return new Double(this.geoROY);
            }
            case 4321: {
                return new Double(this.bmpLUX);
            }
            case 4322: {
                return new Double(this.bmpLUY);
            }
            case 4331: {
                return new Double(this.bmpROX);
            }
            case 4332: {
                return new Double(this.bmpROY);
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void appendToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.quotedString(this.fName));
        stringBuffer.append(',');
        stringBuffer.append(this.pen);
        stringBuffer.append(',');
        stringBuffer.append(this.trans);
        stringBuffer.append(',');
        stringBuffer.append(this.geoLUX);
        stringBuffer.append(',');
        stringBuffer.append(this.geoLUY);
        stringBuffer.append(',');
        stringBuffer.append(this.geoROX);
        stringBuffer.append(',');
        stringBuffer.append(this.geoROY);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpLUX);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpLUY);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpROX);
        stringBuffer.append(',');
        stringBuffer.append(this.bmpROY);
        stringBuffer.append(',');
        stringBuffer.append(this.stufe);
        stringBuffer.append(',');
        stringBuffer.append(this.dig);
        stringBuffer.append(',');
        stringBuffer.append(this.color);
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        RA rA = new RA();
        rA.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        rA.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        rA.fName = Constants.parseString(string);
                        break;
                    }
                    case 1: {
                        rA.pen = (short)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        rA.trans = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 3: {
                        rA.geoLUX = new Double(string);
                        break;
                    }
                    case 4: {
                        rA.geoLUY = new Double(string);
                        break;
                    }
                    case 5: {
                        rA.geoROX = new Double(string);
                        break;
                    }
                    case 6: {
                        rA.geoROY = new Double(string);
                        break;
                    }
                    case 7: {
                        rA.bmpLUX = new Double(string);
                        break;
                    }
                    case 8: {
                        rA.bmpLUY = new Double(string);
                        break;
                    }
                    case 9: {
                        rA.bmpROX = new Double(string);
                        break;
                    }
                    case 10: {
                        rA.bmpROY = new Double(string);
                        break;
                    }
                    case 11: {
                        rA.stufe = (short)Integer.parseInt(string);
                        break;
                    }
                    case 12: {
                        rA.dig = (short)Integer.parseInt(string);
                        break;
                    }
                    case 13: {
                        rA.color = (short)Integer.parseInt(string);
                        break;
                    }
                    case 14: {
                        Constants.parseArts(string, rA);
                    }
                }
            }
            ++n;
        }
        return rA;
    }

    @Override
    public String getContentString() {
        return this.fName;
    }
}

