/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AngleElement;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.Convertable;
import de.geocalc.ggout.objects.DVector;
import de.geocalc.ggout.objects.EbeneArtElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.SCH;
import de.geocalc.ggout.objects.SizeElement;
import java.util.Enumeration;

public class SC
extends DVector
implements EbeneArtElement,
AngleElement,
SizeElement,
Convertable {
    protected int art;
    protected float abstand;
    protected float winkel;
    protected byte subTyp;

    public SC() {
        super(4);
    }

    @Override
    public SCH convert() {
        SCH sCH = new SCH();
        sCH.copy(this);
        sCH.setArt(this.art);
        sCH.setTyp(0);
        sCH.setSize(this.abstand);
        sCH.setAngle(this.winkel);
        sCH.setSubTyp(this.subTyp);
        for (int i = 1; i < this.size(); i += 2) {
            sCH.addElement(new POS((Double)this.elementAt(i - 1), (Double)this.elementAt(i)));
        }
        return sCH;
    }

    @Override
    public int getIdentifier() {
        return 400;
    }

    @Override
    public final int getMasterKey() {
        return 0x4000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public double getSize() {
        return this.abstand;
    }

    @Override
    public void setSize(double d) {
        this.abstand = (float)d;
    }

    @Override
    public double getAngle() {
        return this.winkel;
    }

    @Override
    public void setAngle(double d) {
        this.winkel = (float)d;
    }

    @Override
    public boolean isAngleSet() {
        return true;
    }

    @Override
    public void setAngleSet(boolean bl) {
    }

    public int getSubTyp() {
        return this.subTyp;
    }

    public void setSubTyp(int n) {
        this.subTyp = (byte)n;
    }

    @Override
    public int outLineColumns() {
        return 6;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                return new Integer(this.getArt());
            }
            case 4001: {
                return new Double(this.getAngle());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 5021: {
                return new Integer(this.getSubTyp());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 4001: {
                this.setAngle(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 5021: {
                this.setSubTyp(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.art);
        stringBuffer.append(',');
        stringBuffer.append(this.abstand);
        stringBuffer.append(',');
        stringBuffer.append(this.winkel);
        stringBuffer.append(',');
        stringBuffer.append(this.subTyp);
        stringBuffer.append(',');
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        SC sC = new SC();
        sC.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        sC.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        sC.art = Integer.parseInt(string);
                        break;
                    }
                    case 1: {
                        sC.abstand = Float.parseFloat(string);
                        break;
                    }
                    case 2: {
                        sC.winkel = Float.parseFloat(string);
                        break;
                    }
                    case 3: {
                        sC.subTyp = (byte)Integer.parseInt(string);
                    }
                }
            }
            ++n;
        }
        return sC;
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt() + "[" + this.size() + "]";
    }
}

