/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AngleElement;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.ColorElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OVector;
import de.geocalc.ggout.objects.PNR;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.REF;
import de.geocalc.ggout.objects.SizeElement;
import de.geocalc.ggout.objects.SizePropElement;
import java.util.Enumeration;

public class SCH
extends OVector
implements KatalogEbeneArtElement,
AngleElement,
SizeElement,
SizePropElement,
ColorElement {
    public static final int TYP_SCHRAFFUR = 0;
    public static final int TYP_SPLINE_LO = 1;
    public static final int TYP_SPLINE_LC = 2;
    public static final int TYP_SPLINE_KO = 3;
    public static final int TYP_SPLINE_KC = 4;
    public static final int TYP_BOESCHUNG = 5;
    public static final int TYP_SCHRAFFUR_3D = 10;
    public static final int TYP_BOESCHUNG_3D = 11;
    public static final int SUBTYP_SCHRAFF = 0;
    public static final int SUBTYP_KREUZ = 1;
    public static final int SUBTYP_RASTER = 2;
    public static final int SUBTYP_FLAECHE = 3;
    public static final int SUBTYP_ABSTAND = 4;
    public static final int SUBTYP_SAUM_G = 5;
    public static final int SUBTYP_MUSTER = 6;
    public static final int SUBTYP_SART = 7;
    public static final int SUBTYP_SAUM_O = 8;
    public static final int SUBTYP_PUNKTE = 10;
    public static final int SUBTYP_UMRING = 11;
    protected int art;
    protected byte typ;
    protected float abstand;
    protected double winkel;
    protected byte subTyp;
    protected int color;
    protected String name = "";

    public SCH() {
        super(4);
    }

    public SCH(int n) {
        this.setTyp(n);
    }

    @Override
    public int getIdentifier() {
        return 415;
    }

    @Override
    public final int getMasterKey() {
        return 0x4000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    public int getTyp() {
        return this.typ;
    }

    public void setTyp(int n) {
        this.typ = (byte)n;
    }

    @Override
    public double getSize() {
        return this.abstand;
    }

    @Override
    public void setSize(double d) {
        this.abstand = (float)d;
    }

    @Override
    public double getSize2() {
        return this.subTyp == 10 ? this.winkel : 0.0;
    }

    @Override
    public void setSize2(double d) {
        if (this.subTyp == 10) {
            this.winkel = d;
        }
    }

    @Override
    public boolean isSizeIsFactor() {
        return false;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
    }

    @Override
    public double getAngle() {
        return this.subTyp != 10 ? this.winkel : 0.0;
    }

    @Override
    public void setAngle(double d) {
        if (this.subTyp != 10) {
            this.winkel = d;
        }
    }

    @Override
    public boolean isAngleSet() {
        return true;
    }

    @Override
    public void setAngleSet(boolean bl) {
    }

    public int getSubTyp() {
        return this.subTyp;
    }

    public void setSubTyp(int n) {
        this.subTyp = (byte)n;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int n) {
        this.color = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int outLineColumns() {
        return 6;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                return new Integer(this.getArt());
            }
            case 1521: {
                return new Integer(this.getTyp());
            }
            case 4001: {
                return new Double(this.getAngle());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 5021: {
                return new Integer(this.getSubTyp());
            }
            case 5031: {
                return new Integer(this.getColor());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 1521: {
                this.setTyp(Constants.parseInt(object));
                break;
            }
            case 4001: {
                this.setAngle(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 5021: {
                this.setSubTyp(Constants.parseInt(object));
                break;
            }
            case 5031: {
                this.setColor(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(this.typ);
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.abstand));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.winkel));
        stringBuffer.append(',');
        stringBuffer.append(this.subTyp);
        stringBuffer.append(',');
        if (this.color != 0) {
            stringBuffer.append(Constants.toColorString(this.color));
        }
        stringBuffer.append(',');
        if (this.name != null) {
            stringBuffer.append(Constants.quotedString(this.name));
        }
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 416: {
                this.addElement(POS.parseOutLine(geografOutLine));
                break;
            }
            case 63: {
                this.addElement(REF.parseOutLine(geografOutLine));
                break;
            }
            case 417: {
                this.addElement(PNR.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Objekt: " + this.getOutKey());
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        SCH sCH = new SCH();
        sCH.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        sCH.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        Constants.parseArts(string, sCH);
                        break;
                    }
                    case 1: {
                        sCH.typ = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 2: {
                        sCH.abstand = new Float(string).floatValue();
                        break;
                    }
                    case 3: {
                        sCH.winkel = new Double(string);
                        break;
                    }
                    case 4: {
                        sCH.subTyp = (byte)Integer.parseInt(string);
                        break;
                    }
                    case 5: {
                        sCH.color = Constants.parseColor(string);
                        break;
                    }
                    case 6: {
                        sCH.name = Constants.parseString(string);
                    }
                }
            }
            ++n;
        }
        return sCH;
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt() + ",typ:" + this.typ + "[" + this.size() + "]";
    }
}

