/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.DVector;
import de.geocalc.ggout.objects.EbeneArtElement;
import de.geocalc.ggout.objects.GGElement;
import java.util.Enumeration;

public class SI
extends DVector
implements EbeneArtElement {
    protected int art;
    protected double gamma;
    protected double wan;
    protected double wen;
    protected char typ;
    protected char par;

    public SI() {
        super(2);
    }

    @Override
    public int getIdentifier() {
        return 432;
    }

    @Override
    public final int getMasterKey() {
        return 0x4000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public int outLineColumns() {
        return 6;
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.art);
        stringBuffer.append(',');
        if (this.gamma != 1.0) {
            stringBuffer.append(this.gamma);
        }
        stringBuffer.append(',');
        if (this.typ != '\u0000') {
            stringBuffer.append(this.typ);
        }
        stringBuffer.append(',');
        stringBuffer.append(this.wan);
        stringBuffer.append(',');
        stringBuffer.append(this.wen);
        stringBuffer.append(',');
        if (this.par != '\u0000') {
            stringBuffer.append(this.par);
        }
        stringBuffer.append(',');
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        SI sI = new SI();
        sI.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        sI.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        sI.art = Integer.parseInt(string);
                        break;
                    }
                    case 1: {
                        sI.gamma = new Double(string);
                        break;
                    }
                    case 2: {
                        sI.typ = string.charAt(0);
                        break;
                    }
                    case 3: {
                        sI.wan = new Double(string);
                        break;
                    }
                    case 4: {
                        sI.wen = new Double(string);
                        break;
                    }
                    case 5: {
                        sI.par = string.charAt(0);
                    }
                }
            }
            ++n;
        }
        return sI;
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt() + "[" + this.size() + "]";
    }
}

