/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.ColorElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OVector;
import de.geocalc.ggout.objects.PNR;
import de.geocalc.ggout.objects.POS;
import de.geocalc.ggout.objects.REF;
import de.geocalc.ggout.objects.ZElement;
import java.util.Enumeration;

public class SPL
extends OVector
implements KatalogEbeneArtElement,
ZElement,
ColorElement {
    public static final int TYP_LIN_OPEN = 1;
    public static final int TYP_LIN_CLOSE = 2;
    public static final int TYP_CUB_OPEN = 3;
    public static final int TYP_CUB_CLOSE = 4;
    public static final int TYP_LIN_OPEN_3D = 6;
    public static final int TYP_LIN_CLOSE_3D = 7;
    public static final int TYP_CUB_OPEN_3D = 8;
    public static final int TYP_CUB_CLOSE_3D = 9;
    public static final int TYP_GEN_OPEN = 103;
    public static final int TYP_GEN_CLOSE = 104;
    public static final int TYP_GEN_TANG = 105;
    protected int art;
    protected byte typ;
    protected double z;
    protected int color;

    public SPL() {
        super(2);
    }

    public boolean isCloseTyp() {
        return this.typ == 2 || this.typ == 4 || this.typ == 7 || this.typ == 9;
    }

    public boolean isLinearTyp() {
        return this.typ == 1 || this.typ == 2 || this.typ == 6 || this.typ == 7;
    }

    public boolean is3dTyp() {
        return this.typ == 7 || this.typ == 9 || this.typ == 6 || this.typ == 8;
    }

    @Override
    public int getIdentifier() {
        return 422;
    }

    @Override
    public final int getMasterKey() {
        return 0x4000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return false;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    public int getTyp() {
        return this.typ;
    }

    public void setTyp(int n) {
        this.typ = (byte)n;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setZ(double d) {
        this.z = d;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int n) {
        this.color = n;
    }

    public int outLineColumns() {
        return 6;
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        if (this.typ < 100) {
            stringBuffer.append(this.typ > 0 ? this.typ : (byte)1);
            stringBuffer.append(',');
        } else {
            if (this.typ == 103) {
                stringBuffer.append('o');
            } else if (this.typ == 104) {
                stringBuffer.append('g');
            } else if (this.typ == 105) {
                stringBuffer.append('t');
            }
            stringBuffer.append(',');
            stringBuffer.append("1.0");
            stringBuffer.append(',');
            if (this.typ == 105) {
                stringBuffer.append(',');
                stringBuffer.append(',');
            }
            stringBuffer.append('c');
            stringBuffer.append(',');
        }
        if (this.z != 0.0) {
            stringBuffer.append(Constants.doubleString(this.z));
        }
        stringBuffer.append(',');
        stringBuffer.append(',');
        stringBuffer.append(',');
        if (this.color != 0) {
            stringBuffer.append(Constants.toColorString(this.color));
        }
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 416: {
                this.addElement(POS.parseOutLine(geografOutLine));
                break;
            }
            case 63: {
                this.addElement(REF.parseOutLine(geografOutLine));
                break;
            }
            case 417: {
                this.addElement(PNR.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Objekt: " + this.getOutKey());
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        SPL sPL = new SPL();
        sPL.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        sPL.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        Constants.parseArts(string, sPL);
                        break;
                    }
                    case 1: {
                        try {
                            sPL.typ = (byte)Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            if (string.startsWith("g")) {
                                sPL.typ = (byte)2;
                                break;
                            }
                            sPL.typ = 1;
                        }
                        break;
                    }
                    case 2: {
                        sPL.z = Double.parseDouble(string);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        sPL.color = Constants.parseColor(string);
                    }
                }
            }
            ++n;
        }
        return sPL;
    }

    @Override
    public String getContentString() {
        return this.getEbene() + ":" + this.getArt() + "[" + this.size() + "]";
    }
}

