/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.geom.Koordinate2D;
import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.AngleElement;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.ColorElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.KatalogEbeneArtElement;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.OutFileSubElement;
import de.geocalc.ggout.objects.SizeElement;
import de.geocalc.ggout.objects.SizePropElement;
import de.geocalc.ggout.objects.TA;
import de.geocalc.ggout.objects.TF;
import de.geocalc.ggout.objects.TR;
import de.geocalc.ggout.objects.TX;
import de.geocalc.ggout.objects.TextElement;
import de.geocalc.ggout.objects.XYZElement;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class TE
extends OList
implements KatalogEbeneArtElement,
XYZElement,
AngleElement,
SizeElement,
SizePropElement,
TextElement,
ColorElement,
Koordinate2D {
    public static final int RAHMEN_OHNE = 0;
    public static final int RAHMEN_KASTEN = 1;
    public static final int RAHMEN_KREIS = 2;
    public static final int RAHMEN_EINFACH = 3;
    public static final int RAHMEN_DOPPELT = 4;
    public static final int RAHMEN_DURCH = 5;
    public static final int RAHMEN_OHNE_ECKBEZUG = 6;
    public static final int RAHMEN_DOPPELT_STRICHBEZUG = 7;
    public static final int RAHMEN_DOPPELT_BREIT = 8;
    public static final int RAHMEN_DOPPELT_ENG = 9;
    public static final int FREISTELLUNG_KASTEN = 0;
    public static final int FREISTELLUNG_OHNE = 1;
    public static final int FREISTELLUNG_KREIS = 2;
    public static final int POS_LU = 0;
    public static final int POS_MU = 1;
    public static final int POS_RU = 2;
    public static final int POS_LM = 3;
    public static final int POS_MM = 4;
    public static final int POS_RM = 5;
    public static final int POS_LO = 6;
    public static final int POS_MO = 7;
    public static final int POS_RO = 8;
    private String text;
    private int art;
    private double y;
    private double x;
    private double z;
    private float angle;
    private byte rahmen;
    private byte frei;
    private byte pos;
    private Extends ex = null;

    public TE() {
        this(null, 0.0, 0.0, 0.0, 0, 0);
    }

    public TE(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public TE(String string, double d, double d2) {
        this(string, d, d2, 0.0, 0, 0);
    }

    public TE(String string, double d, double d2, int n, int n2) {
        this(string, d, d2, 0.0, n, n2);
    }

    public TE(String string, double d, double d2, double d3, int n, int n2) {
        this.text = string;
        this.x = d;
        this.y = d2;
        this.angle = (float)d3;
        this.setEbene(n);
        this.art = n2;
    }

    @Override
    public final int getIdentifier() {
        return 300;
    }

    @Override
    public final int getMasterKey() {
        return 0x3000000;
    }

    @Override
    public boolean hasExtendAttributes() {
        return this.ex != null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getAllTextlines() {
        return this.createFullText("\n");
    }

    public String getAllTextLines(String string) {
        return this.createFullText(string);
    }

    private String createFullText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.text != null) {
            stringBuffer.append(this.text);
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            OutFileSubElement outFileSubElement;
            GGElement gGElement = (GGElement)enumeration.nextElement();
            if (gGElement instanceof TA) {
                outFileSubElement = (TA)gGElement;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(((TA)outFileSubElement).getText());
                continue;
            }
            if (!(gGElement instanceof TX)) continue;
            outFileSubElement = (TX)gGElement;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(((TX)outFileSubElement).getText());
        }
        return stringBuffer.toString();
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setZ(double d) {
        this.z = d;
    }

    public boolean hasBez() {
        return this.ex != null && (this.ex.xBez != 0.0 || this.ex.yBez != 0.0);
    }

    public double getXBez() {
        return this.ex != null ? this.ex.xBez : 0.0;
    }

    public void setXBez(double d) {
        if (this.ex != null) {
            this.ex.xBez = d;
        } else if (Math.abs(this.x - d) > 1.0E-4) {
            this.ex = new Extends(this);
            this.ex.xBez = d;
        }
    }

    public double getYBez() {
        return this.ex != null ? this.ex.yBez : 0.0;
    }

    public void setYBez(double d) {
        if (this.ex != null) {
            this.ex.yBez = d;
        } else if (Math.abs(this.y - d) > 1.0E-4) {
            this.ex = new Extends(this);
            this.ex.yBez = d;
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double d) {
        this.angle = (float)d;
    }

    @Override
    public boolean isAngleSet() {
        return true;
    }

    @Override
    public void setAngleSet(boolean bl) {
    }

    public int getRahmen() {
        return this.rahmen;
    }

    public void setRahmen(int n) {
        this.rahmen = (byte)n;
    }

    public int getFrei() {
        return this.frei;
    }

    public void setFrei(int n) {
        this.frei = (byte)n;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        this.pos = (byte)n;
    }

    public int getDigFlags() {
        return this.ex != null ? (int)this.ex.digFlag : 0;
    }

    public void setDigFlags(int n) {
        if (this.ex != null) {
            this.ex.digFlag = (byte)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.digFlag = (byte)n;
        }
    }

    @Override
    public double getSize() {
        return this.ex != null ? (double)this.ex.size : 0.0;
    }

    @Override
    public void setSize(double d) {
        if (this.ex != null) {
            this.ex.size = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.size = (float)d;
        }
    }

    @Override
    public double getSize2() {
        return 0.0;
    }

    @Override
    public void setSize2(double d) {
    }

    public int getRelFlags() {
        return this.ex != null ? (int)this.ex.relFlag : 0;
    }

    public void setRelFlags(int n) {
        if (this.ex != null) {
            this.ex.relFlag = (short)n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.relFlag = (short)n;
        }
    }

    public double getXRel() {
        return this.ex != null ? (double)this.ex.xRel : 0.0;
    }

    public void setXRel(double d) {
        if (this.ex != null) {
            this.ex.xRel = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.xRel = (float)d;
        }
    }

    public double getYRel() {
        return this.ex != null ? (double)this.ex.yRel : 0.0;
    }

    public void setYRel(double d) {
        if (this.ex != null) {
            this.ex.yRel = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.yRel = (float)d;
        }
    }

    public double getAngleRel() {
        return this.ex != null ? (double)this.ex.angleRel : 0.0;
    }

    public void setAngleRel(double d) {
        if (this.ex != null) {
            this.ex.angleRel = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.angleRel = (float)d;
        }
    }

    public double getXOff() {
        return this.ex != null ? (double)this.ex.xOff : 0.0;
    }

    public void setXOff(double d) {
        if (this.ex != null) {
            this.ex.xOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.xOff = (float)d;
        }
    }

    public double getYOff() {
        return this.ex != null ? (double)this.ex.yOff : 0.0;
    }

    public void setYOff(double d) {
        if (this.ex != null) {
            this.ex.yOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.yOff = (float)d;
        }
    }

    public double getAngleOff() {
        return this.ex != null ? (double)this.ex.angleOff : 0.0;
    }

    public void setAngleOff(double d) {
        if (this.ex != null) {
            this.ex.angleOff = (float)d;
        } else if (d != 0.0) {
            this.ex = new Extends(this);
            this.ex.angleOff = (float)d;
        }
    }

    @Override
    public int getColor() {
        return this.ex != null ? this.ex.color : 0;
    }

    @Override
    public void setColor(int n) {
        if (this.ex != null) {
            this.ex.color = n;
        } else if (n != 0) {
            this.ex = new Extends(this);
            this.ex.color = n;
        }
    }

    public boolean isCrossout() {
        return (this.flags & 0x100000) != 0;
    }

    public void setCrossout(boolean bl) {
        this.flags = bl ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    @Override
    public boolean isSizeIsFactor() {
        return (this.flags & 0x200000) != 0;
    }

    @Override
    public void setSizeIsFactor(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }

    public int getLinkKey() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TR)) continue;
            return ((TR)e).getLink();
        }
        return 0;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1200: {
                return this.text;
            }
            case 1201: {
                return this.getAllTextlines();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 2001: {
                return new Double(this.getX());
            }
            case 2002: {
                return new Double(this.getY());
            }
            case 2051: {
                return new Double(this.getXBez());
            }
            case 2052: {
                return new Double(this.getYBez());
            }
            case 2101: {
                return new Double(this.getXOff());
            }
            case 2102: {
                return new Double(this.getYOff());
            }
            case 2911: {
                return new Integer(this.getDigFlags());
            }
            case 2912: {
                return new Integer(this.getRelFlags());
            }
            case 4001: {
                return new Double(this.getAngle());
            }
            case 4011: {
                return new Double(this.getSize());
            }
            case 4201: {
                return new Double(this.getAngleOff());
            }
            case 5011: {
                return new Integer(this.getRahmen());
            }
            case 5012: {
                return new Integer(this.getFrei());
            }
            case 5013: {
                return new Integer(this.getPosition());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1200: {
                this.setText(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 2001: {
                this.setX(Constants.parseDouble(object));
                break;
            }
            case 2002: {
                this.setY(Constants.parseDouble(object));
                break;
            }
            case 2051: {
                this.setXBez(Constants.parseDouble(object));
                break;
            }
            case 2052: {
                this.setYBez(Constants.parseDouble(object));
                break;
            }
            case 2101: {
                this.setXOff(Constants.parseDouble(object));
                break;
            }
            case 2102: {
                this.setYOff(Constants.parseDouble(object));
                break;
            }
            case 2911: {
                this.setDigFlags(Constants.parseInt(object));
                break;
            }
            case 2912: {
                this.setRelFlags(Constants.parseInt(object));
                break;
            }
            case 4001: {
                this.setAngle(Constants.parseDouble(object));
                break;
            }
            case 4011: {
                this.setSize(Constants.parseDouble(object));
                break;
            }
            case 4201: {
                this.setAngleOff(Constants.parseDouble(object));
                break;
            }
            case 5011: {
                this.setRahmen(Constants.parseInt(object));
                break;
            }
            case 5012: {
                this.setFrei(Constants.parseInt(object));
                break;
            }
            case 5013: {
                this.setPosition(Constants.parseInt(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.text != null ? this.text : "");
        stringBuffer.append(',');
        stringBuffer.append(Constants.toArtsString(this));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getX()));
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getY()));
        stringBuffer.append(',');
        if (this.getXBez() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getXBez()));
        }
        stringBuffer.append(',');
        if (this.getYBez() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getYBez()));
        }
        stringBuffer.append(',');
        stringBuffer.append(Constants.doubleString(this.getAngle()));
        stringBuffer.append(',');
        stringBuffer.append(this.getRahmen());
        stringBuffer.append(',');
        stringBuffer.append(this.getFrei());
        stringBuffer.append(',');
        stringBuffer.append(this.getPosition());
        stringBuffer.append(',');
        stringBuffer.append(this.getDigFlags());
        stringBuffer.append(',');
        if (this.getSize() != 0.0 && !this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize()));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.getRelFlags());
        stringBuffer.append(',');
        if (this.getYRel() != 0.0 || this.getXRel() != 0.0) {
            stringBuffer.append(IFormat.f_4.format(this.getXRel()));
            stringBuffer.append(',');
            stringBuffer.append(IFormat.f_4.format(this.getYRel()));
            stringBuffer.append(',');
        } else {
            stringBuffer.append(',');
            stringBuffer.append(',');
        }
        if (this.getAngleRel() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getAngleRel()));
        }
        stringBuffer.append(',');
        if (this.getYOff() != 0.0 || this.getXOff() != 0.0) {
            stringBuffer.append(IFormat.f_4.format(this.getXOff()));
            stringBuffer.append(',');
            stringBuffer.append(IFormat.f_4.format(this.getYOff()));
            stringBuffer.append(',');
        } else {
            stringBuffer.append(',');
            stringBuffer.append(',');
        }
        if (this.getAngleOff() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getAngleOff()));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.isCrossout() ? "j" : "n");
        stringBuffer.append(',');
        if (this.getSize() != 0.0 && this.isSizeIsFactor()) {
            stringBuffer.append(Constants.doubleString(this.getSize()));
        }
        stringBuffer.append(',');
        if (this.getZ() != 0.0) {
            stringBuffer.append(Constants.doubleString(this.getZ()));
        }
        stringBuffer.append(',');
        if (this.getColor() != 0) {
            stringBuffer.append(Constants.toColorString(this.getColor()));
        }
        stringBuffer.append(',');
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
        switch (geografOutLine.getKennung()) {
            case 302: {
                this.addElement(TF.parseOutLine(geografOutLine));
                break;
            }
            case 303: {
                this.addElement(TX.parseOutLine(geografOutLine));
                break;
            }
            case 301: {
                this.addElement(TA.parseOutLine(geografOutLine));
                break;
            }
            default: {
                throw new Exception("Ung\u00fcltigert Typ " + geografOutLine.getKennung() + " beim Einf\u00fcgen in Text: " + this.getOutKey());
            }
        }
    }

    public static GGElement parseOutLine(GeografOutLine geografOutLine) {
        TE tE = new TE();
        tE.setKey(geografOutLine.getKey());
        int n = 0;
        Enumeration enumeration = geografOutLine.values();
        tE.setOnlyReference(!enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() != 0) {
                switch (n) {
                    case 0: {
                        tE.setText(string);
                        break;
                    }
                    case 1: {
                        Constants.parseArts(string, tE);
                        break;
                    }
                    case 2: {
                        tE.setX(Double.parseDouble(string));
                        break;
                    }
                    case 3: {
                        tE.setY(Double.parseDouble(string));
                        break;
                    }
                    case 4: {
                        tE.setXBez(Double.parseDouble(string));
                        break;
                    }
                    case 5: {
                        tE.setYBez(Double.parseDouble(string));
                        break;
                    }
                    case 6: {
                        tE.setAngle(Double.parseDouble(string));
                        break;
                    }
                    case 7: {
                        tE.setRahmen(Integer.parseInt(string));
                        break;
                    }
                    case 8: {
                        tE.setFrei(Integer.parseInt(string));
                        break;
                    }
                    case 9: {
                        tE.setPosition(Integer.parseInt(string));
                        break;
                    }
                    case 10: {
                        tE.setDigFlags(Integer.parseInt(string));
                        break;
                    }
                    case 11: {
                        tE.setSize(Double.parseDouble(string));
                        tE.setSizeIsFactor(false);
                        break;
                    }
                    case 12: {
                        tE.setRelFlags(Integer.parseInt(string));
                        break;
                    }
                    case 13: {
                        tE.setXRel(Double.parseDouble(string));
                        break;
                    }
                    case 14: {
                        tE.setYRel(Double.parseDouble(string));
                        break;
                    }
                    case 15: {
                        tE.setAngleRel(Double.parseDouble(string));
                        break;
                    }
                    case 16: {
                        tE.setXOff(Double.parseDouble(string));
                        break;
                    }
                    case 17: {
                        tE.setYOff(Double.parseDouble(string));
                        break;
                    }
                    case 18: {
                        tE.setAngleOff(Double.parseDouble(string));
                        break;
                    }
                    case 19: {
                        tE.setCrossout(IFormat.parseBoolean(string));
                        break;
                    }
                    case 20: {
                        tE.setSize(Double.parseDouble(string));
                        tE.setSizeIsFactor(true);
                        break;
                    }
                    case 21: {
                        tE.setZ(Double.parseDouble(string));
                        break;
                    }
                    case 22: {
                        tE.setColor(Constants.parseColor(string));
                    }
                }
            }
            ++n;
        }
        return tE;
    }

    @Override
    public String getContentString() {
        return this.createFullText("|") + ":" + IFormat.i04.format(this.getEbene()) + ":" + IFormat.i05.format(this.getArt());
    }

    private class Extends {
        double yBez;
        double xBez;
        int color;
        byte digFlag;
        float size;
        short relFlag;
        float yRel;
        float xRel;
        float angleRel;
        float yOff;
        float xOff;
        float angleOff;

        private Extends(TE tE) {
        }
    }
}

