/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.GeografOutLine;
import de.geocalc.ggout.objects.ArtDefElement;
import de.geocalc.ggout.objects.Attribute;
import de.geocalc.ggout.objects.AttributeNotAvailableException;
import de.geocalc.ggout.objects.AttributedSuperElement;
import de.geocalc.ggout.objects.Constants;
import de.geocalc.ggout.objects.TableAtt;
import de.geocalc.ggout.objects.TableRow;
import de.geocalc.ggout.objects.TableType;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class Table
extends AttributedSuperElement
implements ArtDefElement,
Comparable {
    public static final char TYP_UNIQUE = 'E';
    public static final char TYP_MULTIPLE = 'M';
    public static final char TYP_RELATIONAL = 'R';
    public static final char TYP_SUB = 'S';
    public static final char TYP_PICKLIST = 'P';
    protected String name = null;
    protected char typ = (char)69;
    private Vector arten = new Vector(1);

    public Table() {
    }

    public Table(String string) {
        this.name = string;
    }

    public Table(String string, int n) {
        this.name = string;
        this.setArt(n);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int compareTo(Object object) {
        if (object instanceof Table) {
            return this.getKey() - ((Table)object).getKey();
        }
        return this.name.compareTo(object.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.arten.size() == 0;
    }

    @Override
    public int elementCount() {
        return this.arten.size();
    }

    @Override
    public void addElement(Object object) {
        this.arten.addElement(object);
    }

    @Override
    public Object elementAt(int n) throws NoSuchElementException {
        return this.arten.elementAt(n);
    }

    @Override
    public Object firstElement() {
        return this.arten.firstElement();
    }

    @Override
    public Object lastElement() {
        return this.arten.lastElement();
    }

    @Override
    public void removeFirstElement() {
        this.arten.removeElementAt(0);
    }

    @Override
    public void removeLastElement() {
        this.arten.removeElementAt(this.arten.size() - 1);
    }

    @Override
    public void trimToSize() {
        this.arten.trimToSize();
    }

    @Override
    public Enumeration elements() {
        return this.arten.elements();
    }

    public boolean isSubTyp() {
        return this.typ == 'S' || this.typ == 'P';
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getArt() {
        return this.getSubKey();
    }

    protected void setArt(int n) {
        this.setKey(n);
    }

    public char getTyp() {
        return this.typ;
    }

    public void setTyp(char c) {
        this.typ = c;
    }

    public abstract TableRow createRow();

    public abstract TableType createType();

    public abstract void createRowIndex(TableRow var1);

    public abstract TableAtt createTableAttribute(String var1);

    public abstract Attribute createDataAttribute(String var1, String var2);

    public abstract Attribute createDataAttribute(String var1, int var2);

    public abstract Attribute createDataAttribute(String var1, double var2);

    public abstract Attribute createDataAttribute(String var1, boolean var2);

    public TableAtt getTableAttribute(String string) {
        Enumeration enumeration = this.attributes();
        while (enumeration.hasMoreElements()) {
            TableAtt tableAtt = (TableAtt)enumeration.nextElement();
            if (!tableAtt.getName().equalsIgnoreCase(string)) continue;
            return tableAtt;
        }
        return null;
    }

    public final TableRow searchData(String string, String string2) {
        boolean bl = this.isKeyAttributeName(string);
        Enumeration enumeration = this.datas();
        while (enumeration.hasMoreElements()) {
            TableRow tableRow = (TableRow)enumeration.nextElement();
            Enumeration enumeration2 = tableRow.attributes();
            while (enumeration2.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration2.nextElement();
                if (!(bl ? this.isKeyAttributeName(attribute.getName()) && attribute.getValue().equals(string2) : attribute.getName().equalsIgnoreCase(string) && attribute.getValue().equals(string2))) continue;
                return tableRow;
            }
        }
        return null;
    }

    public final TableRow searchData(TableRow tableRow) {
        Enumeration enumeration = this.datas();
        while (enumeration.hasMoreElements()) {
            TableRow tableRow2 = (TableRow)enumeration.nextElement();
            boolean bl = false;
            Enumeration enumeration2 = tableRow.attributes();
            while (enumeration2.hasMoreElements() && (bl = tableRow2.hasAttributeValue((Attribute)enumeration2.nextElement()))) {
            }
            if (!bl) continue;
            return tableRow2;
        }
        return null;
    }

    public abstract boolean isKeyAttributeName(String var1);

    public abstract String createLinkValue(String var1);

    public boolean hasReferenzTo(int n) {
        Enumeration enumeration = this.attributes();
        while (enumeration.hasMoreElements()) {
            TableAtt tableAtt = (TableAtt)enumeration.nextElement();
            if (tableAtt.getTyp() != '#' || tableAtt.getDef() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getAttribute(int n) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                return this.getName();
            }
            case 1503: {
                return new Integer(this.getArt());
            }
            case 1521: {
                return new Character(this.getTyp());
            }
        }
        return super.getAttribute(n);
    }

    @Override
    public void setAttribute(int n, Object object) throws AttributeNotAvailableException {
        switch (n) {
            case 1100: {
                this.setName(Constants.parseString(object));
                break;
            }
            case 1503: {
                this.setArt(Constants.parseInt(object));
                break;
            }
            case 1521: {
                this.setTyp(Constants.parseChar(object));
                break;
            }
            default: {
                super.setAttribute(n, object);
            }
        }
    }

    @Override
    public void appendDefToOutLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.getOutKey());
        stringBuffer.append(this.getName() != null ? this.getName() : "");
        stringBuffer.append(',');
        stringBuffer.append(this.getSubKey());
        stringBuffer.append(',');
        stringBuffer.append(this.getTyp());
    }

    @Override
    public void addOutLine(GeografOutLine geografOutLine) throws Exception {
    }

    @Override
    public String getContentString() {
        return this.getName() + "," + this.getSubKey() + "[Typ:" + this.typ + "," + this.attributeCount() + " cols," + this.dataCount() + " rows, " + this.elementCount() + " Arten]";
    }
}

