/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.ggout.objects;

import de.geocalc.ggout.objects.Constants;
import de.geocalc.text.IFormat;

public class UuidKey {
    private int key;
    private String pool;

    public UuidKey(String string) throws NumberFormatException {
        if (Constants.isQuotedUuid(string)) {
            string = Constants.getUnquotedUuid(string);
        }
        this.key = Integer.parseInt(string.substring(0, 8), 16);
        this.pool = string.substring(9).intern();
    }

    public int hashCode() {
        return this.key;
    }

    public boolean equals(Object object) {
        if (object instanceof UuidKey) {
            UuidKey uuidKey = (UuidKey)object;
            return uuidKey.key == this.key && uuidKey.pool.equals(this.pool);
        }
        return false;
    }

    public String toString() {
        return IFormat.getRightString(Integer.toHexString(this.key).toUpperCase(), 8, '0') + "-" + this.pool;
    }
}

