/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.gml;

import de.geocalc.geom.DCollection;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.util.VoidEnumerator;
import de.geocalc.xml.XMLElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class GmlFeature {
    private Hashtable parameters;
    private Hashtable attributes;
    private Vector geometries;
    private String name;
    private String className;
    private DRectangle bounds;
    private DPoint position;

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setBounds(DRectangle dRectangle) {
        this.bounds = dRectangle;
    }

    public DRectangle getBounds() {
        return this.bounds;
    }

    public void setPosition(DPoint dPoint) {
        this.position = dPoint;
    }

    public DPoint getPosition() {
        return this.position;
    }

    public void setParameter(String string, Object object) {
        if (this.parameters == null) {
            this.parameters = new Hashtable();
        }
        this.parameters.put(string, object);
    }

    public Object getParameter(String string) {
        return this.parameters != null ? this.parameters.get(string) : null;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes != null ? this.attributes.get(string) : null;
    }

    public Enumeration attributes() {
        return this.attributes != null ? this.attributes.keys() : new VoidEnumerator();
    }

    public void addGeometry(GeomElement geomElement) {
        if (this.geometries == null) {
            this.geometries = new Vector();
        }
        this.geometries.addElement(geomElement);
    }

    public Enumeration geometries() {
        return this.geometries != null ? this.geometries.elements() : new VoidEnumerator();
    }

    public static GmlFeature parse(XMLElement xMLElement) throws Exception {
        GmlFeature gmlFeature = new GmlFeature();
        gmlFeature.setClassName(GmlFeature.parseName(xMLElement.getName()));
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            GeomElement geomElement;
            Object object;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = GmlFeature.parseName(xMLElement2.getName());
            if (string.equals("geographicIdentifier")) {
                gmlFeature.setName(xMLElement2.getContent());
                gmlFeature.setAttribute(string, xMLElement2.getContent());
                continue;
            }
            if (string.equals("boundedBy")) {
                object = GmlFeature.parseGeometry(xMLElement2.getChildrenAt(0));
                gmlFeature.setBounds(object.getBounds());
                continue;
            }
            if (string.equals("position")) {
                object = GmlFeature.parseGeometry(xMLElement2.getChildrenAt(0));
                geomElement = object.getBounds();
                gmlFeature.setPosition(new DPoint(geomElement.y + geomElement.height / 2.0, geomElement.x + geomElement.width / 2.0));
                continue;
            }
            if (string.equals("geographicExtent")) {
                object = xMLElement2.enumerateChildren();
                while (object.hasMoreElements()) {
                    geomElement = GmlFeature.parseGeometry((XMLElement)object.nextElement());
                    gmlFeature.addGeometry(geomElement);
                }
                continue;
            }
            gmlFeature.setAttribute(string, xMLElement2.getContent());
        }
        return gmlFeature;
    }

    private static String parseName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        return n > 0 ? string.substring(n + 1) : string;
    }

    private static GeomElement parseGeometry(XMLElement xMLElement) {
        String string = xMLElement.getName();
        int n = xMLElement.countChildren();
        if (string.equals("gml:Polygon") || string.equals("gml:MultiPolygon") || string.equals("gml:polygonMember") || string.equals("gml:outerBoundaryIs") || string.equals("gml:innerBoundaryIs")) {
            if (n == 1) {
                return GmlFeature.parseGeometry(xMLElement.getChildrenAt(0));
            }
            DCollection dCollection = new DCollection();
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                GeomElement geomElement = GmlFeature.parseGeometry(xMLElement2);
                dCollection.addElement(geomElement);
            }
            return dCollection;
        }
        if (string.equals("gml:LinearRing")) {
            if (n == 1) {
                return GmlFeature.parseGeometry(xMLElement.getChildrenAt(0));
            }
            DPolygon dPolygon = new DPolygon();
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement3 = (XMLElement)enumeration.nextElement();
                GeomElement geomElement = GmlFeature.parseGeometry(xMLElement3);
                Enumeration enumeration2 = geomElement.points();
                while (enumeration2.hasMoreElements()) {
                    dPolygon.addPoint((DPoint)enumeration2.nextElement());
                }
            }
            return dPolygon;
        }
        if (string.equals("gml:Envelope")) {
            DPolygon dPolygon = new DPolygon();
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement4 = (XMLElement)enumeration.nextElement();
                GeomElement geomElement = GmlFeature.parseGeometry(xMLElement4);
                Enumeration enumeration3 = geomElement.points();
                while (enumeration3.hasMoreElements()) {
                    dPolygon.addPoint((DPoint)enumeration3.nextElement());
                }
            }
            return dPolygon.getBounds();
        }
        if (string.equals("gml:Point")) {
            return GmlFeature.parseGeometry(xMLElement.getChildrenAt(0));
        }
        if (string.equals("gml:coordinates")) {
            DPolygon dPolygon = new DPolygon();
            String string2 = xMLElement.getStringAttribute("CS", ",");
            String string3 = xMLElement.getStringAttribute("DECIMAL", ".");
            String string4 = xMLElement.getStringAttribute("TS", " ");
            StringTokenizer stringTokenizer = new StringTokenizer(xMLElement.getContent(), string4);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                string5 = string5.replace(string3.charAt(0), '.');
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, string2);
                dPolygon.addPoint(new Double(stringTokenizer2.nextToken().trim()), new Double(stringTokenizer2.nextToken().trim()));
            }
            return dPolygon;
        }
        if (string.equals("gml:pos")) {
            StringTokenizer stringTokenizer = new StringTokenizer(xMLElement.getContent());
            return new DPoint(new Double(stringTokenizer.nextToken()), new Double(stringTokenizer.nextToken()));
        }
        System.out.println("!Unbekannte Geometrie: " + string);
        return null;
    }
}

