/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import de.geocalc.io.DatLineFormat;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import java.util.Hashtable;

public class DatLine {
    public static final int KENNUNG_KEIN = -1;
    public static final int LEER = -9;
    public static final int KOMMENTAR = -1;
    public static final int WERT = 1;
    public static final int VAR = 2;
    public static final int BLOCK = 3;
    public static final int BLOCKENDE = 4;
    public static final int LISTE = 5;
    public static final int LISTEENDE = 6;
    public static final String STANDARDFORMAT1 = "(I1,2I4,I1,F5.0,2F13.3,F6.3,F10.4,A)";
    public static final String STANDARDFORMAT2 = "(I1,2(1X,2I4,I1,F5.0),2F11.5,4F6.3)";
    public static final String STANDARDFORMAT3 = "(I1,2(2I4,I1,F5.0,2X).2F11.5,2F8.5,F9.4)";
    public static final String STANDARDFORMAT3_9 = "(I1,1X,5F10.5)";
    public static final String STANDARDFORMAT4 = "(I1,1X,2I4,I1,F5.0,15X,2F13.3,2F6.3)";
    public static final String STANDARDFORMAT5 = "(I1,1X,2(1X,2I4,I1,F5.0))";
    public static final String STANDARDFORMAT6 = "(I1,3(1X,2I4,I1,F5.0),F8.3,F11.5)";
    public static final String STANDARDFORMAT7 = "(I1,1X,1X,2I4,I1,F5.0,2F13.3,F6.3,F10.4,3(1X,I1),A)";
    public static final String FORMATDEF1 = "I,N,4F,A";
    public static final String FORMATDEF2 = "I,2N,6F";
    public static final String FORMATDEF3 = "I,2N,5F";
    public static final String FORMATDEF4 = "I,N,4F";
    public static final String FORMATDEF5 = "I,2N";
    public static final String FORMATDEF6 = "I,3N,2F";
    public static final String FORMATDEF7 = "I,N,4F,A";
    public static final String START_KOMMENTAR = "C";
    public static final String START_KOMMENTAR_2 = "c";
    public static final String START_VAR = "C!";
    public static final String START_LISTE = "C$";
    public static final String START_KEY = "%";
    public static final String PUNKT_SHORT_INFO_ALKIS = "C KS          PKN         Y           X     -KL--  --HOE--  PA--- GST-  GWT-- Z P Q--- ART- ABM- BZA- RHO KST-";
    public static final String GPS_SHORT_INFO = "C             PNS            PNZ      Y          X     GY    GX                                    BEMERKUNG";
    public static final String POLAR_SHORT_INFO = "C             PNS            PNZ      R          S     GR    GS                                    BEMERKUNG";
    public static final String FLUCHT_SHORT_INFO = "C              PN                                                  GF                              BEMERKUNG";
    public static final String ORTHO_SHORT_INFO = "C              PN            PNF      A          O     GA    GO    GF    GR                        BEMERKUNG";
    public static final String TRAFO_SHORT_INFO = "C S            PN         Y           X       GL      GN                                           BEMERKUNG";
    public static final String BEM_SHORT_INFO = "C             PNA            PNE BEM";
    public static final String NUMBEZ_SHORT_INFO = "C             PNA            PNE       NB A";
    public static final String IDENT_SHORT_INFO = "C             PNI            PNS Ist-Bem ; Soll-Bem;";
    public static final String UMNUM_SHORT_INFO = "C            PKNA           PKNN  PA-F- GST- GWT--- Z P Q--- ART- ABM- BZA- RHO ABMV KST-          BEMERKUNG";
    public static final int MESSUNG_ORTHO_PUNKT = 0;
    public static final int MESSUNG_ORTHO_ANFANG = 1;
    public static final int MESSUNG_STRECKE = 2;
    public static final int MESSUNG_POLARAUFNAHME = 3;
    public static final int MESSUNG_STREBE = 4;
    public static final int MESSUNG_FEHLER = 5;
    public static final int MESSUNG_BOGENSCHLAG = 6;
    public static final int MESSUNG_KOORDINATENDIFFERENZ = 7;
    public static final int MESSUNG_ORIENTIERTE_RICHTUNG = 8;
    public static final int MESSUNG_ORTHO_ENDE = 9;
    public static final int HOEHE_NIV = 1;
    public static final int HOEHE_TRIG = 2;
    public static final int HOEHE_ZENIT = 3;
    public static final int HOEHE_GEWICHTE = 9;
    public static final int TRAFO_NEXT_PUNKT = 2;
    public static final int TRAFO_SYSTEM_PARAMETER = 9;
    public static final int BEDINGUNG_PARALLELE = 0;
    public static final int BEDINGUNG_GERADE = 1;
    public static final int BEDINGUNG_RECHTER_WINKEL = 2;
    public static final int BEDINGUNG_BEZUG_PARALLELE = 3;
    public static final int BEDINGUNG_ABSTAND_GP = 4;
    public static final int BEDINGUNG_ABSTAND_PP = 5;
    public static final int BEDINGUNG_BOGEN = 6;
    public static final int BEDINGUNG_BOGEN_PUNKT = 9;
    public static final int ZUSATZ_POLY_START = 1;
    public static final int ZUSATZ_POLY_MITTE = 0;
    public static final int ZUSATZ_POLY_ENDE = 9;
    public static final int ZUSATZ_LINIE = 2;
    public static final int ZUSATZ_BEMERKUNG = 5;
    public static final int ZUSATZ_NUMBEZ = 6;
    public static final int ZUSATZ_IDENT = 7;
    public static final int ZUSATZ_UMNUM = 8;
    public static final int BLOCK_KEIN = -9;
    public static final int BLOCK_STEUERDATEN = -1;
    public static final int BLOCK_EOF = 0;
    public static final int BLOCK_PUNKTE = 1;
    public static final int BLOCK_MESSUNGEN = 2;
    public static final int BLOCK_HOEHEN = 3;
    public static final int BLOCK_TRAFO = 4;
    public static final int BLOCK_ZUSATZ = 5;
    public static final int BLOCK_BEDINGUNG = 6;
    public static final int BLOCK_PUNKTE_ERW = 7;
    public static final String START_BLOCK_EOF = "0";
    public static final String START_BLOCK_PUNKTE = "1 (I1,1X,1X,2I4,I1,F5.0,2F13.3,F6.3,F10.4,A)";
    public static final String START_BLOCK_MESSUNGEN = "2 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,4F6.3)";
    public static final String START_BLOCK_HOEHEN = "3 (I1,1X,2(1X,2I4,I1,F5.0),2F11.4,3F8.3)";
    public static final String START_BLOCK_TRAFO = "4 (I1,1X,1X,2I4,I1,F5.0,2F13.3,2F8.3)";
    public static final String START_BLOCK_ZUSATZ = "5 (I1,1X,2(1X,2I4,I1,F5.0))";
    public static final String START_BLOCK_BEDINGUNG = "6 (I1,1X,3(1X,2I4,I1,F5.0),F6.3,F11.4)";
    public static final int LISTE_KEIN = -1;
    public static final int LISTE_POLAR = 201;
    public static final int LISTE_GPS = 202;
    public static final int LISTE_EIGENE = 203;
    public static final int LISTE_NACHWEIS = 204;
    public static final int LISTE_VORGABEN = 205;
    public static final int LISTE_EINRECHNUNG = 206;
    public static final int LISTE_NIVELLEMENT = 301;
    public static final int LISTE_POLARHOEHEN = 302;
    public static final int LISTE_FLST = 510;
    public static final int LISTE_BESTAND = 511;
    public static final int LISTE_NUTZUNG = 512;
    public static final int LISTE_BODEN = 513;
    public static final int LISTE_GEBAEUDE = 520;
    public static final int LISTE_TOPOGRAPHIE = 530;
    public static final int LISTE_KATALOG = 540;
    public static final int LISTE_BEMERKUNG = 550;
    public static final int LISTE_NUMBEZ = 560;
    public static final int LISTE_IDENT = 570;
    public static final int LISTE_ABSTECKUNG = 571;
    public static final int LISTE_UMNUM = 580;
    public static final int LISTE_HOMOGENISIERUNG = 601;
    public static final int LISTE_BEDINGUNGEN = 602;
    public static final String START_LISTE_POLAR = "C$Liste Polare Messungen";
    public static final String START_LISTE_GPS = "C$Liste GPS-Basislinien";
    public static final String START_LISTE_EIGENE = "C$Liste Messband-Messungen";
    public static final String START_LISTE_NACHWEIS = "C$Liste KatasterNachweis";
    public static final String START_LISTE_VORGABEN = "C$Liste Vorgaben";
    public static final String START_LISTE_EINRECHNUNG = "C$Liste Einrechnung";
    public static final String START_LISTE_NIVELLEMENT = "C$Liste Nivellement";
    public static final String START_LISTE_POLARHOEHEN = "C$Liste Polare H\u00f6hen";
    public static final String START_LISTE_HOMOGENISIERUNG = "C$Liste Homogenisierung";
    public static final String START_LISTE_BEDINGUNGEN = "C$Liste Bedingungen";
    public static final String START_LISTE_FLST = "C$Liste Flurstuecke";
    public static final String START_LISTE_BESTAND = "C$Liste Bestand";
    public static final String START_LISTE_NUTZUNG = "C$Liste Nutzung";
    public static final String START_LISTE_BODEN = "C$Liste Boden";
    public static final String START_LISTE_GEBAEUDE = "C$Liste Gebaeude";
    public static final String START_LISTE_TOPOGRAPHIE = "C$Liste Topographie";
    public static final String START_LISTE_KATALOG = "C$Liste Katalog";
    public static final String START_LISTE_BEMERKUNG = "C$Liste Bemerkungen";
    public static final String START_LISTE_NUMBEZ = "C$Liste NummerierungsBezirk";
    public static final String START_LISTE_IDENT = "C$Liste Punktidentitaet";
    public static final String START_LISTE_ABSTECKUNG = "C$Liste Absteckkontrolle";
    public static final String START_LISTE_UMNUM = "C$Liste Umnummerierung";
    public static final String ENDE_LISTE = "C$Ende";
    public static final String ENDE_LISTE_POLAR = "C$Ende Polare Messungen";
    public static final String ENDE_LISTE_GPS = "C$Ende GPS-Basislinien";
    public static final String ENDE_LISTE_EIGENE = "C$Ende Messband-Messungen";
    public static final String ENDE_LISTE_NACHWEIS = "C$Ende KatasterNachweis";
    public static final String ENDE_LISTE_VORGABEN = "C$Ende Vorgaben";
    public static final String ENDE_LISTE_EINRECHNUNG = "C$Ende Einrechnung";
    public static final String ENDE_LISTE_NIVELLEMENT = "C$Ende Nivellement";
    public static final String ENDE_LISTE_POLARHOEHEN = "C$Ende Polare H\u00f6hen";
    public static final String ENDE_LISTE_HOMOGENISIERUNG = "C$Ende Homogenisierung";
    public static final String ENDE_LISTE_BEDINGUNGEN = "C$Ende Bedingungen";
    public static final String ENDE_LISTE_FLST = "C$Ende Flurstuecke";
    public static final String ENDE_LISTE_BESTAND = "C$Ende Bestand";
    public static final String ENDE_LISTE_NUTZUNG = "C$Ende Nutzung";
    public static final String ENDE_LISTE_BODEN = "C$Ende Boden";
    public static final String ENDE_LISTE_GEBAEUDE = "C$Ende Gebaeude";
    public static final String ENDE_LISTE_TOPOGRAPHIE = "C$Ende Topographie";
    public static final String ENDE_LISTE_KATALOG = "C$Ende Katalog";
    public static final String ENDE_LISTE_BEMERKUNG = "C$Ende Bemerkungen";
    public static final String ENDE_LISTE_NUMBEZ = "C$Ende NummerierungsBezirk";
    public static final String ENDE_LISTE_IDENT = "C$Ende Punktidentitaet";
    public static final String ENDE_LISTE_ABSTECKUNG = "C$Ende Absteckkontrolle";
    public static final String ENDE_LISTE_UMNUM = "C$Ende Umnummerierung";
    public static final int VAR_UNDEF = -1;
    public static final int VAR_STEUERDATEN = 1;
    public static final int VAR_KAFDATVERSION = 2;
    public static final int VAR_VERMSTELLE = 10;
    public static final int VAR_ADRESSE_1 = 11;
    public static final int VAR_ADRESSE_2 = 12;
    public static final int VAR_ADRESSE_3 = 13;
    public static final int VAR_BEARBEITER = 14;
    public static final int VAR_GEMEINDE = 20;
    public static final int VAR_GEMARKUNG = 21;
    public static final int VAR_FLUR = 22;
    public static final int VAR_FLURSTUECK = 23;
    public static final int VAR_GELHOEHE = 31;
    public static final int VAR_KATASTERAMT = 40;
    public static final int VAR_ANTRAG = 41;
    public static final int VAR_KOOSYSTEM = 42;
    public static final int VAR_MODEL = 43;
    public static final int VAR_DATEN = 44;
    public static final int VAR_NAS_FILE = 45;
    public static final int VAR_KVZ = 101;
    public static final int VAR_SAP = 102;
    public static final int VAR_KATNEU = 103;
    public static final int VAR_KATHOM = 104;
    public static final int VAR_ALK = 151;
    public static final int VAR_ALKIS = 152;
    public static final int VAR_BLATT = 201;
    public static final int VAR_RISS = 202;
    public static final int VAR_TRAFO = 401;
    public static final int VAR_DIGIT = 402;
    public static final int VAR_ALB = 501;
    public static final int VAR_FLST = 502;
    public static final int VAR_GBBL = 503;
    public static final int VAR_NAME = 504;
    public static final int VAR_NUTZ = 505;
    public static final int VAR_BODENSCHAETZUNG = 506;
    public static final int VAR_GEB = 510;
    public static final int VAR_GKZ = 511;
    public static final int VAR_BW = 512;
    public static final int VAR_TOP = 520;
    public static final int VAR_KATGMD = 531;
    public static final int VAR_KATGMK = 532;
    public static final int VAR_KATLAG = 533;
    public static final int VAR_OTXT = 611;
    public static final int VAR_OSYM = 612;
    public static final int VAR_OLIN = 613;
    public static final int VAR_OATT = 619;
    public static final int VAR_POLAR = 1201;
    public static final int VAR_GPS = 1202;
    public static final int VAR_EIGENE = 1203;
    public static final int VAR_NACHWEIS = 1204;
    public static final int VAR_VORGABEN = 1205;
    public static final int VAR_EINRECHNUNG = 1206;
    public static final int VAR_NIVELLEMENT = 1301;
    public static final int VAR_POLARHOEHEN = 1303;
    public static final int VAR_HOMOGENISIERUNG = 1601;
    public static final int VAR_BEDINGUNGEN = 1602;
    public static final String START_VAR_STEUERDATEN = "C!Steuerdaten  :";
    public static final String START_VAR_KAFDATVERSION = "C!KafDatVersion:";
    public static final String START_VAR_VERMSTELLE = "C!Verm-Stelle  :";
    public static final String START_VAR_ADRESSE_1 = "C!Adresse1     :";
    public static final String START_VAR_ADRESSE_2 = "C!Adresse2     :";
    public static final String START_VAR_ADRESSE_3 = "C!Adresse3     :";
    public static final String START_VAR_BEARBEITER = "C!Bearbeiter   :";
    public static final String START_VAR_GEMEINDE = "C!Gemeinde     :";
    public static final String START_VAR_GEMARKUNG = "C!Gemarkung    :";
    public static final String START_VAR_FLUR = "C!Flur         :";
    public static final String START_VAR_FLURSTUECK = "C!Flurstueck   :";
    public static final String START_VAR_GELHOEHE = "C!Gelaendehoehe:";
    public static final String START_VAR_KATASTERAMT = "C!Katasteramt  :";
    public static final String START_VAR_ANTRAG = "C!Antragsnummer:";
    public static final String START_VAR_KOOSYSTEM = "C!KooSystem    :";
    public static final String START_VAR_MODEL = "C!Modell       :";
    public static final String START_VAR_DATEN = "C!Daten        :";
    public static final String START_VAR_NAS_FILE = "C!NasImport    :";
    public static final String START_VAR_KVZ = "C!Kvz:";
    public static final String START_VAR_SAP = "C!SAP:";
    public static final String START_VAR_KATNEU = "C!Neu:";
    public static final String START_VAR_KATHOM = "C!KatHom:";
    public static final String START_VAR_ALK = "C!ALK:";
    public static final String START_VAR_ALKIS = "C!ALKIS:";
    public static final String START_VAR_BLATT = "C!Blatt:";
    public static final String START_VAR_RISS = "C!Riss:";
    public static final String START_VAR_TRAFO = "C!Trafo:";
    public static final String START_VAR_DIGIT = "C!Digit:";
    public static final String START_VAR_ALB = "C!Alb:";
    public static final String START_VAR_FLST = "C!Flst:";
    public static final String START_VAR_NUTZ = "C!Nutz:";
    public static final String START_VAR_BODENSCHAETZUNG = "C!Bodenschaetzung:";
    public static final String START_VAR_GBBL = "C!Gbbl:";
    public static final String START_VAR_NAME = "C!Name:";
    public static final String START_VAR_GEB = "C!Geb:";
    public static final String START_VAR_GKZ = "C!Gkz:";
    public static final String START_VAR_BW = "C!Bw:";
    public static final String START_VAR_TOP = "C!Top:";
    public static final String START_VAR_KATGMD = "C!KatGmd:";
    public static final String START_VAR_KATGMK = "C!KatGmk:";
    public static final String START_VAR_KATLAG = "C!KatLag:";
    public static final String START_VAR_OTXT = "C!Txt:";
    public static final String START_VAR_OSYM = "C!Sym:";
    public static final String START_VAR_OLIN = "C!Lin:";
    public static final String START_VAR_OATT = "C!Att:";
    public static final String START_VAR_POLAR = "C!PolarRiss:";
    public static final String START_VAR_GPS = "C!GpsRiss:";
    public static final String START_VAR_EIGENE = "C!MessbandRiss:";
    public static final String START_VAR_NACHWEIS = "C!KatasterRiss:";
    public static final String START_VAR_VORGABEN = "C!VorgabenRiss:";
    public static final String START_VAR_EINRECHNUNG = "C!EinrechnungRiss:";
    public static final String START_VAR_NIVELLEMENT = "C!NivRiss:";
    public static final String START_VAR_POLARHOEHEN = "C!TrigRiss:";
    public static final String START_VAR_HOMOGENISIERUNG = "C!HomogenisierungRiss:";
    public static final String START_VAR_BEDINGUNGEN = "C!BedingungenRiss:";
    public static final int MA = 5001;
    public static final int PS = 5002;
    public static final int PZ = 5003;
    public static final int L1 = 5004;
    public static final int L2 = 5005;
    public static final int P1 = 5006;
    public static final int P2 = 5007;
    public static final int P3 = 5008;
    public static final int L = 5009;
    public static final int ZS = 5010;
    protected static DatLineFormat format;
    protected static final Hashtable vars;
    protected String line;
    protected int length;

    static final String var(String string) {
        return string.substring(0, string.indexOf(58)).trim().toUpperCase();
    }

    public DatLine() {
        this.line = new String();
        this.length = 0;
    }

    public DatLine(String string) {
        this.line = string;
        this.length = this.line.length();
    }

    public int length() {
        return this.length;
    }

    public static void setFormat(DatLineFormat datLineFormat) {
        format = datLineFormat;
    }

    public static DatLineFormat getFormat() {
        return format;
    }

    public int getKennung() throws IFileInputException {
        try {
            if (this.length == 0) {
                return -9;
            }
            if (this.line.startsWith(START_KOMMENTAR)) {
                if (this.line.startsWith(START_VAR)) {
                    return 2;
                }
                if (this.line.startsWith(START_LISTE)) {
                    if (this.line.startsWith(ENDE_LISTE)) {
                        return 6;
                    }
                    return 5;
                }
                if (KafkaIOProperties.datVersion == 2) {
                    if (this.length > 1 && Character.isDigit(this.line.charAt(1))) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
            if (this.line.startsWith(START_KOMMENTAR_2)) {
                return -1;
            }
            if (this.line.startsWith(" ")) {
                Integer n = new Integer(this.line.trim());
                if (n == -99) {
                    return 4;
                }
            } else if (Character.isDigit(this.line.charAt(0))) {
                if (this.length <= 3) {
                    return 3;
                }
                if (this.line.substring(0, Math.min(this.length, 80)).lastIndexOf(")") > 0) {
                    return 3;
                }
                return 1;
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Lesefehler bei der Zeilenerkennung");
        }
        throw new IFileInputException("Zeile besitzt keine g\u00fcltige Zeilenkennung");
    }

    public int getBlock() throws IFileInputException {
        try {
            Integer n = new Integer(this.line.substring(0, 1));
            return n;
        }
        catch (Exception exception) {
            throw new IFileInputException("Fehler bei der Blockerkennung");
        }
    }

    public String getFormatString() throws IFileInputException {
        int n = this.line.indexOf("(");
        int n2 = this.line.lastIndexOf(")");
        if (n > 0 && n2 > n) {
            return this.line.substring(n, n2 + 1);
        }
        if (this.length > 0 && Character.isDigit(this.line.charAt(0))) {
            switch (Integer.parseInt(this.line.substring(0, 1))) {
                case 0: {
                    return "";
                }
                case 1: {
                    return STANDARDFORMAT1;
                }
                case 2: {
                    return STANDARDFORMAT2;
                }
                case 3: {
                    return STANDARDFORMAT3;
                }
                case 4: {
                    return STANDARDFORMAT4;
                }
                case 5: {
                    return STANDARDFORMAT5;
                }
                case 6: {
                    return STANDARDFORMAT6;
                }
                case 7: {
                    return STANDARDFORMAT7;
                }
            }
        }
        throw new IFileInputException("Fehlerhafte Formatzeile" + this.line);
    }

    public static String getFormatDef(int n) throws IFileInputException {
        switch (n) {
            case 1: {
                return "I,N,4F,A";
            }
            case 2: {
                return FORMATDEF2;
            }
            case 3: {
                return FORMATDEF3;
            }
            case 4: {
                return FORMATDEF4;
            }
            case 5: {
                return FORMATDEF5;
            }
            case 6: {
                return FORMATDEF6;
            }
            case 7: {
                return "I,N,4F,A";
            }
        }
        return "";
    }

    public int getListe() throws IFileInputException {
        if (this.line.startsWith(START_LISTE_POLAR)) {
            return 201;
        }
        if (this.line.startsWith(START_LISTE_GPS)) {
            return 202;
        }
        if (this.line.startsWith(START_LISTE_EIGENE)) {
            return 203;
        }
        if (this.line.startsWith(START_LISTE_NACHWEIS)) {
            return 204;
        }
        if (this.line.startsWith(START_LISTE_VORGABEN)) {
            return 205;
        }
        if (this.line.startsWith(START_LISTE_EINRECHNUNG)) {
            return 206;
        }
        if (this.line.startsWith(START_LISTE_NIVELLEMENT)) {
            return 301;
        }
        if (this.line.startsWith(START_LISTE_POLARHOEHEN)) {
            return 302;
        }
        if (this.line.startsWith(START_LISTE_FLST)) {
            return 510;
        }
        if (this.line.startsWith(START_LISTE_BESTAND)) {
            return 511;
        }
        if (this.line.startsWith(START_LISTE_NUTZUNG)) {
            return 512;
        }
        if (this.line.startsWith(START_LISTE_BODEN)) {
            return 513;
        }
        if (this.line.startsWith(START_LISTE_GEBAEUDE)) {
            return 520;
        }
        if (this.line.startsWith(START_LISTE_TOPOGRAPHIE)) {
            return 530;
        }
        if (this.line.startsWith(START_LISTE_KATALOG)) {
            return 540;
        }
        if (this.line.startsWith(START_LISTE_BEMERKUNG)) {
            return 550;
        }
        if (this.line.startsWith(START_LISTE_NUMBEZ)) {
            return 560;
        }
        if (this.line.startsWith(START_LISTE_UMNUM)) {
            return 580;
        }
        if (this.line.startsWith(START_LISTE_IDENT)) {
            return 570;
        }
        if (this.line.startsWith(START_LISTE_ABSTECKUNG)) {
            return 571;
        }
        if (this.line.startsWith(START_LISTE_HOMOGENISIERUNG)) {
            return 601;
        }
        if (this.line.startsWith(START_LISTE_BEDINGUNGEN)) {
            return 602;
        }
        if (this.line.startsWith(ENDE_LISTE)) {
            return -1;
        }
        throw new IFileInputException("Fehler bei der Listenerkennung");
    }

    public int getListe(int n) {
        switch (n) {
            case 1201: {
                return 201;
            }
            case 1202: {
                return 202;
            }
            case 1203: {
                return 203;
            }
            case 1204: {
                return 204;
            }
            case 1205: {
                return 205;
            }
            case 1206: {
                return 206;
            }
            case 1301: {
                return 301;
            }
            case 1303: {
                return 302;
            }
            case 1601: {
                return 601;
            }
            case 1602: {
                return 602;
            }
        }
        return -1;
    }

    public int getVariable() {
        int n = this.line.indexOf(58);
        if (n < 0) {
            n = this.line.indexOf(32);
        }
        if (n < 0) {
            return -1;
        }
        Integer n2 = (Integer)vars.get(this.line.substring(0, n).trim().toUpperCase());
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public String getVariableWert() {
        try {
            String string = this.line.substring(this.line.indexOf(":") + 1, this.length).trim();
            return string.length() != 0 ? string : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        vars = new Hashtable();
        vars.put(DatLine.var(START_VAR_STEUERDATEN), new Integer(1));
        vars.put(DatLine.var(START_VAR_KAFDATVERSION), new Integer(2));
        vars.put(DatLine.var(START_VAR_VERMSTELLE), new Integer(10));
        vars.put(DatLine.var(START_VAR_ADRESSE_1), new Integer(11));
        vars.put(DatLine.var(START_VAR_ADRESSE_2), new Integer(12));
        vars.put(DatLine.var(START_VAR_ADRESSE_3), new Integer(13));
        vars.put(DatLine.var(START_VAR_BEARBEITER), new Integer(14));
        vars.put(DatLine.var(START_VAR_GEMEINDE), new Integer(20));
        vars.put(DatLine.var(START_VAR_GEMARKUNG), new Integer(21));
        vars.put(DatLine.var(START_VAR_FLUR), new Integer(22));
        vars.put(DatLine.var(START_VAR_FLURSTUECK), new Integer(23));
        vars.put(DatLine.var(START_VAR_GELHOEHE), new Integer(31));
        vars.put(DatLine.var(START_VAR_KATASTERAMT), new Integer(40));
        vars.put(DatLine.var(START_VAR_ANTRAG), new Integer(41));
        vars.put(DatLine.var(START_VAR_KOOSYSTEM), new Integer(42));
        vars.put(DatLine.var(START_VAR_MODEL), new Integer(43));
        vars.put(DatLine.var(START_VAR_DATEN), new Integer(44));
        vars.put(DatLine.var(START_VAR_NAS_FILE), new Integer(45));
        vars.put(DatLine.var(START_VAR_KVZ), new Integer(101));
        vars.put(DatLine.var(START_VAR_SAP), new Integer(102));
        vars.put(DatLine.var(START_VAR_KATNEU), new Integer(103));
        vars.put(DatLine.var(START_VAR_KATHOM), new Integer(104));
        vars.put(DatLine.var(START_VAR_ALK), new Integer(151));
        vars.put(DatLine.var(START_VAR_ALKIS), new Integer(152));
        vars.put(DatLine.var(START_VAR_BLATT), new Integer(201));
        vars.put(DatLine.var(START_VAR_RISS), new Integer(202));
        vars.put(DatLine.var(START_VAR_TRAFO), new Integer(401));
        vars.put(DatLine.var(START_VAR_DIGIT), new Integer(402));
        vars.put(DatLine.var(START_VAR_ALB), new Integer(501));
        vars.put(DatLine.var(START_VAR_FLST), new Integer(502));
        vars.put(DatLine.var(START_VAR_GBBL), new Integer(503));
        vars.put(DatLine.var(START_VAR_NUTZ), new Integer(505));
        vars.put(DatLine.var(START_VAR_BODENSCHAETZUNG), new Integer(506));
        vars.put(DatLine.var(START_VAR_NAME), new Integer(504));
        vars.put(DatLine.var(START_VAR_GEB), new Integer(510));
        vars.put(DatLine.var(START_VAR_GKZ), new Integer(511));
        vars.put(DatLine.var(START_VAR_BW), new Integer(512));
        vars.put(DatLine.var(START_VAR_TOP), new Integer(520));
        vars.put(DatLine.var(START_VAR_KATGMD), new Integer(531));
        vars.put(DatLine.var(START_VAR_KATGMK), new Integer(532));
        vars.put(DatLine.var(START_VAR_KATLAG), new Integer(533));
        vars.put(DatLine.var(START_VAR_OTXT), new Integer(611));
        vars.put(DatLine.var(START_VAR_OSYM), new Integer(612));
        vars.put(DatLine.var(START_VAR_OLIN), new Integer(613));
        vars.put(DatLine.var(START_VAR_OATT), new Integer(619));
        vars.put(DatLine.var(START_VAR_POLAR), new Integer(1201));
        vars.put(DatLine.var(START_VAR_GPS), new Integer(1202));
        vars.put(DatLine.var(START_VAR_EIGENE), new Integer(1203));
        vars.put(DatLine.var(START_VAR_NACHWEIS), new Integer(1204));
        vars.put(DatLine.var(START_VAR_VORGABEN), new Integer(1205));
        vars.put(DatLine.var(START_VAR_EINRECHNUNG), new Integer(1206));
        vars.put(DatLine.var(START_VAR_NIVELLEMENT), new Integer(1301));
        vars.put(DatLine.var(START_VAR_POLARHOEHEN), new Integer(1303));
        vars.put(DatLine.var(START_VAR_HOMOGENISIERUNG), new Integer(1601));
        vars.put(DatLine.var(START_VAR_BEDINGUNGEN), new Integer(1602));
    }
}

