/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DatLineFormat {
    private static final String ERR = "Fehler bei der Formaterkennung";
    private String fm;
    private Vector tokens = null;

    private static int getNumEndIdx(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        return n;
    }

    public DatLineFormat(String string, String string2) throws NumberFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        this.fm = string;
        Vector<Token> vector = new Vector<Token>();
        FormatTokenizer formatTokenizer = new FormatTokenizer(this, string);
        int n5 = 0;
        while (formatTokenizer.hasMoreElements()) {
            String string3 = (String)formatTokenizer.nextElement();
            n4 = 1;
            if (Character.isDigit(string3.charAt(0))) {
                n3 = DatLineFormat.getNumEndIdx(string3);
                n4 = Integer.parseInt(string3.substring(0, n3));
                string3 = string3.substring(n3);
            }
            for (int i = 0; i < n4; ++i) {
                Token token = string3.indexOf(40) >= 0 ? new SuperToken(this, string3, n5) : new SingleToken(this, string3, n5);
                if (token.getTyp() == 4) {
                    n2 = token.start();
                    for (n = vector.size() - 1; n >= 0; --n) {
                        Token token2 = (Token)vector.elementAt(n);
                        if (token2.length() == 0) {
                            token2.setLength(n2 - token2.start());
                            break;
                        }
                        token2.setStart(n2 -= token2.length());
                    }
                    n5 = token.start();
                    continue;
                }
                n5 += token.length();
                vector.addElement(token);
            }
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            if (((Token)vector.elementAt(i)).countValues() > 0) continue;
            vector.removeElementAt(i);
        }
        this.tokens = new Vector();
        FormatDef formatDef = new FormatDef(this, string2);
        n4 = vector.size() - 1;
        n3 = formatDef.size() - 1;
        while (n3 >= 0) {
            DefToken defToken = (DefToken)formatDef.elementAt(n3);
            n2 = defToken.getTyp();
            n = 0;
            if (n2 == 9) {
                int n6 = 1;
                for (var13_20 = n3 - 1; var13_20 >= 0; --var13_20) {
                    if (((DefToken)formatDef.elementAt(var13_20)).getTyp() != 9) continue;
                    ++n6;
                }
                var13_20 = n4 + 1 - (n3 + 1 - n6);
                int n7 = var13_20 / n6;
                if (n7 == 1) {
                    while (n6 > 0) {
                        this.tokens.insertElementAt(vector.elementAt(n4), 0);
                        --n3;
                        --n4;
                        --n6;
                    }
                    n = 1;
                } else {
                    while (n6 > 0) {
                        SuperToken superToken = new SuperToken(this);
                        for (int i = 0; i < n7; ++i) {
                            superToken.insertElement((Token)vector.elementAt(n4));
                            --n4;
                        }
                        this.tokens.insertElementAt(superToken, 0);
                        --n3;
                        --n6;
                    }
                    n = 1;
                }
            } else {
                while (n4 >= 0) {
                    Token token = (Token)vector.elementAt(n4);
                    var13_20 = token.getTyp();
                    while (var13_20 == 9) {
                        if (token.countValues() == 1) {
                            token = token.getValueToken();
                            var13_20 = token.getTyp();
                            continue;
                        }
                        throw new NumberFormatException("Fehler bei der Formaterkennung, geklammerter Formatteil kann nicht aufgel\u00f6st werden");
                    }
                    if (n2 == var13_20) {
                        this.tokens.insertElementAt(token, 0);
                        n = 1;
                    }
                    --n4;
                    if (n == 0) continue;
                    break;
                }
                --n3;
            }
            if (n != 0) continue;
            throw new NumberFormatException("Fehler bei der Formaterkennung, Formatangabe enth\u00e4lt nicht die geforderten Elemente");
        }
    }

    public String parseValueAt(String string, int n) {
        Token token = (Token)this.tokens.elementAt(n);
        if (string.length() <= token.start()) {
            return "";
        }
        return token.parseValue(string);
    }

    public String parseStringAt(String string, int n) {
        Token token = (Token)this.tokens.elementAt(n);
        if (string.length() <= token.start()) {
            return "";
        }
        return string.substring(token.start(), token.start() + token.length());
    }

    public int getStartAt(int n) {
        return ((Token)this.tokens.elementAt(n)).start();
    }

    public int getEndAt(int n) {
        Token token = (Token)this.tokens.elementAt(n);
        return token.start() + token.length();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fm + "\n");
        stringBuffer.append('(');
        for (n = 0; n < this.tokens.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.tokens.elementAt(n).toString());
        }
        stringBuffer.append(')');
        for (n = 0; n < this.tokens.size(); ++n) {
            Token token = (Token)this.tokens.elementAt(n);
            stringBuffer.append("\n  ");
            stringBuffer.append(token);
            stringBuffer.append("  ");
            stringBuffer.append(token.start());
            stringBuffer.append(",");
            stringBuffer.append(token.start() + token.length());
        }
        return stringBuffer.toString();
    }

    private class FormatTokenizer
    implements Enumeration {
        int idx = 0;
        int nextIdx = 0;
        String fm;

        FormatTokenizer(DatLineFormat datLineFormat, String string) {
            string = string.trim();
            this.fm = string.indexOf("(") == 0 ? string.substring(1, string.length() - 1) : string;
            this.nextIdx = this.getNextIdx();
        }

        private int getNextIdx() {
            int n;
            int n2 = 0;
            block5: for (n = this.idx; n < this.fm.length(); ++n) {
                switch (this.fm.charAt(n)) {
                    case '(': {
                        ++n2;
                        continue block5;
                    }
                    case ')': {
                        --n2;
                        continue block5;
                    }
                    case ',': {
                        if (n2 != 0) continue block5;
                        return n;
                    }
                }
            }
            return n;
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextIdx > this.idx;
        }

        public Object nextElement() {
            String string = this.fm.substring(this.idx, this.nextIdx);
            this.idx = ++this.nextIdx;
            this.nextIdx = this.getNextIdx();
            return string;
        }
    }

    private class SuperToken
    extends Token {
        private Vector tokens;

        SuperToken(DatLineFormat datLineFormat) {
            super(datLineFormat);
            this.typ = 9;
            this.tokens = new Vector();
        }

        SuperToken(DatLineFormat datLineFormat, String string, int n) {
            super(datLineFormat);
            this.typ = 9;
            this.start = n;
            this.tokens = new Vector();
            FormatTokenizer formatTokenizer = new FormatTokenizer(datLineFormat, string);
            while (formatTokenizer.hasMoreElements()) {
                String string2 = (String)formatTokenizer.nextElement();
                int n2 = 1;
                if (Character.isDigit(string2.charAt(0))) {
                    int n3 = DatLineFormat.getNumEndIdx(string2);
                    n2 = Integer.parseInt(string2.substring(0, n3));
                    string2 = string2.substring(n3);
                }
                for (int i = 0; i < n2; ++i) {
                    Token token;
                    if (string2.indexOf(40) > 0) {
                        token = new SuperToken(datLineFormat, string2, n + this.length);
                    } else {
                        token = new SingleToken(datLineFormat, string2, n + this.length);
                        token.setFill(true);
                    }
                    if (token.getTyp() == 4) continue;
                    this.length += token.length();
                    if (token.countValues() <= 0) continue;
                    this.tokens.addElement(token);
                }
            }
        }

        @Override
        void setFill(boolean bl) {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Token token = (Token)this.tokens.elementAt(i);
                token.setFill(bl);
            }
        }

        void insertElement(Token token) {
            this.length = this.start < 0 ? (this.length += token.length()) : (this.length += this.start - token.start());
            this.start = token.start();
            token.setFill(true);
            this.tokens.insertElementAt(token, 0);
        }

        @Override
        String parseValue(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.tokens.size(); ++i) {
                Token token = (Token)this.tokens.elementAt(i);
                stringBuffer.append(token.parseValue(string));
            }
            return stringBuffer.toString();
        }

        @Override
        int countValues() {
            int n = 0;
            for (int i = 0; i < this.tokens.size(); ++i) {
                n += ((Token)this.tokens.elementAt(i)).countValues();
            }
            return n;
        }

        @Override
        Token getValueToken() {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Token token = (Token)this.tokens.elementAt(i);
                if (token.countValues() != 1) continue;
                return token;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i = 0; i < this.tokens.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.tokens.elementAt(i).toString());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    private class SingleToken
    extends Token {
        int subLength = -1;
        int skip = 0;
        boolean fill = false;

        SingleToken(DatLineFormat datLineFormat, String string, int n) {
            super(datLineFormat);
            this.start = n;
            switch (string.charAt(0)) {
                case 'I': 
                case 'i': {
                    this.typ = 0;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.typ = 1;
                    break;
                }
                case 'A': 
                case 'a': {
                    this.typ = 2;
                    break;
                }
                case 'X': 
                case 'x': {
                    this.typ = 3;
                    break;
                }
                case 'T': 
                case 't': {
                    this.typ = 4;
                }
            }
            if (string.length() == 1) {
                if (this.typ == 3) {
                    this.length = 1;
                }
            } else if (this.typ == 4) {
                if (string.length() > 1) {
                    this.start = Integer.parseInt(string.substring(1)) - 1;
                }
            } else {
                this.skip = string.charAt(1) == '0' ? 1 : 0;
                int n2 = 0;
                if (this.typ == 1 && (n2 = string.indexOf(46)) > 0) {
                    this.length = Integer.parseInt(string.substring(1, n2));
                    this.subLength = Integer.parseInt(string.substring(n2 + 1));
                } else {
                    this.length = Integer.parseInt(string.substring(1));
                }
            }
        }

        @Override
        void setFill(boolean bl) {
            this.fill = bl;
        }

        @Override
        String parseValue(String string) {
            int n;
            if (this.typ == 3 || this.typ == 4 || string.length() < this.start) {
                return "";
            }
            String string2 = string.substring(this.start + this.skip, Math.min(this.start + this.length, string.length()));
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (this.fill && (this.typ == 0 || this.typ == 1)) {
                for (n = 0; n < stringBuffer.length() && stringBuffer.charAt(n) == ' '; ++n) {
                    stringBuffer.setCharAt(n, '0');
                }
            }
            if (this.subLength > 0 && string2.indexOf(".") < 0) {
                for (n = stringBuffer.length() - 1; n >= 0 && stringBuffer.charAt(n) == ' '; --n) {
                }
                if (n > 0) {
                    stringBuffer.insert(n + 1 - this.subLength, '.');
                }
            }
            return stringBuffer.toString().trim();
        }

        @Override
        int countValues() {
            switch (this.typ) {
                case 0: 
                case 1: 
                case 2: {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        Token getValueToken() {
            if (this.countValues() == 1) {
                return this;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.typ) {
                case 0: {
                    stringBuffer.append('I');
                    break;
                }
                case 1: {
                    stringBuffer.append('F');
                    break;
                }
                case 2: {
                    stringBuffer.append('A');
                    break;
                }
                case 3: {
                    stringBuffer.append('X');
                    break;
                }
                case 4: {
                    stringBuffer.append('T');
                }
            }
            stringBuffer.append(this.length);
            if (this.subLength >= 0) {
                stringBuffer.append('.');
                stringBuffer.append(this.subLength);
            }
            return stringBuffer.toString();
        }
    }

    private abstract class Token {
        static final int I = 0;
        static final int F = 1;
        static final int A = 2;
        static final int X = 3;
        static final int T = 4;
        static final int S = 9;
        int typ = 0;
        int start = -1;
        int length = 0;

        private Token(DatLineFormat datLineFormat) {
        }

        int start() {
            return this.start;
        }

        void setStart(int n) {
            this.start = n;
        }

        int length() {
            return this.length;
        }

        void setLength(int n) {
            this.length = n;
        }

        int getTyp() {
            return this.typ;
        }

        abstract String parseValue(String var1);

        abstract int countValues();

        abstract Token getValueToken();

        abstract void setFill(boolean var1);
    }

    private class FormatDef {
        private Vector tokens = new Vector();

        FormatDef(DatLineFormat datLineFormat, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                DefToken defToken;
                String string2 = stringTokenizer.nextToken();
                int n = 1;
                if (Character.isDigit(string2.charAt(0))) {
                    n = Integer.parseInt(string2.substring(0, 1));
                    defToken = new DefToken(datLineFormat, string2.substring(1));
                } else {
                    defToken = new DefToken(datLineFormat, string2);
                }
                for (int i = 0; i < n; ++i) {
                    this.tokens.addElement(defToken);
                }
            }
        }

        public int size() {
            return this.tokens.size();
        }

        public Object elementAt(int n) {
            return this.tokens.elementAt(n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.tokens.elementAt(i));
            }
            return stringBuffer.toString();
        }
    }

    private class DefToken {
        public static final String DEF_ERR = "Fehler bei der Formaterkennung, Definitionsformat enth\u00e4lt unbekanntes Token";
        public static final int I = 0;
        public static final int F = 1;
        public static final int A = 2;
        public static final int N = 9;
        int typ = -1;

        DefToken(DatLineFormat datLineFormat, String string) {
            if (string.length() != 1) {
                throw new NumberFormatException(DEF_ERR);
            }
            switch (string.charAt(0)) {
                case 'I': 
                case 'i': {
                    this.typ = 0;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.typ = 1;
                    break;
                }
                case 'A': 
                case 'a': {
                    this.typ = 2;
                    break;
                }
                case 'N': 
                case 'n': {
                    this.typ = 9;
                    break;
                }
                default: {
                    throw new NumberFormatException(DEF_ERR);
                }
            }
        }

        int getTyp() {
            return this.typ;
        }

        public String toString() {
            switch (this.typ) {
                case 0: {
                    return "I";
                }
                case 1: {
                    return "F";
                }
                case 2: {
                    return "A";
                }
                case 9: {
                    return "N";
                }
            }
            return "\u00b0";
        }
    }
}

