/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import de.geocalc.geom.DPoint;
import de.geocalc.text.GeoNumberFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class DxfFileWriter
extends PrintWriter {
    public DxfFileWriter(Writer writer) throws IOException {
        super(writer);
    }

    public void writeVar(int n, String string) {
        super.println(GeoNumberFormat.nr03.format(n).toString());
        super.println(string);
    }

    public void writeVar(int n, int n2) {
        super.println(GeoNumberFormat.nr03.format(n).toString());
        super.println(GeoNumberFormat.nr06.format(n2).toString());
    }

    public void writeVar(int n, double d) {
        super.println(GeoNumberFormat.nr03.format(n).toString());
        super.println(GeoNumberFormat.m03.format(d).toString());
    }

    public void writeLine(DPoint dPoint, DPoint dPoint2, String string) {
        this.writeLine(dPoint, dPoint2, string, null, -1);
    }

    public void writeLine(DPoint dPoint, DPoint dPoint2, String string, int n) {
        this.writeLine(dPoint, dPoint2, string, null, -n);
    }

    public void writeLine(DPoint dPoint, DPoint dPoint2, String string, String string2) {
        this.writeLine(dPoint, dPoint2, string, string2, -1);
    }

    public void writeLine(DPoint dPoint, DPoint dPoint2, String string, String string2, int n) {
        this.writeVar(0, "LINE");
        this.writeVar(8, string);
        if (string2 != null) {
            this.writeVar(6, string2);
        }
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(11, dPoint2.y);
        this.writeVar(21, dPoint2.x);
        this.writeVar(31, 0.0);
        if (n >= 0) {
            this.writeVar(62, n);
        }
    }

    public void writeSolid(DPoint dPoint, DPoint dPoint2, DPoint dPoint3, DPoint dPoint4, String string) {
        this.writeVar(0, "SOLID");
        this.writeVar(8, string);
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(11, dPoint2.y);
        this.writeVar(21, dPoint2.x);
        this.writeVar(31, 0.0);
        this.writeVar(12, dPoint3.y);
        this.writeVar(22, dPoint3.x);
        this.writeVar(32, 0.0);
        this.writeVar(13, dPoint4.y);
        this.writeVar(23, dPoint4.x);
        this.writeVar(33, 0.0);
    }

    public void writeCircle(DPoint dPoint, double d, String string) {
        this.writeCircle(dPoint, d, string, -1);
    }

    public void writeCircle(DPoint dPoint, double d, String string, int n) {
        this.writeVar(0, "CIRCLE");
        this.writeVar(8, string);
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(40, d);
        if (n >= -1) {
            this.writeVar(62, n);
        }
    }

    public void writeArc(DPoint dPoint, double d, double d2, double d3, String string) {
        this.writeArc(dPoint, d, d2, d3, string, -1);
    }

    public void writeArc(DPoint dPoint, double d, double d2, double d3, String string, int n) {
        this.writeVar(0, "ARC");
        this.writeVar(8, string);
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(40, d);
        this.writeVar(50, d2);
        this.writeVar(51, d3);
        if (n >= -1) {
            this.writeVar(62, n);
        }
    }

    public void writeInsert(String string, DPoint dPoint, double d, double d2, String string2) {
        this.writeInsert(string, dPoint, d, d2, string2, -1);
    }

    public void writeInsert(String string, DPoint dPoint, double d, double d2, String string2, int n) {
        this.writeVar(0, "INSERT");
        this.writeVar(8, string2);
        if (n >= 0) {
            this.writeVar(62, n);
        }
        this.writeVar(2, string);
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(41, d);
        this.writeVar(42, d);
        this.writeVar(50, d2);
    }

    public void writeText(String string, DPoint dPoint, int n, double d, double d2, String string2) {
        this.writeText(string, dPoint, n, d, d2, string2, -1);
    }

    public void writeText(String string, DPoint dPoint, int n, double d, double d2, String string2, int n2) {
        this.writeVar(0, "Text");
        this.writeVar(8, string2);
        if (n2 > 0) {
            this.writeVar(62, n2);
        }
        this.writeVar(10, dPoint.y);
        this.writeVar(20, dPoint.x);
        this.writeVar(30, 0.0);
        this.writeVar(11, dPoint.y);
        this.writeVar(21, dPoint.x);
        this.writeVar(31, 0.0);
        switch (n) {
            case -11: 
            case -10: 
            case -9: {
                this.writeVar(72, 0);
                break;
            }
            case -1: 
            case 0: 
            case 1: {
                this.writeVar(72, 1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.writeVar(72, 2);
            }
        }
        switch (n) {
            case -11: 
            case -1: 
            case 9: {
                this.writeVar(73, 3);
                break;
            }
            case -10: 
            case 0: 
            case 10: {
                this.writeVar(73, 2);
                break;
            }
            case -9: 
            case 1: 
            case 11: {
                this.writeVar(73, 1);
            }
        }
        this.writeVar(40, d);
        this.writeVar(1, string);
        this.writeVar(50, d2);
    }
}

