/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.text.IFormat;
import java.util.Enumeration;

public class ErrConstants {
    public static final int UNKNOWN = 0;
    public static final int ERROR = 1;
    public static final int LOC = 2;
    public static final int ELEM = 3;
    public static final int TEXT = 4;
    public static final String S_FATAL = "FATAL";
    public static final String S_ERROR = "ERROR";
    public static final String S_WARNING = "WARNING";
    public static final String S_MESSAGE = "MESSAGE";
    public static final String S_LOC = "LOC";
    public static final String S_ELEM = "ELEM";
    public static final String S_TEXT = "TEXT";
    public static final String S_END = "END";

    public static final String toString(DPoint dPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P(");
        stringBuffer.append(IFormat.f_3.format(dPoint.y).toString());
        stringBuffer.append(',');
        stringBuffer.append(IFormat.f_3.format(dPoint.x).toString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final String toString(DLine dLine) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("L(");
        stringBuffer.append(IFormat.f_3.format(dLine.ya).toString());
        stringBuffer.append(',');
        stringBuffer.append(IFormat.f_3.format(dLine.xa).toString());
        stringBuffer.append(',');
        stringBuffer.append(IFormat.f_3.format(dLine.ye).toString());
        stringBuffer.append(',');
        stringBuffer.append(IFormat.f_3.format(dLine.xe).toString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final String toString(DPolygon dPolygon) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A(");
        for (int i = 0; i < dPolygon.npoints; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(IFormat.f_3.format(dPolygon.ypoints[i]).toString());
            stringBuffer.append(',');
            stringBuffer.append(IFormat.f_3.format(dPolygon.xpoints[i]).toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final String toString(DCollection dCollection) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Enumeration enumeration = dCollection.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (n != 0) {
                stringBuffer.append("; ");
            }
            if (e instanceof DPoint) {
                stringBuffer.append(ErrConstants.toString((DPoint)e));
            }
            if (e instanceof DLine) {
                stringBuffer.append(ErrConstants.toString((DLine)e));
            }
            if (e instanceof DPolygon) {
                stringBuffer.append(ErrConstants.toString((DPolygon)e));
            }
            if (e instanceof DCollection) {
                stringBuffer.append(ErrConstants.toString((DCollection)e));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String toString(String string) {
        return string.replace("\n", "\\n");
    }
}

