/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import de.geocalc.io.CsvIOProperties;
import de.geocalc.io.GeoFileFilter;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.EsriDigitReader;
import de.geocalc.text.IFormat;
import de.geocalc.text.Pattern;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class GeoFile {
    public static final int UNKNOWN = -2;
    public static final int NODEF = -1;
    public static final int KOO = 100;
    public static final int KOO_LT3 = 103;
    public static final int KOO_LT7 = 107;
    public static final int KOO_LT8 = 108;
    public static final int KOO_LT9 = 109;
    public static final int KOO_SOFT = 121;
    public static final int KOO_GG = 122;
    public static final int KOO_GSB = 123;
    public static final int KOO_EDBS = 124;
    public static final int KOO_DBK = 125;
    public static final int KOO_KVZ = 126;
    public static final int KOO_TTP = 127;
    public static final int KOO_PDB = 128;
    public static final int KOO_PDK = 129;
    public static final int KOO_IDB = 130;
    public static final int KOO_AGA = 131;
    public static final int KOO_CSV = 132;
    public static final int KOO_KIV = 133;
    public static final int KOO_CDY = 134;
    public static final int KOO_ITR = 135;
    public static final int KOO_ALK = 136;
    public static final int KOO_STA = 137;
    public static final int KOO_GPS = 138;
    public static final int KOO_ALKIS = 139;
    public static final int KOO_ZENO = 140;
    public static final int KOO_FREE = 199;
    public static final int POL = 200;
    public static final int POL_SOFT = 201;
    public static final int POL_MES = 202;
    public static final int POL_AGA = 203;
    public static final int POL_SOK = 204;
    public static final int POL_SDR = 205;
    public static final int POL_SDRX = 206;
    public static final int POL_REC = 207;
    public static final int POL_NIK = 208;
    public static final int POL_STM = 209;
    public static final int POL_CDY = 210;
    public static final int POL_GRE = 211;
    public static final int POL_GSI = 212;
    public static final int POL_ITR = 213;
    public static final int NIV = 300;
    public static final int NIV_WNA = 301;
    public static final int GPS = 400;
    public static final int GPS_BSL = 401;
    public static final int GPS_BSP = 411;
    public static final int GPS_LQP = 412;
    public static final int DAT = 500;
    public static final int DAT_KAF = 501;
    public static final int DAT_LNE = 502;
    public static final int DAT_OUT = 503;
    public static final int DAT_GGALK = 504;
    public static final int DAT_DA040 = 505;
    public static final int DAT_RISS = 509;
    public static final int DAT_DXF = 510;
    public static final int DAT_SYP = 511;
    public static final int DAT_STA = 512;
    public static final int DAT_MKR = 513;
    public static final int DAT_UMNUM = 520;
    public static final int DAT_GGU = 521;
    public static final int DAT_XML = 530;
    public static final int DAT_ALK = 540;
    public static final int DAT_NAS = 550;
    public static final int DAT_WLDGE = 561;
    public static final int DAT_ALB = 562;
    public static final int DAT_ALBP = 563;
    public static final int DAT_CSV = 570;
    public static final int DAT_LT6 = 586;
    public static final int DAT_RID = 591;
    public static final int DAT_TFL = 592;
    public static final int DAT_STAO = 593;
    public static final int DAT_ESRI_DIG = 594;
    public static final int DAT_ZENO = 595;
    public static final int KAF = 600;
    public static final int KAF_KPV = 601;
    public static final int KAF_KPZ = 602;
    public static final int KAF_VHTM = 603;
    public static final int KAF_ERR = 604;
    public static final int KAF_KPL = 605;
    public static final int KAF_KPD = 606;
    public static final int KAF_KPP = 607;
    public static final int KAF_KPZUS = 608;
    public static final int KAF_LTA = 609;
    public static final int KAF_HOM = 610;
    public static final int KAF_GGH = 611;
    private static final String NODEF_STRING = "unbekannt";
    private static final String KOO_SOFT_STRING = "GeoSoft-Koordinaten";
    private static final String KOO_GG_STRING = "GeoGraf-Koordinaten";
    private static final String KOO_GSB_STRING = "Gsb-Koordinaten";
    private static final String KOO_EDBS_STRING = "Edbs-Koordinaten";
    private static final String KOO_DBK_STRING = "Dbk-Koordinaten";
    private static final String KOO_KVZ_STRING = "Koordinatenverzeichnis";
    private static final String KOO_LT3_STRING = "Kafka-Koordinaten";
    private static final String KOO_LT7_STRING = "Kafka-Edbsausgabe";
    private static final String KOO_LT8_STRING = "Kafka-Transformationsverbesserungen";
    private static final String KOO_LT9_STRING = "Kafka-Transformationsrestklaffen";
    private static final String KOO_TTP_STRING = "Minka-Koordinaten";
    private static final String KOO_PDB_STRING = "Punktdaten Brandenburg";
    private static final String KOO_PDK_STRING = "Kafka-Punktdaten";
    private static final String KOO_IDB_STRING = "IDB-Punktdaten";
    private static final String KOO_AGA_STRING = "Geodimeter-Koordinaten";
    private static final String KOO_CSV_STRING = "Komma-Separierte Koordinaten";
    private static final String KOO_KIV_STRING = "IBM-KIV-Koordinaten";
    private static final String KOO_CDY_STRING = "Caddy-Koordinaten";
    private static final String KOO_ITR_STRING = "GeoITR-Koordinaten";
    private static final String KOO_ALK_STRING = "ALK-Koordinaten";
    private static final String KOO_STA_STRING = "Systra-Koordinaten";
    private static final String KOO_GPS_STRING = "GPS-Koordinaten";
    private static final String KOO_ALKIS_STRING = "ALKIS-Koordinaten";
    private static final String KOO_ZENO_STRING = "Leica-Zeno-Koordinaten";
    private static final String KOO_FREE_STRING = "Freies Format Koordinaten";
    private static final String POL_SOFT_STRING = "GeoSoft-Polardaten";
    private static final String POL_MES_STRING = "Minka-Polardaten";
    private static final String POL_AGA_STRING = "Geodimeter-Polardaten";
    private static final String POL_SOK_STRING = "Sokkia-Polardaten";
    private static final String POL_SDR_STRING = "SDR-Polardaten";
    private static final String POL_SDRX_STRING = "SDR-XX-Polardaten";
    private static final String POL_REC_STRING = "Rec500-Polardaten";
    private static final String POL_NIK_STRING = "Nikon-Polardaten";
    private static final String POL_STM_STRING = "GeoFeld-Polardaten";
    private static final String POL_CDY_STRING = "Caddy-Polardaten";
    private static final String POL_GRE_STRING = "Leica-Polardaten";
    private static final String POL_GSI_STRING = "Gsi-Polardaten";
    private static final String POL_ITR_STRING = "Husky-Polardaten";
    private static final String NIV_WNA_STRING = "Wild-Nivellementdaten";
    private static final String GPS_BSL_STRING = "GPS-Basislinien";
    private static final String GPS_BSP_STRING = "GPS-Basislinien Koo";
    private static final String GPS_LQP_STRING = "LeicaQualityProtocol";
    private static final String DAT_KAF_STRING = "Kafka-Daten";
    private static final String DAT_LNE_STRING = "Geograf-Linien";
    private static final String DAT_OUT_STRING = "Geograf-Grafik";
    private static final String DAT_GGALK_STRING = "Geograf-ALK-Grafik";
    private static final String DAT_DA040_STRING = "Datenart 040";
    private static final String DAT_DXF_STRING = "AutoCAD-Dxf";
    private static final String DAT_SYP_STRING = "Systra-Projekt";
    private static final String DAT_STA_STRING = "Systra-Startdatei";
    private static final String DAT_MKR_STRING = "Xdesy-Projekt";
    private static final String DAT_UMNUM_STRING = "Umnummerierungsliste";
    private static final String DAT_GGU_STRING = "Geograf-Umnummerierung";
    private static final String DAT_XML_STRING = "Xml-Daten";
    private static final String DAT_ALK_STRING = "ALK-Daten";
    private static final String DAT_NAS_STRING = "NAS-Daten";
    private static final String DAT_WLDGE_STRING = "ALB-Daten";
    private static final String DAT_ALB_STRING = "ALB-Textdatei";
    private static final String DAT_ALBP_STRING = "ALB-Printdatei";
    private static final String DAT_CSV_STRING = "CSV-Fehlerdatei";
    private static final String DAT_LT6_STRING = "Kafka-Fehlerdatei";
    private static final String DAT_RID_STRING = "Image Georeferenzierung";
    private static final String DAT_TFL_STRING = "KafPlot Georeferenzierung";
    private static final String DAT_STAO_STRING = "Systra Ergebnisse";
    private static final String DAT_ESRI_DIG_STRING = "ESRI-Digitalisiersystem";
    private static final String DAT_RISS_STRING = "Geograf-Riss";
    private static final String DAT_ZENO_STRING = "Leica-Zeno-Daten";
    private static final String KAF_KPV_STRING = "KafPlotViewer-Daten";
    private static final String KAF_KPZ_STRING = "KafPlotViewer-Daten-Zip";
    private static final String KAF_VHTM_STRING = "KafPlotViewer";
    private static final String KAF_ERR_STRING = "KafPlot-Fehler";
    private static final String KAF_KPL_STRING = "KafPlot-Liste Punktgenauigkeit";
    private static final String KAF_KPD_STRING = "KafPlot-Liste Punktdifferenz";
    private static final String KAF_KPP_STRING = "KafPlot-Projekt";
    private static final String KAF_KPZUS_STRING = "KafPlot-Zusatzdaten";
    private static final String KAF_LTA_STRING = "KafPlot-Koordinatensicherung";
    private static final String KAF_HOM_STRING = "KafPlot-Homogenisierungsergebnisse";
    private static final String KAF_GGH_STRING = "KafPlot-Homogenisierung f\u00fcr Geograf";
    private static final String KOO_SOFT_EXTENSION = "";
    private static final String KOO_GG_EXTENSION = "pkt";
    private static final String KOO_GSB_EXTENSION = "gsb";
    private static final String KOO_EDBS_EXTENSION = "edb";
    private static final String KOO_DBK_EXTENSION = "dbk";
    private static final String KOO_KVZ_EXTENSION = "kvz";
    private static final String KOO_LT3_EXTENSION = "lt3";
    private static final String KOO_LT7_EXTENSION = "lt7";
    private static final String KOO_LT8_EXTENSION = "lt8";
    private static final String KOO_LT9_EXTENSION = "lt9";
    private static final String KOO_TTP_EXTENSION = "ttp";
    private static final String KOO_PDB_EXTENSION = "pdb";
    private static final String KOO_PDK_EXTENSION = "pdk";
    private static final String KOO_IDB_EXTENSION = "idb";
    private static final String KOO_AGA_EXTENSION = "are";
    private static final String KOO_CSV_EXTENSION = "csv";
    private static final String KOO_KIV_EXTENSION = "kiv";
    private static final String KOO_CDY_EXTENSION = "kor";
    private static final String KOO_ITR_EXTENSION = "koo";
    private static final String KOO_ALK_EXTENSION = "ul8";
    private static final String KOO_STA_EXTENSION = "koo";
    private static final String KOO_GPS_EXTENSION = "gps";
    private static final String KOO_ALKIS_EXTENSION = "alkis";
    private static final String KOO_ZENO_EXTENSION = "txt";
    private static final String KOO_FREE_EXTENSION = "koo";
    private static final String POL_SOFT_EXTENSION = "geo";
    private static final String POL_MES_EXTENSION = "mes";
    private static final String POL_AGA_EXTENSION = "aga";
    private static final String POL_SOK_EXTENSION = "sok.out";
    private static final String POL_SDR_EXTENSION = "mes";
    private static final String POL_SDRX_EXTENSION = "roh";
    private static final String POL_REC_EXTENSION = "rec";
    private static final String POL_NIK_EXTENSION = "roh";
    private static final String POL_STM_EXTENSION = "stm";
    private static final String POL_CDY_EXTENSION = "dat";
    private static final String POL_GRE_EXTENSION = "gre";
    private static final String POL_GSI_EXTENSION = "gsi";
    private static final String POL_ITR_EXTENSION = "itr";
    private static final String NIV_WNA_EXTENSION = "na";
    private static final String GPS_BSL_EXTENSION = "bsl";
    private static final String GPS_BSP_EXTENSION = "bsp";
    private static final String GPS_LQP_EXTENSION = "lqp";
    private static final String DAT_KAF_EXTENSION = "dat";
    private static final String DAT_LNE_EXTENSION = "lne";
    private static final String DAT_OUT_EXTENSION = "plan.out";
    private static final String DAT_GGALK_EXTENSION = "alk.out";
    private static final String DAT_DA040_EXTENSION = "d40";
    private static final String DAT_RISS_EXTENSION = "riss.out";
    private static final String DAT_DXF_EXTENSION = "dxf";
    private static final String DAT_SYP_EXTENSION = "syp";
    private static final String DAT_STA_EXTENSION = "sta";
    private static final String DAT_MKR_EXTENSION = "mkr";
    private static final String DAT_UMNUM_EXTENSION = "unl";
    private static final String DAT_GGU_EXTENSION = "unl.out";
    private static final String DAT_XML_EXTENSION = "xml";
    private static final String DAT_ALK_EXTENSION = "bspe";
    private static final String DAT_NAS_EXTENSION = "nas.xml";
    private static final String DAT_WLDGE_EXTENSION = "wldge";
    private static final String DAT_ALB_EXTENSION = "alb.txt";
    private static final String DAT_ALBP_EXTENSION = "alb";
    private static final String DAT_CSV_EXTENSION = "csv";
    private static final String DAT_ZENO_EXTENSION = "txt.zip";
    private static final String DAT_LT6_EXTENSION = "lt6";
    private static final String DAT_RID_EXTENSION = "rid";
    private static final String DAT_TFL_EXTENSION = "tfl";
    private static final String DAT_STAO_EXTENSION = "out";
    private static final String DAT_ESRI_DIG_EXTENSION = "esri.txt";
    private static final String KAF_KPV_EXTENSION = "kpv";
    private static final String KAF_KPZ_EXTENSION = "kpz";
    private static final String KAF_VHTM_EXTENSION = "html";
    private static final String KAF_ERR_EXTENSION = "err";
    private static final String KAF_KPL_EXTENSION = "kpl";
    private static final String KAF_KPD_EXTENSION = "kpd";
    private static final String KAF_KPP_EXTENSION = "kpp";
    private static final String KAF_KPZUS_EXTENSION = "kpzus";
    private static final String KAF_LTA_EXTENSION = "lta";
    private static final String KAF_HOM_EXTENSION = "hom";
    private static final String KAF_GGH_EXTENSION = "ggh";
    private static final Hashtable fileTypStrings = new Hashtable();
    private static final Hashtable fileTypExtensions = new Hashtable();
    private File geoFile = null;
    private int geoFileTyp;
    private String encoding = null;

    public GeoFile() throws Exception {
        this(null);
    }

    public GeoFile(File file, int n) throws Exception {
        this.geoFile = file;
        this.geoFileTyp = n;
    }

    public GeoFile(File file) throws Exception {
        this.geoFile = file;
        if (file != null) {
            String string = GeoFile.detectEncoding(file);
            try {
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), string != null ? string : "Cp1252"));
                String string2 = lineNumberReader.readLine();
                if (string2 == null) {
                    this.geoFileTyp = -1;
                } else {
                    String string3 = lineNumberReader.readLine();
                    do {
                        this.geoFileTyp = this.detectFileType(lineNumberReader, string2, string3);
                        string2 = string3;
                        string3 = lineNumberReader.readLine();
                    } while (this.geoFileTyp == -2 && string2 != null);
                    if (this.geoFileTyp == -2) {
                        this.geoFileTyp = -1;
                    }
                }
                lineNumberReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Datei " + file.getName() + " nicht gefunden!");
            }
            catch (IOException iOException) {
                throw new IOException("Konnte Datei " + file.getName() + " nicht lesen");
            }
            catch (Exception exception) {
                this.geoFileTyp = -1;
                exception.printStackTrace();
            }
            if (this.geoFileTyp == -1) {
                throw new IFileInputException("Datei " + file.getName() + " besitzt kein g\u00fcltiges Dateiformat!");
            }
            if (string != null) {
                this.encoding = string;
                System.out.println(this.toString() + ", Detected Encoding: " + this.encoding);
            }
        }
    }

    public int getFileTyp() {
        return this.geoFileTyp;
    }

    public static String detectEncoding(File file) {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4];
            int n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length);
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                string = "UTF-32BE";
            } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
                string = "UTF-32LE";
            } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                string = "UTF-8";
            } else if (byArray[0] == -2 && byArray[1] == -1) {
                string = "UTF-16BE";
            } else if (byArray[0] == -1 && byArray[1] == -2) {
                string = "UTF-16LE";
            }
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private int detectFileType(LineNumberReader lineNumberReader, String string, String string2) throws Exception {
        int n = -1;
        if (string.startsWith("#KafPlotViewer")) {
            return 601;
        }
        if (string.startsWith("#KafPlot-Projekt")) {
            return 607;
        }
        if (string.startsWith("#GPS-Basislinien-Koo")) {
            return 411;
        }
        if (string.startsWith("#GPS-Basislinien")) {
            return 401;
        }
        if (string.startsWith("LeicaQualityProtocol ")) {
            return 412;
        }
        if (string.startsWith("#KafPlot-Fehler")) {
            return 604;
        }
        if (string.startsWith("#KafPlot Liste-Punktgenauigkeit")) {
            return 605;
        }
        if (string.startsWith("#KafPlot Liste-Punktdifferenz")) {
            return 606;
        }
        if (string.startsWith("#KafPlot Zusatz")) {
            return 608;
        }
        if (string.startsWith("#Caddy")) {
            return 134;
        }
        if (string.startsWith("#KafPlot-Georeferenzierungen")) {
            return 592;
        }
        if (string.startsWith("#KafPlot-Koordinatensicherung")) {
            return 609;
        }
        if (string.indexOf("FID;VID;X;Y;") >= 0) {
            return 140;
        }
        if (string.indexOf("<AX_Bestandsdatenauszug") >= 0) {
            return 550;
        }
        if (string.indexOf("<?xml ") >= 0) {
            if (string.indexOf("http://www.adv-online.de/namespaces/adv/gid/") >= 0) {
                return 550;
            }
            if (string2 != null && string2.indexOf("http://www.adv-online.de/namespaces/adv/gid/") >= 0) {
                return 550;
            }
            String string3 = null;
            int n2 = 0;
            while ((string3 = lineNumberReader.readLine()) != null) {
                if (string3.indexOf("http://www.adv-online.de/namespaces/adv/gid/") >= 0) {
                    return 550;
                }
                if (string3.indexOf("<AX_Bestandsdatenauszug") >= 0) {
                    return 550;
                }
                if (n2++ <= 100) continue;
            }
            return -2;
        }
        if (string2 != null && string2.startsWith(" NB1")) {
            return 103;
        }
        if (string2 != null && string2.startsWith(" ---")) {
            return 586;
        }
        if (string.startsWith("I") && string.length() < 4) {
            return 107;
        }
        if (string.startsWith("*") && string2 != null && string2.startsWith("* GRAFBAT")) {
            return 503;
        }
        if (string.startsWith("#NAS-Export ")) {
            return 139;
        }
        if (string.length() >= 65 && string.charAt(0) != ' ' && string.charAt(1) == ' ' && string.charAt(16) != ' ' && string.charAt(17) == ' ' && string.charAt(32) != ' ' && string.charAt(33) == ' ' && string.charAt(34) != ' ' && string.charAt(42) == '.' && string.charAt(46) == ' ' && string.charAt(47) != ' ' && string.charAt(54) == '.' && string.charAt(58) == ' ') {
            return 139;
        }
        if (string.startsWith("#A")) {
            return 204;
        }
        if (string.startsWith("A") && string.length() == 1) {
            return 207;
        }
        if (string.startsWith("* Messdatenk")) {
            return 205;
        }
        if (string.length() > 24 && string.startsWith("10 ") && string.charAt(24) == '.') {
            return 202;
        }
        if (string.startsWith("CO,Nikon")) {
            return 208;
        }
        if (string.startsWith("00NMSDR") || string2 != null && string2.startsWith("00NMSDR")) {
            return 206;
        }
        if (string.startsWith("00") && string2 != null && string2.startsWith("05")) {
            return 209;
        }
        if (string.length() > 17 && string.charAt(5) != ' ' && string.charAt(6) == '+' && string.charAt(8) != ' ' && string.charAt(15) == ' ' || string.length() > 14 && string.charAt(5) != ' ' && string.charAt(6) == '+' && string.charAt(7) == '?' && string.charAt(14) != ' ') {
            return 211;
        }
        if (string.length() > 9 && string.startsWith("*") && string.charAt(6) != ' ' && string.charAt(7) == '+' && string.charAt(9) != ' ' || string.startsWith("*00 ")) {
            return 212;
        }
        if (string.startsWith("Polarpunktberechnung") || string.startsWith("10 ") || string.length() >= 53 && string.charAt(0) == ' ' && string.charAt(15) == '.' && string.charAt(18) == ' ' && string.charAt(22) == '.' && string.charAt(26) == ' ' && string.charAt(30) == '.' && string.charAt(35) == ' ' && string.charAt(39) == '.' && string.charAt(53) != ' ' || string2 != null && string2.length() >= 53 && string2.charAt(0) == ' ' && string2.charAt(15) == '.' && string2.charAt(18) == ' ' && string2.charAt(22) == '.' && string2.charAt(26) == ' ' && string2.charAt(30) == '.' && string2.charAt(35) == ' ' && string2.charAt(39) == '.' && string2.charAt(53) != ' ') {
            return 201;
        }
        if (string.length() >= 29 && string.startsWith("-") && string.charAt(29) == '.' || string.length() >= 47 && string.charAt(16) == '.' && string.charAt(29) == '.' && string.charAt(38) == '.' && string.charAt(47) == '.') {
            return 210;
        }
        if (string.startsWith("50=")) {
            return 203;
        }
        if (string.startsWith("5=")) {
            return 131;
        }
        if (string.length() >= 69 && string.charAt(0) == ' ' && string.charAt(23) == '.' && string.charAt(38) == '.' && string.charAt(53) == '.' || string.length() >= 70 && string.substring(16, 20).equals("    ") && string.charAt(27) == '.' && string.charAt(42) == '.' || string.length() >= 53 && string.charAt(0) == ' ' && string.charAt(15) == '.' && string.charAt(17) == ' ' && string.charAt(25) == '.' && string.charAt(29) == ' ' && string.charAt(37) == '.' && string.charAt(41) == ' ' && string.charAt(49) == '.') {
            return 121;
        }
        if (string.length() >= 57 && string.charAt(4) == '.' && string.charAt(42) == '.' && string.charAt(54) == '.') {
            return 123;
        }
        if (string.startsWith("EDBS")) {
            String string4 = null;
            while ((string4 = lineNumberReader.readLine()) != null) {
                if (string4.length() <= 34) continue;
                String string5 = string4.substring(28, 35);
                if (string5.equals("ULPUNN ")) {
                    return 124;
                }
                if (!string5.equals("ULO8ALK") && !string5.equals("ULOBNN ")) continue;
                return 540;
            }
            return -1;
        }
        if (string.length() > 47 && string.charAt(0) == ' ' && string.charAt(24) == '.' && string.charAt(37) == '.' && string.charAt(47) == '.') {
            return 125;
        }
        if (string.length() > 43 && string.charAt(14) != ' ' && string.charAt(15) == ' ' && string.charAt(20) != ' ' && string.charAt(21) == ' ' && string.charAt(30) == '.' && string.charAt(43) == '.') {
            return 122;
        }
        if (string.length() > 53 && string.charAt(11) == ',' && string.charAt(25) == ',' && string.charAt(39) == ',' && string.charAt(53) == ',') {
            return 127;
        }
        if (string.length() > 54 && string.charAt(0) != ' ' && string.charAt(42) == '.' && string.charAt(54) == '.') {
            return 128;
        }
        if (string.length() > 37 && string.charAt(24) == '.' && string.charAt(37) == '.') {
            return 129;
        }
        if (string.length() > 38 && string.charAt(25) == '.' && string.charAt(38) == '.') {
            return 129;
        }
        if (string.length() > 48 && string.charAt(14) != ' ' && string.charAt(15) == ' ' && string.charAt(24) != ' ' && string.charAt(25) == ' ' && string.charAt(34) == '.' && string.charAt(47) == '.') {
            return 122;
        }
        if (string.length() > 55 && string.charAt(14) != ' ' && string.charAt(15) == ' ' && string.charAt(29) != ' ' && string.charAt(30) == ' ' && string.charAt(39) == '.' && string.charAt(52) == '.') {
            return 122;
        }
        if (string.length() > 43 && string.charAt(14) != ' ' && string.charAt(15) == ' ' && string.charAt(17) != ' ' && string.charAt(18) == ' ' && string.charAt(28) == '.' && string.charAt(41) == '.') {
            return 122;
        }
        if (string.length() > 29 && string.charAt(0) != ' ' && string.charAt(5) != ' ' && string.charAt(6) == ' ' && string.charAt(14) == '.' && string.charAt(17) != ' ' && string.charAt(18) == ' ' && string.charAt(26) == '.' && string.charAt(29) != ' ') {
            return 130;
        }
        if (string.startsWith("#KafPlot-Umnum") || string.length() >= 20 && string.charAt(0) == '8' && string.charAt(14) != ' ' && string.charAt(15) == ' ') {
            return 520;
        }
        if (string.length() > 55 && string.charAt(0) != ' ' && string.charAt(9) != ' ' && string.charAt(10) == ' ' && string.charAt(26) == 'D' && string.charAt(30) == '0' && string.charAt(31) == '0' && string.charAt(49) == '1' && string.charAt(50) == '1') {
            return 561;
        }
        if (string.startsWith("*------------------------------------*------------------------------------*") && string2.startsWith("|AUSZUG AUS DEM LIEGENSCHAFTSKATASTER|")) {
            return 562;
        }
        if (string.trim().startsWith("Druckauftrags-Nr.") || string2.trim().startsWith("Druckauftrags-Nr.")) {
            return 563;
        }
        if (IFormat.countChar(string, ',') >= 2 && string.indexOf("(") < 0) {
            return 132;
        }
        if (string.length() > 42 && string.charAt(0) != ' ' && string.charAt(1) != ' ' && string.charAt(2) != ' ' && string.charAt(6) != ' ' && string.charAt(7) == ' ' && string.charAt(18) != ' ' && string.charAt(19) == ' ' && string.charAt(20) == ' ' && string.charAt(30) != ' ' && string.charAt(31) == ' ' && string.charAt(32) == ' ' && string.charAt(42) != ' ') {
            return 133;
        }
        if (!(string2 == null || string2.length() <= 75 || string2.charAt(0) != ' ' || string2.charAt(1) != '0' && string2.charAt(1) != '1' && string2.charAt(1) != '2' || string2.charAt(3) == ' ' || string2.charAt(4) != ' ' || string2.charAt(5) != '1' && string2.charAt(5) != '2' && string2.charAt(5) != '3' && string2.charAt(5) != '4' || string2.charAt(6) != ' ' && string2.charAt(6) != '-' || string2.charAt(7) != '1' && string2.charAt(7) != '2' || string2.charAt(8) != ' ')) {
            return 501;
        }
        if (string.length() == 86 && string.charAt(56) == ' ') {
            return 134;
        }
        if (new Pattern("00000#####0.000###0.000######0.0000####0.000###0.0000000 000000::000 000000::000").contains(string)) {
            return 505;
        }
        if (new Pattern(" ~~~~~~~~~~~~~0.0 ~~~0.000 ~~0.0000 ~~0.0000         0                        **", 3).contains(string)) {
            return 213;
        }
        if (string.startsWith(" ------------------------") && string2 != null && (string2.startsWith(" Standard-RID-Datei") || string2.startsWith(" Datei: "))) {
            return 591;
        }
        if (string.length() >= 60 && string.charAt(0) == ' ' && string.charAt(14) != ' ' && string.charAt(15) == ' ' && string.charAt(25) == '.' && string.charAt(40) == '.' && string.charAt(70) == ' ' && string.charAt(71) != ' ') {
            return 137;
        }
        if (string.length() >= 39 && string.charAt(13) != ' ' && string.charAt(14) == ' ' && string.charAt(15) == ' ' && string.charAt(16) != ' ' && string.charAt(22) == '.' && string.charAt(26) == ' ' && string.charAt(27) == ' ' && string.charAt(28) != ' ' && string.charAt(35) == '.') {
            return 138;
        }
        if (string.startsWith("[programminfo]") && string2 != null && string2.startsWith("version=")) {
            return 511;
        }
        if (string.startsWith("INI=")) {
            return 512;
        }
        if (string.startsWith("PK")) {
            return 602;
        }
        if (string.startsWith("           P r o g r a m m   S y s t r a")) {
            return 593;
        }
        if (EsriDigitReader.detectLine(string)) {
            return 594;
        }
        if (CsvIOProperties.parseColDelim(string) != '\u0000' && CsvIOProperties.parseColDelim(string) != ' ') {
            return 570;
        }
        if (string.trim().startsWith("Datum:") || string.trim().startsWith("Jobname:") || string.trim().startsWith("Instrument")) {
            String string6 = null;
            int n3 = 0;
            while ((string6 = lineNumberReader.readLine()) != null) {
                if (string6.length() > 9 && string6.startsWith("*") && string6.charAt(6) != ' ' && string6.charAt(7) == '+' && string6.charAt(9) != ' ' || string6.startsWith("*00 ")) {
                    return 212;
                }
                if (n3++ <= 10) continue;
            }
            return -2;
        }
        return string.startsWith("*") || string.trim().length() == 0 ? -2 : -1;
    }

    public int getFileGroup() {
        if (this.geoFileTyp == -1) {
            return -1;
        }
        if (this.geoFileTyp > 100 && this.geoFileTyp < 200) {
            return 100;
        }
        if (this.geoFileTyp > 200 && this.geoFileTyp < 400) {
            return 200;
        }
        if (this.geoFileTyp > 400 && this.geoFileTyp < 500) {
            return 400;
        }
        if (this.geoFileTyp > 500 && this.geoFileTyp < 600) {
            return 500;
        }
        if (this.geoFileTyp > 600) {
            return 600;
        }
        return -1;
    }

    public static int getFileTyp(String string) {
        Enumeration enumeration = fileTypStrings.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string2 = (String)fileTypStrings.get(n);
            if (!string2.equals(string)) continue;
            return n;
        }
        return -1;
    }

    public String getFileTypString() {
        String string = GeoFile.getFileTypString(this.geoFileTyp);
        return string != null ? string : NODEF_STRING;
    }

    public static String getFileTypString(int n) {
        return (String)fileTypStrings.get(new Integer(n));
    }

    public String getFileTypExtension() {
        return GeoFile.getFileTypExtension(this.geoFileTyp);
    }

    public static String getFileTypExtension(int n) {
        return (String)fileTypExtensions.get(new Integer(n));
    }

    public static int getFileTypOfExtension(String string) {
        Enumeration enumeration = fileTypExtensions.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string2 = (String)fileTypExtensions.get(n);
            if (!string.equals(string2)) continue;
            return n;
        }
        return -1;
    }

    public boolean isKatFileTyp() {
        switch (this.geoFileTyp) {
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 133: 
            case 139: {
                return true;
            }
        }
        return false;
    }

    public boolean is3DTyp() {
        return GeoFile.is3DTyp(this.geoFileTyp);
    }

    public static boolean is3DTyp(int n) {
        switch (n) {
            case 121: 
            case 122: 
            case 124: 
            case 127: 
            case 129: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 138: 
            case 139: 
            case 140: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 211: 
            case 212: 
            case 213: 
            case 301: 
            case 401: 
            case 411: 
            case 412: 
            case 503: 
            case 504: 
            case 509: 
            case 530: {
                return true;
            }
        }
        return false;
    }

    public File getFile() {
        return this.geoFile;
    }

    public String getName() {
        return this.geoFile.getName();
    }

    public String toString() {
        return "GeoFile: " + this.getName() + " [" + GeoFile.getFileTypString(this.getFileTyp()) + "]";
    }

    public static FileFilter fileFilter(int n) {
        Object object = GeoFile.getFileTypExtension(n);
        String string = GeoFile.getFileTypString(n);
        object = object == null ? KOO_SOFT_EXTENSION : "." + (String)object;
        if (string == null) {
            string = NODEF_STRING;
        }
        return new GeoFileFilter((String)object, string);
    }

    public static File getDirectory(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getAbsolutePath()).lastIndexOf(File.separator)) > 0) {
            return new File(string.substring(0, n));
        }
        return new File(".");
    }

    static {
        fileTypStrings.put(new Integer(-1), NODEF_STRING);
        fileTypStrings.put(new Integer(121), KOO_SOFT_STRING);
        fileTypStrings.put(new Integer(122), KOO_GG_STRING);
        fileTypStrings.put(new Integer(123), KOO_GSB_STRING);
        fileTypStrings.put(new Integer(124), KOO_EDBS_STRING);
        fileTypStrings.put(new Integer(125), KOO_DBK_STRING);
        fileTypStrings.put(new Integer(126), KOO_KVZ_STRING);
        fileTypStrings.put(new Integer(103), KOO_LT3_STRING);
        fileTypStrings.put(new Integer(107), KOO_LT7_STRING);
        fileTypStrings.put(new Integer(108), KOO_LT8_STRING);
        fileTypStrings.put(new Integer(109), KOO_LT9_STRING);
        fileTypStrings.put(new Integer(127), KOO_TTP_STRING);
        fileTypStrings.put(new Integer(128), KOO_PDB_STRING);
        fileTypStrings.put(new Integer(129), KOO_PDK_STRING);
        fileTypStrings.put(new Integer(130), KOO_IDB_STRING);
        fileTypStrings.put(new Integer(131), KOO_AGA_STRING);
        fileTypStrings.put(new Integer(132), KOO_CSV_STRING);
        fileTypStrings.put(new Integer(133), KOO_KIV_STRING);
        fileTypStrings.put(new Integer(134), KOO_CDY_STRING);
        fileTypStrings.put(new Integer(135), KOO_ITR_STRING);
        fileTypStrings.put(new Integer(136), KOO_ALK_STRING);
        fileTypStrings.put(new Integer(137), KOO_STA_STRING);
        fileTypStrings.put(new Integer(138), KOO_GPS_STRING);
        fileTypStrings.put(new Integer(139), KOO_ALKIS_STRING);
        fileTypStrings.put(new Integer(140), KOO_ZENO_STRING);
        fileTypStrings.put(new Integer(199), KOO_FREE_STRING);
        fileTypStrings.put(new Integer(201), POL_SOFT_STRING);
        fileTypStrings.put(new Integer(202), POL_MES_STRING);
        fileTypStrings.put(new Integer(203), POL_AGA_STRING);
        fileTypStrings.put(new Integer(204), POL_SOK_STRING);
        fileTypStrings.put(new Integer(205), POL_SDR_STRING);
        fileTypStrings.put(new Integer(206), POL_SDRX_STRING);
        fileTypStrings.put(new Integer(207), POL_REC_STRING);
        fileTypStrings.put(new Integer(208), POL_NIK_STRING);
        fileTypStrings.put(new Integer(209), POL_STM_STRING);
        fileTypStrings.put(new Integer(210), POL_CDY_STRING);
        fileTypStrings.put(new Integer(211), POL_GRE_STRING);
        fileTypStrings.put(new Integer(212), POL_GSI_STRING);
        fileTypStrings.put(new Integer(213), POL_ITR_STRING);
        fileTypStrings.put(new Integer(301), NIV_WNA_STRING);
        fileTypStrings.put(new Integer(401), GPS_BSL_STRING);
        fileTypStrings.put(new Integer(411), GPS_BSP_STRING);
        fileTypStrings.put(new Integer(412), GPS_LQP_STRING);
        fileTypStrings.put(new Integer(501), DAT_KAF_STRING);
        fileTypStrings.put(new Integer(502), DAT_LNE_STRING);
        fileTypStrings.put(new Integer(503), DAT_OUT_STRING);
        fileTypStrings.put(new Integer(504), DAT_GGALK_STRING);
        fileTypStrings.put(new Integer(505), DAT_DA040_STRING);
        fileTypStrings.put(new Integer(509), DAT_RISS_STRING);
        fileTypStrings.put(new Integer(510), DAT_DXF_STRING);
        fileTypStrings.put(new Integer(511), DAT_SYP_STRING);
        fileTypStrings.put(new Integer(512), DAT_STA_STRING);
        fileTypStrings.put(new Integer(513), DAT_MKR_STRING);
        fileTypStrings.put(new Integer(520), DAT_UMNUM_STRING);
        fileTypStrings.put(new Integer(521), DAT_GGU_STRING);
        fileTypStrings.put(new Integer(530), DAT_XML_STRING);
        fileTypStrings.put(new Integer(540), DAT_ALK_STRING);
        fileTypStrings.put(new Integer(550), DAT_NAS_STRING);
        fileTypStrings.put(new Integer(561), DAT_WLDGE_STRING);
        fileTypStrings.put(new Integer(562), DAT_ALB_STRING);
        fileTypStrings.put(new Integer(563), DAT_ALBP_STRING);
        fileTypStrings.put(new Integer(570), DAT_CSV_STRING);
        fileTypStrings.put(new Integer(595), DAT_ZENO_STRING);
        fileTypStrings.put(new Integer(586), DAT_LT6_STRING);
        fileTypStrings.put(new Integer(591), DAT_RID_STRING);
        fileTypStrings.put(new Integer(592), DAT_TFL_STRING);
        fileTypStrings.put(new Integer(593), DAT_STAO_STRING);
        fileTypStrings.put(new Integer(594), DAT_ESRI_DIG_STRING);
        fileTypStrings.put(new Integer(601), KAF_KPV_STRING);
        fileTypStrings.put(new Integer(602), KAF_KPZ_STRING);
        fileTypStrings.put(new Integer(603), KAF_VHTM_STRING);
        fileTypStrings.put(new Integer(604), KAF_ERR_STRING);
        fileTypStrings.put(new Integer(605), KAF_KPL_STRING);
        fileTypStrings.put(new Integer(606), KAF_KPD_STRING);
        fileTypStrings.put(new Integer(607), KAF_KPP_STRING);
        fileTypStrings.put(new Integer(608), KAF_KPZUS_STRING);
        fileTypStrings.put(new Integer(609), KAF_LTA_STRING);
        fileTypStrings.put(new Integer(610), KAF_HOM_STRING);
        fileTypStrings.put(new Integer(611), KAF_GGH_STRING);
        fileTypExtensions.put(new Integer(121), KOO_SOFT_EXTENSION);
        fileTypExtensions.put(new Integer(122), KOO_GG_EXTENSION);
        fileTypExtensions.put(new Integer(123), KOO_GSB_EXTENSION);
        fileTypExtensions.put(new Integer(124), KOO_EDBS_EXTENSION);
        fileTypExtensions.put(new Integer(125), KOO_DBK_EXTENSION);
        fileTypExtensions.put(new Integer(126), KOO_KVZ_EXTENSION);
        fileTypExtensions.put(new Integer(103), KOO_LT3_EXTENSION);
        fileTypExtensions.put(new Integer(107), KOO_LT7_EXTENSION);
        fileTypExtensions.put(new Integer(108), KOO_LT8_EXTENSION);
        fileTypExtensions.put(new Integer(109), KOO_LT9_EXTENSION);
        fileTypExtensions.put(new Integer(127), KOO_TTP_EXTENSION);
        fileTypExtensions.put(new Integer(128), KOO_PDB_EXTENSION);
        fileTypExtensions.put(new Integer(129), KOO_PDK_EXTENSION);
        fileTypExtensions.put(new Integer(130), KOO_IDB_EXTENSION);
        fileTypExtensions.put(new Integer(131), KOO_AGA_EXTENSION);
        fileTypExtensions.put(new Integer(132), "csv");
        fileTypExtensions.put(new Integer(133), KOO_KIV_EXTENSION);
        fileTypExtensions.put(new Integer(134), KOO_CDY_EXTENSION);
        fileTypExtensions.put(new Integer(135), "koo");
        fileTypExtensions.put(new Integer(136), KOO_ALK_EXTENSION);
        fileTypExtensions.put(new Integer(137), "koo");
        fileTypExtensions.put(new Integer(138), KOO_GPS_EXTENSION);
        fileTypExtensions.put(new Integer(139), KOO_ALKIS_EXTENSION);
        fileTypExtensions.put(new Integer(140), KOO_ZENO_EXTENSION);
        fileTypExtensions.put(new Integer(199), "koo");
        fileTypExtensions.put(new Integer(201), POL_SOFT_EXTENSION);
        fileTypExtensions.put(new Integer(202), "mes");
        fileTypExtensions.put(new Integer(203), POL_AGA_EXTENSION);
        fileTypExtensions.put(new Integer(204), POL_SOK_EXTENSION);
        fileTypExtensions.put(new Integer(205), "mes");
        fileTypExtensions.put(new Integer(206), "roh");
        fileTypExtensions.put(new Integer(207), POL_REC_EXTENSION);
        fileTypExtensions.put(new Integer(208), "roh");
        fileTypExtensions.put(new Integer(209), POL_STM_EXTENSION);
        fileTypExtensions.put(new Integer(210), "dat");
        fileTypExtensions.put(new Integer(211), POL_GRE_EXTENSION);
        fileTypExtensions.put(new Integer(212), POL_GSI_EXTENSION);
        fileTypExtensions.put(new Integer(213), POL_ITR_EXTENSION);
        fileTypExtensions.put(new Integer(301), NIV_WNA_EXTENSION);
        fileTypExtensions.put(new Integer(401), GPS_BSL_EXTENSION);
        fileTypExtensions.put(new Integer(411), GPS_BSP_EXTENSION);
        fileTypExtensions.put(new Integer(412), GPS_LQP_EXTENSION);
        fileTypExtensions.put(new Integer(501), "dat");
        fileTypExtensions.put(new Integer(502), DAT_LNE_EXTENSION);
        fileTypExtensions.put(new Integer(503), DAT_OUT_EXTENSION);
        fileTypExtensions.put(new Integer(504), DAT_GGALK_EXTENSION);
        fileTypExtensions.put(new Integer(505), DAT_DA040_EXTENSION);
        fileTypExtensions.put(new Integer(509), DAT_RISS_EXTENSION);
        fileTypExtensions.put(new Integer(510), DAT_DXF_EXTENSION);
        fileTypExtensions.put(new Integer(511), DAT_SYP_EXTENSION);
        fileTypExtensions.put(new Integer(512), DAT_STA_EXTENSION);
        fileTypExtensions.put(new Integer(513), DAT_MKR_EXTENSION);
        fileTypExtensions.put(new Integer(520), DAT_UMNUM_EXTENSION);
        fileTypExtensions.put(new Integer(521), DAT_GGU_EXTENSION);
        fileTypExtensions.put(new Integer(530), DAT_XML_EXTENSION);
        fileTypExtensions.put(new Integer(540), DAT_ALK_EXTENSION);
        fileTypExtensions.put(new Integer(550), DAT_NAS_EXTENSION);
        fileTypExtensions.put(new Integer(561), DAT_WLDGE_EXTENSION);
        fileTypExtensions.put(new Integer(562), DAT_ALB_EXTENSION);
        fileTypExtensions.put(new Integer(563), DAT_ALBP_EXTENSION);
        fileTypExtensions.put(new Integer(570), "csv");
        fileTypExtensions.put(new Integer(595), DAT_ZENO_EXTENSION);
        fileTypExtensions.put(new Integer(586), DAT_LT6_EXTENSION);
        fileTypExtensions.put(new Integer(591), DAT_RID_EXTENSION);
        fileTypExtensions.put(new Integer(592), DAT_TFL_EXTENSION);
        fileTypExtensions.put(new Integer(593), DAT_STAO_EXTENSION);
        fileTypExtensions.put(new Integer(594), DAT_ESRI_DIG_EXTENSION);
        fileTypExtensions.put(new Integer(601), KAF_KPV_EXTENSION);
        fileTypExtensions.put(new Integer(602), KAF_KPZ_EXTENSION);
        fileTypExtensions.put(new Integer(603), KAF_VHTM_EXTENSION);
        fileTypExtensions.put(new Integer(604), KAF_ERR_EXTENSION);
        fileTypExtensions.put(new Integer(605), KAF_KPL_EXTENSION);
        fileTypExtensions.put(new Integer(606), KAF_KPD_EXTENSION);
        fileTypExtensions.put(new Integer(607), KAF_KPP_EXTENSION);
        fileTypExtensions.put(new Integer(608), KAF_KPZUS_EXTENSION);
        fileTypExtensions.put(new Integer(609), KAF_LTA_EXTENSION);
        fileTypExtensions.put(new Integer(610), KAF_HOM_EXTENSION);
        fileTypExtensions.put(new Integer(611), KAF_GGH_EXTENSION);
    }
}

