/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UnEncodingInputStreamReader
extends Reader {
    private int bufferSize = 8192;
    private byte[] bb;
    private InputStream in;

    public UnEncodingInputStreamReader(InputStream inputStream) {
        super(inputStream);
        this.in = inputStream;
        this.bb = new byte[this.bufferSize];
    }

    public String getEncoding() {
        return "UnEncoding";
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 > this.bufferSize) {
                this.bufferSize = n2;
                this.bb = new byte[this.bufferSize];
            }
            int n3 = this.in.read(this.bb, 0, n2);
            int n4 = 0;
            while (n4 < n3) {
                byte by = this.bb[n4];
                cArray[n] = by >= 0 ? (char)by : (char)(by + 256);
                ++n4;
                ++n;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.in.available() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.bb = null;
        }
    }
}

