/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class UnEncodingOutputStreamWriter
extends Writer {
    private int bufferSize = 8192;
    private byte[] bb;
    OutputStream out;

    public UnEncodingOutputStreamWriter(OutputStream outputStream) {
        super(outputStream);
        this.out = outputStream;
        this.bb = new byte[this.bufferSize];
    }

    public String getEncoding() {
        return "UnEncoding";
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 > this.bufferSize) {
                this.bufferSize = n2;
                this.bb = new byte[this.bufferSize];
            }
            for (int i = 0; i < n2; ++i) {
                this.bb[i] = (byte)cArray[n++];
            }
            this.out.write(this.bb, 0, n2);
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
            this.bb = null;
        }
    }
}

