/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.text.GeoNumberFormat;
import java.util.StringTokenizer;

public final class ArtKey {
    public static int IGNORE = -1;
    public static int FALSE = 0;
    public static int TRUE = 1;
    protected int eb;
    protected int art;
    protected int sym;

    public ArtKey() {
        this(IGNORE, IGNORE, IGNORE);
    }

    public ArtKey(int n, int n2) {
        this(n, n2, IGNORE);
    }

    public ArtKey(int n, int n2, int n3) {
        this.setEbene(n);
        this.setArt(n2);
        this.setSymbol(n3);
    }

    public void setEbene(int n) {
        this.eb = n >= 0 ? n : IGNORE;
    }

    public int getEbene() {
        return this.eb;
    }

    public void setArt(int n) {
        this.art = n >= 0 ? n : IGNORE;
    }

    public int getArt() {
        return this.art;
    }

    public void setSymbol(int n) {
        this.sym = n >= 0 ? n : IGNORE;
    }

    public int getSymbol() {
        return this.sym;
    }

    public boolean equals(Object object) {
        if (object instanceof ArtKey) {
            ArtKey artKey = (ArtKey)object;
            return artKey.art == this.art && artKey.eb == this.eb && artKey.sym == this.sym;
        }
        return false;
    }

    public int hashCode() {
        return new Long((long)(this.art + 1) * 10000000L + (long)(this.eb + 1) * 10000L + (long)(this.sym + 1)).hashCode();
    }

    public static ArtKey parseArtKey(String string) throws NumberFormatException {
        ArtKey artKey = new ArtKey();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() == 0) {
            return null;
        }
        try {
            artKey.setEbene(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                artKey.setArt(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                artKey.setSymbol(Integer.parseInt(stringTokenizer.nextToken()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Art enth\u00e4lt ung\u00fcltige Zeichen");
        }
        return artKey;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.nr02n.format(this.eb).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr02.format(this.art).toString());
        stringBuffer.append(" ");
        stringBuffer.append(GeoNumberFormat.nr02.format(this.sym).toString());
        return stringBuffer.toString();
    }
}

