/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.IdentitaetUtil;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.lang.Control;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.sml.Tag;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Bedingung
implements PunktContainer,
Drawable,
Control,
Messager,
DatObject,
TagObject,
Cloneable,
StatElement {
    public static final int UNDEF = -1;
    public static final int PARALLELE = 0;
    public static final int GERADE = 1;
    public static final int RECHTER_WINKEL = 2;
    public static final int BEZUG_PARALLELE = 3;
    public static final int ABSTAND_GP = 4;
    public static final int ABSTAND_PP = 5;
    public static final int BOGEN = 6;
    public static final int BOGEN_PUNKT = 9;
    private static Color defaultColor;
    public int ba;
    public Punkt p1;
    public Punkt p2;
    public Punkt p3;
    public double l;
    public float g;
    private Bedingung referenz = null;
    private int flags;
    String bemerkung;
    private Stat stat;
    private Riss riss;
    private static final int FLAG_ON = 2;
    private static final double S_LIM = 1.0;
    private static final int RW = 9;
    private static final int RW2 = 4;
    private static final int PFT = 10;
    private static final int PFL = 20;
    private static final int PFB = 3;
    private static final int R = 4;
    private static final TextArt ta;

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public Bedingung() {
        this(-1, null, null, null, 0.0);
    }

    public Bedingung(int n) {
        this(n, null, null, null, 0.0);
    }

    public Bedingung(int n, Punkt punkt, Punkt punkt2, Punkt punkt3, double d) {
        this.ba = n;
        this.p1 = punkt;
        this.p2 = punkt2;
        this.p3 = punkt3;
        this.l = d;
        this.setOn(true);
    }

    public Punkt getP1() {
        return this.p1;
    }

    public Punkt getP2() {
        return this.p2;
    }

    public Punkt getP3() {
        return this.p3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.bemerkung);
        }
        return this.bemerkung;
    }

    @Override
    public boolean hasStatistik() {
        return this.stat != null;
    }

    @Override
    public void setStatistik(Stat stat) {
        this.stat = stat;
    }

    @Override
    public Stat getStatistik() {
        return this.stat;
    }

    public void setContainer(Riss riss) {
        this.riss = riss;
    }

    public Riss getContainer() {
        return this.riss;
    }

    @Override
    public void setOn(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 2) != 0;
    }

    public boolean hasReferenz() {
        return this.referenz != null;
    }

    public void setReferenz(Bedingung bedingung) {
        this.referenz = bedingung;
    }

    public Bedingung getReferenz() {
        return this.referenz;
    }

    public DPoint getCatchPoint() {
        return this.getHashPoint();
    }

    @Override
    public DPoint getHashPoint() {
        try {
            switch (this.ba) {
                case 1: {
                    double d = Math.atan2(this.p1.y - this.p2.y, this.p1.x - this.p2.x);
                    return new DPoint(this.p2.y + Math.sin(d) * 0.01, this.p2.x + Math.cos(d) * 0.01);
                }
                case 2: {
                    DPoint dPoint = new DPoint(this.p2.y, this.p2.x);
                    DPoint dPoint2 = DPoint.getMiddle(this.p1, this.p3);
                    dPoint.y = dPoint.y + (dPoint2.y > this.p2.y ? 0.01 : -0.01);
                    dPoint.x = dPoint.x + (dPoint2.x > this.p2.x ? 0.01 : -0.01);
                    return dPoint;
                }
                case 0: {
                    boolean bl = this.p1.getDistance2(this.p2) < this.referenz.p1.getDistance2(this.referenz.p2);
                    Bedingung bedingung = bl ? this : this.referenz;
                    Bedingung bedingung2 = bl ? this.referenz : this;
                    DPoint dPoint = bedingung.getMittelPunkt();
                    DPoint dPoint3 = bedingung2.getLotPunkt(dPoint);
                    return DPoint.getMiddle(dPoint, dPoint3);
                }
                case 4: {
                    return DPoint.getMiddle(this.getLotPunkt(this.p3), this.p3);
                }
                case 9: {
                    return DPoint.getMiddle(this.referenz.p1, this.p1);
                }
            }
            return this.getMittelPunkt();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.ba) {
            case 3: {
                stringBuffer.append("Parallele: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p2.nr));
                break;
            }
            case 0: {
                stringBuffer.append("Parallele: ");
                stringBuffer.append(Long.toString(this.referenz.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.referenz.p2.nr));
                stringBuffer.append(" >> ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p2.nr));
                if (this.l == 0.0) break;
                stringBuffer.append(" a=");
                stringBuffer.append(IFormat.f_3.format(this.l));
                break;
            }
            case 1: {
                stringBuffer.append("Gerade: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p2.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p3.nr));
                break;
            }
            case 2: {
                stringBuffer.append("Rechter Winkel: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p2.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p3.nr));
                break;
            }
            case 4: {
                stringBuffer.append("Abstand: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append("-");
                stringBuffer.append(Long.toString(this.p2.nr));
                stringBuffer.append(" >> ");
                stringBuffer.append(Long.toString(this.p3.nr));
                stringBuffer.append(" a=");
                stringBuffer.append(IFormat.f_3.format(this.l));
                break;
            }
            case 5: {
                stringBuffer.append("Abstand: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append(" >> ");
                stringBuffer.append(Long.toString(this.p2.nr));
                stringBuffer.append(" a=");
                stringBuffer.append(IFormat.f_3.format(this.l));
                break;
            }
            case 6: {
                stringBuffer.append("Bogen: ");
                stringBuffer.append(Long.toString(this.p1.nr));
                stringBuffer.append(" >> ");
                stringBuffer.append(Long.toString(this.p2.nr));
                stringBuffer.append(", ");
                stringBuffer.append(Long.toString(this.p3.nr));
                if (this.l == 0.0) break;
                stringBuffer.append(" r=");
                stringBuffer.append(IFormat.f_3.format(this.l));
                break;
            }
            case 9: {
                stringBuffer.append("Bogen: ");
                stringBuffer.append(Long.toString(this.referenz.p1.nr));
                stringBuffer.append(" >> ");
                stringBuffer.append(Long.toString(this.p1.nr));
                if (this.referenz.l == 0.0) break;
                stringBuffer.append(" r=");
                stringBuffer.append(IFormat.f_3.format(this.referenz.l));
            }
        }
        if (!this.isOn()) {
            stringBuffer.append(" (aus)");
        }
        String string = null;
        int n = KafPlotProperties.getColorMessSwitch();
        if (n == 2003) {
            string = "Riss=" + this.getContainer().getName();
        } else if (n == 2004) {
            string = "GW=" + IFormat.f_2.format(this.g);
        } else if (n == 2011 && this.stat != null) {
            string = "V=" + IFormat.f_3.format((double)this.stat.getSumV() * 0.001) + "m";
        } else if (n == 2012 && this.stat != null) {
            string = "SaV=" + IFormat.f_3.format((double)this.stat.getMaxSaV() * 0.001) + "m";
        } else if (n == 2013 && this.stat != null) {
            string = "V-SaV=" + IFormat.f_3.format((double)(this.stat.getSumV() - this.stat.getSumSaV()) * 0.001) + "m";
        } else if (n == 2014 && this.stat != null) {
            string = "EV=" + this.stat.getMidEv() + "%";
        } else if (n == 2015 && this.stat != null) {
            string = "EP=" + IFormat.f_3.format((double)this.stat.getSumEp() * 0.001) + "m";
        } else if (n == 2016 && this.stat != null) {
            string = "NV=" + IFormat.f_1.format((double)this.stat.getMaxNv() * 0.1);
        } else if (n == 2017 && this.stat != null) {
            string = "GF=" + IFormat.f_3.format((double)this.stat.getSumGf() * 0.001) + "m";
        } else if (n == 2018 && this.stat != null) {
            string = "GRZW=" + IFormat.f_3.format((double)this.stat.getMaxGrzw() * 0.001) + "m";
        } else if (n == 2019 && this.stat != null) {
            string = "EGK=" + IFormat.f_3.format((double)this.stat.getMaxEgk() * 0.001) + "m";
        }
        if (string != null) {
            stringBuffer.append("   ");
            stringBuffer.append(string);
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    public final String getClassName() {
        switch (this.ba) {
            case 1: {
                return "Geradenbedingung";
            }
            case 2: {
                return "Rechter Winkel";
            }
            case 0: {
                return "Parallele";
            }
            case 3: {
                return "Parallelenbezug";
            }
            case 4: {
                return "Geradenabstand";
            }
            case 5: {
                return "Punktabstand";
            }
            case 6: {
                return "Kreisbogen";
            }
            case 9: {
                return "Kreisbogenpunkt";
            }
        }
        return "";
    }

    public final String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.p1 != null) {
            stringBuffer.append(Long.toString(this.p1.nr));
            bl = true;
        }
        if (this.p2 != null) {
            if (bl) {
                stringBuffer.append("-");
            }
            stringBuffer.append(Long.toString(this.p2.nr));
            bl = true;
        }
        if (this.p3 != null) {
            if (bl) {
                stringBuffer.append("-");
            }
            stringBuffer.append(Long.toString(this.p3.nr));
            bl = true;
        }
        if (this.l != 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f_2.format(this.l));
        }
        return stringBuffer.toString();
    }

    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        return this.getExceptionableName();
    }

    public final String getFormatedPunktName(int n) {
        switch (this.ba) {
            case 1: {
                if (n == 1) {
                    return "Anfangspunkt";
                }
                if (n == 2) {
                    return "Fluchtpunkt";
                }
                if (n != 3) break;
                return "Endpunkt";
            }
            case 2: {
                if (n == 1) {
                    return "Anfangspunkt";
                }
                if (n == 2) {
                    return "Rechtwinkelpunkt";
                }
                if (n != 3) break;
                return "Endpunkt";
            }
            case 0: {
                if (n == 1 || n == 2) {
                    return "Parallelpunkt";
                }
            }
            case 3: {
                if (n != 1 && n != 2) break;
                return "Bezugspunkt";
            }
            case 4: {
                if (n == 1 || n == 2) {
                    return "Bezugspunkt";
                }
                if (n != 3) break;
                return "Abstandspunkt";
            }
            case 5: {
                if (n != 1 && n != 2) break;
                return "Abstandspunkt";
            }
            case 6: {
                if (n == 1) {
                    return "Mittelpunkt";
                }
                if (n != 2 && n != 3) break;
                return "Bogenpunkt";
            }
            case 9: {
                if (n != 1) break;
                return "Bogenpunkt";
            }
        }
        return "";
    }

    public final String getFormatedValue(int n) {
        return n == 1 && this.l != 0.0 ? IFormat.f_2.format(this.l) : "";
    }

    public final String getFormatedValueName(int n) {
        if (n != 1) {
            return "";
        }
        switch (this.ba) {
            case 1: 
            case 2: 
            case 3: {
                return "";
            }
            case 0: 
            case 4: 
            case 5: {
                return "Abstand";
            }
            case 6: 
            case 9: {
                return "Radius";
            }
        }
        return "";
    }

    public final String getFormatedDimension(int n) {
        if (n != 1) {
            return "";
        }
        switch (this.ba) {
            case 1: 
            case 2: 
            case 3: {
                return "";
            }
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                return "m";
            }
        }
        return "";
    }

    public final String getFormatedStatistikName(int n) {
        switch (this.ba) {
            case 1: {
                if (n != 1) break;
                return "Fluchtabstand";
            }
            case 2: {
                if (n != 1) break;
                return "Rechter Winkel";
            }
            case 3: {
                return "";
            }
            case 0: {
                if (n == 1) {
                    return "Parallelit\u00e4t";
                }
                if (n != 2) break;
                return "Abstand";
            }
            case 4: 
            case 5: {
                if (n != 1) break;
                return "Abstand";
            }
            case 6: {
                if (n != 1 && n != 2) break;
                return "Radius";
            }
            case 9: {
                if (n != 1) break;
                return "Radius";
            }
        }
        return "";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Bedingung) {
            Bedingung bedingung = (Bedingung)object;
            return (this.p1 != null && this.p1.equals(bedingung.p1) || bedingung.p1 == null) && (this.p2 != null && this.p2.equals(bedingung.p2) || bedingung.p2 == null) && (this.p3 != null && this.p3.equals(bedingung.p3) || bedingung.p3 == null) && (this.referenz != null && this.referenz.equals(bedingung.referenz) || bedingung.referenz == null);
        }
        return false;
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.p1 != null && this.p1.equals(punkt) || this.p2 != null && this.p2.equals(punkt) || this.p3 != null && this.p3.equals(punkt);
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.p1 != null) {
            punktTable.put(this.p1);
        }
        if (this.p2 != null) {
            punktTable.put(this.p2);
        }
        if (this.p3 != null) {
            punktTable.put(this.p3);
        }
        return punktTable;
    }

    public double getRadius() {
        if (this.l != 0.0) {
            return this.l / DataBase.getStreckeMasstab((this.p2.y + this.p1.y) / 2.0);
        }
        return Math.sqrt(((this.p2.x - this.p1.x) * (this.p2.x - this.p1.x) + (this.p2.y - this.p1.y) * (this.p2.y - this.p1.y) + (this.p2.x - this.p1.x) * (this.p2.x - this.p1.x) + (this.p2.y - this.p1.y) * (this.p2.y - this.p1.y)) / 2.0) / DataBase.getStreckeMasstab((this.p2.y + this.p1.y) / 2.0);
    }

    private double getS2() {
        return (this.p3.x - this.p2.x) * (this.p3.x - this.p2.x) + (this.p3.y - this.p2.y) * (this.p3.y - this.p2.y);
    }

    public double getPfeilHoehe() {
        return this.getRadius() - Math.sqrt(this.getRadius() * this.getRadius() - this.getS2() / 4.0) * (this.l > 0.0 ? 1.0 : -1.0);
    }

    public double getRichtung() {
        Punkt punkt = this.p2 != null ? this.p2 : this.getReferenz().p1;
        return punkt != null ? Math.atan2(punkt.y - this.p1.y, punkt.x - this.p1.x) : 0.0;
    }

    public DPoint getMittelPunkt() {
        Punkt punkt = this.p2 != null ? this.p2 : this.getReferenz().p1;
        return punkt != null ? new DPoint((this.p1.y + punkt.y) / 2.0, (this.p1.x + punkt.x) / 2.0) : this.p1;
    }

    public DPoint getLotPunkt(DPoint dPoint) {
        double d = (this.p2.y - this.p1.y) / (this.p2.x - this.p1.x);
        double d2 = this.p1.x + (d * (dPoint.y - this.p1.y) + (dPoint.x - this.p1.x)) / (d * d + 1.0);
        double d3 = this.p1.y + d * (d2 - this.p1.x);
        return new DPoint(d3, d2);
    }

    private boolean isRightPunkt(Punkt punkt, Punkt punkt2, Punkt punkt3) {
        OrthoLinie orthoLinie = new OrthoLinie();
        orthoLinie.setAnfangsPunkt(punkt);
        orthoLinie.setEndPunkt(punkt2);
        return orthoLinie.getMessungOf((Punkt)punkt3).l2 > 0.0;
    }

    @Override
    public String toDatLine() {
        if (KafkaIOProperties.datVersion >= 2) {
            Punkt punkt;
            IdentitaetUtil identitaetUtil;
            String string = this.bemerkung;
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.isOn()) {
                stringBuffer.append(IFormat.i1.format(this.ba));
                stringBuffer.append(" ");
            } else {
                stringBuffer.append('C');
                stringBuffer.append(IFormat.i1.format(this.ba));
            }
            stringBuffer.append(" ");
            if (this.p1 != null && this.p1.nr > 0L) {
                identitaetUtil = new IdentitaetUtil(this.p1, string, 1, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.p2 != null && this.p2.nr > 0L) {
                identitaetUtil = new IdentitaetUtil(this.p2, string, 2, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.p3 != null && this.p3.nr > 0L) {
                identitaetUtil = new IdentitaetUtil(this.p3, string, 3, !KafkaIOProperties.writeOffline);
                punkt = identitaetUtil.getPunkt();
                string = identitaetUtil.getBem();
                stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
            } else {
                stringBuffer.append("              ");
            }
            if (this.g != 0.0f) {
                stringBuffer.append(IFormat.f2_3.format(this.g));
            } else {
                stringBuffer.append("      ");
            }
            if (this.l != 0.0) {
                stringBuffer.append(IFormat.f6_2.format(this.l));
            } else {
                stringBuffer.append("         ");
            }
            stringBuffer.append("  ");
            if (string != null) {
                stringBuffer.append(IFormat.getSpaces(37));
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return this.toDatLine(1.0);
    }

    public String toDatLine(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.nr01n.format(this.ba).toString());
        stringBuffer.append(" ");
        if (this.p1 != null && this.p1.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.p1.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append(" ");
        if (this.p2 != null && this.p2.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.p2.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append(" ");
        if (this.p3 != null && this.p3.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr13.format(this.p3.nr).toString());
        } else {
            stringBuffer.append("             ");
        }
        stringBuffer.append("    ");
        stringBuffer.append(GeoNumberFormat.m01.format(d).toString());
        stringBuffer.append("   ");
        switch (this.ba) {
            case 4: 
            case 5: {
                stringBuffer.append(GeoNumberFormat.m43.format(this.l).toString());
                break;
            }
            default: {
                if (this.l == 0.0) break;
                stringBuffer.append(GeoNumberFormat.m43.format(this.l).toString());
            }
        }
        return stringBuffer.toString();
    }

    public String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlIOProperties.openln("bedingung"));
        if (this.p1 != null && this.p1.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr1", Long.toString(this.p1.nr)));
        }
        if (this.p2 != null && this.p2.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr2", Long.toString(this.p2.nr)));
        }
        if (this.p3 != null && this.p3.nr != 0L) {
            stringBuffer.append(XmlIOProperties.dataln("nr3", Long.toString(this.p3.nr)));
        }
        stringBuffer.append(XmlIOProperties.dataln("ba", Integer.toString(this.ba)));
        switch (this.ba) {
            case 4: 
            case 5: {
                stringBuffer.append(XmlIOProperties.dataln("l1", IFormat.f_3.format(this.l).toString()));
                break;
            }
            default: {
                if (this.l == 0.0) break;
                stringBuffer.append(XmlIOProperties.dataln("l1", IFormat.f_3.format(this.l).toString()));
            }
        }
        stringBuffer.append(XmlIOProperties.close("bedingung"));
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        if (this.p1 != null) {
            d = Math.min(d, this.p1.y);
            d2 = Math.min(d2, this.p1.x);
            d3 = Math.max(d3, this.p1.y);
            d4 = Math.max(d4, this.p1.x);
        }
        if (this.p2 != null) {
            d = Math.min(d, this.p2.y);
            d2 = Math.min(d2, this.p2.x);
            d3 = Math.max(d3, this.p2.y);
            d4 = Math.max(d4, this.p2.x);
        }
        if (this.p3 != null) {
            d = Math.min(d, this.p3.y);
            d2 = Math.min(d2, this.p3.x);
            d3 = Math.max(d3, this.p3.y);
            d4 = Math.max(d4, this.p3.x);
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return new DRectangle();
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isVisible() {
        switch (this.ba) {
            case 1: {
                return KafPlotProperties.isBedGeradeVisible;
            }
            case 2: {
                return KafPlotProperties.isBedWinkelVisible;
            }
            case 0: 
            case 3: {
                return KafPlotProperties.isBedParallelVisible;
            }
            case 4: 
            case 5: {
                return KafPlotProperties.isBedAbstandVisible;
            }
            case 6: 
            case 9: {
                return KafPlotProperties.isBedBogenVisible;
            }
        }
        return false;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        this.drawForeground(iGraphics, bl, bl2);
        if (KafPlotProperties.isMaszeVisible()) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            if (this.p1 != null) {
                this.p1.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.p2 != null) {
                this.p2.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.p3 != null) {
                this.p3.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.referenz != null) {
                this.referenz.drawObject(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    private Color getColor() {
        if (!this.isOn()) {
            return KafPlotColor.OFFLINE;
        }
        int n = KafPlotProperties.getColorMessSwitch();
        if (n == 2004) {
            return KafPlotProperties.mgwColor.getColor(this.g);
        }
        if (n >= 2011 && n <= 2019) {
            return KafPlotColor.getStatColor(n, this.stat);
        }
        if (n == 2001 || defaultColor == null) {
            return KafPlotProperties.mmaColor.getColor(new Integer(60 + this.ba));
        }
        return defaultColor;
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        DPoint dPoint = this.getCatchPoint();
        if (dPoint == null) {
            return;
        }
        if (!iGraphics.contains(dPoint)) {
            return;
        }
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            graphics.setColor(this.getColor());
        }
        Object object = null;
        double d = this.getRichtung() + iGraphics.getRotation();
        switch (this.ba) {
            case 0: {
                object = this.l != 0.0 ? "-#" + IFormat.f_2k.format(this.l).toString() + "-" : "-#-";
                d += 1.5707963267948966;
                break;
            }
            case 4: {
                d += 1.5707963267948966;
            }
            case 5: {
                object = "-" + IFormat.f_2k.format(this.l).toString() + "-";
                break;
            }
            case 9: {
                if (this.referenz.l == 0.0) break;
                object = "r=" + IFormat.f_2k.format(this.referenz.l).toString();
            }
        }
        if (object != null) {
            if (d < 0.0) {
                d += Math.PI;
            }
            TextSymbol.paint(graphics, (String)object, iGraphics.getGraphicPoint(dPoint, new Point()), ta, 4, 0, d, 1.0);
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            graphics.setColor(this.getColor());
        }
        switch (this.ba) {
            case 1: 
            case 2: {
                if (this.p2 != null && this.p3 != null) {
                    if (bl2) {
                        iGraphics.drawLine(this.p2, this.p3, 2);
                    } else {
                        iGraphics.drawLine(this.p2, this.p3);
                    }
                }
            }
            case 0: 
            case 3: 
            case 4: {
                if (this.p1 == null || this.p2 == null) break;
                if (bl2) {
                    iGraphics.drawLine(this.p1, this.p2, 2);
                    break;
                }
                iGraphics.drawLine(this.p1, this.p2);
                break;
            }
            case 6: {
                if (this.p1 == null || this.p2 == null || this.p3 == null) break;
                Polygon polygon = iGraphics.getGraphicBogenPolygon(this.p2, this.p3, this.isRightPunkt(this.p2, this.p3, this.p1) ? this.l : -this.l);
                if (bl2) {
                    iGraphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints, 2);
                    break;
                }
                graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            }
        }
        switch (this.ba) {
            case 2: {
                if (this.p1 == null || this.p2 == null || this.p3 == null) break;
                this.drawRechterWinkel(iGraphics, this.p1, this.p2, this.p3);
                break;
            }
            case 1: {
                if (this.p1 == null || this.p2 == null) break;
                this.drawGeradeWinkel(iGraphics, this.p1, this.p2);
                break;
            }
            case 4: {
                if (this.p1 == null || this.p2 == null || this.p3 == null) break;
                this.drawPfeil(iGraphics, this.p3, this.getLotPunkt(this.p3), true);
                break;
            }
            case 5: {
                if (this.p1 == null || this.p2 == null) break;
                this.drawPfeil(iGraphics, this.p1, this.p2, true);
                break;
            }
            case 9: {
                if (this.p1 == null) break;
                this.drawPfeil(iGraphics, this.referenz.p1, this.p1, false);
            }
        }
    }

    public void drawPfeil(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl) {
        Point point;
        Graphics graphics = iGraphics.getGraphics();
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        if (iGraphics.contains(dPoint)) {
            point = iGraphics.getGraphicPoint(dPoint, new Point());
            point.x += (int)(d2 * 4.0);
            point.y += (int)(d3 * 4.0);
            graphics.drawLine(point.x, point.y, point.x + (int)Math.rint(d2 * 24.0), point.y + (int)Math.rint(d3 * 24.0));
            graphics.drawLine(point.x, point.y, point.x + (int)Math.rint(d2 * 14.0 - d3 * 3.0), point.y + (int)Math.rint(d3 * 14.0 + d2 * 3.0));
            graphics.drawLine(point.x, point.y, point.x + (int)Math.rint(d2 * 14.0 + d3 * 3.0), point.y + (int)Math.rint(d3 * 14.0 - d2 * 3.0));
        }
        if (bl && iGraphics.contains(dPoint2)) {
            point = iGraphics.getGraphicPoint(dPoint2, new Point());
            point.x -= (int)(d2 * 4.0);
            point.y -= (int)(d3 * 4.0);
            graphics.drawLine(point.x, point.y, point.x - (int)Math.rint(d2 * 24.0), point.y - (int)Math.rint(d3 * 24.0));
            graphics.drawLine(point.x, point.y, point.x - (int)Math.rint(d2 * 14.0 - d3 * 3.0), point.y - (int)Math.rint(d3 * 14.0 + d2 * 3.0));
            graphics.drawLine(point.x, point.y, point.x - (int)Math.rint(d2 * 14.0 + d3 * 3.0), point.y - (int)Math.rint(d3 * 14.0 - d2 * 3.0));
        }
    }

    private void drawRechterWinkel(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, DPoint dPoint3) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d3 * (dPoint3.y - dPoint2.y) + d2 * (dPoint3.x - dPoint2.x) < 0.0 ? -1.0 : 1.0;
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        int[] nArray = new int[]{point.x - (int)Math.rint(d2 * 13.0), point.x - (int)Math.rint(d2 * 8.0 - d3 * 8.0 * d4), point.x - (int)Math.rint(-d3 * 13.0 * d4)};
        int[] nArray2 = new int[]{point.y - (int)Math.rint(d3 * 13.0), point.y - (int)Math.rint(d3 * 8.0 + d2 * 8.0 * d4), point.y - (int)Math.rint(d2 * 13.0 * d4)};
        iGraphics.getGraphics().drawPolyline(nArray, nArray2, 3);
    }

    private void drawGeradeWinkel(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() + (dPoint.x > dPoint2.x ? 1.5707963267948966 : -1.5707963267948966);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        int[] nArray = new int[]{point.x + (int)Math.rint(d2 * 13.0), point.x + (int)Math.rint(d2 * 8.0 - d3 * 8.0), point.x + (int)Math.rint(-d3 * 13.0), point.x - (int)Math.rint(d2 * 8.0 + d3 * 8.0), point.x - (int)Math.rint(d2 * 13.0)};
        int[] nArray2 = new int[]{point.y + (int)Math.rint(d3 * 13.0), point.y + (int)Math.rint(d3 * 8.0 + d2 * 8.0), point.y + (int)Math.rint(d2 * 13.0), point.y - (int)Math.rint(d3 * 8.0 - d2 * 8.0), point.y - (int)Math.rint(d3 * 13.0)};
        iGraphics.getGraphics().drawPolyline(nArray, nArray2, 5);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(16);
        dataOutput.writeByte(this.ba);
        dataOutput.writeInt(this.flags);
        PunktNummer.writeObject(this.p1 != null ? this.p1.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.p2 != null ? this.p2.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.p3 != null ? this.p3.nr : 0L, dataOutput);
        if (this.l != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeFloat(this.g);
        if (this.hasStatistik() && KpvIOProperties.writeStatistik()) {
            this.getStatistik().writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
    }

    public static PunktContainer readObject(DataInput dataInput) throws IOException {
        Bedingung bedingung = new Bedingung();
        bedingung.ba = dataInput.readByte();
        bedingung.flags = dataInput.readInt();
        bedingung.p1 = new Punkt(PunktNummer.readObject(dataInput));
        bedingung.p2 = new Punkt(PunktNummer.readObject(dataInput));
        bedingung.p3 = new Punkt(PunktNummer.readObject(dataInput));
        if (dataInput.readByte() != 0) {
            bedingung.l = dataInput.readFloat();
        }
        if (KpvIOProperties.RVER >= 110) {
            bedingung.g = dataInput.readFloat();
            bedingung.setStatistik(Stat.readObject(dataInput));
        }
        return bedingung;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": ");
        stringBuffer.append(this.ba);
        if (this.p1 != null) {
            stringBuffer.append(" p1=" + this.p1.nr);
        }
        if (this.p2 != null) {
            stringBuffer.append(" p2=" + this.p2.nr);
        }
        if (this.p3 != null) {
            stringBuffer.append(" p3=" + this.p3.nr);
        }
        if (this.l != 0.0) {
            stringBuffer.append(" " + GeoNumberFormat.m02.format(this.l).toString());
        }
        return stringBuffer.toString();
    }

    public HashKey getHashKey() {
        return new HashKey(this, this);
    }

    static {
        ta = TextArt.create(1);
    }

    class HashKey {
        Bedingung b;

        HashKey(Bedingung bedingung, Bedingung bedingung2) {
            this.b = bedingung2;
        }

        public int hashCode() {
            long l = 0L;
            if (this.b.p1 != null) {
                l += this.b.p1.nr;
            }
            if (this.b.p2 != null) {
                l += this.b.p2.nr;
            }
            if (this.b.p3 != null) {
                l += this.b.p3.nr;
            }
            if (this.b.referenz != null) {
                if (this.b.referenz.p1 != null) {
                    l += this.b.referenz.p1.nr;
                }
                if (this.b.referenz.p2 != null) {
                    l += this.b.referenz.p2.nr;
                }
                if (this.b.referenz.p3 != null) {
                    l += this.b.referenz.p3.nr;
                }
            }
            return (int)(l ^ l >> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof HashKey) {
                Bedingung bedingung = ((HashKey)object).b;
                if (this.b.ba == bedingung.ba) {
                    if (this.b.ba == 1 || this.b.ba == 2) {
                        if (this.b.p2 == bedingung.p2) {
                            return this.b.p1 == bedingung.p1 && this.b.p3 == bedingung.p3 || this.b.p1 == bedingung.p3 && this.b.p3 == bedingung.p1;
                        }
                    } else if (this.b.ba == 4 ? this.b.p3 == bedingung.p3 && this.b.l == bedingung.l : this.b.ba == 5 && this.b.l == bedingung.l) {
                        return this.b.p1 == bedingung.p1 && this.b.p2 == bedingung.p2 || this.b.p1 == bedingung.p2 && this.b.p2 == bedingung.p1;
                    }
                }
            }
            return false;
        }
    }
}

