/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObject;
import de.geocalc.util.HashStack;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BedingungCreator
extends IProgressElement {
    public static final int ABSTAND_NO = 0;
    public static final int ABSTAND_FREI = 1;
    public static final int ABSTAND_METER = 2;
    public static final int ABSTAND_RUTEN = 3;
    public static double MAX_ABSTAND_NO = 0.0;
    public static double MAX_ABSTAND_METER = 20.0;
    public static double MAX_ABSTAND_RUTEN = 4.0;
    private static int BREAKER = 2;
    private static int errors = 0;
    private static double dist = 1.0;
    private static double angle = 0.07853981633974483;
    private static double rundung = 2.0;
    private static double maxAbstand = 10.0;
    private static int abstBed = 0;
    private static boolean visitOldBedingungen = false;
    private static boolean onlyVisibleElements = false;
    private static boolean createGeraden = true;
    private static boolean newGeneralize = false;
    private static boolean oldGeneralize = false;
    private boolean isALK = false;
    private boolean saveErrors = true;
    private DataBase db;
    private Riss riss;
    private ExceptionList exceptions;
    private LinieHash L = new LinieHash();
    private PunktTable P = new PunktTable();
    private PunktTable BP = new PunktTable();

    public BedingungCreator(DataBase dataBase, PunktTable punktTable, Riss riss) {
        this(dataBase, null, null, punktTable, riss);
    }

    public BedingungCreator(DataBase dataBase, IProgressBar iProgressBar, Label label, PunktTable punktTable, Riss riss) {
        super(iProgressBar, label);
        this.db = dataBase;
        this.P = punktTable;
        this.riss = riss;
    }

    public void setExceptionList(ExceptionList exceptionList) {
        this.exceptions = exceptionList;
    }

    public ExceptionList getExceptionList() {
        return this.exceptions;
    }

    public static void setOnlyVisibleElements(boolean bl) {
        onlyVisibleElements = bl;
    }

    public static boolean isOnlyVisibleElements() {
        return onlyVisibleElements;
    }

    public static void setVisitOldBedingungen(boolean bl) {
        visitOldBedingungen = bl;
    }

    public static boolean isVisitOldBedingungen() {
        return visitOldBedingungen;
    }

    public static void setCreateGeraden(boolean bl) {
        createGeraden = bl;
    }

    public static boolean isCreateGeraden() {
        return createGeraden;
    }

    public static void setNewGeneralize(boolean bl) {
        newGeneralize = bl;
    }

    public static boolean isNewGeneralize() {
        return newGeneralize;
    }

    public static void setOldGeneralize(boolean bl) {
        oldGeneralize = bl;
    }

    public static boolean isOldGeneralize() {
        return oldGeneralize;
    }

    public static void setLageDistance(double d) {
        dist = d;
    }

    public static double getLageDistance() {
        return dist;
    }

    public static void setAngleDistance(double d) {
        angle = d;
    }

    public static double getAngleDistance() {
        return angle;
    }

    public static void setMaxAbstand(double d) {
        maxAbstand = d;
    }

    public static double getMaxAbstand() {
        return maxAbstand;
    }

    public static void setRundung(double d) {
        rundung = d;
    }

    public static double getRundung() {
        return rundung;
    }

    public static void setAbstandBedingung(int n) {
        abstBed = n;
    }

    public static int getAbstandBedingung() {
        return abstBed;
    }

    private void putUsedPoints(PunktTable punktTable, Bedingung bedingung) {
        switch (bedingung.ba) {
            case 0: 
            case 3: {
                punktTable.put(bedingung.p1);
                punktTable.put(bedingung.p2);
                break;
            }
            case 1: 
            case 2: {
                punktTable.put(bedingung.p2);
                break;
            }
            case 4: {
                punktTable.put(bedingung.p3);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void create() {
        Object object;
        Enumeration<Linie> enumeration;
        Cloneable cloneable;
        Enumeration<Object> enumeration2;
        this.isALK = false;
        if (visitOldBedingungen) {
            BedingungCreator bedingungCreator = this;
            Enumeration enumeration3 = bedingungCreator.db.bedingungen();
            while (enumeration3.hasMoreElements()) {
                this.putUsedPoints(this.BP, (Bedingung)enumeration3.nextElement());
            }
            BedingungCreator bedingungCreator2 = this;
            enumeration3 = bedingungCreator2.db.homogenisierungen();
            while (enumeration3.hasMoreElements()) {
                this.putUsedPoints(this.BP, (Bedingung)enumeration3.nextElement());
            }
        }
        int n = 0;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (!onlyVisibleElements || KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
            enumeration2 = DataBase.FLST.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Flurstueck)enumeration2.nextElement();
                if (onlyVisibleElements && !((Flurstueck)cloneable).isVisible()) continue;
                this.isALK = true;
                enumeration = ((DataContainer)cloneable).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Linie)enumeration.nextElement();
                    if (((Linie)object).pe == null || this.P.get(((Linie)object).pa.nr) == null || this.P.get(((Linie)object).pe.nr) == null) continue;
                    hashtable.put(((Linie)object).getArtHashKey(), object);
                }
            }
        }
        if (!onlyVisibleElements || KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
            enumeration2 = DataBase.GEB.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Gebaeude)enumeration2.nextElement();
                if (onlyVisibleElements && !((DataContainer)cloneable).isVisible()) continue;
                this.isALK = true;
                enumeration = ((DataContainer)cloneable).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Linie)enumeration.nextElement();
                    if (((Linie)object).pe == null || this.P.get(((Linie)object).pa.nr) == null || this.P.get(((Linie)object).pe.nr) == null) continue;
                    hashtable.put(((Linie)object).getArtHashKey(), object);
                }
            }
        }
        if (!onlyVisibleElements || KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopPolyVisible) {
            enumeration2 = DataBase.TOP.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (TopObject)enumeration2.nextElement();
                if (onlyVisibleElements && !((DataContainer)cloneable).isVisible()) continue;
                enumeration = ((DataContainer)cloneable).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Linie)enumeration.nextElement();
                    if (((Linie)object).pe == null || this.P.get(((Linie)object).pa.nr) == null || this.P.get(((Linie)object).pe.nr) == null) continue;
                    hashtable.put(((Linie)object).getArtHashKey(), object);
                }
            }
        }
        enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            cloneable = (Linie)enumeration2.nextElement();
            this.L.add(((Linie)cloneable).pa, (Linie)cloneable);
            this.L.add(((Linie)cloneable).pe, (Linie)cloneable);
        }
        hashtable.clear();
        hashtable = null;
        int n2 = 0;
        if (createGeraden) {
            n2 += this.P.size();
        }
        if (abstBed != 0 && (!onlyVisibleElements || KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible)) {
            n2 += DataBase.FLST.size();
        }
        if (abstBed != 0 && (!onlyVisibleElements || KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible)) {
            n2 += DataBase.GEB.size();
        }
        BREAKER = Math.max(2, n2 / 25);
        this.setBorderValues(0L, n2);
        this.setLabelValue(0L);
        int n3 = 0;
        if (createGeraden) {
            enumeration = new Vector();
            object = this.P.elements();
            while (object.hasMoreElements()) {
                Punkt punkt = (Punkt)object.nextElement();
                if (!PunktStatus.isFest(punkt.getPs())) {
                    ((Vector)((Object)enumeration)).removeAllElements();
                    Enumeration enumeration4 = this.L.lines(punkt);
                    while (enumeration4.hasMoreElements()) {
                        ((Vector)((Object)enumeration)).addElement(this.getClone((Linie)enumeration4.nextElement()));
                    }
                    n += this.createBedingungen((Vector)((Object)enumeration), punkt);
                    if (n3 % BREAKER == 0) {
                        this.setLabelValue(n);
                        this.showProgress(n3);
                    }
                }
                ++n3;
            }
        }
        if (abstBed != 0) {
            if (!onlyVisibleElements || KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
                enumeration = DataBase.FLST.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Flurstueck)enumeration.nextElement();
                    if ((!onlyVisibleElements || ((Flurstueck)object).isVisible()) && ((Flurstueck)object).getNutzung() > 0 && Oska.isLinienFoermigObject(((Flurstueck)object).getNutzung() * 10)) {
                        n += this.createFlstParallelen((Flurstueck)object, Oska.isMetricFoermigObject(((Flurstueck)object).getNutzung() * 10));
                    }
                    if (n3 % BREAKER == 0) {
                        this.setLabelValue(n);
                        this.showProgress(n3);
                    }
                    ++n3;
                }
            }
            if (!onlyVisibleElements || KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
                enumeration = DataBase.GEB.elements();
                while (enumeration.hasMoreElements()) {
                    object = (GObject)enumeration.nextElement();
                    if (!onlyVisibleElements || ((DataContainer)object).isVisible()) {
                        n += this.createGebParallelen((GObject)object);
                    }
                    if (n3 % BREAKER == 0) {
                        this.setLabelValue(n);
                        this.showProgress(n3);
                    }
                    ++n3;
                }
            }
        }
        this.riss.initGeom();
        this.showProgress(true);
        n2 = 0;
        if (newGeneralize) {
            n2 += 2 * this.riss.size();
        }
        if (oldGeneralize) {
            n2 += (DataBase.BB.countObjects() + DataBase.BH.countObjects()) * 2;
        }
        BREAKER = Math.max(2, n2 / 25);
        this.setBorderValues(0L, n2);
        this.setLabelText(this.getLabelText() + this.getLabelValue() + " erzeugt, ");
        this.setLabelValue(0L);
        n = 0;
        n3 = 0;
        this.showProgress(n3);
        if (newGeneralize) {
            this.generalize(this.riss, n, n3);
        }
        if (oldGeneralize) {
            enumeration = DataBase.BB.elements();
            while (enumeration.hasMoreElements()) {
                this.generalize((Riss)enumeration.nextElement(), n, n3);
            }
            enumeration = DataBase.BH.elements();
            while (enumeration.hasMoreElements()) {
                this.generalize((Riss)enumeration.nextElement(), n, n3);
            }
        }
        this.showProgress(Math.max(n2, 1));
        this.setLabelText(this.getLabelText() + this.getLabelValue() + " generalisiert");
        this.setLabelValue(-1L);
        this.showProgress(true);
    }

    private void generalize(Riss riss, int n, int n2) {
        Bedingung bedingung;
        Cloneable cloneable;
        HashStack hashStack = new HashStack();
        this.fillHashStack(hashStack, riss.elements());
        int n3 = 0;
        while (n3 < riss.size()) {
            cloneable = (Bedingung)riss.elementAt(n3);
            if ((this.loc(((Bedingung)cloneable).p1) || this.loc(((Bedingung)cloneable).p2) || this.loc(((Bedingung)cloneable).p3)) && (bedingung = this.generalize((Bedingung)cloneable, hashStack)) != cloneable) {
                riss.setElementAt(bedingung, n3);
                ++n;
            }
            if (n2 % BREAKER == 0) {
                this.setLabelValue(n);
                this.showProgress(n2);
            }
            ++n3;
            ++n2;
        }
        n3 = 0;
        cloneable = new Hashtable();
        while (n3 < riss.size()) {
            bedingung = (Bedingung)riss.elementAt(n3);
            Bedingung.HashKey hashKey = bedingung.getHashKey();
            if (((Hashtable)cloneable).put(hashKey, bedingung) != null) {
                riss.removeElementAt(n3);
                ++n;
                continue;
            }
            if (n2 % BREAKER == 0) {
                this.setLabelValue(n);
                this.showProgress(n2);
            }
            ++n3;
            ++n2;
        }
        this.setLabelValue(n);
    }

    private Bedingung generalize(Bedingung bedingung, HashStack hashStack) {
        boolean bl = this.loc(bedingung.p1);
        boolean bl2 = this.loc(bedingung.p3);
        if (bl || bl2) {
            Vector<Punkt> vector = new Vector<Punkt>();
            vector.addElement(bedingung.p1);
            vector.addElement(bedingung.p2);
            vector.addElement(bedingung.p3);
            while (bl || bl2) {
                if (bl) {
                    bl = this.findNextStart(hashStack, vector);
                }
                if (!bl2) continue;
                bl2 = this.findNextEnd(hashStack, vector);
            }
            Punkt punkt = (Punkt)vector.firstElement();
            Punkt punkt2 = (Punkt)vector.lastElement();
            Punkt punkt3 = (Punkt)this.P.get(punkt.nr);
            Punkt punkt4 = (Punkt)this.P.get(punkt2.nr);
            if (punkt3 != null && punkt4 != null && !this.loc(punkt) && !this.loc(punkt2)) {
                OrthoLinie orthoLinie = new OrthoLinie(punkt3, punkt4);
                boolean bl3 = true;
                for (int i = 1; i < vector.size() - 1; ++i) {
                    Punkt punkt5 = (Punkt)this.P.get(((Punkt)vector.elementAt((int)i)).nr);
                    if (punkt5 != null && !(Math.abs(orthoLinie.getMessungOf((Punkt)punkt5).l2) > dist)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    return new Bedingung(1, punkt, bedingung.p2, punkt2, 0.0);
                }
            }
        }
        return bedingung;
    }

    private boolean loc(Punkt punkt) {
        return punkt.getOska() <= 0;
    }

    private void fillHashStack(HashStack hashStack, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Bedingung bedingung = (Bedingung)enumeration.nextElement();
            if (bedingung.ba != 1 || !this.loc(bedingung.p1) && !this.loc(bedingung.p2) && !this.loc(bedingung.p3)) continue;
            hashStack.put(bedingung.p2, bedingung);
        }
    }

    private boolean findNextStart(HashStack hashStack, Vector vector) {
        Punkt punkt = (Punkt)vector.elementAt(0);
        Punkt punkt2 = (Punkt)vector.elementAt(1);
        Enumeration enumeration = hashStack.elements(punkt);
        while (enumeration.hasMoreElements()) {
            Bedingung bedingung = (Bedingung)enumeration.nextElement();
            if (bedingung.p1 == punkt2) {
                vector.insertElementAt(bedingung.p3, 0);
                return this.loc(bedingung.p3);
            }
            if (bedingung.p3 != punkt2) continue;
            vector.insertElementAt(bedingung.p1, 0);
            return this.loc(bedingung.p1);
        }
        return false;
    }

    private boolean findNextEnd(HashStack hashStack, Vector vector) {
        Punkt punkt = (Punkt)vector.elementAt(vector.size() - 1);
        Punkt punkt2 = (Punkt)vector.elementAt(vector.size() - 2);
        Enumeration enumeration = hashStack.elements(punkt);
        while (enumeration.hasMoreElements()) {
            Bedingung bedingung = (Bedingung)enumeration.nextElement();
            if (bedingung.p1 == punkt2) {
                vector.addElement(bedingung.p3);
                return this.loc(bedingung.p3);
            }
            if (bedingung.p3 != punkt2) continue;
            vector.addElement(bedingung.p1);
            return this.loc(bedingung.p1);
        }
        return false;
    }

    private Linie getClone(Linie linie) {
        Linie linie2 = (Linie)linie.clone();
        linie2.setPa((Punkt)this.P.get(linie.pa.nr));
        if (linie.pe != null) {
            linie2.setPe((Punkt)this.P.get(linie.pe.nr));
        }
        return linie2;
    }

    private int createGebParallelen(GObject gObject) {
        int n = 0;
        int n2 = gObject.size();
        OrthoLinie orthoLinie = new OrthoLinie();
        for (int i = 0; i < n2; ++i) {
            Cloneable cloneable;
            Linie linie = this.getClone((Linie)gObject.elementAt(i));
            if (linie.pa == null || linie.pe == null || PunktStatus.isFest(linie.pa.getPs()) && PunktStatus.isFest(linie.pe.getPs()) || this.P.get(linie.pa.nr) == null || this.P.get(linie.pe.nr) == null || this.BP.get(linie.pa.nr) != null || this.BP.get(linie.pe.nr) != null) continue;
            double d = linie.getLaenge();
            Cloneable cloneable2 = null;
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                cloneable = this.getClone((Linie)gObject.elementAt(j));
                if (((Linie)cloneable).pa == null || ((Linie)cloneable).pe == null || PunktStatus.isFest(((Linie)cloneable).pa.getPs()) && PunktStatus.isFest(((Linie)cloneable).pe.getPs()) || this.P.get(((Linie)cloneable).pa.nr) == null || this.P.get(((Linie)cloneable).pe.nr) == null || ((Linie)cloneable).pa.equals(linie.pa) || ((Linie)cloneable).pe.equals(linie.pa) || ((Linie)cloneable).pa.equals(linie.pe) || ((Linie)cloneable).pe.equals(linie.pe)) continue;
                boolean bl = ((Linie)cloneable).getLaenge() < d;
                Cloneable cloneable3 = bl ? linie : cloneable;
                Cloneable cloneable4 = bl ? cloneable : linie;
                orthoLinie.setAnfangsPunkt(cloneable3.pa);
                orthoLinie.setEndPunkt(cloneable3.pe);
                Messung messung = orthoLinie.getMessungOf(((Linie)cloneable4).pa);
                Messung messung2 = orthoLinie.getMessungOf(((Linie)cloneable4).pe);
                double d2 = Math.abs(linie.getRichtung() - ((Linie)cloneable).getRichtung());
                if (!(Math.abs(messung.l2 - messung2.l2) < dist) || !(d2 < angle) && !(Math.abs(Math.PI - d2) < angle)) continue;
                if (cloneable2 != null) {
                    double d3 = (Math.abs(messung.l2) + Math.abs(messung2.l2)) / 2.0;
                    int n4 = 0;
                    if (Math.abs(messung.l1) < dist || Math.abs(messung.l1 - orthoLinie.getEndMass()) < dist) {
                        n4 += 4;
                    }
                    if (Math.abs(messung2.l1) < dist || Math.abs(messung2.l1 - orthoLinie.getEndMass()) < dist) {
                        n4 += 4;
                    }
                    if (messung.l1 > -dist && messung2.l1 < orthoLinie.getEndMass() + dist) {
                        n4 += 2;
                    }
                    if (d3 < maxAbstand) {
                        n4 += (int)(3.0 * d3 / maxAbstand);
                    }
                    n4 += (int)(2.0 * Math.abs(messung.l2 - messung2.l2) / dist);
                    if ((n4 += (int)(2.0 * (d2 < angle ? d2 : Math.abs(Math.PI - d2)) / angle)) <= n3) continue;
                    n3 = n4;
                    cloneable2 = cloneable;
                    continue;
                }
                cloneable2 = cloneable;
            }
            if (cloneable2 == null) continue;
            Bedingung bedingung = new Bedingung(3, (Punkt)DataBase.P.get(((Linie)cloneable2).pa.nr), (Punkt)DataBase.P.get(((Linie)cloneable2).pe.nr), null, 0.0);
            cloneable = new Bedingung(0, (Punkt)DataBase.P.get(linie.pa.nr), (Punkt)DataBase.P.get(linie.pe.nr), null, 0.0);
            ((Bedingung)cloneable).setReferenz(bedingung);
            this.riss.addElement(bedingung);
            this.riss.addElement(cloneable);
            this.BP.put(((Linie)cloneable2).pa);
            this.BP.put(((Linie)cloneable2).pe);
            this.BP.put(linie.pa);
            this.BP.put(linie.pe);
            ++n;
        }
        return n;
    }

    private int createFlstParallelen(Flurstueck flurstueck, boolean bl) {
        Messung messung;
        Cloneable cloneable;
        int n = 0;
        int n2 = flurstueck.size();
        OrthoLinie orthoLinie = new OrthoLinie();
        double d = 0.0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Linie linie = this.getClone((Linie)flurstueck.elementAt(i));
            if (linie.pa == null || linie.pe == null || PunktStatus.isFest(linie.pa.getPs()) && PunktStatus.isFest(linie.pe.getPs()) || this.P.get(linie.pa.nr) == null || this.P.get(linie.pe.nr) == null) continue;
            double d2 = linie.getLaenge();
            for (int j = i; j < n2; ++j) {
                Linie linie2 = this.getClone((Linie)flurstueck.elementAt(j));
                if (linie2.pa == null || linie2.pe == null || PunktStatus.isFest(linie2.pa.getPs()) && PunktStatus.isFest(linie2.pe.getPs()) || this.P.get(linie2.pa.nr) == null || this.P.get(linie2.pe.nr) == null || linie2.pa.equals(linie.pa) || linie2.pe.equals(linie.pa) || linie2.pa.equals(linie.pe) || linie2.pe.equals(linie.pe)) continue;
                if (linie2.getLaenge() < d2) {
                    orthoLinie.setAnfangsPunkt(linie.pa);
                    orthoLinie.setEndPunkt(linie.pe);
                    cloneable = orthoLinie.getMessungOf(linie2.pa);
                    messung = orthoLinie.getMessungOf(linie2.pe);
                } else {
                    orthoLinie.setAnfangsPunkt(linie2.pa);
                    orthoLinie.setEndPunkt(linie2.pe);
                    cloneable = orthoLinie.getMessungOf(linie.pa);
                    messung = orthoLinie.getMessungOf(linie.pe);
                }
                double d3 = Math.abs(linie.getRichtung() - linie2.getRichtung());
                if (!(Math.abs(((Messung)cloneable).l2 - messung.l2) < dist) || !(((Messung)cloneable).l1 > 0.0 && ((Messung)cloneable).l1 < orthoLinie.getEndMass()) && (!(messung.l1 > 0.0) || !(messung.l1 < orthoLinie.getEndMass())) || !(Math.abs(((Messung)cloneable).l2) < maxAbstand) || !(Math.abs(messung.l2) < maxAbstand) || !(d3 < angle) && !(Math.abs(Math.PI - d3) < angle)) continue;
                d += (Math.abs(((Messung)cloneable).l2) + Math.abs(messung.l2)) / 2.0;
                ++n3;
            }
        }
        if (n3 > 0) {
            d /= (double)n3;
        } else {
            return 0;
        }
        d = rundung * Math.rint(d / rundung);
        Bedingung bedingung = null;
        for (int i = 0; i < n2; ++i) {
            Linie linie = this.getClone((Linie)flurstueck.elementAt(i));
            if (linie.pa == null || linie.pe == null || PunktStatus.isFest(linie.pa.getPs()) && PunktStatus.isFest(linie.pe.getPs()) || this.P.get(linie.pa.nr) == null || this.P.get(linie.pe.nr) == null) continue;
            double d4 = linie.getLaenge();
            for (int j = i; j < n2; ++j) {
                double d5;
                Messung messung2;
                cloneable = this.getClone((Linie)flurstueck.elementAt(j));
                if (((Linie)cloneable).pa == null || ((Linie)cloneable).pe == null || PunktStatus.isFest(((Linie)cloneable).pa.getPs()) && PunktStatus.isFest(((Linie)cloneable).pe.getPs()) || this.P.get(((Linie)cloneable).pa.nr) == null || this.P.get(((Linie)cloneable).pe.nr) == null || ((Linie)cloneable).pa.equals(linie.pa) || ((Linie)cloneable).pe.equals(linie.pa) || ((Linie)cloneable).pa.equals(linie.pe) || ((Linie)cloneable).pe.equals(linie.pe)) continue;
                if (((Linie)cloneable).getLaenge() < d4) {
                    orthoLinie.setAnfangsPunkt(linie.pa);
                    orthoLinie.setEndPunkt(linie.pe);
                    messung = orthoLinie.getMessungOf(((Linie)cloneable).pa);
                    messung2 = orthoLinie.getMessungOf(((Linie)cloneable).pe);
                } else {
                    orthoLinie.setAnfangsPunkt(((Linie)cloneable).pa);
                    orthoLinie.setEndPunkt(((Linie)cloneable).pe);
                    messung = orthoLinie.getMessungOf(linie.pa);
                    messung2 = orthoLinie.getMessungOf(linie.pe);
                }
                double d6 = Math.abs(linie.getRichtung() - ((Linie)cloneable).getRichtung());
                if (!(Math.abs(messung.l2 - messung2.l2) < dist) || !(messung.l1 > 0.0 && messung.l1 < orthoLinie.getEndMass()) && (!(messung2.l1 > 0.0) || !(messung2.l1 < orthoLinie.getEndMass())) || !(Math.abs(messung.l2) < maxAbstand) || !(Math.abs(messung2.l2) < maxAbstand) || !(d6 < angle) && !(Math.abs(Math.PI - d6) < angle) || Math.abs(messung2.l1 - messung.l1) > d != this.getDeckung(messung.l1, messung2.l1, orthoLinie.getEndMass()) > d) continue;
                Bedingung bedingung2 = new Bedingung(3, (Punkt)DataBase.P.get(orthoLinie.getAnfangsPunkt().nr), (Punkt)DataBase.P.get(orthoLinie.getEndPunkt().nr), null, 0.0);
                if (!bedingung2.equals(bedingung)) {
                    this.riss.addElement(bedingung2);
                    this.BP.put(bedingung2.p1);
                    this.BP.put(bedingung2.p2);
                    bedingung = bedingung2;
                }
                double d7 = 0.0;
                if ((abstBed == 2 || abstBed == 3) && d != 0.0 && Math.abs((d5 = (Math.abs(messung.l2) + Math.abs(messung2.l2)) / 2.0) - d) < dist) {
                    d7 = d;
                }
                Bedingung bedingung3 = new Bedingung(0, (Punkt)DataBase.P.get(messung.ps.nr), (Punkt)DataBase.P.get(messung2.ps.nr), null, d7);
                this.BP.put(messung.ps);
                this.BP.put(messung2.ps);
                bedingung3.setReferenz(bedingung);
                this.riss.addElement(bedingung3);
                ++n;
            }
        }
        return n;
    }

    private double getDeckung(double d, double d2, double d3) {
        if (d < d2) {
            return Math.min(d2, d3) - Math.max(d, 0.0);
        }
        return Math.min(d, d3) - Math.max(d2, 0.0);
    }

    private int createBedingungen(Vector vector, Punkt punkt) {
        if (this.BP.get(punkt.nr) != null) {
            return 0;
        }
        int n = 0;
        OrthoLinie orthoLinie = new OrthoLinie();
        for (int i = 0; i < vector.size(); ++i) {
            Linie linie = (Linie)vector.elementAt(i);
            if (this.isALK && linie.getLa() < 2) continue;
            Punkt punkt2 = (Punkt)this.P.get(linie.pa.equals(punkt) ? linie.pe.nr : linie.pa.nr);
            double d = linie.getLaenge();
            for (int j = i + 1; j < vector.size(); ++j) {
                Linie linie2 = (Linie)vector.elementAt(j);
                if (this.isALK && linie2.getLa() < 2) continue;
                Punkt punkt3 = (Punkt)this.P.get(linie2.pa.equals(punkt) ? linie2.pe.nr : linie2.pa.nr);
                orthoLinie.setAnfangsPunkt(punkt);
                Messung messung = null;
                if (linie2.getLaenge() < d) {
                    orthoLinie.setEndPunkt(punkt2);
                    messung = orthoLinie.getMessungOf(punkt3);
                } else {
                    orthoLinie.setEndPunkt(punkt3);
                    messung = orthoLinie.getMessungOf(punkt2);
                }
                if (messung.l1 < 0.0 && Math.abs(messung.l2) < dist && Math.atan2(Math.abs(messung.l2), Math.abs(messung.l1)) < angle) {
                    this.riss.addElement(new Bedingung(1, (Punkt)DataBase.P.get(punkt2.nr), (Punkt)DataBase.P.get(punkt.nr), (Punkt)DataBase.P.get(punkt3.nr), 0.0));
                    this.BP.put(punkt);
                    ++n;
                }
                if (linie.getLa() != 3 && linie2.getLa() != 3 || !(Math.abs(messung.l1) < dist) || !(Math.atan2(Math.abs(messung.l1), Math.abs(messung.l2)) < angle)) continue;
                this.riss.addElement(new Bedingung(2, (Punkt)DataBase.P.get(punkt2.nr), (Punkt)DataBase.P.get(punkt.nr), (Punkt)DataBase.P.get(punkt3.nr), 0.0));
                this.BP.put(punkt);
                ++n;
            }
        }
        return n;
    }

    private void addError(GeomException geomException) {
        if (this.saveErrors && geomException != null) {
            this.exceptions.addException(geomException);
            ++errors;
        }
        this.setLabelText(errors + " Fehler");
        this.showProgress();
    }

    private void resetErrors() {
        errors = 0;
        this.setLabelText("0 Fehler");
    }

    class LinieHash
    extends Hashtable {
        LinieHash() {
        }

        void add(Punkt punkt, Linie linie) {
            HashEntry hashEntry = new HashEntry(BedingungCreator.this);
            hashEntry.value = linie;
            hashEntry.next = super.put(punkt, hashEntry);
        }

        Enumeration lines(Punkt punkt) {
            return new HashEnumerator(BedingungCreator.this, (HashEntry)this.get(punkt));
        }
    }

    class HashEnumerator
    implements Enumeration {
        HashEntry entry = null;

        HashEnumerator(BedingungCreator bedingungCreator, HashEntry hashEntry) {
            this.entry = hashEntry;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null;
        }

        public Object nextElement() {
            Linie linie = this.entry.value;
            this.entry = this.entry.next;
            return linie;
        }
    }

    class HashEntry {
        Linie value;
        HashEntry next;

        HashEntry(BedingungCreator bedingungCreator) {
        }
    }
}

