/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.lang.ErrorMessage;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public final class Bemerkung
extends TextBox
implements PunktContainer,
ErrorMessage,
Drawable,
DatObject {
    public Punkt p1;
    public Punkt p2;
    private boolean lastMode = false;

    public Bemerkung() {
        this(null, null, null);
    }

    public Bemerkung(Punkt punkt) {
        this(punkt, null, null);
    }

    public Bemerkung(Punkt punkt, Punkt punkt2) {
        this(punkt, punkt2, null);
    }

    public Bemerkung(Punkt punkt, Punkt punkt2, String string) {
        super(string);
        this.p1 = punkt;
        this.p2 = punkt2;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.p1 != null) {
            punktTable.put(this.p1);
        }
        if (this.p2 != null) {
            punktTable.put(this.p2);
        }
        return punktTable;
    }

    public boolean equals(Object object) {
        if (object instanceof Bemerkung) {
            Bemerkung bemerkung = (Bemerkung)object;
            return bemerkung.p1 == this.p1 && bemerkung.p2 == this.p2;
        }
        return false;
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.p1 == punkt || this.p2 == punkt;
    }

    @Override
    protected void calculatePosition() {
        double d;
        int n = -99;
        n = this.p1 == null ? -99 : (this.p2 == null ? 11 : ((d = Math.atan2(this.p2.y - this.p1.y, this.p2.x - this.p1.x) * 180.0 / Math.PI) < -157.5 ? -10 : (d < -112.5 ? 11 : (d < -67.5 ? 1 : (d < -22.5 ? -9 : (d < 22.5 ? 10 : (d < 67.5 ? 11 : (d < 112.5 ? 1 : (d < 157.5 ? -9 : -10)))))))));
        this.setPosition(n);
    }

    @Override
    public DPoint getCatchPoint() {
        return this.getHashPoint();
    }

    @Override
    public DPoint getHashPoint() {
        DPoint dPoint = new DPoint();
        if (this.p2 != null) {
            dPoint.y = (this.p1.y + this.p2.y) / 2.0;
            dPoint.x = (this.p1.x + this.p2.x) / 2.0;
        } else {
            dPoint.y = this.p1.y;
            dPoint.x = this.p1.x;
        }
        double d = 0.01;
        switch (this.getPosition()) {
            case -11: {
                dPoint.y += d;
                dPoint.x -= d;
                break;
            }
            case -1: {
                dPoint.x -= d;
                break;
            }
            case 9: {
                dPoint.y -= d;
                dPoint.x -= d;
                break;
            }
            case -10: {
                dPoint.y += d;
                break;
            }
            case 10: {
                dPoint.y -= d;
                break;
            }
            case -9: {
                dPoint.y += d;
                dPoint.x += d;
                break;
            }
            case 1: {
                dPoint.x += d;
                break;
            }
            case 11: {
                dPoint.y -= d;
                dPoint.x += d;
            }
        }
        return dPoint;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(0);
        dataOutput.writeByte(this.getPosition());
        PunktNummer.writeObject(this.p1 != null ? this.p1.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.p2 != null ? this.p2.nr : 0L, dataOutput);
        KafPlotIOConstants.writeString(dataOutput, this.getText());
    }

    public static Bemerkung readObject(DataInput dataInput) throws IOException {
        Bemerkung bemerkung = new Bemerkung();
        dataInput.readByte();
        bemerkung.setPosition(dataInput.readByte());
        bemerkung.p1 = new Punkt(PunktNummer.readObject(dataInput));
        bemerkung.p2 = new Punkt(PunktNummer.readObject(dataInput));
        bemerkung.setText(KafPlotIOConstants.readString(dataInput));
        return bemerkung;
    }

    @Override
    public DRectangle getBounds() {
        if (this.p2 == null) {
            return new DRectangle(this.p1.y, this.p1.x, 0.0, 0.0);
        }
        return new DRectangle(Math.min(this.p1.y, this.p2.y), Math.min(this.p1.x, this.p2.x), Math.abs(this.p1.y - this.p2.y), Math.abs(this.p1.x - this.p2.x));
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawInscription(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        super.setLocation(iGraphics.getGraphicPoint(this.getCatchPoint()));
        if (this.lastMode) {
            bl2 = false;
        }
        this.lastMode = bl2;
        graphics.setPaintMode();
        Color color = KafPlotColor.BEMERKUNG_FG;
        Color color2 = KafPlotColor.BEMERKUNG_BEM_BG;
        if (bl2) {
            color2 = KafPlotColor.BEMERKUNG_RAISED_BG;
            color = KafPlotColor.BEMERKUNG_RAISED_FG;
        } else {
            color2 = KafPlotProperties.bemColor.getColor(new Integer(1));
            if (KafPlotProperties.getBemerkungColorAlpha() < 255) {
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), KafPlotProperties.getBemerkungColorAlpha());
            }
        }
        this.setBackground(color2);
        this.setForeground(color);
        this.paint(graphics);
    }

    public String getLocationAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.p1.nr);
        if (this.p2 != null) {
            stringBuffer.append("-");
            stringBuffer.append(this.p2.nr);
        }
        return stringBuffer.toString();
    }

    public String toMessageString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.p1 != null) {
            stringBuffer.append(this.p1.nr);
        }
        if (this.p2 != null && this.p2.nr != 0L) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.p2.nr);
        }
        stringBuffer.append("     ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText());
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (stringBuffer.length() + string.length() < 50) {
                stringBuffer.append(string);
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("...");
            break;
        }
        return stringBuffer.toString();
    }

    @Override
    public String toFileMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.EOL);
        if (this.p1 != null && this.p1.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr14.format(this.p1.nr).toString());
            stringBuffer.append(" ");
        }
        if (this.p2 != null && this.p2.nr != 0L) {
            stringBuffer.append(GeoNumberFormat.nr14.format(this.p2.nr).toString());
        }
        stringBuffer.append(GeoNumberFormat.EOL);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("5 ");
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.i14.format(this.p1.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.p1.getNr() : this.p1.nr)));
        stringBuffer.append(" ");
        stringBuffer.append(this.p2 != null ? IFormat.i14.format(this.p2.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? this.p2.getNr() : this.p2.nr)) : "              ");
        stringBuffer.append(" ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDialogMessage() {
        return this.toMessageString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": ");
        if (this.p1 != null) {
            stringBuffer.append(" P1=" + this.p1.nr);
        }
        if (this.p2 != null) {
            stringBuffer.append(" P2=" + this.p2.nr);
        }
        if (this.getText() != null) {
            stringBuffer.append(this.getText());
        }
        return stringBuffer.toString();
    }
}

