/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class BodenInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    private Label idLabel;
    private Label oskaValueLabel;
    private Label oskaTextLabel;
    private Label kulturValueLabel;
    private Label kulturAcroLabel;
    private Label kulturTextLabel;
    private Label bodenValueLabel;
    private Label bodenAcroLabel;
    private Label bodenTextLabel;
    private Label stufeNameLabel;
    private Label stufeValueLabel;
    private Label stufeAcroLabel;
    private Label stufeTextLabel;
    private Label entValueLabel;
    private Label entAcroLabel;
    private Label entTextLabel;
    private Label klimaValueLabel;
    private Label klimaAcroLabel;
    private Label klimaTextLabel;
    private Label wasserValueLabel;
    private Label wasserAcroLabel;
    private Label wasserTextLabel;
    private Label bodenZahlNameLabel;
    private Label bodenZahlValueLabel;
    private Label wertZahlNameLabel;
    private Label wertZahlValueLabel;

    public BodenInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (BodenSchaetzung)null);
    }

    public BodenInfoDialog(IFrame iFrame, String string, BodenSchaetzung bodenSchaetzung) {
        super(iFrame, string, bodenSchaetzung);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        Label label = new Label("Kennzeichen: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.idLabel = new Label("", 0);
        iPanel.add(this.idLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        label = new Label("Oska: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oskaValueLabel = new Label("", 0);
        iPanel.add(this.oskaValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.oskaValueLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.oskaTextLabel = new Label("", 0);
        iPanel.add(this.oskaTextLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.oskaTextLabel, gridBagConstraints);
        label = new Label("Kulturart: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kulturValueLabel = new Label("", 0);
        iPanel.add(this.kulturValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.kulturValueLabel, gridBagConstraints);
        this.kulturAcroLabel = new Label("", 0);
        iPanel.add(this.kulturAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.kulturAcroLabel, gridBagConstraints);
        this.kulturTextLabel = new Label("", 0);
        iPanel.add(this.kulturTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.kulturTextLabel, gridBagConstraints);
        label = new Label("Bodenart: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bodenValueLabel = new Label("", 0);
        iPanel.add(this.bodenValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.bodenValueLabel, gridBagConstraints);
        this.bodenAcroLabel = new Label("", 0);
        iPanel.add(this.bodenAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.bodenAcroLabel, gridBagConstraints);
        this.bodenTextLabel = new Label("", 0);
        iPanel.add(this.bodenTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.bodenTextLabel, gridBagConstraints);
        this.stufeNameLabel = new Label("Stufe: ", 0);
        iPanel.add(this.stufeNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.stufeNameLabel, gridBagConstraints);
        this.stufeValueLabel = new Label("", 0);
        iPanel.add(this.stufeValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.stufeValueLabel, gridBagConstraints);
        this.stufeAcroLabel = new Label("", 0);
        iPanel.add(this.stufeAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.stufeAcroLabel, gridBagConstraints);
        this.stufeTextLabel = new Label("", 0);
        iPanel.add(this.stufeTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.stufeTextLabel, gridBagConstraints);
        label = new Label("Entstehungsart: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.entValueLabel = new Label("", 0);
        iPanel.add(this.entValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.entValueLabel, gridBagConstraints);
        this.entAcroLabel = new Label("", 0);
        iPanel.add(this.entAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.entAcroLabel, gridBagConstraints);
        this.entTextLabel = new Label("", 0);
        iPanel.add(this.entTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.entTextLabel, gridBagConstraints);
        label = new Label("Klimastufe: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.klimaValueLabel = new Label("", 0);
        iPanel.add(this.klimaValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.klimaValueLabel, gridBagConstraints);
        this.klimaAcroLabel = new Label("", 0);
        iPanel.add(this.klimaAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.klimaAcroLabel, gridBagConstraints);
        this.klimaTextLabel = new Label("", 0);
        iPanel.add(this.klimaTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.klimaTextLabel, gridBagConstraints);
        label = new Label("Wasserverh\u00e4ltnisse: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.wasserValueLabel = new Label("", 0);
        iPanel.add(this.wasserValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.wasserValueLabel, gridBagConstraints);
        this.wasserAcroLabel = new Label("", 0);
        iPanel.add(this.wasserAcroLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.1;
        gridBagLayout.setConstraints(this.wasserAcroLabel, gridBagConstraints);
        this.wasserTextLabel = new Label("", 0);
        iPanel.add(this.wasserTextLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.wasserTextLabel, gridBagConstraints);
        this.bodenZahlNameLabel = new Label("Bodenzahl: ", 0);
        iPanel.add(this.bodenZahlNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.bodenZahlNameLabel, gridBagConstraints);
        this.bodenZahlValueLabel = new Label("", 0);
        iPanel.add(this.bodenZahlValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.bodenZahlValueLabel, gridBagConstraints);
        this.wertZahlNameLabel = new Label("Wertzahl: ", 0);
        iPanel.add(this.wertZahlNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.wertZahlNameLabel, gridBagConstraints);
        this.wertZahlValueLabel = new Label("", 0);
        iPanel.add(this.wertZahlValueLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.wertZahlValueLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(3);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Kennzeichen", 0), new ITableCell("Oska", 0), new ITableCell("Wert", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)object;
        this.table.removeLines();
        super.setObject(object);
        if (bodenSchaetzung != null) {
            this.addObjectToTable(bodenSchaetzung);
        }
    }

    public void setObjects(Enumeration enumeration) {
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            this.addObjectToTable(enumeration.nextElement());
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)object;
        if (bodenSchaetzung != null) {
            this.idLabel.setText(bodenSchaetzung.getName());
            this.oskaValueLabel.setText(bodenSchaetzung.getOskaAsString());
            this.oskaTextLabel.setText(Alkis.getObjectName(bodenSchaetzung.getOska()));
            BodenSchaetzung.BodenEntry bodenEntry = null;
            bodenEntry = bodenSchaetzung.getKulturEntry();
            this.kulturValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.kulturAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.kulturTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            bodenEntry = bodenSchaetzung.getBodenArtEntry();
            this.bodenValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.bodenAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.bodenTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            bodenEntry = bodenSchaetzung.getStufeEntry();
            this.stufeNameLabel.setText((String)(bodenEntry != null ? bodenSchaetzung.getStufeLabel() + ": " : "Stufe: "));
            this.stufeValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.stufeAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.stufeTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            bodenEntry = bodenSchaetzung.getEntstehungsArtEntry();
            this.entValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.entAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.entTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            bodenEntry = bodenSchaetzung.getKlimaStufeEntry();
            this.klimaValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.klimaAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.klimaTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            bodenEntry = bodenSchaetzung.getWasserStufeEntry();
            this.wasserValueLabel.setText(bodenEntry != null ? Integer.toString(bodenEntry.getKey()) : "");
            this.wasserAcroLabel.setText(bodenEntry != null ? bodenEntry.getAcronym() : "");
            this.wasserTextLabel.setText(bodenEntry != null ? bodenEntry.getDescription() : "");
            this.bodenZahlNameLabel.setText(bodenSchaetzung.getBodenZahlLabel() + ": ");
            this.bodenZahlValueLabel.setText(bodenSchaetzung.getBodenZahlAsString());
            this.wertZahlNameLabel.setText(bodenSchaetzung.getWertZahlLabel() + ": ");
            this.wertZahlValueLabel.setText(bodenSchaetzung.getWertZahlAsString());
        } else {
            this.idLabel.setText("");
            this.oskaValueLabel.setText("");
            this.oskaTextLabel.setText("");
            this.kulturValueLabel.setText("");
            this.kulturAcroLabel.setText("");
            this.kulturTextLabel.setText("");
            this.bodenValueLabel.setText("");
            this.bodenAcroLabel.setText("");
            this.bodenTextLabel.setText("");
            this.stufeNameLabel.setText("Stufe: ");
            this.stufeValueLabel.setText("");
            this.stufeAcroLabel.setText("");
            this.stufeTextLabel.setText("");
            this.entValueLabel.setText("");
            this.entAcroLabel.setText("");
            this.entTextLabel.setText("");
            this.klimaValueLabel.setText("");
            this.klimaAcroLabel.setText("");
            this.klimaTextLabel.setText("");
            this.wasserValueLabel.setText("");
            this.wasserAcroLabel.setText("");
            this.wasserTextLabel.setText("");
            this.bodenZahlNameLabel.setText("");
            this.bodenZahlValueLabel.setText("");
            this.wertZahlNameLabel.setText("");
            this.wertZahlValueLabel.setText("");
        }
        this.doLayout();
    }

    private void addObjectToTable(Object object) {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)object;
        ITableCell[] iTableCellArray = new ITableCell[3];
        iTableCellArray = new ITableCell[]{new ITableCell(bodenSchaetzung.getName(), -10), new ITableCell(bodenSchaetzung.getOskaAsString(), -10), new ITableCell(bodenSchaetzung.getLabel().replace(BodenSchaetzung.LABEL_DELIM, ' '), -10)};
        this.table.addLine(new ITableLine(iTableCellArray, bodenSchaetzung));
        Enumeration enumeration = bodenSchaetzung.decors();
        while (enumeration.hasMoreElements()) {
            ObjectDecor objectDecor = (ObjectDecor)enumeration.nextElement();
            iTableCellArray = new ITableCell[3];
            if (objectDecor instanceof ObjectText) {
                iTableCellArray[0] = new ITableCell("Text", -10);
                iTableCellArray[1] = new ITableCell(IFormat.i04.format(objectDecor.getOska()), -10);
                iTableCellArray[2] = new ITableCell(((ObjectText)objectDecor).getText(), -10);
            } else if (objectDecor instanceof ObjectSymbol) {
                iTableCellArray[0] = new ITableCell("Symbol", -10);
                iTableCellArray[1] = new ITableCell(IFormat.i04.format(objectDecor.getOska()), -10);
                iTableCellArray[2] = new ITableCell("", -10);
            } else {
                iTableCellArray[0] = new ITableCell("", -10);
                iTableCellArray[1] = new ITableCell(IFormat.i04.format(objectDecor.getOska()), -10);
                iTableCellArray[2] = new ITableCell("", -10);
            }
            this.table.addLine(new ITableLine(iTableCellArray, bodenSchaetzung));
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.object = iTableEvent.getContent();
        this.showObject(iTableEvent.getContent());
        if (iTableEvent.getClickCount() > 1 && this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }
}

