/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.Sortable;
import de.geocalc.util.SortedList;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class BodenSchaetzung
extends GObject
implements PaintObject,
DatObject,
Comparable,
Exceptionable,
Messager {
    public static char LABEL_DELIM = (char)36;
    public static String LABEL_DELIM_STRING = Character.toString(LABEL_DELIM);
    private int count = 0;
    private short kulturArt;
    private short bodenArt;
    private short stufe;
    private short entstehungsArt;
    private short klimaStufe;
    private short wasserStufe;
    private String bodenZahl = "";
    private String wertZahl = "";
    private static final Text textOben = new Text(2, 2, null, 0.0, 0.0, 0.0, 1, 42404356);
    private static final Text textUnten = new Text(2, 2, null, 0.0, 0.0, 0.0, 7, 0);
    private static final TextSymbol symOben = new TextSymbol(textOben, new Point());
    private static final TextSymbol symUnten = new TextSymbol(textUnten, new Point());
    private static final Point p = new Point();
    private static final IntegerHashList KULTUR = new IntegerHashList();
    private static final IntegerHashList BODEN = new IntegerHashList();
    private static final IntegerHashList STUFE = new IntegerHashList();
    private static final IntegerHashList ENTST = new IntegerHashList();
    private static final IntegerHashList KLIMA = new IntegerHashList();
    private static final IntegerHashList WASSER = new IntegerHashList();
    private static final IntegerHashList SON = new IntegerHashList();
    private static final Color C_SAND = new Color(253, 251, 164);
    private static final Color C_SAND_LEHM_1 = new Color(250, 231, 129);
    private static final Color C_SAND_LEHM_2 = new Color(247, 211, 97);
    private static final Color C_SAND_LEHM_3 = new Color(247, 211, 97);
    private static final Color C_LEHM_SAND = new Color(208, 169, 130);
    private static final Color C_LEHM = new Color(207, 143, 115);
    private static final Color C_LEHM_1 = new Color(203, 163, 190);
    private static final Color C_TON = new Color(171, 160, 202);
    private static final Color C_MOOR = new Color(95, 173, 133);
    private static final Color C_STEIN = new Color(127, 127, 127);
    private static final Color C_FELS = new Color(100, 100, 100);
    private static final Color C_LOESS = new Color(175, 95, 95);

    public void setKulturArt(int n) {
        this.kulturArt = (short)n;
    }

    public int getKulturArt() {
        return this.kulturArt;
    }

    public BodenEntry getKulturEntry() {
        return (BodenEntry)KULTUR.get(this.kulturArt);
    }

    public void setBodenArt(int n) {
        this.bodenArt = (short)n;
    }

    public int getBodenArt() {
        return this.bodenArt;
    }

    public BodenEntry getBodenArtEntry() {
        return (BodenEntry)BODEN.get(this.bodenArt);
    }

    public void setStufe(int n) {
        this.stufe = (short)n;
    }

    public int getStufe() {
        return this.stufe;
    }

    public String getStufeLabel() {
        if (this.stufe > 1000 && this.stufe < 2000) {
            return "Zustandsstufe";
        }
        if (this.stufe > 2000) {
            return "Bodenstufe";
        }
        return "";
    }

    public BodenEntry getStufeEntry() {
        return (BodenEntry)STUFE.get(this.stufe);
    }

    public int getEntstehungsArt() {
        return this.entstehungsArt;
    }

    public void setEntstehungsArt(int n) {
        this.entstehungsArt = (short)n;
    }

    public BodenEntry getEntstehungsArtEntry() {
        return (BodenEntry)ENTST.get(this.stufe);
    }

    public void setKlimaStufe(int n) {
        this.klimaStufe = (short)n;
    }

    public int getKlimaStufe() {
        return this.klimaStufe;
    }

    public BodenEntry getKlimaStufeEntry() {
        return (BodenEntry)KLIMA.get(this.stufe);
    }

    public void setWasserStufe(int n) {
        this.wasserStufe = (short)n;
    }

    public int getWasserStufe() {
        return this.wasserStufe;
    }

    public BodenEntry getWasserStufeEntry() {
        return (BodenEntry)WASSER.get(this.stufe);
    }

    public void setBodenZahl(String string) {
        this.bodenZahl = string;
    }

    public boolean hasBodenZahl() {
        return this.bodenZahl.length() > 0;
    }

    public String getBodenZahl() {
        return this.bodenZahl;
    }

    public String getBodenZahlAsString() {
        return this.bodenZahl.length() > 0 ? this.bodenZahl : "-";
    }

    public String getBodenZahlLabel() {
        if (this.kulturArt >= 1000 && this.kulturArt <= 2000) {
            return "Bodenzahl";
        }
        if (this.kulturArt >= 3000 && this.kulturArt <= 4000) {
            return "Gr\u00fcnlandgrundzahl";
        }
        return "";
    }

    public float getBodenValue() {
        try {
            return Float.parseFloat(this.bodenZahl);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void setWertZahl(String string) {
        this.wertZahl = string;
    }

    public boolean hasWertZahl() {
        return this.wertZahl.length() > 0;
    }

    public String getWertZahl() {
        return this.wertZahl;
    }

    public String getWertZahlAsString() {
        return this.wertZahl.length() > 0 ? this.wertZahl : "-";
    }

    public String getWertZahlLabel() {
        if (this.kulturArt >= 1000 && this.kulturArt <= 2000) {
            return "Ackerzahl";
        }
        if (this.kulturArt >= 3000 && this.kulturArt <= 4000) {
            return "Gr\u00fcnlandzahl";
        }
        return "";
    }

    public float getWertValue() {
        try {
            return Float.parseFloat(this.wertZahl);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public float getMixedValue() {
        float f = this.getBodenValue();
        float f2 = this.getWertValue();
        if ((double)f2 == 0.0) {
            return f;
        }
        if ((double)f == 0.0) {
            return f2;
        }
        return (f + f2) / 2.0f;
    }

    public String getLabel() {
        CharSequence charSequence;
        Object object;
        String string;
        Object object2;
        String string2 = "";
        Object object3 = "";
        Object object4 = "";
        boolean bl = false;
        if (this.hasAttributes()) {
            object2 = this.attributes();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                if (string.startsWith("sonstigeAngaben")) {
                    int n = Integer.parseInt(this.getAttribute(string).toString());
                    object = (BodenEntry)SON.get(n);
                    CharSequence charSequence2 = charSequence = object != null ? ((BodenEntry)object).getAcronym() : "?";
                    if (n == 3000 || n == 4000) {
                        object3 = (String)object3 + (String)charSequence;
                    } else {
                        object4 = (String)object4 + (String)charSequence;
                    }
                    bl = true;
                    continue;
                }
                if (!string.equals("jahreszahl")) continue;
                string2 = this.getAttribute(string).toString();
            }
        }
        string = (object2 = (BodenEntry)BODEN.get(this.bodenArt)) != null ? ((BodenEntry)object2).getAcronym() : "";
        object2 = (BodenEntry)STUFE.get(this.stufe);
        String string3 = object2 != null ? ((BodenEntry)object2).getAcronym() : "";
        object = "";
        if (this.entstehungsArt != 0) {
            object2 = (BodenEntry)ENTST.get(this.entstehungsArt);
            object = (String)object + ((BodenEntry)object2).getAcronym();
        }
        if (this.klimaStufe != 0) {
            object2 = (BodenEntry)KLIMA.get(this.klimaStufe);
            object = (String)object + ((BodenEntry)object2).getAcronym();
        }
        if (this.wasserStufe != 0) {
            object2 = (BodenEntry)WASSER.get(this.wasserStufe);
            object = (String)object + ((BodenEntry)object2).getAcronym();
        }
        charSequence = new StringBuffer();
        if (this.kulturArt == 2000 || this.kulturArt == 4000) {
            ((StringBuffer)charSequence).append("(");
        }
        ((StringBuffer)charSequence).append(string);
        ((StringBuffer)charSequence).append(string3);
        ((StringBuffer)charSequence).append((String)object);
        if (this.kulturArt == 2000 || this.kulturArt == 4000) {
            ((StringBuffer)charSequence).append(")");
        }
        ((StringBuffer)charSequence).append(LABEL_DELIM);
        ((StringBuffer)charSequence).append(this.getBodenZahlAsString());
        ((StringBuffer)charSequence).append("/");
        ((StringBuffer)charSequence).append(this.getWertZahlAsString());
        if (bl) {
            ((StringBuffer)charSequence).append(LABEL_DELIM);
            if (((String)object3).length() > 0) {
                ((StringBuffer)charSequence).append((String)object3);
            } else {
                ((StringBuffer)charSequence).append((String)object4);
                ((StringBuffer)charSequence).append(string2);
            }
        }
        return ((StringBuffer)charSequence).toString();
    }

    @Override
    public LinieParameter getLineDefaults() {
        return LinieParameter.BODEN;
    }

    @Override
    public boolean defMultiArea() {
        return true;
    }

    @Override
    public boolean isVoid() {
        return this.count == 0;
    }

    @Override
    public void deleteName() {
        this.count = 0;
    }

    public boolean equals(Object object) {
        if (object instanceof BodenSchaetzung) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)object;
        if (this.count == bodenSchaetzung.count) {
            return 0;
        }
        if (this.count > bodenSchaetzung.count) {
            return 1;
        }
        return -1;
    }

    public void setNummer(int n) {
        this.count = n;
    }

    public int getNummer() {
        return this.count;
    }

    public String getNummerAsString() {
        return this.count > 0 ? IFormat.i06.format(this.count) : "";
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.count != 0) {
            stringBuffer.append("BS");
            stringBuffer.append(IFormat.i06.format(this.count).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "BodenSchaetzung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.count != 0) {
            stringBuffer.append(IFormat.i06.format(this.count));
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataContainer parseDatLine(String string) throws IException {
        BodenSchaetzung bodenSchaetzung = new BodenSchaetzung();
        int n = 0;
        if (string == null) return bodenSchaetzung;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                if (n == 0 && string2.startsWith("BS")) {
                    try {
                        bodenSchaetzung.setNummer(Integer.parseInt(string2.substring(2)));
                    }
                    catch (Exception exception) {
                        throw new IException("fehlerhaftes Objektkennzeichen");
                    }
                } else {
                    int n2 = string2.indexOf(61);
                    String string3 = string2.substring(0, n2);
                    String string4 = string2.substring(n2 + 1);
                    if (string3.equalsIgnoreCase("A")) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ":-.");
                        int n3 = 0;
                        while (stringTokenizer2.hasMoreTokens()) {
                            int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                            switch (n3) {
                                case 0: {
                                    bodenSchaetzung.setKulturArt(n4);
                                    break;
                                }
                                case 1: {
                                    bodenSchaetzung.setBodenArt(n4);
                                    break;
                                }
                                case 2: {
                                    bodenSchaetzung.setStufe(n4);
                                    break;
                                }
                                case 3: {
                                    bodenSchaetzung.setEntstehungsArt(n4);
                                    break;
                                }
                                case 4: {
                                    bodenSchaetzung.setKlimaStufe(n4);
                                    break;
                                }
                                case 5: {
                                    bodenSchaetzung.setWasserStufe(n4);
                                    break;
                                }
                                default: {
                                    throw new Exception();
                                }
                            }
                            ++n3;
                        }
                    } else if (string3.equalsIgnoreCase("W")) {
                        int n5 = string4.indexOf("/");
                        if (n5 < 0) throw new Exception();
                        String string5 = string4.substring(0, n5);
                        if (!string5.equals("-")) {
                            bodenSchaetzung.setBodenZahl(string5);
                        }
                        if (!(string5 = string4.substring(n5 + 1)).equals("-")) {
                            bodenSchaetzung.setWertZahl(string5);
                        }
                    } else if (string3.equalsIgnoreCase("Y")) {
                        bodenSchaetzung.y = Double.parseDouble(string4);
                    } else {
                        if (!string3.equalsIgnoreCase("X")) throw new IException("unzul\u00e4ssige Variable: " + string3);
                        bodenSchaetzung.x = Double.parseDouble(string4);
                    }
                }
                ++n;
            }
            catch (Exception exception) {
                throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
            }
        }
        return bodenSchaetzung;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Bodenschaetzung:");
        stringBuffer.append(" ");
        if (this.count != 0) {
            stringBuffer.append("BS");
            stringBuffer.append(IFormat.i06.format(this.count).toString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        if (this.getKulturArt() != 0) {
            stringBuffer.append(" A=");
            stringBuffer.append(IFormat.i04.format(this.getKulturArt()));
            stringBuffer.append(":");
            stringBuffer.append(IFormat.i04.format(this.getBodenArt()));
            stringBuffer.append(":");
            stringBuffer.append(IFormat.i04.format(this.getStufe()));
            stringBuffer.append(":");
            stringBuffer.append(IFormat.i04.format(this.getEntstehungsArt()));
            stringBuffer.append(":");
            stringBuffer.append(IFormat.i04.format(this.getKlimaStufe()));
            stringBuffer.append(":");
            stringBuffer.append(IFormat.i04.format(this.getWasserStufe()));
        }
        if (this.hasBodenZahl() || this.hasWertZahl()) {
            stringBuffer.append(" W=");
            stringBuffer.append(this.getBodenZahlAsString());
            stringBuffer.append("/");
            stringBuffer.append(this.getWertZahlAsString());
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(this.kulturArt);
        dataOutput.writeShort(this.bodenArt);
        dataOutput.writeShort(this.stufe);
        dataOutput.writeShort(this.entstehungsArt);
        dataOutput.writeShort(this.klimaStufe);
        dataOutput.writeShort(this.wasserStufe);
        KafPlotIOConstants.writeString(dataOutput, this.bodenZahl);
        KafPlotIOConstants.writeString(dataOutput, this.wertZahl);
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeInt(this.count);
        dataOutput.writeShort(this.kulturArt);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Linie)enumeration.nextElement()).writeObject(dataOutput);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ((ObjectDecor)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        if (this.att != null) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(110);
                String string = (String)enumeration.nextElement();
                KafPlotIOConstants.writeString(dataOutput, string);
                KafPlotIOConstants.writeString(dataOutput, this.getAttribute(string).toString());
            }
        }
        dataOutput.writeByte(0);
    }

    public static BodenSchaetzung readObject(DataInput dataInput) throws IOException {
        BodenSchaetzung bodenSchaetzung = new BodenSchaetzung();
        bodenSchaetzung.y = dataInput.readDouble();
        bodenSchaetzung.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            bodenSchaetzung.yt = dataInput.readDouble();
            bodenSchaetzung.xt = dataInput.readDouble();
        }
        bodenSchaetzung.kulturArt = dataInput.readShort();
        bodenSchaetzung.bodenArt = dataInput.readShort();
        bodenSchaetzung.stufe = dataInput.readShort();
        bodenSchaetzung.entstehungsArt = dataInput.readShort();
        bodenSchaetzung.klimaStufe = dataInput.readShort();
        bodenSchaetzung.wasserStufe = dataInput.readShort();
        bodenSchaetzung.bodenZahl = KafPlotIOConstants.readString(dataInput);
        bodenSchaetzung.wertZahl = KafPlotIOConstants.readString(dataInput);
        bodenSchaetzung.setTextAngle(dataInput.readFloat());
        bodenSchaetzung.count = dataInput.readInt();
        bodenSchaetzung.kulturArt = dataInput.readShort();
        byte by = 0;
        while ((by = dataInput.readByte()) != -1) {
            if (by == 15) {
                bodenSchaetzung.addElement(Linie.readObject(dataInput));
                continue;
            }
            if (by == 61) {
                bodenSchaetzung.addDecor(ObjectText.readObject(dataInput));
                continue;
            }
            if (by == 62) {
                bodenSchaetzung.addDecor(ObjectSymbol.readObject(dataInput));
                continue;
            }
            if (by != 110) break;
            bodenSchaetzung.setAttribute(KafPlotIOConstants.readString(dataInput), KafPlotIOConstants.readString(dataInput));
        }
        return bodenSchaetzung;
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        return new Vector(1);
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2 || KafPlotProperties.isFlaecheFillVisible && KafPlotProperties.isBodsFillVisible) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        if (bl2 || KafPlotProperties.isFlaechePolyVisible && KafPlotProperties.isBodsPolyVisible) {
            this.drawForeground(iGraphics, bl, bl2);
        }
        if (KafPlotProperties.isFlaecheTextVisible) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            this.drawHashpoint(iGraphics, bl, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.size() == 0) {
            return;
        }
        if (KafPlotProperties.getColorSwitch() == 1012) {
            iGraphics.getGraphics().setColor(KafPlotProperties.aBkColor.getColor(new Integer(this.getKulturArt())));
        } else if (KafPlotProperties.getColorSwitch() == 1013) {
            iGraphics.getGraphics().setColor(KafPlotProperties.aBaColor.getColor(new Integer(this.getBodenArt())));
        } else {
            if (KafPlotProperties.getColorSwitch() != 1014) return;
            float f = this.getMixedValue();
            if (f == 0.0f) return;
            iGraphics.getGraphics().setColor(KafPlotProperties.aBwColor.getColor(f));
        }
        super.drawBackground(iGraphics, bl, bl2);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        Object object;
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (this.kulturArt <= 0) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = null;
        if (KafPlotProperties.getColorSwitch() == 1009) {
            color = KafPlotProperties.aBgColor.getColor("O");
        } else if (KafPlotProperties.getColorSwitch() == 1004 && !this.isFortfuehrung()) {
            color = IColor.getDarker(KafPlotProperties.aFoColor.getColor("F0"), 0.9f);
        } else {
            Color color2 = color = this.kulturArt < 3000 ? Alkis.COLOR_BODEN_RED : Alkis.COLOR_BODEN_GREEN;
        }
        if (KafPlotProperties.getColorSwitch() == 1012 || KafPlotProperties.getColorSwitch() == 1013 || KafPlotProperties.getColorSwitch() == 1014) {
            color = color.darker();
        }
        graphics.setColor(color);
        if (this.hasLocation() && KafPlotProperties.isBodsTextVisible && iGraphics.contains(this.y, this.x)) {
            object = this.getLabel();
            int n = 0;
            int n2 = 0;
            FontMetrics fontMetrics = graphics.getFontMetrics(Alkis.FONT_BODEN);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, LABEL_DELIM_STRING);
            while (stringTokenizer.hasMoreTokens()) {
                n += fontMetrics.getAscent();
                n2 = Math.max(n2, fontMetrics.stringWidth(stringTokenizer.nextToken()));
            }
            iGraphics.getGraphicPoint(this.y, this.x, p);
            graphics.setFont(Alkis.FONT_BODEN);
            int n3 = BodenSchaetzung.p.x;
            int n4 = BodenSchaetzung.p.y - n / 2;
            StringTokenizer stringTokenizer2 = new StringTokenizer((String)object, LABEL_DELIM_STRING);
            while (stringTokenizer2.hasMoreTokens()) {
                String string = stringTokenizer2.nextToken();
                graphics.drawString(string, n3 - fontMetrics.stringWidth(string) / 2, n4 += fontMetrics.getAscent());
            }
        }
        if (this.hasDecor()) {
            object = this.decors();
            while (object.hasMoreElements()) {
                ObjectDecor objectDecor = (ObjectDecor)object.nextElement();
                objectDecor.setColor(color);
                if (objectDecor instanceof ObjectSymbol) {
                    if (!KafPlotProperties.isTopSymVisible) continue;
                    objectDecor.drawObject(iGraphics, bl, bl2);
                    continue;
                }
                if (!KafPlotProperties.isTopTextVisible) continue;
                objectDecor.drawObject(iGraphics, bl, bl2);
            }
        }
    }

    public static Enumeration kulturArten() {
        return new SortedList(KULTUR).elements();
    }

    public static Enumeration bodenArten() {
        return new SortedList(BODEN).elements();
    }

    static {
        KULTUR.put(new BodenColorEntry(1000, "A", "Ackerland", new Color(255, 250, 200)));
        KULTUR.put(new BodenColorEntry(2000, "AGr", "Acker-Gr\u00fcnland", new Color(235, 245, 195)));
        KULTUR.put(new BodenColorEntry(4000, "GrA", "Gr\u00fcnland-Acker", new Color(200, 225, 175)));
        KULTUR.put(new BodenColorEntry(3000, "Gr", "Gr\u00fcnland", new Color(180, 220, 170)));
        BODEN.put(new BodenColorEntry(1100, "S", "Sand", C_SAND));
        BODEN.put(new BodenColorEntry(2100, "lS", "Lehmiger Sand", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(3100, "L", "Lehm", C_LEHM));
        BODEN.put(new BodenColorEntry(4100, "T", "Ton", C_TON));
        BODEN.put(new BodenColorEntry(5000, "Mo", "Moor", C_MOOR));
        BODEN.put(new BodenColorEntry(1200, "Sl", "Anlehmiger Sand", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(2200, "SL", "Stark lehmiger Sand", C_SAND_LEHM_3));
        BODEN.put(new BodenColorEntry(3200, "sL", "Sandiger Lehm", C_LEHM_SAND));
        BODEN.put(new BodenColorEntry(4200, "LT", "Schwerer Lehm", C_LEHM_1));
        BODEN.put(new BodenColorEntry(6110, "SMo", "Sand, Moor", C_SAND));
        BODEN.put(new BodenColorEntry(6120, "lSMo", "Lehmiger Sand, Moor", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(6130, "LMo", "Lehm, Moor", C_LEHM));
        BODEN.put(new BodenColorEntry(6140, "TMo", "Ton, Moor", C_TON));
        BODEN.put(new BodenColorEntry(6210, "MoS", "Moor,Sand", C_MOOR));
        BODEN.put(new BodenColorEntry(6220, "MolS", "Moor, Lehmiger Sand", C_MOOR));
        BODEN.put(new BodenColorEntry(6230, "MoL", "Moor, Lehm", C_MOOR));
        BODEN.put(new BodenColorEntry(6240, "MoT", "Moor, Ton", C_MOOR));
        BODEN.put(new BodenColorEntry(7110, "S/sL", "Sand auf sandigem Lehm", C_SAND));
        BODEN.put(new BodenColorEntry(7130, "S/LT", "Sand auf schwerem Lehm", C_SAND));
        BODEN.put(new BodenColorEntry(7210, "Sl/L", "Anlehmiger Sand auf Lehm", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(7220, "Sl/LT", "Anlehmiger Sand auf schwerem Lehm", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(7230, "Sl/T", "Anlehmiger Sand auf Ton", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(7310, "lS/LT", "Lehmiger Sand auf schwerem Lehm", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(7320, "lS/S", "Lehmiger Sand auf Sand", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(7400, "SL/T", "Stark lehmiger Sand auf Ton", C_SAND_LEHM_3));
        BODEN.put(new BodenColorEntry(7510, "T/SL", "Ton auf stark lehmigen Sand", C_TON));
        BODEN.put(new BodenColorEntry(7530, "T/Sl", "Ton auf anlehmigen Sand", C_TON));
        BODEN.put(new BodenColorEntry(7610, "LT/lS", "Schwerer Lehm auf lehmigen Sand", C_LEHM_1));
        BODEN.put(new BodenColorEntry(7620, "LT/Sl", "Schwerer Lehm auf anlehmigen Sand", C_LEHM_1));
        BODEN.put(new BodenColorEntry(7630, "LT/S", "Schwerer Lehm auf Sand", C_LEHM_1));
        BODEN.put(new BodenColorEntry(7710, "L/Sl", "Lehm auf anlehmigen Sand", C_LEHM));
        BODEN.put(new BodenColorEntry(7800, "sL/S", "Sandiger Lehm auf Sand", C_LEHM_SAND));
        BODEN.put(new BodenColorEntry(7120, "S/L", "Sand auf Lehm", C_SAND));
        BODEN.put(new BodenColorEntry(7140, "S/T", "Sand auf Ton", C_SAND));
        BODEN.put(new BodenColorEntry(7330, "lS/T", "Lehmiger Sand auf Ton", C_LEHM_SAND));
        BODEN.put(new BodenColorEntry(7520, "T/lS", "Ton auf lehmigen Sand", C_TON));
        BODEN.put(new BodenColorEntry(7540, "T/S", "Ton auf Sand", C_TON));
        BODEN.put(new BodenColorEntry(7720, "L/S", "Lehm auf Sand", C_LEHM));
        BODEN.put(new BodenColorEntry(8110, "S/Mo", "Sand auf Moor", C_SAND));
        BODEN.put(new BodenColorEntry(8120, "lS/Mo", "Lehmiger Sand auf Moor", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(8130, "L/Mo", "Lehm auf Moor", C_LEHM));
        BODEN.put(new BodenColorEntry(8140, "T/Mo", "Ton auf Moor", C_TON));
        BODEN.put(new BodenColorEntry(8210, "Mo/S", "Moor auf Sand", C_MOOR));
        BODEN.put(new BodenColorEntry(8220, "Mo/lS", "Moor auf lehmigen Sand", C_MOOR));
        BODEN.put(new BodenColorEntry(8230, "Mo/L", "Moor auf Lehm", C_MOOR));
        BODEN.put(new BodenColorEntry(8240, "Mo/T", "Moor auf Ton", C_MOOR));
        BODEN.put(new BodenColorEntry(9120, "L+Mo", "Bodenwechsel vom Lehm zu Moor", C_LEHM));
        BODEN.put(new BodenColorEntry(9130, "lSg", "Lehmiger Sand mit starkem Steingehalt", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9140, "Lg", "Lehm mit starkem Steingehalt", C_LEHM));
        BODEN.put(new BodenColorEntry(9150, "lS+St", "lehmiger Sand mit Steinen und Bl\u00f6cken", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9160, "L+St", "Lehm mit Steinen und Bl\u00f6cken", C_LEHM));
        BODEN.put(new BodenColorEntry(9170, "St+lS", "Steine und Bl\u00f6cke mit lehmigem Sand", C_STEIN));
        BODEN.put(new BodenColorEntry(9180, "St+L", "Steine und Bl\u00f6cke mit Lehm", C_STEIN));
        BODEN.put(new BodenColorEntry(9190, "lS+Fe", "lehmiger Sand mit Felsen", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9200, "L+Fe", "Lehm mit Felsen", C_LEHM));
        BODEN.put(new BodenColorEntry(9210, "Fe+lS", "Felsen mit lehmigem Sand", C_FELS));
        BODEN.put(new BodenColorEntry(9220, "Fe+L", "Felsen mit Lehm", C_FELS));
        BODEN.put(new BodenColorEntry(9310, "S/lS", "Sand auf lehmigen Sand", C_SAND));
        BODEN.put(new BodenColorEntry(9320, "Sl/Me", "Anlehmiger Sand auf Mergel", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(9330, "Sl/sL", "Anlehmiger Sand auf sandigem Lehm", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(9340, "lS/L", "Lehmiger Sand auf Lehm", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9350, "lS/Me", "Lehmiger Sand auf Mergel", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9360, "lS/sL", "Lehmiger Sand auf sandigem Lehm", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9370, "lSMe", "Lehmiger Sand, Mergel", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9380, "lSMo/Me", "Lehmiger Sand, Moor auf Mergel", C_SAND_LEHM_2));
        BODEN.put(new BodenColorEntry(9390, "SlMo", "Anlehmiger Sand, Moor", C_SAND_LEHM_1));
        BODEN.put(new BodenColorEntry(9410, "L/Me", "Lehm auf Mergel", C_LEHM));
        BODEN.put(new BodenColorEntry(9420, "LMo/Me", "Lehm, Moor auf Mergel", C_LEHM));
        BODEN.put(new BodenColorEntry(9430, "LT/Mo", "Schwerer Lehm auf Moor", C_LEHM_1));
        BODEN.put(new BodenColorEntry(9440, "T/Me", "Ton auf Mergel", C_TON));
        BODEN.put(new BodenColorEntry(9450, "Mo/Me", "Moor auf Mergel", C_MOOR));
        BODEN.put(new BodenColorEntry(9460, "MoL/Me", "Moor, Lehm auf Mergel", C_MOOR));
        BODEN.put(new BodenColorEntry(9470, "MoMe", "Moor, Mergel", C_MOOR));
        BODEN.put(new BodenColorEntry(9480, "L\u00f6D", "L\u00f6\u00dfDiluvium", C_LOESS));
        BODEN.put(new BodenColorEntry(9490, "AlD", "AlluviumDiluvium", C_LOESS));
        STUFE.put(new BodenEntry(1100, "1", "Zustandsstufe 1"));
        STUFE.put(new BodenEntry(1200, "2", "Zustandsstufe 2"));
        STUFE.put(new BodenEntry(1300, "3", "Zustandsstufe 3"));
        STUFE.put(new BodenEntry(1400, "4", "Zustandsstufe 4"));
        STUFE.put(new BodenEntry(1500, "5", "Zustandsstufe 5"));
        STUFE.put(new BodenEntry(1600, "6", "Zustandsstufe 6"));
        STUFE.put(new BodenEntry(1700, "7", "Zustandsstufe 7"));
        STUFE.put(new BodenEntry(1800, "-", "Zustandsstufe Misch- und Schichtb\u00f6den sowie k\u00fcnstlichver\u00e4nderte B\u00f6den"));
        STUFE.put(new BodenEntry(2100, "I", "Bodenstufe I"));
        STUFE.put(new BodenEntry(2200, "II", "Bodenstufe II"));
        STUFE.put(new BodenEntry(2300, "III", "Bodenstufe III"));
        STUFE.put(new BodenEntry(2400, "-", "Bodenstufe Misch- und Schichtb\u00f6den sowie k\u00fcnstlich ver\u00e4nderte B\u00f6den"));
        STUFE.put(new BodenEntry(3100, "II+III", "Bodenstufe II+III"));
        STUFE.put(new BodenEntry(3200, "(III)", "Bodenstufe III"));
        STUFE.put(new BodenEntry(3300, "IV", "Bodenstufe IV"));
        ENTST.put(new BodenEntry(1000, "D", "Diluvium"));
        ENTST.put(new BodenEntry(1100, "DAl", "Diluvium \u00fcber Alluvium"));
        ENTST.put(new BodenEntry(1200, "DL\u00f6", "Diluvium \u00fcber L\u00f6\u00df"));
        ENTST.put(new BodenEntry(1300, "DV", "Diluvium \u00fcber Verwitterung"));
        ENTST.put(new BodenEntry(1400, "Dg", "Diluvium, gesteinig"));
        ENTST.put(new BodenEntry(1410, "DgAl", "Diluvium, gesteinig \u00fcber Alluvium"));
        ENTST.put(new BodenEntry(1420, "DgL\u00f6", "Diluvium, gesteinig \u00fcber L\u00f6\u00df"));
        ENTST.put(new BodenEntry(1430, "DgV", "Diluvium, gesteinig \u00fcber Verwitterung"));
        ENTST.put(new BodenEntry(2000, "L\u00f6", "L\u00f6\u00df"));
        ENTST.put(new BodenEntry(2100, "L\u00f6D", "L\u00f6\u00df \u00fcber Diluvium"));
        ENTST.put(new BodenEntry(2110, "L\u00f6Dg", "L\u00f6\u00df, Diluvium, Gesteinsb\u00f6den"));
        ENTST.put(new BodenEntry(2120, "L\u00f6DV", "L\u00f6\u00df, Diluvium, Verwitterung"));
        ENTST.put(new BodenEntry(2200, "L\u00f6Al", "L\u00f6\u00df \u00fcber Alluvium"));
        ENTST.put(new BodenEntry(2300, "L\u00f6V", "L\u00f6\u00df \u00fcber Verwitterung"));
        ENTST.put(new BodenEntry(2310, "L\u00f6Vg", "L\u00f6\u00df, Verwitterung, Gesteinsb\u00f6den"));
        ENTST.put(new BodenEntry(2400, "L\u00f6Vg", "L\u00f6\u00df \u00fcber Verwitterung, gesteinig"));
        ENTST.put(new BodenEntry(3000, "Al", "Alluvium"));
        ENTST.put(new BodenEntry(3100, "AlD", "Alluvium \u00fcber Diluvium"));
        ENTST.put(new BodenEntry(3200, "AlL\u00f6", "Alluvium \u00fcber L\u00f6\u00df"));
        ENTST.put(new BodenEntry(3300, "AlV", "Alluvium \u00fcber Verwitterung"));
        ENTST.put(new BodenEntry(3400, "Alg", "Alluvium, gesteinig"));
        ENTST.put(new BodenEntry(3410, "AlgD", "Alluvium, gesteinig \u00fcber Diluvium"));
        ENTST.put(new BodenEntry(3420, "AlgL\u00f6", "Alluvium, gesteinig \u00fcber L\u00f6\u00df"));
        ENTST.put(new BodenEntry(3430, "AlgV", "Alluvium, gesteinig \u00fcber Verwitterung"));
        ENTST.put(new BodenEntry(3500, "AlMa", "Alluvium, Marsch"));
        ENTST.put(new BodenEntry(3610, "AlMo", "Alluvium, Moor"));
        ENTST.put(new BodenEntry(3620, "MoAI", "Moor, Alluvium"));
        ENTST.put(new BodenEntry(3700, "Me", "Mergel"));
        ENTST.put(new BodenEntry(4000, "V", "Verwitterung"));
        ENTST.put(new BodenEntry(4100, "VD", "Verwitterung \u00fcber Diluvium"));
        ENTST.put(new BodenEntry(4200, "VAl", "Verwitterung \u00fcber Alluvium"));
        ENTST.put(new BodenEntry(4300, "VL\u00f6", "Verwitterung \u00fcber L\u00f6\u00df"));
        ENTST.put(new BodenEntry(4400, "Vg", "Verwitterung, Gesteinsb\u00f6den"));
        ENTST.put(new BodenEntry(4410, "VgD", "Verwitterung, Gesteinsb\u00f6den \u00fcber Diluvium"));
        ENTST.put(new BodenEntry(5000, "-", "Entstehungsart nicht erkennbar"));
        KLIMA.put(new BodenEntry(6100, "a", "Klimastufe 8\u00b0 C und dar\u00fcber"));
        KLIMA.put(new BodenEntry(6200, "b", "Klimastufe 7,9\u00b0 - 7,0\u00b0 C"));
        KLIMA.put(new BodenEntry(6300, "c", "Klimastufe 6,9\u00b0 - 5,7\u00b0 C"));
        KLIMA.put(new BodenEntry(6400, "d", "Klimastufe 5,6\u00b0 C und darunter"));
        WASSER.put(new BodenEntry(7100, "1", "Wasserstufe"));
        WASSER.put(new BodenEntry(7200, "2", "Wasserstufe"));
        WASSER.put(new BodenEntry(7300, "3", "Wasserstufe"));
        WASSER.put(new BodenEntry(7400, "4", "Wasserstufe"));
        WASSER.put(new BodenEntry(7410, "4-", "Wasserstufe"));
        WASSER.put(new BodenEntry(7500, "5", "Wasserstufe"));
        WASSER.put(new BodenEntry(7510, "5-", "Wasserstufe"));
        WASSER.put(new BodenEntry(7520, "3-", "Wasserstufe"));
        WASSER.put(new BodenEntry(7530, "3+4", "Wasserstufe"));
        SON.put(new BodenEntry(1100, "Wa+", "Nass, zu viel Wasser"));
        SON.put(new BodenEntry(1200, "Wa-", "Trocken, zu wenig Wasser"));
        SON.put(new BodenEntry(1300, "Wa gt", "Besonders g\u00fcnstige Wasserverh\u00e4ltnisse"));
        SON.put(new BodenEntry(1400, "RiWa", "Rieselwasser, k\u00fcnstliche Bew\u00e4sserung"));
        SON.put(new BodenEntry(2100, "W", "Unbedingtes Wiesenland"));
        SON.put(new BodenEntry(2200, "Str", "Streuwiese"));
        SON.put(new BodenEntry(2300, "Hu", "Hutung"));
        SON.put(new BodenEntry(2400, "A-Hack", "Acker-Hackrain"));
        SON.put(new BodenEntry(2500, "Gr-Hack", "Gr\u00fcnland-Hackrain"));
        SON.put(new BodenEntry(2600, "G", "Garten"));
        SON.put(new BodenEntry(3000, "N", "Neukultur"));
        SON.put(new BodenEntry(4000, "T", "Tiefkultur"));
        SON.put(new BodenEntry(5000, "Ger", "Geringstland"));
        SON.put(new BodenEntry(9000, "", "Nachsch\u00e4tzung erforderlich"));
    }

    public static class BodenEntry
    implements IntegerHashObject,
    Sortable {
        private int key;
        private String acronym;
        private String description;

        public BodenEntry(int n, String string, String string2) {
            this.key = n;
            this.acronym = string;
            this.description = string2;
        }

        @Override
        public int intHashKey() {
            return this.key;
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public boolean isLt(Sortable sortable) {
            return this.key < ((IntegerHashObject)((Object)sortable)).intHashKey();
        }

        public String getAcronym() {
            return this.acronym;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class BodenColorEntry
    extends BodenEntry {
        private Color color;

        public BodenColorEntry(int n, String string, String string2, Color color) {
            super(n, string, string2);
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

