/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geodata.Feature;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.DataContainerTable;

public class BodenSchaetzungTable
extends DataContainerTable {
    private int countVoid = 0;

    public BodenSchaetzungTable() {
        this.reset();
    }

    public void reset() {
        this.countVoid = 0;
    }

    @Override
    public void put(Feature feature) throws GeomException {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)feature;
        if (bodenSchaetzung.isVoid()) {
            bodenSchaetzung.setCount(++this.countVoid);
        }
        for (int i = 0; i < this.size(); ++i) {
            BodenSchaetzung bodenSchaetzung2 = (BodenSchaetzung)this.elementAt(i);
            int n = bodenSchaetzung2.compareTo(bodenSchaetzung);
            if (n > 0) {
                super.insertElementAt(bodenSchaetzung, i);
                return;
            }
            if (n != 0) continue;
            throw new GeomException(bodenSchaetzung.getHashPoint(), bodenSchaetzung.getPolygon(), bodenSchaetzung.getClassName() + ": " + bodenSchaetzung.getObjectName() + " ist doppelt vergeben");
        }
        super.addElement(bodenSchaetzung);
    }

    public void addElement(Feature feature) {
        BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)feature;
        if (bodenSchaetzung.isVoid()) {
            bodenSchaetzung.setCount(++this.countVoid);
        }
        super.addElement(bodenSchaetzung);
    }

    @Override
    public Feature get(Feature feature) {
        return null;
    }
}

