/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class Bogen
extends Linie
implements Drawable,
Messager,
Exceptionable {
    public Punkt pm;
    private Punkt pt;
    private boolean isTangentenBogen = false;

    public void setBogenMitte(Punkt punkt) {
        if (this.pa == null || this.pe == null || punkt == null) {
            return;
        }
        if (punkt == this.pa || punkt == this.pe) {
            this.l2 = 0.0;
            return;
        }
        double d = (this.pa.y + punkt.y) / 2.0;
        double d2 = (this.pa.x + punkt.x) / 2.0;
        double d3 = (punkt.y + this.pe.y) / 2.0;
        double d4 = (punkt.x + this.pe.x) / 2.0;
        double d5 = 0.0;
        double d6 = this.getS();
        OrthoLinie orthoLinie = new OrthoLinie();
        orthoLinie.setAnfangsPunkt(this.pa);
        orthoLinie.setEndPunkt(this.pe);
        Messung messung = orthoLinie.getMessungOf(punkt);
        if (messung.l1 < 0.0) {
            double d7 = Math.atan2(this.pa.y - punkt.y, this.pa.x - punkt.x);
            double d8 = Math.atan2(this.pe.y - this.pa.y, this.pe.x - this.pa.x);
            d5 = d6 / (2.0 * Math.sin(d8 - d7));
            this.isTangentenBogen = true;
            this.pt = this.pa;
        } else if (messung.l1 > d6) {
            double d9 = Math.atan2(punkt.y - this.pe.y, punkt.x - this.pe.x);
            double d10 = Math.atan2(this.pa.y - this.pe.y, this.pa.x - this.pe.x);
            d5 = d6 / (2.0 * Math.sin(d10 - d9));
            this.isTangentenBogen = true;
            this.pt = this.pe;
        } else {
            double d11;
            double d12;
            double d13 = punkt.x - this.pa.x;
            double d14 = this.pe.x - punkt.x;
            if (d13 == 0.0) {
                double d15 = (punkt.y - this.pa.y) / d13;
                d12 = d;
                d11 = d4 - d15 * (d - d3);
            } else if (d14 == 0.0) {
                double d16 = (punkt.y - this.pa.y) / d13;
                d12 = d3;
                d11 = d2 - d16 * (d3 - d);
            } else {
                double d17 = (punkt.y - this.pa.y) / d13;
                double d18 = (this.pe.y - punkt.y) / d14;
                d11 = (d17 * d18 * (d - d3) + d18 * (d2 - d4)) / (d18 - d17) + d4;
                d12 = -1.0 / d18 * (d11 - d4) + d3;
            }
            d5 = Math.sqrt((d11 - this.pa.x) * (d11 - this.pa.x) + (d12 - this.pa.y) * (d12 - this.pa.y));
            Messung messung2 = orthoLinie.getMessungOf(new Punkt(d12, d11));
            if (messung.l2 < 0.0 && messung2.l2 < -0.001 || messung.l2 > 0.0 && messung2.l2 > 0.001) {
                return;
            }
            if (messung.l2 > 0.0) {
                d5 = -d5;
            }
            this.isTangentenBogen = false;
        }
        this.pm = punkt;
        this.l2 = d5;
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pm == null) {
            stringBuffer.append("Gerade  s= " + IFormat.f_3.format(this.getLaenge()));
        } else {
            if (this.isTangentenBogen) {
                stringBuffer.append("Tangente ");
            } else {
                stringBuffer.append("Bogen ");
            }
            if (this.pm.nr > 0L) {
                stringBuffer.append("\u00fcber Punkt  ");
                stringBuffer.append(this.pm.nr);
            }
            stringBuffer.append("  r= ");
            if (Double.isNaN(this.l2)) {
                stringBuffer.append("unendl.");
            } else {
                stringBuffer.append(IFormat.f_3.format(this.l2 * DataBase.getStreckeMasstab((this.pa.y + this.pe.y) / 2.0)));
            }
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public final String getClassName() {
        return "Bogen";
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
        if (bl2) {
            if (this.pa != null) {
                this.pa.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.pe != null && this.pe != this.pa) {
                this.pe.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.pm != null && this.pm != this.pa && this.pm != this.pe) {
                this.pm.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        Point point2 = new Point();
        if (this.pa == null || this.pe == null) {
            return;
        }
        iGraphics.setXORMode();
        if (this.isBogen()) {
            Polygon polygon = iGraphics.getGraphicBogenPolygon(this.pa, this.pe, this.l2);
            graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            if (this.isTangentenBogen) {
                point = iGraphics.getGraphicPoint(this.pt, point);
                point2 = iGraphics.getGraphicPoint(this.pm, point2);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        } else {
            point = iGraphics.getGraphicPoint(this.pa, point);
            point2 = iGraphics.getGraphicPoint(this.pe, point2);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    @Override
    public String toString() {
        return this.pa.nr + " - " + (this.pe != null ? this.pe.nr : 0L);
    }
}

