/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Message;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashObject;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Buchungsstelle
implements Comparable,
Exceptionable,
IntegerHashObject {
    private static final String DELIM = ".";
    private String blatt;
    private String laufendeNummer;
    private int buchungsart;
    private Buchungsstelle next = null;

    public Buchungsstelle() {
    }

    public Buchungsstelle(String string, String string2, int n) {
        this.blatt = string;
        this.setLaufendeNummer(string2);
        this.setBuchungssArt(n);
    }

    public String getGrundbuchblattName() {
        return this.blatt;
    }

    public boolean hasLaufendeNummer() {
        return this.laufendeNummer != null;
    }

    public void setLaufendeNummer(String string) {
        this.laufendeNummer = string != null ? IFormat.trimLeft(string, '0') : null;
    }

    public String getLaufendeNummer() {
        return this.laufendeNummer;
    }

    public boolean hasBuchungssArt() {
        return this.buchungsart != 0;
    }

    public void setBuchungssArt(int n) {
        this.buchungsart = n;
    }

    public int getBuchungsArt() {
        return this.buchungsart;
    }

    public String getBuchungsArtAsString() {
        return Integer.toString(this.buchungsart);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Buchungsstelle getNext() {
        return this.next;
    }

    public void setNext(Buchungsstelle buchungsstelle) {
        this.next = buchungsstelle;
    }

    public Enumeration getSequenze() {
        return new BuchungsEnumerator(this, this);
    }

    public String getKennzeichen() {
        if (this.hasLaufendeNummer()) {
            StringBuffer stringBuffer = new StringBuffer(this.blatt);
            stringBuffer.append(DELIM);
            stringBuffer.append(this.laufendeNummer);
            return stringBuffer.toString();
        }
        return this.blatt;
    }

    public String getName() {
        return this.getKennzeichen();
    }

    @Override
    public String getExceptionableName() {
        return this.getKennzeichen();
    }

    public String createDatLineKennzeichen() {
        StringBuffer stringBuffer = new StringBuffer(Grundbuchblatt.createDatLineKennzeichen(this.blatt));
        stringBuffer.append(DELIM);
        stringBuffer.append(this.getLaufendeNummer());
        stringBuffer.append(DELIM);
        stringBuffer.append(Integer.toString(this.getBuchungsArt()));
        return stringBuffer.toString();
    }

    public static Buchungsstelle parseDatLineKennzeichen(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        return new Buchungsstelle(Grundbuchblatt.createKennzeichen(stringTokenizer.nextToken()), stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null, stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof Buchungsstelle) {
            Buchungsstelle buchungsstelle = (Buchungsstelle)object;
            return this.getKennzeichen().equals(buchungsstelle.getKennzeichen());
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        Buchungsstelle buchungsstelle = (Buchungsstelle)object;
        return this.getKennzeichen().compareTo(buchungsstelle.getKennzeichen());
    }

    public int hashCode() {
        return this.getKennzeichen().hashCode();
    }

    @Override
    public int intHashKey() {
        return this.getKennzeichen().hashCode();
    }

    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getKennzeichen());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Buchung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    public final String toHumanString() {
        return this.toHumanString("\n");
    }

    public final String toHumanString(String string) {
        return this.toString();
    }

    public String toString() {
        return this.createDatLineKennzeichen();
    }

    private class BuchungsEnumerator
    implements Enumeration {
        private Buchungsstelle bst;

        BuchungsEnumerator(Buchungsstelle buchungsstelle, Buchungsstelle buchungsstelle2) {
            this.bst = buchungsstelle2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.bst != null;
        }

        public Object nextElement() {
            Buchungsstelle buchungsstelle = this.bst;
            this.bst = this.bst.getNext();
            return buchungsstelle;
        }
    }
}

