/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.BedingungCreator;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class CreateBedingungenDialog
extends IDialog
implements ActionListener,
ItemListener {
    private Riss riss = new Riss(6, 601);
    private int liste = 601;
    private DataBase db;
    protected ExceptionList exceptions;
    private static final String OK_COMMAND = "OK";
    private static final String DO_COMMAND = "Erzeugen";
    private static final String SAVE_COMMAND = "\u00dcbernehmen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String M_STRING = "[m]";
    private static final String GON_STRING = "[gon]";
    private static final String RUTE_STRING = "[\u00b0]";
    private static final String SPACER_STRING = "    ";
    private Button okButton;
    private Button doButton;
    private Button saveButton;
    private Button abortButton;
    private ILabel rundungLabel;
    private ILabel rundungMassLabel;
    private ILabel maximumLabel;
    private ILabel maximumMassLabel;
    private ILabel rutenHelpLabel;
    private ITextField nameTextField;
    private ITextField lageTextField;
    private ITextField winkelTextField;
    private ITextField rundungTextField;
    private ITextField maximumTextField;
    private CheckboxGroup pGroup;
    private CheckboxGroup cbGroup;
    private Checkbox visibleElementsCheckbox;
    private Checkbox visitOldBedingungenCheckbox;
    private Checkbox geradenCheckbox;
    private Checkbox newGeneralCheckbox;
    private Checkbox oldGeneralCheckbox;
    private Checkbox allesCheckbox;
    private Checkbox mengeCheckbox;
    private Checkbox trafoCheckbox;
    private Checkbox ohneCheckbox;
    private Checkbox freiCheckbox;
    private Checkbox meterCheckbox;
    private Checkbox rutenCheckbox;
    private Choice trafoChoice;
    private Label progressLabel;
    private IProgressBar progressBar;

    public CreateBedingungenDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout2);
        iPanel.setBorder(new IBorder(1));
        ILabel iLabel = new ILabel("Name:");
        iPanel.add(iLabel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        this.nameTextField = new ITextField("erschn\u00fcffelte Bedingungen", 20);
        iPanel.add(this.nameTextField);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.nameTextField, gridBagConstraints2);
        this.visibleElementsCheckbox = new Checkbox("nur f\u00fcr sichtbare Linien", BedingungCreator.isOnlyVisibleElements());
        iPanel.add(this.visibleElementsCheckbox);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.visibleElementsCheckbox, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel, gridBagConstraints);
        panel.add(iPanel);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        IPanel iPanel2 = new IPanel(gridBagLayout3);
        iPanel2.setBorder(new IBorder(1, "Punktauswahl"));
        this.pGroup = new CheckboxGroup();
        this.allesCheckbox = new Checkbox("Alles", !dataBase.hasMenge(), this.pGroup);
        iPanel2.add(this.allesCheckbox);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout3.setConstraints(this.allesCheckbox, gridBagConstraints3);
        this.mengeCheckbox = new Checkbox("Menge", dataBase.hasMenge(), this.pGroup);
        iPanel2.add(this.mengeCheckbox);
        this.mengeCheckbox.setEnabled(dataBase.hasMenge());
        gridBagConstraints3.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagLayout3.setConstraints(this.mengeCheckbox, gridBagConstraints3);
        this.trafoCheckbox = new Checkbox("Transformation", false, this.pGroup);
        iPanel2.add(this.trafoCheckbox);
        this.trafoCheckbox.setEnabled(DataBase.T.size() > 0);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagLayout3.setConstraints(this.trafoCheckbox, gridBagConstraints3);
        this.trafoChoice = new Choice();
        iPanel2.add(this.trafoChoice);
        Object object = DataBase.T.elements();
        while (object.hasMoreElements()) {
            this.trafoChoice.addItem(((TrafoSystem)object.nextElement()).getName());
        }
        this.trafoChoice.addItemListener(this);
        this.trafoChoice.setEnabled(DataBase.T.size() > 0);
        gridBagConstraints3.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints(this.trafoChoice, gridBagConstraints3);
        iLabel = new ILabel("homogenisierte Punkte ausschlie\u00dfen:");
        iPanel2.add(iLabel);
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints(iLabel, gridBagConstraints3);
        this.visitOldBedingungenCheckbox = new Checkbox(null, true);
        iPanel2.add(this.visitOldBedingungenCheckbox);
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints(this.visitOldBedingungenCheckbox, gridBagConstraints3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        panel.add(iPanel2);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = 17;
        IPanel iPanel3 = new IPanel((LayoutManager)object);
        iPanel3.setBorder(new IBorder(1, "Parameter"));
        iLabel = new ILabel("Punktlagefehler:");
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        this.lageTextField = new ITextField(IFormat.f_2.format(BedingungCreator.getLageDistance()).toString(), 5);
        iPanel3.add(this.lageTextField);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(this.lageTextField, gridBagConstraints4);
        iLabel = new ILabel(M_STRING);
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        iLabel = new ILabel("Winkelabweichung:");
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        this.winkelTextField = new ITextField(IFormat.f_2.format(BedingungCreator.getAngleDistance() * 200.0 / Math.PI).toString(), 5);
        iPanel3.add(this.winkelTextField);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(this.winkelTextField, gridBagConstraints4);
        iLabel = new ILabel(GON_STRING);
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 5;
        gridBagConstraints4.gridy = 0;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        iLabel = new ILabel("Geradenbedingungen:");
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        this.geradenCheckbox = new Checkbox(null, true);
        iPanel3.add(this.geradenCheckbox);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.geradenCheckbox, gridBagConstraints4);
        this.cbGroup = new CheckboxGroup();
        iLabel = new ILabel("Abstandsbedingungen:");
        iPanel3.add(iLabel);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        ((GridBagLayout)object).setConstraints(iLabel, gridBagConstraints4);
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridheight = 1;
        this.ohneCheckbox = new Checkbox("keine", true, this.cbGroup);
        iPanel3.add(this.ohneCheckbox);
        this.ohneCheckbox.addItemListener(this);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.ohneCheckbox, gridBagConstraints4);
        this.freiCheckbox = new Checkbox("frei", false, this.cbGroup);
        iPanel3.add(this.freiCheckbox);
        this.freiCheckbox.addItemListener(this);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.freiCheckbox, gridBagConstraints4);
        this.meterCheckbox = new Checkbox("Meter", false, this.cbGroup);
        iPanel3.add(this.meterCheckbox);
        this.meterCheckbox.addItemListener(this);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.meterCheckbox, gridBagConstraints4);
        this.rutenCheckbox = new Checkbox("Ruten", false, this.cbGroup);
        iPanel3.add(this.rutenCheckbox);
        this.rutenCheckbox.addItemListener(this);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 5;
        ((GridBagLayout)object).setConstraints(this.rutenCheckbox, gridBagConstraints4);
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        this.maximumLabel = new ILabel("max. Abstand:");
        iPanel3.add(this.maximumLabel);
        this.maximumLabel.setEnabled(!this.ohneCheckbox.getState());
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.maximumLabel, gridBagConstraints4);
        this.maximumTextField = new ITextField(IFormat.f_2.format(BedingungCreator.getMaxAbstand()).toString(), 5);
        iPanel3.add(this.maximumTextField);
        this.maximumTextField.setEnabled(!this.ohneCheckbox.getState());
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.maximumTextField, gridBagConstraints4);
        this.maximumMassLabel = new ILabel(SPACER_STRING);
        iPanel3.add(this.maximumMassLabel);
        this.maximumMassLabel.setEnabled(!this.ohneCheckbox.getState());
        gridBagConstraints4.gridx = 5;
        gridBagConstraints4.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.maximumMassLabel, gridBagConstraints4);
        this.rundungLabel = new ILabel("Rundung:");
        iPanel3.add(this.rundungLabel);
        this.rundungLabel.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.rundungLabel, gridBagConstraints4);
        this.rundungTextField = new ITextField(IFormat.f_2.format(BedingungCreator.getRundung()).toString(), 5);
        iPanel3.add(this.rundungTextField);
        this.rundungTextField.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.rundungTextField, gridBagConstraints4);
        this.rundungMassLabel = new ILabel(SPACER_STRING);
        iPanel3.add(this.rundungMassLabel);
        this.rundungMassLabel.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
        gridBagConstraints4.gridx = 5;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.rundungMassLabel, gridBagConstraints4);
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridheight = 1;
        this.rutenHelpLabel = new ILabel("1\u00b0 = 3,7662 m");
        iPanel3.add(this.rutenHelpLabel);
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 4;
        ((GridBagLayout)object).setConstraints(this.rutenHelpLabel, gridBagConstraints4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iPanel3, gridBagConstraints);
        panel.add(iPanel3);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints5.anchor = 17;
        IPanel iPanel4 = new IPanel(gridBagLayout4);
        iPanel4.setBorder(new IBorder(1, "Generalisierung"));
        iLabel = new ILabel("erzeugte Bedingungen:");
        iPanel4.add(iLabel);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagLayout4.setConstraints(iLabel, gridBagConstraints5);
        this.newGeneralCheckbox = new Checkbox(null, true);
        iPanel4.add(this.newGeneralCheckbox);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        gridBagLayout4.setConstraints(this.newGeneralCheckbox, gridBagConstraints5);
        iLabel = new ILabel("vorhandene Bedingungen:");
        iPanel4.add(iLabel);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagLayout4.setConstraints(iLabel, gridBagConstraints5);
        this.oldGeneralCheckbox = new Checkbox(null, false);
        iPanel4.add(this.oldGeneralCheckbox);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        gridBagLayout4.setConstraints(this.oldGeneralCheckbox, gridBagConstraints5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(iPanel4, gridBagConstraints);
        panel.add(iPanel4);
        IPanel iPanel5 = new IPanel(new BorderLayout());
        iPanel5.setBorder(new IBorder(1));
        this.progressBar = new IProgressBar();
        iPanel5.add("North", this.progressBar);
        this.progressLabel = new Label("Bedingungen: ");
        iPanel5.add("South", this.progressLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(iPanel5, gridBagConstraints);
        panel.add(iPanel5);
        this.add("North", panel);
        Panel panel2 = new Panel(new FlowLayout(2));
        this.doButton = new Button(DO_COMMAND);
        this.doButton.addActionListener(this);
        panel2.add(this.doButton);
        this.saveButton = new Button(SAVE_COMMAND);
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        panel2.add(this.saveButton);
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        panel2.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel2.add(this.abortButton);
        this.add("South", panel2);
        this.pack();
        this.setLocationOfParent(iFrame);
        this.rutenHelpLabel.setVisible(this.rutenCheckbox.getState());
    }

    public void create() {
        Object object;
        PunktTable punktTable;
        this.riss = new Riss(this.nameTextField.getText(), 6, this.liste);
        try {
            double d;
            BedingungCreator.setOnlyVisibleElements(this.visibleElementsCheckbox.getState());
            BedingungCreator.setVisitOldBedingungen(this.visitOldBedingungenCheckbox.getState());
            try {
                BedingungCreator.setLageDistance(Double.valueOf(this.lageTextField.getText().trim().replace(',', '.')));
            }
            catch (Exception exception) {
                throw new NumberFormatException("Ung\u00fcltiger Punktlagefehler");
            }
            try {
                BedingungCreator.setAngleDistance(Double.valueOf(this.winkelTextField.getText().trim().replace(',', '.')) * Math.PI / 200.0);
            }
            catch (Exception exception) {
                throw new NumberFormatException("Ung\u00fcltige Winkelabweichung");
            }
            BedingungCreator.setCreateGeraden(this.geradenCheckbox.getState());
            int n = 0;
            n = this.meterCheckbox.getState() ? 2 : (this.rutenCheckbox.getState() ? 3 : (this.freiCheckbox.getState() ? 1 : 0));
            BedingungCreator.setAbstandBedingung(n);
            if (n != 0) {
                try {
                    d = Double.valueOf(IFormat.getFloats(this.maximumTextField.getText()));
                    if (n == 3) {
                        d *= 3.7662;
                    }
                    BedingungCreator.setMaxAbstand(d);
                }
                catch (Exception exception) {
                    throw new NumberFormatException("Ung\u00fcltiger max. Abstand");
                }
            }
            if (n == 2 || n == 3) {
                try {
                    d = Double.valueOf(IFormat.getFloats(this.rundungTextField.getText()));
                    if (n == 3) {
                        d *= 3.7662;
                    }
                    BedingungCreator.setRundung(d);
                }
                catch (Exception exception) {
                    throw new NumberFormatException("Ung\u00fcltige Rundung");
                }
            }
            BedingungCreator.setNewGeneralize(this.newGeneralCheckbox.getState());
            BedingungCreator.setOldGeneralize(this.oldGeneralCheckbox.getState());
        }
        catch (Exception exception) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, exception);
            errorDialog.setVisible(true);
            return;
        }
        Checkbox checkbox = this.pGroup.getSelectedCheckbox();
        if (checkbox == this.allesCheckbox) {
            punktTable = DataBase.P;
        } else if (checkbox == this.mengeCheckbox) {
            punktTable = new PunktTable();
            CreateBedingungenDialog createBedingungenDialog = this;
            if (createBedingungenDialog.db.hasMenge()) {
                object = DataBase.MENGE.elements();
                while (object.hasMoreElements()) {
                    punktTable.put((Punkt)object.nextElement());
                }
            }
        } else if (checkbox == this.trafoCheckbox) {
            punktTable = new PunktTable();
            object = (TrafoSystem)DataBase.T.elementAt(this.trafoChoice.getSelectedIndex());
            Enumeration enumeration = ((DataContainer)object).elements();
            while (enumeration.hasMoreElements()) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                Punkt punkt = (Punkt)trafoPunkt.getPunkt().clone();
                punkt.y = trafoPunkt.y;
                punkt.x = trafoPunkt.x;
                punktTable.put(punkt);
            }
        } else {
            punktTable = new PunktTable();
        }
        object = new BedingungCreator(this.db, punktTable, this.riss);
        ((BedingungCreator)object).setExceptionList(this.exceptions);
        ((IProgressElement)object).setProgressBar(this.progressBar);
        this.progressLabel.setText("Bedingungen: ");
        ((IProgressElement)object).setProgressLabel(this.progressLabel);
        ((BedingungCreator)object).create();
        this.saveButton.setEnabled(this.riss.size() > 0);
        this.okButton.setEnabled(true);
    }

    public void write() {
        if (this.liste == 601) {
            DataBase.BH.addElement(this.riss);
        } else {
            DataBase.BB.addElement(this.riss);
        }
        this.saveButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.progressLabel.setText("Bedingungen: ");
        this.progressBar.setValue(0);
        this.riss = new Riss(6, this.liste);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DO_COMMAND)) {
            this.create();
        } else if (string.equals(OK_COMMAND)) {
            this.write();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
            this.endDialog();
        } else if (string.equals(SAVE_COMMAND)) {
            this.write();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.trafoChoice) {
            this.trafoCheckbox.setState(true);
        } else {
            this.maximumTextField.setEnabled(!this.ohneCheckbox.getState());
            this.maximumLabel.setEnabled(!this.ohneCheckbox.getState());
            this.maximumMassLabel.setEnabled(!this.ohneCheckbox.getState());
            this.rundungTextField.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
            this.rundungLabel.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
            this.rundungMassLabel.setEnabled(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
            this.maximumMassLabel.setVisible(!this.ohneCheckbox.getState());
            if (this.rutenCheckbox.getState()) {
                this.maximumMassLabel.setText(RUTE_STRING);
            } else if (this.meterCheckbox.getState()) {
                this.maximumMassLabel.setText(M_STRING);
            } else if (this.freiCheckbox.getState()) {
                this.maximumMassLabel.setText(M_STRING);
            } else {
                this.maximumMassLabel.setText(SPACER_STRING);
            }
            if (this.rundungMassLabel.getText().equals(RUTE_STRING)) {
                try {
                    double d = Double.valueOf(IFormat.getFloats(this.maximumTextField.getText()));
                    double d2 = Double.valueOf(IFormat.getFloats(this.rundungTextField.getText()));
                    double d3 = Math.rint(d2 * Math.rint(3.7662));
                    this.rundungTextField.setText(IFormat.f_2.format(d3));
                    this.maximumTextField.setText(IFormat.f_2.format(Math.rint(d * 3.7662 / d3) * d3));
                }
                catch (Exception exception) {}
            } else if (this.rutenCheckbox.getState()) {
                try {
                    double d = Double.valueOf(IFormat.getFloats(this.maximumTextField.getText()));
                    double d4 = Double.valueOf(IFormat.getFloats(this.rundungTextField.getText()));
                    double d5 = 1.0 / Math.rint(3.7662 / d4);
                    this.rundungTextField.setText(IFormat.f_2.format(d5));
                    this.maximumTextField.setText(IFormat.f_2.format(Math.rint(d / 3.7662 / d5) * d5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.rundungMassLabel.setVisible(this.meterCheckbox.getState() || this.rutenCheckbox.getState());
            if (this.rutenCheckbox.getState()) {
                this.rundungMassLabel.setText(RUTE_STRING);
            } else if (this.meterCheckbox.getState()) {
                this.rundungMassLabel.setText(M_STRING);
            } else if (this.freiCheckbox.getState()) {
                this.rundungMassLabel.setText(M_STRING);
            } else {
                this.rundungMassLabel.setText(SPACER_STRING);
            }
            this.rutenHelpLabel.setVisible(this.rutenCheckbox.getState());
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

