/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.ITextField;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.io.ErrorWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;

public class CreateLgaDialog
extends IDialog
implements ActionListener {
    private DataBase db;
    protected ExceptionList exceptions;
    private static final String OK_COMMAND = "Ausf\u00fchren";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String HELP_TEXT = "Es wird die Lagegenauigkeitsstufe LGA aller Katasterpunkte anhand der erreichten Standardabweichung neu berechnet. Wenn die untere Schranke gesetzt ist, wird keine genauere LGA vergeben.";
    private Button okButton;
    private Button abortButton;
    private Checkbox aendCheckbox;
    private Choice minChoice;
    private Label minLabel;
    private Label faktorLabel;
    private ITextField faktorTextField;
    private Label progressLabel;
    private IProgressBar progressBar;
    private int errors = 0;
    private int newLgaPoints = 0;
    private int oldLgaPoints = 0;
    private double faktor = 1.0;
    private char minLga = (char)32;

    public CreateLgaDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 17;
        iPanel.setBorder(new IBorder(1));
        FlowText flowText = new FlowText(HELP_TEXT, false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        this.aendCheckbox = new Checkbox("Vorhandene LGA verbessern", true);
        iPanel.add(this.aendCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.aendCheckbox, gridBagConstraints);
        this.minLabel = new Label("untere Schranke:");
        iPanel.add(this.minLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.minLabel, gridBagConstraints);
        this.minChoice = new Choice();
        iPanel.add(this.minChoice);
        this.minChoice.add("   ");
        this.minChoice.add("1  ");
        this.minChoice.add("2  ");
        this.minChoice.add("3  ");
        this.minChoice.add("7  ");
        this.minChoice.add("8  ");
        this.minChoice.add("9  ");
        this.minChoice.add("A  ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.minChoice, gridBagConstraints);
        this.faktorLabel = new Label("Faktor:");
        iPanel.add(this.faktorLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.faktorLabel, gridBagConstraints);
        this.faktorTextField = new ITextField("1.00");
        iPanel.add(this.faktorTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.faktorTextField, gridBagConstraints);
        this.progressBar = new IProgressBar();
        iPanel.add(this.progressBar);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        this.progressLabel = new Label("0 Punkte");
        iPanel.add(this.progressLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.progressLabel, gridBagConstraints);
        this.add("Center", iPanel);
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        this.add("South", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void create() {
        Enumeration enumeration;
        try {
            this.faktor = new Double(this.faktorTextField.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.minLga = this.minChoice.getSelectedItem().charAt(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = this.aendCheckbox.getState();
        boolean bl2 = false;
        CreateLgaDialog createLgaDialog = this;
        int n = createLgaDialog.db.hasMenge() ? DataBase.MENGE.size() : DataBase.P.size();
        boolean bl3 = false;
        CreateLgaDialog createLgaDialog2 = this;
        Enumeration enumeration2 = createLgaDialog2.db.hasMenge() ? DataBase.MENGE.elements() : (enumeration = DataBase.P.elements());
        while (enumeration.hasMoreElements()) {
        }
        this.saveErrors();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.create();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim \u00c4ndern der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.create();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    private void addError(GeomException geomException) {
        if (geomException != null) {
            this.exceptions.addException(geomException);
            ++this.errors;
        }
    }

    private void saveErrors() {
        DataBase.ERR.removeAllElements();
        Object object = this.exceptions.elements();
        while (object.hasMoreElements()) {
            DataBase.ERR.addElement(new ErrorObject("SetPointAttLGA", (GeomException)object.nextElement()));
        }
        object = new ErrorWriter(new File(KafPlotProperties.getCheckFileName() + "_lga.err"), this.exceptions);
        ((ErrorWriter)object).setHeader("#Erzeugung Lagegenauigkeit am " + new Date().toString() + "\n# Faktor: " + this.faktor + "\n# untere Schranke: " + this.minLga + "\n# " + this.newLgaPoints + " neue LGA erzeugt\n# " + this.oldLgaPoints + " alte LGA verbessert");
        try {
            ((ErrorWriter)object).write();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

