/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CreatePointRasterDialog
extends IDialog
implements ActionListener {
    public static final long START_NUMBER = 99999999000000L;
    private DataBase db;
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private Button okButton;
    private Button abortButton;
    private ITextField vyTextField;
    private ITextField vxTextField;
    private ITextField byTextField;
    private ITextField bxTextField;
    private ITextField ddTextField;
    private ITextField nrTextField;

    public CreatePointRasterDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.setLayout(new BorderLayout());
        IPanel iPanel = new IPanel(new GridLayout(6, 2));
        iPanel.setBorder(new IBorder(1));
        iPanel.add(new Label("von Rechtswert: "));
        this.vyTextField = new ITextField(IFormat.f0_2.format(DataBase.ymin).toString(), 14);
        iPanel.add(this.vyTextField);
        iPanel.add(new Label("von Hochwert: "));
        this.vxTextField = new ITextField(IFormat.f0_2.format(DataBase.xmin).toString(), 14);
        iPanel.add(this.vxTextField);
        iPanel.add(new Label("bis Rechtswert: "));
        this.byTextField = new ITextField(IFormat.f0_2.format(DataBase.ymax).toString(), 14);
        iPanel.add(this.byTextField);
        iPanel.add(new Label("bis Hochwert: "));
        this.bxTextField = new ITextField(IFormat.f0_2.format(DataBase.xmax).toString(), 14);
        iPanel.add(this.bxTextField);
        iPanel.add(new Label("Raster [m]: "));
        this.ddTextField = new ITextField("100", 14);
        iPanel.add(this.ddTextField);
        iPanel.add(new Label("Startnummer: "));
        this.nrTextField = new ITextField(Long.toString(99999999000000L), 14);
        iPanel.add(this.nrTextField);
        this.add("North", iPanel);
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        this.add("South", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void create() {
        double d = DataBase.ymin;
        double d2 = DataBase.xmin;
        double d3 = DataBase.ymax;
        double d4 = DataBase.xmax;
        long l = 99999999000000L;
        int n = 100;
        try {
            d = new Double(this.vyTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d2 = new Double(this.vxTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d3 = new Double(this.byTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d4 = new Double(this.bxTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = new Integer(this.ddTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l = new Long(this.nrTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (double d5 = d2; d5 < d4 + (double)n; d5 += (double)n) {
            for (double d6 = d; d6 < d3 + (double)n; d6 += (double)n) {
                while (true) {
                    if (DataBase.P.get(l) == null) break;
                    ++l;
                }
                DataBase.P.put(new Punkt(l, (int)(d6 + (double)(n / 2)) / n * n, (int)(d5 + (double)(n / 2)) / n * n));
                ++l;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        this.create();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

