/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.SortableVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class CreateTrafoDialog
extends IDialog
implements ActionListener,
ItemListener {
    public static final float GEN_ALK = 10.0f;
    public static final float GEN_ATKIS = 2.0f;
    public static final long START_NUMBER = 99999999000000L;
    private DataBase db;
    private boolean isAlkis = false;
    protected ExceptionList exceptions;
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private Button okButton;
    private Button abortButton;
    private ITextField alkTextField;
    private ITextField atkisTextField;
    private ITextField ppTextField;
    private Checkbox trennCheckbox;
    private Checkbox ppCheckbox;
    private Checkbox oriCheckbox;

    public CreateTrafoDialog(IFrame iFrame, String string, DataBase dataBase) {
        super(iFrame, string, false);
        this.db = dataBase;
        this.exceptions = new ExceptionList();
        this.isAlkis = DataBase.model.getModel() == 2;
        this.setLayout(new BorderLayout());
        IPanel iPanel = new IPanel(new GridLayout(5, 2));
        this.trennCheckbox = new Checkbox("Systeme trennen");
        iPanel.add(this.trennCheckbox);
        this.trennCheckbox.setState(true);
        iPanel.add(new Label(""));
        iPanel.setBorder(new IBorder(1));
        iPanel.add(new Label("Genauigkeit Kataster-Objekte: "));
        this.alkTextField = new ITextField(IFormat.f0_2.format(10.0).toString(), 8);
        iPanel.add(this.alkTextField);
        iPanel.add(new Label("Genauigkeit Luftbild-Objekte: "));
        this.atkisTextField = new ITextField(IFormat.f0_2.format(2.0).toString(), 8);
        iPanel.add(this.atkisTextField);
        this.ppCheckbox = new Checkbox("PseudoPasspunkte");
        iPanel.add(this.ppCheckbox);
        this.ppCheckbox.addItemListener(this);
        this.ppTextField = new ITextField(Long.toString(99999999000000L), 8);
        iPanel.add(this.ppTextField);
        this.ppTextField.setEnabled(false);
        this.oriCheckbox = new Checkbox("Ausgangskoord. verwenden", true);
        iPanel.add(this.oriCheckbox);
        this.add("North", iPanel);
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        this.add("South", panel);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    private boolean isAtkis(GObject gObject) {
        return gObject.getFolie() == 84;
    }

    private boolean isAlk(GObject gObject) {
        return gObject.getFolie() != 84;
    }

    public void create() {
        Object object;
        Object object2;
        PunktTable punktTable = new PunktTable(1.0f);
        PunktTable punktTable2 = new PunktTable(1.0f);
        CreateTrafoDialog createTrafoDialog = this;
        PunktTable punktTable3 = createTrafoDialog.db.hasMenge() ? DataBase.MENGE : DataBase.P;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        if (this.trennCheckbox.getState()) {
            if (this.isAlkis) {
                var12_8 = punktTable3.elements();
                while (var12_8.hasMoreElements()) {
                    var13_10 = (Punkt)var12_8.nextElement();
                    d = Math.min(d, ((Punkt)var13_10).x);
                    d2 = Math.min(d2, ((Punkt)var13_10).y);
                    d3 = Math.max(d3, ((Punkt)var13_10).x);
                    d4 = Math.max(d4, ((Punkt)var13_10).y);
                    if (((Punkt)var13_10).getParameter().getEq() == 2000) {
                        punktTable2.put((LongHashObject)((Object)var13_10));
                        continue;
                    }
                    punktTable.put((LongHashObject)((Object)var13_10));
                }
            } else {
                CreateTrafoDialog createTrafoDialog2 = this;
                var12_8 = createTrafoDialog2.db.objekte();
                while (var12_8.hasMoreElements()) {
                    var13_10 = (GObject)var12_8.nextElement();
                    boolean bl = false;
                    if (this.isAtkis((GObject)var13_10)) {
                        bl = true;
                    } else {
                        if (!this.isAlk((GObject)var13_10)) continue;
                        bl = false;
                    }
                    object2 = ((GObject)var13_10).getPunkte().elements();
                    while (object2.hasMoreElements()) {
                        object = (Punkt)object2.nextElement();
                        if (!punktTable3.contains((LongHashObject)object)) continue;
                        d = Math.min(d, ((Punkt)object).x);
                        d2 = Math.min(d2, ((Punkt)object).y);
                        d3 = Math.max(d3, ((Punkt)object).x);
                        d4 = Math.max(d4, ((Punkt)object).y);
                        if (bl) {
                            punktTable2.put((LongHashObject)object);
                            continue;
                        }
                        punktTable.put((LongHashObject)object);
                    }
                }
            }
        } else {
            var12_8 = punktTable3.elements();
            while (var12_8.hasMoreElements()) {
                var13_10 = (Punkt)var12_8.nextElement();
                d = Math.min(d, ((Punkt)var13_10).x);
                d2 = Math.min(d2, ((Punkt)var13_10).y);
                d3 = Math.max(d3, ((Punkt)var13_10).x);
                d4 = Math.max(d4, ((Punkt)var13_10).y);
                punktTable.put((LongHashObject)((Object)var13_10));
            }
        }
        float f = 0.0f;
        float f2 = 0.0f;
        try {
            f = new Float(this.alkTextField.getText().trim()).floatValue();
        }
        catch (Exception exception) {
            f = 10.0f;
        }
        try {
            f2 = new Float(this.atkisTextField.getText().trim()).floatValue();
        }
        catch (Exception exception) {
            f2 = 2.0f;
        }
        TrafoGewicht trafoGewicht = new TrafoGewicht(f, f / 2.0f);
        object2 = new TrafoGewicht(f2, f2 / 2.0f);
        object = new TrafoGewicht(0.01f, 0.01f);
        Punkt punkt = null;
        Punkt punkt2 = null;
        Punkt punkt3 = null;
        Punkt punkt4 = null;
        if (this.ppCheckbox.getState()) {
            d = (int)d / 1000 * 1000;
            d2 = (int)d2 / 1000 * 1000;
            d3 = (int)(d3 + 1000.0) / 1000 * 1000;
            d4 = (int)(d4 + 1000.0) / 1000 * 1000;
            long l = 99999999000000L;
            try {
                l = Long.parseLong(this.ppTextField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            punkt = this.createPP(l + 0L, d2, d);
            punkt2 = this.createPP(l + 1L, d2, d3);
            punkt3 = this.createPP(l + 2L, d4, d3);
            punkt4 = this.createPP(l + 3L, d4, d);
        }
        if (punktTable.size() > 0) {
            TrafoSystem trafoSystem = new TrafoSystem(9);
            if (this.isAlkis) {
                trafoSystem.setName("generiertes " + (this.trennCheckbox.getState() ? "Kataster-" : "") + "ALKIS-Digitalisiersystem");
            } else {
                trafoSystem.setName("generiertes " + (this.trennCheckbox.getState() ? "ALK-" : "") + "Digitalisiersystem");
            }
            trafoSystem.setParameter(6);
            this.fill(trafoSystem, punktTable, trafoGewicht);
            trafoSystem.initGeom();
            DataBase.T.addElement(trafoSystem);
            if (this.ppCheckbox.getState()) {
                this.addPP(trafoSystem, punkt, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt2, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt3, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt4, (TrafoGewicht)object);
            }
        }
        if (punktTable2.size() > 0) {
            TrafoSystem trafoSystem = new TrafoSystem(9);
            if (this.isAlkis) {
                trafoSystem.setName("generiertes Luftbild-Digitalisiersystem");
            } else {
                trafoSystem.setName("generiertes ATKIS-Digitalisiersystem");
            }
            trafoSystem.setParameter(4);
            this.fill(trafoSystem, punktTable2, (TrafoGewicht)object2);
            trafoSystem.initGeom();
            DataBase.T.addElement(trafoSystem);
            if (this.ppCheckbox.getState()) {
                this.addPP(trafoSystem, punkt, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt2, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt3, (TrafoGewicht)object);
                this.addPP(trafoSystem, punkt4, (TrafoGewicht)object);
            }
        }
        KafPlotProperties.isTrafoVisible = true;
    }

    private Punkt createPP(long l, double d, double d2) {
        l = DataBase.P.getNextFreeNumber(l);
        Punkt punkt = new Punkt(l, d, d2);
        punkt.setPs(2);
        punkt.g = 0.01f;
        punkt.setRiss("generierte PseudoPasspunkte");
        DataBase.P.put(punkt);
        return punkt;
    }

    private void addPP(TrafoSystem trafoSystem, Punkt punkt, TrafoGewicht trafoGewicht) {
        trafoSystem.addElement(new TrafoPunkt(punkt, punkt.y, punkt.x, trafoGewicht));
    }

    private void fill(TrafoSystem trafoSystem, PunktTable punktTable, TrafoGewicht trafoGewicht) {
        SortableVector sortableVector = new SortableVector(punktTable.elements());
        sortableVector.sort();
        boolean bl = true;
        Enumeration enumeration = sortableVector.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            DPoint dPoint = this.oriCheckbox.getState() ? punkt.getOriginal() : punkt;
            TrafoPunkt trafoPunkt = new TrafoPunkt(punkt, dPoint.y, dPoint.x, trafoGewicht);
            trafoPunkt.setFirst(bl);
            if (bl) {
                bl = false;
            }
            trafoSystem.addElement(trafoPunkt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.ppTextField.setEnabled(this.ppCheckbox.getState());
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.create();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_data_update"));
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

