/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.Util;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.BedingungEnumerator;
import de.geocalc.kafplot.BedingungRissEnumerator;
import de.geocalc.kafplot.BemerkungTable;
import de.geocalc.kafplot.BodenSchaetzungTable;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckTable;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeTable;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.GrundbuchTable;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.ImageTable;
import de.geocalc.kafplot.KafPlotVariableTable;
import de.geocalc.kafplot.KafkaReader;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieSearchTable;
import de.geocalc.kafplot.MessElementTable;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungEnumerator;
import de.geocalc.kafplot.MessungRissEnumerator;
import de.geocalc.kafplot.NummerierungsBezirkTable;
import de.geocalc.kafplot.NutzungTable;
import de.geocalc.kafplot.ObjektEnumerator;
import de.geocalc.kafplot.Plotbox;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktFilter;
import de.geocalc.kafplot.PunktIdentitaetTable;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.Stat4;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TopObjectTable;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.TrafoSystemTable;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kafplot.io.dat.SteuerDaten;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.kataster.model.KatasterModel;
import de.geocalc.util.VoidEnumerator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public final class DataBase {
    public static final int CLOSE = -1;
    public static final int EMPTY = 0;
    public static final int ONLY_IMAGES = 1;
    public static final int ONLY_POINTS = 2;
    public static final int FULL = 3;
    public static final PunktTable P = new PunktTable(3.0f);
    public static final PunktIdentitaetTable P_IDENT = new PunktIdentitaetTable();
    public static final MessElementTable MG = new MessElementTable();
    public static final MessElementTable MP = new MessElementTable();
    public static final MessElementTable MM = new MessElementTable();
    public static final MessElementTable MK = new MessElementTable();
    public static final MessElementTable ME = new MessElementTable();
    public static final MessElementTable MV = new MessElementTable();
    public static final MessElementTable HN = new MessElementTable();
    public static final MessElementTable HP = new MessElementTable();
    public static final TrafoSystemTable T = new TrafoSystemTable();
    public static final MessElementTable BH = new MessElementTable();
    public static final MessElementTable BB = new MessElementTable();
    public static final Vector UMNUM = new Vector();
    public static final PunktTable MENGE = new PunktTable();
    public static final NummerierungsBezirkTable NB = new NummerierungsBezirkTable();
    public static final FlurstueckTable ALB = new FlurstueckTable();
    public static final FlurstueckTable FLST = new FlurstueckTable();
    public static final GrundbuchTable BUCH = new GrundbuchTable();
    public static final NutzungTable NUTZ = new NutzungTable();
    public static final BodenSchaetzungTable BODEN = new BodenSchaetzungTable();
    public static final GebaeudeTable GEB = new GebaeudeTable();
    public static final TopObjectTable TOP = new TopObjectTable();
    public static final BemerkungTable BEM = new BemerkungTable();
    public static final BemerkungTable ERR = new BemerkungTable();
    public static final ImageTable IMG = new ImageTable();
    public static final PunktTable PM = new PunktTable(1.0f);
    public static final PunktTable PI = new PunktTable(1.0f);
    public static PunktTable SEARCH_NUTZ_POINTS = null;
    public static PunktTable SEARCH_GEB_POINTS = null;
    public static Hashtable<String, Punkt> NAS_OBJECTS = new Hashtable();
    public static Vector<String> NAS_FILES = new Vector();
    public static Plotbox PLOTBOX = null;
    public static int trafoSteps = 0;
    public static boolean isTested = true;
    public static SteuerDaten steuerDaten = null;
    public static boolean isSaved = true;
    public static boolean hasStatistik = false;
    private static File sourceFile = null;
    private static String sourcePath = null;
    private static String sourceName = null;
    private static boolean isKafkaSource = false;
    public static String projekt;
    public static String kafDatVersion;
    public static String vermStelle;
    public static String adresse_1;
    public static String adresse_2;
    public static String adresse_3;
    public static String bearbeiter;
    public static String gemeinde;
    public static String gemarkung;
    public static String flur;
    public static String flurstueck;
    public static String katasterAmt;
    public static String antrag;
    public static String daten;
    public static String kooSystemName;
    public static String source;
    public static double xmin;
    public static double ymin;
    public static double xmax;
    public static double ymax;
    public static double emax;
    public static double vmax;
    public static double zmax;
    public static double amax;
    public static double smax;
    public static double dhmax;
    public static double tvmax;
    public static double trmax;
    public static double maxAreaProportion;
    public static double maxAreaDifference;
    public static double minBodenschaetzZahl;
    public static double maxBodenschaetzZahl;
    public static Stat4 maxStat;
    public static int maxStatGrzw;
    public static int maxStatEgk;
    public static int nutzVersion;
    public static double KPG;
    public static double KAPG;
    public static double KFPG;
    public static double maxEinrechenDistance;
    public static double maxLinieDistance;
    public static GregorianCalendar projektDate;
    public static KatasterModel model;
    private static int kooSystem;
    private static int numSystem;
    private static final Vector dbListeners;
    private static boolean isWork;
    private static DataBase instance;

    public static void setWork(boolean bl) {
        isWork = bl;
    }

    public static boolean isWork() {
        return isWork;
    }

    public static boolean hasImages() {
        return IMG.size() > 0;
    }

    protected DataBase(int n) {
        KafPlotVariableTable.setSource(this);
        this.clear();
    }

    public static DataBase getInstance() {
        return instance;
    }

    public static boolean isEmpty() {
        return DataBase.getState() <= 0;
    }

    public static int getState() {
        if (!(MP.isEmpty() && MG.isEmpty() && MM.isEmpty() && MK.isEmpty() && MV.isEmpty() && HN.isEmpty() && HP.isEmpty() && T.isEmpty() && BH.isEmpty() && BB.isEmpty() && ALB.isEmpty() && FLST.isEmpty() && GEB.isEmpty() && TOP.isEmpty() && BUCH.isEmpty() && BEM.isEmpty() && ERR.isEmpty())) {
            return 3;
        }
        if (!P.isEmpty()) {
            return 2;
        }
        if (!IMG.isEmpty()) {
            return 1;
        }
        if (kooSystem > -9) {
            return 0;
        }
        return -1;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        P.clear();
        P_IDENT.clear();
        MP.removeAllElements();
        MG.removeAllElements();
        MM.removeAllElements();
        MK.removeAllElements();
        ME.removeAllElements();
        MV.removeAllElements();
        T.removeAllElements();
        HN.removeAllElements();
        HP.removeAllElements();
        BH.removeAllElements();
        BB.removeAllElements();
        UMNUM.removeAllElements();
        MENGE.removeAllElements();
        NB.removeAllElements();
        ALB.removeAllElements();
        ALB.reset();
        FLST.removeAllElements();
        FLST.reset();
        NUTZ.clear();
        NUTZ.reset();
        BODEN.clear();
        BODEN.reset();
        BUCH.clear();
        GEB.removeAllElements();
        TOP.removeAllElements();
        BEM.removeAllElements();
        ERR.removeAllElements();
        PM.clear();
        PI.clear();
        SEARCH_NUTZ_POINTS = null;
        SEARCH_GEB_POINTS = null;
        NAS_OBJECTS.clear();
        NAS_FILES.removeAllElements();
        if (bl) {
            PLOTBOX = null;
        }
        if (bl) {
            IMG.clear();
        }
        projekt = null;
        kafDatVersion = null;
        vermStelle = null;
        adresse_1 = null;
        adresse_2 = null;
        adresse_3 = null;
        bearbeiter = null;
        gemeinde = null;
        gemarkung = null;
        flur = null;
        flurstueck = null;
        katasterAmt = null;
        antrag = null;
        source = null;
        isTested = true;
        trafoSteps = 0;
        DataBase.setKooSystem(-9);
        DataBase.setNumSystem(-9);
        emax = 0.0;
        vmax = 0.0;
        zmax = 0.0;
        tvmax = 0.0;
        trmax = 0.0;
        dhmax = 0.0;
        hasStatistik = false;
        maxStat = new Stat4(null, null);
        sourceFile = null;
        sourceName = null;
        isKafkaSource = false;
        System.gc();
    }

    public void updateStatistik(Stat stat) {
        DataBase.updateStatistik(maxStat, stat);
        maxStatGrzw = Math.max(maxStatGrzw, stat.getMaxGrzw());
        maxStatEgk = Math.max(maxStatEgk, stat.getMaxEgk());
        hasStatistik = true;
    }

    public static void updateStatistik(Stat4 stat4, Stat stat) {
        if (stat4 != null && stat != null) {
            for (int i = 1; i < stat.count() + 1; ++i) {
                if (Stat.isValue(stat.getV(i))) {
                    stat4.setV(1, (short)Math.min(stat4.getV(i), Math.abs(stat.getV(i))));
                }
                if (Stat.isValue(stat.getV(i))) {
                    stat4.setV(2, (short)Math.max(stat4.getV(i), Math.abs(stat.getV(i))));
                }
                if (Stat.isValue(stat.getSaV(i))) {
                    stat4.setSaV(1, (short)Math.min(stat4.getSaV(i), stat.getSaV(i)));
                }
                if (Stat.isValue(stat.getSaV(i))) {
                    stat4.setSaV(2, (short)Math.max(stat4.getSaV(i), stat.getSaV(i)));
                }
                if (Stat.isValue(stat.getEp(i))) {
                    stat4.setEp(1, (short)Math.min(stat4.getEp(i), stat.getEp(i)));
                }
                if (Stat.isValue(stat.getEp(i))) {
                    stat4.setEp(2, (short)Math.max(stat4.getEp(i), stat.getEp(i)));
                }
                if (Stat.isValue(stat.getEv(i))) {
                    stat4.setEv(1, (short)Math.min(stat4.getEv(i), stat.getEv(i)));
                }
                if (Stat.isValue(stat.getEv(i))) {
                    stat4.setEv(2, (short)Math.max(stat4.getEv(i), stat.getEv(i)));
                }
                if (Stat.isValue(stat.getNv(i))) {
                    stat4.setNv(1, (short)Math.min(stat4.getNv(i), stat.getNv(i)));
                }
                if (Stat.isValue(stat.getNv(i))) {
                    stat4.setNv(2, (short)Math.max(stat4.getNv(i), stat.getNv(i)));
                }
                if (Stat.isValue(stat.getGf(i))) {
                    stat4.setGf(1, (short)Math.min(stat4.getGf(i), Math.abs(stat.getGf(i))));
                }
                if (!Stat.isValue(stat.getGf(i))) continue;
                stat4.setGf(2, (short)Math.max(stat4.getGf(i), Math.abs(stat.getGf(i))));
            }
            stat4.setV(3, (short)Math.max(stat4.getV(3), stat.getSumV()));
            stat4.setSaV(3, (short)Math.max(stat4.getSaV(3), stat.getMaxSaV()));
            stat4.setSaN(3, (short)Math.max(stat4.getSaN(3), stat.getMaxSaN()));
            stat4.setEp(3, (short)Math.max(stat4.getEp(3), stat.getSumEp()));
            stat4.setEv(3, (short)Math.max(stat4.getEv(3), stat.getMidEv()));
            stat4.setNv(3, (short)Math.max(stat4.getNv(3), stat.getMaxNv()));
            stat4.setGf(3, (short)Math.max(stat4.getGf(3), stat.getSumGf()));
        }
    }

    public static double getGelHoehe() {
        if (steuerDaten != null) {
            return steuerDaten.getHoehe();
        }
        return 0.0;
    }

    public static double getNvGrenz() {
        if (steuerDaten != null) {
            return steuerDaten.getK();
        }
        return 3.3;
    }

    public static void setGelHoehe(double d) {
        if (steuerDaten == null) {
            steuerDaten = new SteuerDaten("AutoCreate");
        }
        steuerDaten.setHoehe(d);
    }

    public static SteuerDaten getSteuerDaten() {
        return steuerDaten != null ? steuerDaten : new SteuerDaten("AutoCreate");
    }

    public static void update() {
        DataBase.fireDataBaseEvent(2001);
    }

    public static void update(File file) {
        if (!DataBase.isInit()) {
            DataBase.init(file);
        } else {
            DataBase.fireDataBaseEvent(2001);
        }
    }

    public static void init(File file) {
        if (file == null) {
            sourceFile = null;
            sourceName = null;
            isKafkaSource = false;
        } else {
            sourceFile = new File(file.getAbsolutePath());
            DataBase.setSourcePath(sourceFile.getParent());
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            sourceName = string;
            isKafkaSource = KafkaReader.isKafkaFile(file);
        }
        DataBase.fireDataBaseEvent(2001);
    }

    public static boolean isInit() {
        return sourceFile != null;
    }

    public boolean isKafkaSource() {
        return isKafkaSource;
    }

    public static File getSourceFile() {
        return sourceFile;
    }

    public static File getSourceFile(String string) {
        if (DataBase.getSourceName() == null) {
            return null;
        }
        return new File(DataBase.getSourcePath() + DataBase.getSourceName() + DataBase.regExt(string));
    }

    public static void setSourcePath(String object) {
        if (object == null) {
            sourcePath = null;
        } else {
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            sourcePath = new File((String)object).isDirectory() ? Util.regularPath((String)object) : null;
        }
    }

    public static String getSourcePath() {
        String string = sourcePath;
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string == null) {
            string = System.getProperty("user.home");
        }
        if (string == null) {
            string = new File(".").getAbsolutePath();
        }
        return string;
    }

    public static String getSourceName() {
        return sourceName;
    }

    public static File getDestFile(String string) {
        return new File(DataBase.getDestPath() + DataBase.getDestName() + DataBase.regExt(string));
    }

    public static String getDestFileDisplayName(String string) {
        return isKafkaSource ? string : DataBase.getDestPath() + string;
    }

    public static String getDestPath() {
        String string = sourcePath;
        if (string != null && Files.isWritable(Paths.get(string, new String[0]))) {
            return string;
        }
        string = System.getProperty("user.dir");
        if (string != null && Files.isWritable(Paths.get(string, new String[0]))) {
            return string;
        }
        string = System.getProperty("user.home");
        if (string != null && Files.isWritable(Paths.get(string, new String[0]))) {
            return string;
        }
        string = System.getProperty("java.io.tmpdir");
        if (string != null && Files.isWritable(Paths.get(string, new String[0]))) {
            return string;
        }
        return new File(".").getAbsolutePath();
    }

    public static String getDestName() {
        return sourceName != null ? sourceName : "KafPlot";
    }

    private static String regExt(String object) {
        if (object == null) {
            object = "";
        } else if (!((String)object).startsWith(".")) {
            object = "." + (String)object;
        }
        return object;
    }

    public static void addNasFile(String string) {
        NAS_FILES.addElement(string);
    }

    public Enumeration nasFiles() {
        return NAS_FILES.elements();
    }

    public static void addImage(GeoImage geoImage) {
        String string = geoImage.getName();
        boolean bl = false;
        int n = 0;
        do {
            bl = false;
            Enumeration enumeration = IMG.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage2 = (GeoImage)enumeration.nextElement();
                if (!geoImage2.getName().equals(geoImage.getName())) continue;
                geoImage.setName(string + " (" + ++n + ")");
                bl = true;
            }
        } while (bl);
        IMG.addElement(geoImage);
        DataBase.addDataBaseListener(geoImage.getImageLocation());
        DataBase.fireDataBaseEvent(2001);
    }

    public static void updateImage(GeoImage geoImage) {
        DataBase.fireDataBaseEvent(2001);
    }

    public static void addDataBaseListener(DataBaseListener dataBaseListener) {
        if (!dbListeners.contains(dataBaseListener)) {
            dbListeners.addElement(dataBaseListener);
        }
    }

    public static void removeDataBaseListener(DataBaseListener dataBaseListener) {
        dbListeners.removeElement(dataBaseListener);
    }

    public static void sendUpdateEvent() {
        DataBase.fireDataBaseEvent(2001);
    }

    private static void fireDataBaseEvent(int n) {
        DataBaseEvent dataBaseEvent = new DataBaseEvent(DataBase.getInstance(), n);
        Enumeration enumeration = dbListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((DataBaseListener)enumeration.nextElement()).dataBaseUpdated(dataBaseEvent);
        }
    }

    public static void setNumSystem(int n) {
        numSystem = n;
    }

    public static int getNumSystem() {
        return numSystem;
    }

    public static String getNumSystemName() {
        return KoordinatenSystem.getSystemName(numSystem);
    }

    public static void setKooSystem(int n) {
        kooSystem = n;
    }

    public static double getStreckeMasstab(double d) {
        return DataBase.getStreckeMasstab(d, DataBase.getGelHoehe());
    }

    public static double getStreckeMasstab(DPoint dPoint) {
        return DataBase.getStreckeMasstab(dPoint.y, DataBase.getGelHoehe());
    }

    public static double getStreckeMasstab(DPoint dPoint, double d) {
        return DataBase.getStreckeMasstab(dPoint.y, d);
    }

    public static double getStreckeMasstab(double d, double d2) {
        double d3 = (int)(d / 1000000.0) * 1000000 + 500000;
        double d4 = (d - d3) / 1000.0;
        double d5 = 1.0;
        double d6 = 1.0 + d2 / 6380000.0;
        switch (kooSystem) {
            case 150: {
                d5 = 1.0 + d4 * d4 / 8.14088E7;
                break;
            }
            case 489: {
                d5 = (1.0 + d4 * d4 / 8.14088E7) * 0.9996;
            }
        }
        return 1.0 / d5 * d6;
    }

    public static double getFlaecheMasstab(double d) {
        return DataBase.getFlaecheMasstab(d, DataBase.getGelHoehe());
    }

    public static double getFlaecheMasstab(DPoint dPoint) {
        return DataBase.getFlaecheMasstab(dPoint.y, DataBase.getGelHoehe());
    }

    public static double getFlaecheMasstab(DPoint dPoint, double d) {
        return DataBase.getFlaecheMasstab(dPoint.y, d);
    }

    public static double getFlaecheMasstab(double d, double d2) {
        double d3 = (int)(d / 1000000.0) * 1000000 + 500000;
        double d4 = (d - d3) / 1000.0;
        double d5 = 1.0;
        double d6 = 1.0 + d2 / 6380000.0;
        switch (kooSystem) {
            case 150: {
                d5 = 1.0 + d4 * d4 / 8.14088E7;
                break;
            }
            case 489: {
                d5 = (1.0 + d4 * d4 / 8.14088E7) * 0.9996;
            }
        }
        return 1.0 / (d5 * d5) * (d6 * d6);
    }

    public static int getKooSystem() {
        return kooSystem;
    }

    public static String getKooSystemName() {
        return KoordinatenSystem.getSystemName(kooSystem);
    }

    public static DPoint getAreaCenter() {
        return new DPoint((ymin + ymax) / 2.0, (xmin + xmax) / 2.0);
    }

    public static DRectangle getBounds() {
        return new DRectangle(ymin, xmin, ymax - ymin, xmax - xmin);
    }

    public void setArea(int n) {
        xmin = Double.MAX_VALUE;
        ymin = Double.MAX_VALUE;
        xmax = -1.7976931348623157E308;
        ymax = -1.7976931348623157E308;
        emax = -1.7976931348623157E308;
        vmax = -1.7976931348623157E308;
        dhmax = -1.7976931348623157E308;
        if (!P.isEmpty()) {
            var2_2 = P.elements();
            while (var2_2.hasMoreElements()) {
                Punkt punkt = (Punkt)var2_2.nextElement();
                xmin = Math.min(xmin, punkt.x);
                ymin = Math.min(ymin, punkt.y);
                xmax = Math.max(xmax, punkt.x);
                ymax = Math.max(ymax, punkt.y);
                emax = Math.max(emax, (double)punkt.getSP());
                vmax = Math.max(vmax, (double)punkt.getDS());
                dhmax = Math.max(dhmax, (double)Math.abs(punkt.dh));
            }
        } else if (!ERR.isEmpty()) {
            var2_2 = ERR.elements();
            while (var2_2.hasMoreElements()) {
                TextBox textBox = (TextBox)var2_2.nextElement();
                DPoint dPoint = textBox.getCatchPoint();
                if (dPoint == null) continue;
                xmin = Math.min(xmin, dPoint.x);
                ymin = Math.min(ymin, dPoint.y);
                xmax = Math.max(xmax, dPoint.x);
                ymax = Math.max(ymax, dPoint.y);
            }
        } else if (!IMG.isEmpty()) {
            var2_2 = IMG.elements();
            while (var2_2.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)var2_2.nextElement();
                GeoImageLocation geoImageLocation = geoImage.getImageLocation();
                if (geoImageLocation.getWidth() != 0.0 && geoImageLocation.getHeight() != 0.0) {
                    xmin = Math.min(xmin, geoImageLocation.getX() - geoImageLocation.getHeight() * geoImageLocation.getScale());
                    ymin = Math.min(ymin, geoImageLocation.getY());
                    xmax = Math.max(xmax, geoImageLocation.getX());
                    ymax = Math.max(ymax, geoImageLocation.getY() + geoImageLocation.getWidth() * geoImageLocation.getScale());
                    continue;
                }
                xmin = 0.0;
                ymin = 0.0;
                xmax = 1000.0;
                ymax = 1000.0;
                emax = 0.0;
                vmax = 0.0;
                dhmax = 0.0;
            }
        } else {
            xmin = 0.0;
            ymin = 0.0;
            xmax = 1000.0;
            ymax = 1000.0;
            emax = 0.0;
            vmax = 0.0;
            dhmax = 0.0;
        }
        if (xmin == xmax || ymin == ymax) {
            xmin -= 100.0;
            xmax += 100.0;
            ymin -= 100.0;
            ymax += 100.0;
        }
        if (n > -1) {
            DataBase.setKooSystem(n);
            DataBase.setNumSystem(n);
        } else {
            int n2 = KoordinatenSystem.getSystemOf(ymin, ymax);
            DataBase.setKooSystem(n2);
            DataBase.setNumSystem(n2);
        }
    }

    public static boolean isInArea(double d, double d2) {
        return d >= ymin && d < ymax && d2 >= xmin && d2 <= xmax;
    }

    public static int getGObjectCount() {
        return FLST.size() + GEB.size() + NUTZ.size() + BODEN.size() + TOP.size();
    }

    public static String getElements() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            switch (punkt.getPs()) {
                case -9: {
                    ++n;
                    break;
                }
                case -2: {
                    ++n2;
                    break;
                }
                case 0: {
                    ++n3;
                    break;
                }
                case 1: {
                    ++n4;
                    break;
                }
                case 2: {
                    ++n5;
                }
            }
        }
        int n6 = MP.countObjects() + MG.countObjects() + MM.countObjects() + MK.countObjects() + ME.countObjects() + MV.countObjects();
        return new String(n4 + " " + n5 + " " + n2 + " " + n3 + " " + n + " " + n6);
    }

    public int getDynamicPoints() {
        int n = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            int n2 = punkt.getPs();
            if (n2 != 2 && n2 != 0) continue;
            ++n;
        }
        return n;
    }

    public boolean hasDynamicPoints() {
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            int n = punkt.getPs();
            if (n != 2 && n != 0) continue;
            return true;
        }
        return false;
    }

    public static double getStrecke(Linie linie) {
        return DataBase.getStrecke(linie.pa, linie.pe);
    }

    public static double getStrecke(Punkt punkt, Punkt punkt2) {
        return DataBase.getStreckeMasstab((punkt.y + punkt2.y) / 2.0) * Math.sqrt((punkt2.x - punkt.x) * (punkt2.x - punkt.x) + (punkt2.y - punkt.y) * (punkt2.y - punkt.y));
    }

    public Punkt searchPunkt(long l) {
        return (Punkt)P.get(l);
    }

    public Punkt searchUmnumPunkt(long l) {
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (punkt.getUmnum() != l) continue;
            return punkt;
        }
        return null;
    }

    public double getAbstandVonLinie(Punkt punkt, Punkt punkt2, Punkt punkt3) {
        double d = Math.atan2(punkt2.y - punkt.y, punkt2.x - punkt.x);
        double d2 = Math.atan2(punkt3.y - punkt.y, punkt3.x - punkt.x);
        return -DataBase.getStrecke(punkt, punkt3) * Math.sin(d - d2);
    }

    public double getAbstandVonLinie(Linie linie, Punkt punkt) {
        return this.getAbstandVonLinie(linie.pa, linie.pe, punkt);
    }

    public double getKatasterStreckenGenauigkeit(double d, float f) {
        d = Math.abs(d);
        double d2 = (KatasterParameter.A1 + KatasterParameter.A2 * d + KatasterParameter.A3 * Math.sqrt(d)) * KatasterParameter.AF;
        if (KatasterParameter.USE_GEWICHTE) {
            d2 /= Math.sqrt(f);
        }
        return d2;
    }

    public static boolean hasPlotbox() {
        return PLOTBOX != null;
    }

    public static boolean hasMenge() {
        return MENGE.size() > 0;
    }

    public static void changeMenge() {
        PunktTable punktTable = (PunktTable)MENGE.clone();
        MENGE.removeAllElements();
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (punktTable.get(punkt.nr) != null) continue;
            MENGE.put(punkt);
        }
    }

    public static void removeMenge() {
        MENGE.removeAllElements();
    }

    public static int removeMenge(Punkt punkt) {
        if (MENGE.contains(punkt)) {
            MENGE.removeElement(punkt);
            return 1;
        }
        return 0;
    }

    public static int removeMenge(PunktTable punktTable) {
        int n = 0;
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!MENGE.contains(punkt)) continue;
            MENGE.removeElement(punkt);
            ++n;
        }
        return n;
    }

    public static int removeMenge(DPolygon dPolygon) {
        int n = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!punkt.isVisible() || !MENGE.contains(punkt) || !dPolygon.contains(punkt.y, punkt.x)) continue;
            MENGE.removeElement(punkt);
            ++n;
        }
        return n;
    }

    public static int buildMenge(DPolygon dPolygon) {
        int n = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!punkt.isVisible() || MENGE.contains(punkt) || !dPolygon.contains(punkt.y, punkt.x)) continue;
            MENGE.addElement(punkt);
            ++n;
        }
        DataBase.fireDataBaseEvent(2001);
        return n;
    }

    public static int buildMenge(Punkt punkt) {
        if (!MENGE.contains(punkt)) {
            MENGE.addElement(punkt);
            return 1;
        }
        DataBase.fireDataBaseEvent(2001);
        return 0;
    }

    public static int buildMenge(PunktTable punktTable) {
        int n = 0;
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (MENGE.contains(punkt)) continue;
            MENGE.addElement(punkt);
            ++n;
        }
        DataBase.fireDataBaseEvent(2001);
        return n;
    }

    public static int buildMenge(PunktFilter punktFilter) {
        int n = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (MENGE.contains(punkt) || !punktFilter.isValidValue(punkt)) continue;
            MENGE.addElement(punkt);
            ++n;
        }
        DataBase.fireDataBaseEvent(2001);
        return n;
    }

    public static int removeMenge(PunktFilter punktFilter) {
        int n = 0;
        Enumeration enumeration = P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!MENGE.contains(punkt) || !punktFilter.isValidValue(punkt)) continue;
            MENGE.removeElement(punkt);
            ++n;
        }
        DataBase.fireDataBaseEvent(2001);
        return n;
    }

    public boolean isGpsPunkt(Punkt punkt) {
        return MG.contains(punkt);
    }

    public boolean isAufnahmePunkt(Punkt punkt) {
        if (MP.contains(punkt)) {
            return true;
        }
        if (MG.contains(punkt)) {
            return true;
        }
        return MM.contains(punkt);
    }

    public static boolean isFreeNutzungsartenPunkt(Punkt punkt) {
        if (punkt.getKafPa() != -1 || punkt.getOska() > 0) {
            return false;
        }
        if (SEARCH_NUTZ_POINTS == null) {
            SEARCH_NUTZ_POINTS = new PunktTable(1.0f);
            Enumeration enumeration = DataBase.flurstueckLinien();
            while (enumeration.hasMoreElements()) {
                Linie linie = (Linie)enumeration.nextElement();
                if (linie.getOska() != 241) continue;
                if (linie.pa != null && linie.pa.getKafPa() == -1 && linie.pa.getOska() <= 0) {
                    SEARCH_NUTZ_POINTS.put(linie.pa);
                }
                if (linie.pe == null || linie.pe.getKafPa() != -1 || linie.pe.getOska() > 0) continue;
                SEARCH_NUTZ_POINTS.put(linie.pe);
            }
        }
        return SEARCH_NUTZ_POINTS.contains(punkt);
    }

    public static boolean isFreeGebaeudePunkt(Punkt punkt) {
        if (punkt.getKafPa() != -1 || punkt.getOska() > 0) {
            return false;
        }
        if (SEARCH_GEB_POINTS == null) {
            SEARCH_GEB_POINTS = new PunktTable(1.0f);
            Enumeration enumeration = DataBase.gebaeudeLinien();
            while (enumeration.hasMoreElements()) {
                Linie linie = (Linie)enumeration.nextElement();
                if (linie.pa != null && linie.pa.getKafPa() == -1 && linie.pa.getOska() <= 0) {
                    SEARCH_GEB_POINTS.put(linie.pa);
                }
                if (linie.pe == null || linie.pe.getKafPa() != -1 || linie.pe.getOska() > 0) continue;
                SEARCH_GEB_POINTS.put(linie.pe);
            }
        }
        return SEARCH_GEB_POINTS.contains(punkt);
    }

    public boolean isNachweisPunkt(Punkt punkt) {
        for (int i = 0; i < T.size(); ++i) {
            TrafoSystem trafoSystem = (TrafoSystem)T.elementAt(i);
            if (trafoSystem.getStatus() != 2 || !trafoSystem.contains(punkt)) continue;
            return true;
        }
        return MK.contains(punkt);
    }

    public static boolean isTrafoPunkt(Punkt punkt) {
        for (int i = 0; i < T.size(); ++i) {
            TrafoSystem trafoSystem = (TrafoSystem)T.elementAt(i);
            if (trafoSystem.getStatus() != 8 || !trafoSystem.contains(punkt)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigitPunkt(Punkt punkt) {
        for (int i = 0; i < T.size(); ++i) {
            TrafoSystem trafoSystem = (TrafoSystem)T.elementAt(i);
            if (trafoSystem.getStatus() != 9 || !trafoSystem.contains(punkt)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHomogenisierungPunkt(Punkt punkt) {
        return BH.contains(punkt);
    }

    public static boolean isSchnittPunkt(Punkt punkt) {
        int n = 0;
        Enumeration enumeration = ME.objects();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            if (messung.getMessungsArt() != 200 || !messung.contains(punkt) || ++n < 2) continue;
            return true;
        }
        return n >= 2;
    }

    public void removeIdentitaet(Identitaet identitaet) {
        int n = identitaet.getOperation();
        if (n == 1) {
            PI.remove(identitaet);
        } else if (n == 0) {
            identitaet.setOperation(2);
        }
    }

    public void removePunktMove(PunktMove punktMove) {
        int n = punktMove.getOperation();
        if (n == 1) {
            PM.remove(punktMove);
        } else if (n == 0) {
            punktMove.setOperation(2);
        }
    }

    public static DataContainerTable getDataContainer(int n) {
        switch (n) {
            case 201: {
                return MG;
            }
            case 202: {
                return MP;
            }
            case 203: {
                return MM;
            }
            case 204: {
                return MK;
            }
            case 205: {
                return MV;
            }
            case 206: {
                return ME;
            }
            case 601: {
                return BH;
            }
            case 602: {
                return BB;
            }
        }
        return null;
    }

    public static Enumeration punkte() {
        return P.elements();
    }

    public static Enumeration messRisse() {
        return new MessungRissEnumerator();
    }

    public static Enumeration polarRisse() {
        return MP.elements();
    }

    public static Enumeration gpsRisse() {
        return MG.elements();
    }

    public static Enumeration messbandRisse() {
        return MM.elements();
    }

    public static Enumeration katasterRisse() {
        return MK.elements();
    }

    public static Enumeration einrechenRisse() {
        return ME.elements();
    }

    public static Enumeration vorgabeRisse() {
        return MV.elements();
    }

    public static Enumeration messungen() {
        return new MessungEnumerator();
    }

    public static Enumeration polarMessungen() {
        return MP.dataObjects();
    }

    public static Enumeration gpsMessungen() {
        return MG.dataObjects();
    }

    public static Enumeration messbandMessungen() {
        return MM.dataObjects();
    }

    public static Enumeration katasterMessungen() {
        return MK.dataObjects();
    }

    public static Enumeration einrechenMessungen() {
        return ME.dataObjects();
    }

    public static Enumeration vorgabeMessungen() {
        return MV.dataObjects();
    }

    public static Enumeration allBedingungRisse() {
        return new BedingungRissEnumerator();
    }

    public static Enumeration bedingungRisse() {
        return BB.elements();
    }

    public static Enumeration bedingungen() {
        return BB.dataObjects();
    }

    public static Enumeration homogenisierungRisse() {
        return BH.elements();
    }

    public static Enumeration homogenisierungen() {
        return BH.dataObjects();
    }

    public static Enumeration allBedingungen() {
        return new BedingungEnumerator();
    }

    public static Enumeration trafoRisse() {
        return T.elements();
    }

    public static Enumeration trafoPunkte() {
        return T.dataObjects();
    }

    public static Enumeration flurstuecke() {
        return FLST.elements();
    }

    public static Enumeration nutzungen() {
        return NUTZ.elements();
    }

    public static Enumeration bodenObjekte() {
        return BODEN.elements();
    }

    public static Enumeration gebaeude() {
        return GEB.elements();
    }

    public static Enumeration topObjekte() {
        return TOP.elements();
    }

    public static Enumeration objekte() {
        return new ObjektEnumerator();
    }

    public static Enumeration bestaende() {
        return BUCH.elements();
    }

    public static Enumeration flurstueckLinien() {
        return FLST.dataObjects();
    }

    public static Enumeration gebaeudeLinien() {
        return GEB.dataObjects();
    }

    public static Enumeration nutzungLinien() {
        return NUTZ.dataObjects();
    }

    public static Enumeration bodenLinien() {
        return BODEN.dataObjects();
    }

    public static Enumeration topLinien() {
        return TOP.dataObjects();
    }

    public static Enumeration images() {
        return IMG.elements();
    }

    public static Enumeration errors() {
        return ERR.elements();
    }

    public static Enumeration elementsOf(Object object) {
        if (object instanceof Flurstueck) {
            return DataBase.flurstuecke();
        }
        if (object instanceof Gebaeude) {
            return DataBase.gebaeude();
        }
        if (object instanceof TopObject) {
            return DataBase.topObjekte();
        }
        if (object instanceof GeoImage) {
            return DataBase.images();
        }
        if (object instanceof Messung) {
            return DataBase.messungen();
        }
        if (object instanceof Bedingung) {
            return DataBase.allBedingungen();
        }
        if (object instanceof Punkt) {
            return DataBase.punkte();
        }
        if (object instanceof ErrorObject) {
            return DataBase.errors();
        }
        return new VoidEnumerator();
    }

    public boolean containsIgnoreArt(Linie linie) {
        Enumeration enumeration = DataBase.flurstueckLinien();
        while (enumeration.hasMoreElements()) {
            if (!((Linie)enumeration.nextElement()).equalsIgnoreArt(linie)) continue;
            return true;
        }
        enumeration = DataBase.gebaeudeLinien();
        while (enumeration.hasMoreElements()) {
            if (!((Linie)enumeration.nextElement()).equalsIgnoreArt(linie)) continue;
            return true;
        }
        enumeration = DataBase.topLinien();
        while (enumeration.hasMoreElements()) {
            if (!((Linie)enumeration.nextElement()).equalsIgnoreArt(linie)) continue;
            return true;
        }
        return false;
    }

    public Hashtable getLinien() {
        Linie linie;
        Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
        Enumeration enumeration = DataBase.flurstueckLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneHashKey(), linie);
        }
        enumeration = DataBase.gebaeudeLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneHashKey(), linie);
        }
        enumeration = DataBase.topLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneHashKey(), linie);
        }
        return hashtable;
    }

    public Hashtable getOskaLinien() {
        Linie linie;
        Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
        Enumeration enumeration = DataBase.flurstueckLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneOskaHashKey(), linie);
        }
        enumeration = DataBase.gebaeudeLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneOskaHashKey(), linie);
        }
        enumeration = DataBase.topLinien();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            hashtable.put(linie.getArtEbeneOskaHashKey(), linie);
        }
        return hashtable;
    }

    public LinieSearchTable getGrenzen(Punkt punkt) {
        LinieSearchTable linieSearchTable = new LinieSearchTable();
        Enumeration enumeration = DataBase.flurstueckLinien();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pe == null || linie.getLa() != 2 || !linie.contains(punkt)) continue;
            linieSearchTable.put(linie.getArtHashKey(), linie);
        }
        return linieSearchTable;
    }

    public LinieSearchTable getGebaeudeLinien(Punkt punkt) {
        LinieSearchTable linieSearchTable = new LinieSearchTable();
        Enumeration enumeration = DataBase.gebaeudeLinien();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pe == null || linie.getLa() != 3 || !linie.contains(punkt)) continue;
            linieSearchTable.put(linie.getArtHashKey(), linie);
        }
        return linieSearchTable;
    }

    public static Vector getRequiredObjects(Bedingung bedingung, boolean bl) {
        Vector<Bedingung> vector = new Vector<Bedingung>();
        switch (bedingung.ba) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                vector.addElement(bedingung);
                return vector;
            }
            case 0: 
            case 9: {
                if (bl && bedingung.getReferenz() != null) {
                    vector.addElement(bedingung.getReferenz());
                }
                vector.addElement(bedingung);
                return vector;
            }
            case 3: 
            case 6: {
                return DataBase.getRequiredObjects(bedingung);
            }
        }
        vector.addElement(bedingung);
        return vector;
    }

    public static Vector getRequiredObjects(Messung messung, boolean bl) {
        Vector<Messung> vector = new Vector<Messung>();
        switch (messung.getMessungsArt()) {
            case 220: {
                vector.addElement(messung);
                return vector;
            }
            case 200: 
            case 240: {
                if (bl) {
                    Messung messung2 = messung.getReferenz();
                    if (messung2 != null) {
                        vector.addElement(messung2);
                        vector.addElement(messung);
                        if (messung2.getReferenz() != null) {
                            vector.addElement(messung2.getReferenz());
                        }
                    }
                } else {
                    vector.addElement(messung);
                }
                return vector;
            }
            case 260: {
                vector.addElement(messung);
                if (messung.getReferenz() != null) {
                    vector.addElement(messung.getReferenz());
                }
                return vector;
            }
            case 210: {
                if (bl) {
                    vector.addElement(messung);
                    if (messung.getReferenz() != null) {
                        vector.addElement(messung.getReferenz());
                    }
                    return vector;
                }
                return DataBase.getRequiredObjects(messung);
            }
            case 290: {
                if (bl) {
                    if (messung.getReferenz() != null) {
                        vector.addElement(messung.getReferenz());
                    }
                    vector.addElement(messung);
                    return vector;
                }
                return DataBase.getRequiredObjects(messung.getReferenz());
            }
            case 230: 
            case 270: 
            case 280: {
                if (bl) {
                    if (messung.getReferenz() != null) {
                        vector.addElement(messung.getReferenz());
                    }
                    vector.addElement(messung);
                    return vector;
                }
                if (messung.getReferenz() != null) {
                    vector.addElement(messung);
                    return vector;
                }
                return DataBase.getRequiredObjects(messung);
            }
        }
        vector.addElement(messung);
        return vector;
    }

    private static Vector getRequiredObjects(Bedingung bedingung) {
        Vector vector = null;
        vector = DataBase.getRequiredObjects(bedingung, (DataContainerTable)BB);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(bedingung, (DataContainerTable)BH);
        if (vector != null) {
            return vector;
        }
        return vector;
    }

    private static Vector getRequiredObjects(Messung messung) {
        Vector vector = null;
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)MG);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)MP);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)MM);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)MK);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)ME);
        if (vector != null) {
            return vector;
        }
        vector = DataBase.getRequiredObjects(messung, (DataContainerTable)MV);
        if (vector != null) {
            return vector;
        }
        return vector;
    }

    private static Vector getRequiredObjects(Messung messung, DataContainerTable dataContainerTable) {
        Vector vector = null;
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            vector = DataBase.getRequiredObjects(messung, (Riss)enumeration.nextElement());
            if (vector == null) continue;
            return vector;
        }
        return vector;
    }

    private static Vector getRequiredObjects(Bedingung bedingung, DataContainerTable dataContainerTable) {
        Vector vector = null;
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            vector = DataBase.getRequiredObjects(bedingung, (Riss)enumeration.nextElement());
            if (vector == null) continue;
            return vector;
        }
        return vector;
    }

    private static Vector getRequiredObjects(Bedingung bedingung, Riss riss) {
        Vector<Bedingung> vector = null;
        block12: for (int i = 0; i < riss.size(); ++i) {
            Bedingung bedingung2 = (Bedingung)riss.elementAt(i);
            if (bedingung2 != bedingung) continue;
            int n = bedingung2.ba;
            switch (n) {
                case 3: {
                    Bedingung bedingung3;
                    int n2;
                    vector = new Vector<Bedingung>();
                    vector.addElement(bedingung2);
                    for (n2 = i + 1; n2 < riss.size(); ++n2) {
                        bedingung3 = (Bedingung)riss.elementAt(n2);
                        switch (bedingung3.ba) {
                            case 3: {
                                return vector;
                            }
                            case 0: {
                                vector.addElement(bedingung3);
                            }
                        }
                    }
                }
                case 6: {
                    Bedingung bedingung3;
                    int n2;
                    vector = new Vector();
                    vector.addElement(bedingung2);
                    for (n2 = i + 1; n2 < riss.size(); ++n2) {
                        bedingung3 = (Bedingung)riss.elementAt(n2);
                        switch (bedingung3.ba) {
                            case 6: {
                                return vector;
                            }
                            case 9: {
                                vector.addElement(bedingung3);
                            }
                        }
                    }
                    continue block12;
                }
            }
        }
        return vector;
    }

    private static Vector getRequiredObjects(Messung messung, Riss riss) {
        Vector<Messung> vector = null;
        block8: for (int i = 0; i < riss.size(); ++i) {
            Messung messung2 = (Messung)riss.elementAt(i);
            if (messung2 != messung) continue;
            int n = messung2.getMessungsArt();
            switch (n) {
                case 210: {
                    Messung messung3;
                    int n2;
                    vector = new Vector<Messung>();
                    vector.addElement(messung2);
                    block9: for (n2 = i + 1; n2 < riss.size(); ++n2) {
                        messung3 = (Messung)riss.elementAt(n2);
                        switch (messung3.getMessungsArt()) {
                            case 200: 
                            case 240: {
                                vector.addElement(messung3);
                                continue block9;
                            }
                            case 290: {
                                vector.addElement(messung3);
                                return vector;
                            }
                        }
                    }
                    continue block8;
                }
                case 230: 
                case 270: 
                case 280: {
                    Messung messung3;
                    int n2;
                    vector = new Vector();
                    vector.addElement(messung2);
                    for (n2 = i + 1; n2 < riss.size(); ++n2) {
                        messung3 = (Messung)riss.elementAt(n2);
                        if (messung3.getMessungsArt() != n) continue;
                        if (messung2.ps == null) {
                            vector.addElement(messung3);
                            continue;
                        }
                        return vector;
                    }
                    continue block8;
                }
            }
        }
        return vector;
    }

    public void removeMessungen(Vector vector) {
        MG.removeData(vector);
        MP.removeData(vector);
        MM.removeData(vector);
        MK.removeData(vector);
        ME.removeData(vector);
        MV.removeData(vector);
    }

    public void removeBedingungen(Vector vector) {
        BH.removeData(vector);
        BB.removeData(vector);
    }

    public static void removeBestimmungen(PunktTable punktTable) {
        DataBase.removeBestimmungen(punktTable, MG);
        DataBase.removeBestimmungen(punktTable, MP);
        DataBase.removeBestimmungen(punktTable, MM);
        DataBase.removeBestimmungen(punktTable, MK);
        DataBase.removeBestimmungen(punktTable, ME);
        DataBase.removeBestimmungen(punktTable, MV);
        DataBase.removeBestimmungen(punktTable, T);
        DataBase.removeBestimmungen(punktTable, BB);
        DataBase.removeBestimmungen(punktTable, BH);
    }

    private static void removeBestimmungen(PunktTable punktTable, DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            int n;
            ValueDataContainer valueDataContainer;
            Object e = enumeration.nextElement();
            if (e instanceof Riss) {
                valueDataContainer = (Riss)e;
                if (valueDataContainer.getTyp() == 1) {
                    for (n = valueDataContainer.size() - 1; n >= 0; --n) {
                        cloneable = (Messung)valueDataContainer.elementAt(n);
                        switch (((Messung)cloneable).getMessungsArt()) {
                            default: 
                        }
                        if (((Messung)cloneable).ps != null && !punktTable.contains(((Messung)cloneable).ps) || ((Messung)cloneable).pz != null && !punktTable.contains(((Messung)cloneable).pz)) continue;
                        valueDataContainer.removeElementAt(n);
                    }
                    continue;
                }
                if (valueDataContainer.getTyp() != 6) continue;
                for (n = valueDataContainer.size() - 1; n >= 0; --n) {
                    cloneable = (Bedingung)valueDataContainer.elementAt(n);
                    switch (((Bedingung)cloneable).ba) {
                        default: 
                    }
                    if (((Bedingung)cloneable).p1 != null && !punktTable.contains(((Bedingung)cloneable).p1) && ((Bedingung)cloneable).p2 != null && !punktTable.contains(((Bedingung)cloneable).p2) && ((Bedingung)cloneable).p3 != null && !punktTable.contains(((Bedingung)cloneable).p3)) continue;
                    valueDataContainer.removeElementAt(n);
                }
                continue;
            }
            if (!(e instanceof TrafoSystem)) continue;
            valueDataContainer = (TrafoSystem)e;
            for (n = valueDataContainer.size() - 1; n >= 0; --n) {
                cloneable = ((TrafoPunkt)valueDataContainer.elementAt(n)).getPunkt();
                if (!punktTable.containsKey(((Punkt)cloneable).nr)) continue;
                valueDataContainer.removeElementAt(n);
            }
        }
    }

    static {
        maxStat = new Stat4(null, null);
        nutzVersion = 0;
        KPG = 0.03;
        KAPG = 0.08;
        KFPG = 0.02;
        maxEinrechenDistance = 0.04;
        maxLinieDistance = 0.001;
        projektDate = new GregorianCalendar();
        model = Alkis.getInstance();
        kooSystem = -1;
        numSystem = -1;
        dbListeners = new Vector();
        isWork = false;
        instance = new DataBase(1);
    }
}

