/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IProgressElement;
import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.GeomException;
import de.geocalc.geom.GeomGrid;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Hoehe;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieSearchTable;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.CountTable;
import de.geocalc.util.LongHashList;
import de.geocalc.util.LongHashObject;
import java.awt.Label;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataBaseChecker
extends IProgressElement {
    private static final int BREAKER = 2;
    private static int errors = 0;
    private DataBase db;
    boolean saveErrors = true;
    private static Hashtable pa2 = new Hashtable();
    private static Hashtable pa3 = new Hashtable();
    private ExceptionList exceptions;
    public static boolean checkNummer = true;
    public static boolean checkAufnahme = true;
    public static boolean checkConfig = true;
    public static boolean checkKatNachw = true;
    public static boolean checkPunktLage = true;
    public static boolean checkArt = true;
    public static boolean checkTeilung = true;
    public static boolean checkObjGeom = true;
    public static boolean checkObjAtt = true;
    public static boolean useGewichte = KatasternachweisIOProperties.USE_GEWICHTE;
    public static boolean checkNummerId = true;
    public static boolean checkNummerNb = true;
    public static boolean checkUmnum = true;
    public static boolean checkAufnahmeGpsLage = true;
    public static boolean checkAufnahmePolLage = true;
    public static boolean checkAufnahmeNivHoehe = true;
    public static boolean checkAufnahmePolHoehe = true;
    public static boolean checkWithDigit = false;
    public static boolean checkWithBedGerade = false;
    public static boolean checkConfigDefects = true;
    public static boolean checkConfigNoBerBeob = true;
    public static boolean checkMarkKatPoint = false;
    public static boolean checkMarkLokPoint = false;
    public static boolean checkConfigNoBerMenge = false;
    public static boolean checkConfigBerMenge = false;
    public static boolean checkLagegenauigkeit = true;
    public static boolean checkKatAufnahme = true;
    public static boolean checkKontrolliertheit = true;
    public static boolean checkLageabweichung = true;
    public static boolean checkFestpunkte = true;
    public static boolean checkLG = true;
    public static boolean checkLgLzk = true;
    public static boolean checkGrenzpunktArt = true;
    public static boolean checkUmringArt = true;
    public static boolean checkPointOska = true;
    public static boolean checkLineOska = true;
    public static boolean checkFlstUmring = true;
    public static boolean checkLineLength = true;
    public static boolean checkFlstSchleife = true;
    public static boolean checkFreiePunkte = true;
    public static boolean checkFlaecheSumme = true;
    public static boolean checkObjectKoo = true;
    public static boolean checkUeberbau = true;
    public static boolean checkMultiArea = true;
    public static boolean checkBuchArea = true;
    public static boolean checkAlb = false;
    public static boolean checkGebSoll = false;
    public static boolean checkFlstNutzung = true;
    public static boolean checkFlstLagebez = true;
    public static boolean checkGebNutzung = true;
    public static boolean checkGebPseudo = true;
    public static boolean checkGebLage = true;
    public static boolean checkStrassenland = true;
    public static int nummerMode = 0;
    public static int checkAufnahmeLageCount = 1;
    public static int checkAufnahmeHoeheCount = 2;
    public static int flstNutzungUnderGroup = 0;
    public static int minBuchArea = 50;
    public static int maxBuchArea = 200;
    public static double minLineLength = 0.01;
    public static double minAufnahmeLLsp = 0.02;
    public static double maxAufnahmeLLsp = 0.02;
    public static double minAufnahmeHLsp = 0.01;
    public static double maxAufnahmeHLsp = 0.01;

    public static void loadPaOskas(int n, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Integer n2 = new Integer(string2);
                if (n == 2) {
                    pa2.put(n2, n2);
                    continue;
                }
                pa3.put(n2, n2);
            }
            catch (Exception exception) {
                throw new IOException("Token " + string2 + " ist nicht numerisch");
            }
        }
    }

    public DataBaseChecker(DataBase dataBase) {
        this(dataBase, null, null);
    }

    public DataBaseChecker(DataBase dataBase, IProgressBar iProgressBar, Label label) {
        super(iProgressBar, label);
        this.db = dataBase;
    }

    public void setExceptionList(ExceptionList exceptionList) {
        this.exceptions = exceptionList;
    }

    public ExceptionList getExceptionList() {
        return this.exceptions;
    }

    private String createBemerkung(Punkt punkt, double d, double d2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("\n");
        if (punkt != null && punkt.nr != 0L) {
            stringBuffer.append("Punkt: " + punkt.nr);
        }
        stringBuffer.append("\n");
        stringBuffer.append("D: ");
        stringBuffer.append(GeoNumberFormat.m03.format(d));
        stringBuffer.append(" (");
        stringBuffer.append(GeoNumberFormat.m03.format(d2));
        stringBuffer.append(" zul.)");
        return stringBuffer.toString();
    }

    private String createBemerkung(Punkt punkt, Punkt punkt2, double d, double d2, double d3, Riss riss, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("\n");
        if (punkt != null && punkt.nr != 0L) {
            stringBuffer.append("Punkt: " + punkt.nr);
        }
        if (punkt2 != null && punkt2.nr != 0L) {
            stringBuffer.append(" - Punkt: " + punkt2.nr);
        }
        if (riss != null) {
            stringBuffer.append("\nRiss: ");
            stringBuffer.append(riss.getName());
        }
        stringBuffer.append("\ngem: " + GeoNumberFormat.m03.format(d));
        stringBuffer.append("  ger: " + GeoNumberFormat.m03.format(d2));
        stringBuffer.append("\nDiff: " + GeoNumberFormat.m03.format(d - d2));
        stringBuffer.append(" (" + GeoNumberFormat.m03.format(d3) + " zul.)");
        return stringBuffer.toString();
    }

    public boolean checkNummer() {
        Object object;
        Object object2;
        this.resetErrors();
        this.setBorderValues(0L, 2 * DataBase.P.size());
        this.showProgress(false);
        int n = 0;
        int n2 = Math.max(DataBase.P.size() / 100, 2);
        if (checkNummerId) {
            object2 = new Hashtable();
            object = DataBase.P.elements();
            while (object.hasMoreElements()) {
                Punkt punkt = (Punkt)object.nextElement();
                Long l = new Long(punkt.buildKatNr(nummerMode, checkUmnum ? punkt.getNr() : punkt.nr));
                Punkt punkt2 = (Punkt)((Hashtable)object2).get(l);
                if (punkt2 != null) {
                    this.addError(new GeomException(punkt, new DLine(punkt2, punkt), "Die Ausgabenummer " + l + " wurde aus verschiedenen Auftragspunkten erzeugt: " + punkt2.nr + ", " + punkt.nr));
                } else {
                    ((Hashtable)object2).put(l, punkt);
                }
                if (++n % n2 != 0) continue;
                this.showProgress(n);
            }
            ((Hashtable)object2).clear();
        }
        if (checkNummerNb) {
            object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                object = (Punkt)object2.nextElement();
                if (((Punkt)object).getPa() <= 0 || ((Punkt)object).getPa() > 8) continue;
                long l = ((Punkt)object).buildKatNr(nummerMode, checkUmnum ? ((Punkt)object).getNr() : ((Punkt)object).nr);
                int n3 = (int)(l / 1000000L);
                if (n3 > 100000000) {
                    n3 %= 100000000;
                }
                if (n3 <= 0) continue;
                if (n3 < 100) {
                    if (n3 != ((Punkt)object).getNb2()) {
                        this.addError(new GeomException((DPoint)object, (GeomElement)object, "Der errechnete Nummerierungsbezirk " + ((Punkt)object).getNb2() + " ist nicht identisch mit dem NB der Punktnummer " + n3));
                    }
                } else if (n3 < 10000) {
                    if (n3 != ((Punkt)object).getNb4()) {
                        this.addError(new GeomException((DPoint)object, (GeomElement)object, "Der errechnete Nummerierungsbezirk " + ((Punkt)object).getNb4() + " ist nicht identisch mit dem NB der Punktnummer " + n3));
                    }
                } else if (n3 < 100000000 && n3 != ((Punkt)object).getNb8() && n3 != ((Punkt)object).getNb8Alk()) {
                    this.addError(new GeomException((DPoint)object, (GeomElement)object, "Der errechnete Nummerierungsbezirk " + ((Punkt)object).getNb8() + " ist nicht identisch mit dem NB der Punktnummer " + n3));
                }
                if (++n % n2 != 0) continue;
                this.showProgress(n);
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    public boolean checkAufnahme() {
        int n;
        this.resetErrors();
        int n2 = 0;
        if (checkAufnahmeGpsLage) {
            n2 += DataBase.MG.size();
        }
        if (checkAufnahmePolLage) {
            n2 += DataBase.MP.size();
        }
        if (checkAufnahmeNivHoehe) {
            n2 += DataBase.HN.size();
        }
        if (checkAufnahmePolHoehe) {
            n2 += DataBase.HP.size();
        }
        this.setBorderValues(0L, n2);
        this.showProgress(false);
        int n3 = 0;
        int n4 = Math.max(n2 / 20, 2);
        if (checkAufnahmeGpsLage) {
            n = 0;
            while (true) {
                if (n3 >= DataBase.MG.size()) break;
                this.checkAufnahmeLageRiss((Riss)DataBase.MG.elementAt(n), 1);
                ++n;
                ++n3;
            }
        }
        if (checkAufnahmePolLage) {
            n = 0;
            while (true) {
                if (n3 >= DataBase.MP.size()) break;
                this.checkAufnahmeLageRiss((Riss)DataBase.MP.elementAt(n), 2);
                ++n;
                ++n3;
            }
        }
        if (checkAufnahmeNivHoehe) {
            n = 0;
            while (true) {
                if (n3 >= DataBase.HN.size()) break;
                this.checkAufnahmeHoeheRiss((Riss)DataBase.HN.elementAt(n), 1);
                ++n;
                ++n3;
            }
        }
        if (checkAufnahmePolHoehe) {
            n = 0;
            while (true) {
                if (n3 >= DataBase.HP.size()) break;
                this.checkAufnahmeHoeheRiss((Riss)DataBase.HP.elementAt(n), 1);
                ++n;
                ++n3;
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void addAufnahmeErr(Punkt punkt, String string, int n, String string2) {
        this.addError(new GeomException(punkt, punkt, "Riss: " + string + ",\n Der Standpunkt " + punkt.nr + " hat " + (String)(n <= 0 ? "keine " : "nur " + n) + " " + string2 + "kontrolle"));
    }

    private void checkAufnahmeLageRiss(Riss riss, int n) {
        Punkt punkt = null;
        int n2 = -n;
        int n3 = 0;
        for (int i = 0; i < riss.size(); ++i) {
            Messung messung = (Messung)riss.elementAt(i);
            if (messung.ps != null) {
                if (punkt != null && n2 < checkAufnahmeLageCount && n3 > 0) {
                    this.addAufnahmeErr(punkt, riss.getName(), n2, "Lage");
                }
                n2 = -n;
                n3 = 0;
                punkt = messung.ps;
                if (punkt.getPs() == 1 || punkt.lsp > 0.0f && (double)punkt.lsp < minAufnahmeLLsp) {
                    ++n2;
                }
            }
            if (messung.pz == null || !messung.isOn()) continue;
            if (messung.getWerteBelegung() == 3 && messung.pz.lsp > 0.0f && (double)messung.pz.lsp < minAufnahmeLLsp) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (punkt != null && n2 < checkAufnahmeLageCount && n3 > 0) {
            this.addAufnahmeErr(punkt, riss.getName(), n2, "Lage");
        }
    }

    private void checkAufnahmeHoeheRiss(Riss riss, int n) {
        Punkt punkt = null;
        int n2 = -n;
        int n3 = 0;
        for (int i = 0; i < riss.size(); ++i) {
            Hoehe hoehe = (Hoehe)riss.elementAt(i);
            if (hoehe.ps != null) {
                if (punkt != null && n2 < checkAufnahmeHoeheCount && n3 > 0) {
                    this.addAufnahmeErr(punkt, riss.getName(), n2, "H\u00f6hen");
                }
                n2 = -n;
                n3 = 0;
                punkt = hoehe.ps;
                if (punkt.lhsp > 0.0f && (double)punkt.lhsp < minAufnahmeHLsp) {
                    ++n2;
                }
            }
            if (hoehe.pz == null || !hoehe.isOn()) continue;
            if (hoehe.pz.lhsp > 0.0f && (double)hoehe.pz.lhsp < minAufnahmeHLsp) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (punkt != null && n2 < checkAufnahmeHoeheCount && n3 > 0) {
            this.addAufnahmeErr(punkt, riss.getName(), n2, "H\u00f6hen");
        }
    }

    public boolean checkConfig() {
        Object object;
        Enumeration enumeration;
        boolean bl = false;
        this.resetErrors();
        this.setBorderValues(0L, 100L);
        this.showProgress(false);
        int n = Math.max(DataBase.P.size() / 100, 2);
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration2 = DataBase.P.elements();
        while (enumeration2.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration2.nextElement();
            if (!punkt.isOn() || punkt.getPs() != 1 && punkt.getPs() != 2) continue;
            punktTable.put(punkt);
        }
        int n2 = 0;
        int n3 = 5;
        this.showProgress(n3);
        if (checkConfigDefects) {
            DataBaseChecker dataBaseChecker = this;
            enumeration = dataBaseChecker.db.messRisse();
            while (enumeration.hasMoreElements()) {
                this.checkMessDefects((Riss)enumeration.nextElement());
            }
            n3 += 5;
        }
        this.showProgress(n3);
        do {
            enumeration = new Hashtable();
            n2 = 0;
            DataBaseChecker dataBaseChecker = this;
            object = dataBaseChecker.db.messRisse();
            while (object.hasMoreElements()) {
                n2 += this.checkMessConfig((Riss)object.nextElement(), punktTable, (Hashtable)((Object)enumeration));
            }
            if (checkWithBedGerade) {
                DataBaseChecker dataBaseChecker2 = this;
                object = dataBaseChecker2.db.allBedingungRisse();
                while (object.hasMoreElements()) {
                    n2 += this.checkBedConfig((Riss)object.nextElement(), punktTable, (Hashtable)((Object)enumeration));
                }
            }
            this.showProgress(n3 += 5);
            object = DataBase.T.elements();
            while (object.hasMoreElements()) {
                n2 += this.checkTrafoConfig((TrafoSystem)object.nextElement(), punktTable);
            }
            this.showProgress(n3 += 5);
            if (n3 < 80) continue;
            n3 = 0;
        } while (n2 > 0);
        this.showProgress(80L);
        if (checkConfigNoBerBeob) {
            DataBaseChecker dataBaseChecker = this;
            enumeration = dataBaseChecker.db.messRisse();
            while (enumeration.hasMoreElements()) {
                this.markMessConfig((Riss)enumeration.nextElement(), punktTable);
            }
            this.showProgress(85L);
            enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                this.markTrafoConfig((TrafoSystem)enumeration.nextElement(), punktTable);
            }
            this.showProgress(90L);
            DataBaseChecker dataBaseChecker3 = this;
            enumeration = dataBaseChecker3.db.allBedingungRisse();
            while (enumeration.hasMoreElements()) {
                this.markBedingungConfig((Riss)enumeration.nextElement(), punktTable);
            }
        }
        this.showProgress(95L);
        enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            object = (Punkt)enumeration.nextElement();
            if (!((Punkt)object).isOn()) continue;
            if (punktTable.contains((LongHashObject)object)) {
                if (!checkConfigBerMenge) continue;
                DataBase.MENGE.put((LongHashObject)object);
                continue;
            }
            if (((Punkt)object).isKatasterPunkt()) {
                if (checkMarkKatPoint) {
                    this.addError(new GeomException((DPoint)object, (GeomElement)object, "Katasterpunkt " + ((Punkt)object).nr + " nicht berechenbar"));
                }
            } else if (checkMarkLokPoint) {
                this.addError(new GeomException((DPoint)object, (GeomElement)object, "Punkt " + ((Punkt)object).nr + " nicht berechenbar"));
            }
            if (!checkConfigNoBerMenge) continue;
            DataBase.MENGE.put((LongHashObject)object);
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void checkMessDefects(Riss riss) {
        Punkt punkt = null;
        Punkt punkt2 = null;
        Punkt punkt3 = null;
        boolean bl = true;
        Enumeration enumeration = riss.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Messung messung = (Messung)enumeration.nextElement();
            if (!messung.isOn() || messung.isFehler()) continue;
            int n = messung.getMessungsArt();
            if (n == 210) {
                punkt = messung.pz != null ? messung.pz : messung.ps;
                cloneable = messung.getReferenz();
                Punkt punkt4 = punkt2 = ((Messung)cloneable).pz != null ? ((Messung)cloneable).pz : ((Messung)cloneable).ps;
            }
            if ((n == 210 || n == 200 || n == 290) && messung.l2 != 0.0) {
                double d = DLine.getDistance(punkt, punkt2, messung.ps);
                if (!(messung.l2 > 0.0 && d < 0.0) && (!(messung.l2 < 0.0) || !(d > 0.0))) continue;
                this.addError(new GeomException(DPoint.getMiddle(messung.pz, messung.ps), new DLine(messung.pz, messung.ps), "Konfigurationsdefekt: Ordinate " + IFormat.f_2.format(messung.l2) + " hat umgekehrtes Vorzeichen zum Istwert"));
                continue;
            }
            if (n != 260) continue;
            if (bl) {
                double d;
                cloneable = messung.pz;
                Punkt punkt5 = messung.ps;
                Punkt punkt6 = messung.getReferenz().ps;
                punkt3 = messung.pz;
                double d2 = DLine.getDistance(punkt5, punkt6, (DPoint)((Object)cloneable));
                if (d2 < 0.0) {
                    DCollection dCollection = new DCollection();
                    dCollection.addElement(new DLine(punkt5, (DPoint)((Object)cloneable)));
                    dCollection.addElement(new DLine(punkt6, (DPoint)((Object)cloneable)));
                    this.addError(new GeomException((DPoint)((Object)cloneable), dCollection, "Konfigurationsdefekt: Bogenschnitt " + punkt5.nr + "-" + ((Punkt)cloneable).nr + "-" + punkt6.nr + " ist linksseitig"));
                }
                if ((d = Math.abs(((DPoint)((Object)cloneable)).getAngle(punkt5, punkt6))) < 0.47123889803846897 || d > 2.670353755551324) {
                    DCollection dCollection = new DCollection();
                    dCollection.addElement(new DLine(punkt5, (DPoint)((Object)cloneable)));
                    dCollection.addElement(new DLine(punkt6, (DPoint)((Object)cloneable)));
                    this.addError(new GeomException((DPoint)((Object)cloneable), dCollection, "ung\u00fcnstige Konfiguration: Bogenschnitt " + punkt5.nr + "-" + ((Punkt)cloneable).nr + "-" + punkt6.nr + " hat ung\u00fcnstigen Schnitt"));
                }
            } else if (messung.pz != punkt3) {
                this.addError(new GeomException(messung.pz, new DLine(messung.pz, punkt3), "Konfigurationsdefekt: Bogenschnitte zu den Punkten  " + messung.pz.nr + " und " + punkt3.nr + " nicht in richtiger Abfolge eingegeben"));
            }
            bl = !bl;
        }
    }

    private void markMessConfig(Riss riss, PunktTable punktTable) {
        boolean bl = false;
        boolean bl2 = false;
        block6: for (int i = 0; i < riss.size(); ++i) {
            Messung messung = (Messung)riss.elementAt(i);
            if (!messung.isOn()) continue;
            int n = messung.getMessungsArt(true);
            switch (n) {
                case 230: {
                    if (messung.ps != null && !(bl = punktTable.contains(messung.ps))) {
                        this.addError(new GeomException(messung.ps, messung.ps, riss.toDebugString() + ", Polarstandpunkt " + messung.ps.nr + " nicht berechenbar"));
                    }
                    if (!bl || punktTable.contains(messung.pz)) continue block6;
                    this.addError(new GeomException(messung.pz, new DLine(messung.pz, messung.getReferenz() != null ? messung.getReferenz().ps : messung.ps), riss.toDebugString() + ", " + messung.getExceptionableName() + " nicht berechenbar"));
                    continue block6;
                }
                case 210: {
                    Punkt punkt = messung.pz != null && messung.pz.nr > 0L ? messung.pz : messung.ps;
                    Punkt punkt2 = messung.getReferenz().pz != null && messung.getReferenz().pz.nr > 0L ? messung.getReferenz().pz : messung.getReferenz().ps;
                    boolean bl3 = bl2 = punktTable.contains(punkt) && punktTable.contains(punkt2);
                    if (!bl2) {
                        this.addError(new GeomException(DPoint.getMiddle(messung.pz != null ? messung.pz : messung.ps, messung.getReferenz().pz != null ? messung.getReferenz().pz : messung.getReferenz().ps), new DLine(messung.pz != null ? messung.pz : messung.ps, messung.getReferenz().pz != null ? messung.getReferenz().pz : messung.getReferenz().ps), riss.toDebugString() + ", Ortholinie " + punkt.nr + " - " + punkt2.nr + " nicht berechenbar"));
                    }
                }
                case 200: {
                    if (!bl2 || punktTable.contains(messung.ps)) continue block6;
                    this.addError(new GeomException(messung.ps, messung.pz != null ? new DLine(messung.ps, messung.pz) : messung.ps, riss.toDebugString() + ", " + messung.getExceptionableName() + " nicht berechenbar"));
                    continue block6;
                }
                case 290: {
                    if (bl2 && !punktTable.contains(messung.ps)) {
                        this.addError(new GeomException(messung.ps, messung.pz != null ? new DLine(messung.ps, messung.pz) : messung.ps, riss.toDebugString() + ", " + messung.getExceptionableName() + " nicht berechenbar"));
                    }
                    bl2 = false;
                    continue block6;
                }
                default: {
                    Punkt punkt = messung.getP1();
                    Punkt punkt3 = messung.getP2();
                    if ((punkt == null || punktTable.contains(punkt)) && (punkt3 == null || punktTable.contains(punkt3))) continue block6;
                    this.addError(new GeomException(punkt != null && punkt3 != null ? DPoint.getMiddle(punkt, punkt3) : (punkt3 != null ? punkt3 : punkt), punkt3 != null ? new DLine(punkt, punkt3) : punkt, riss.toDebugString() + ", " + messung.getExceptionableName() + " nicht berechenbar"));
                }
            }
        }
    }

    private void markTrafoConfig(TrafoSystem trafoSystem, PunktTable punktTable) {
        if (trafoSystem.getRissInfo().getTyp() == 9 && !checkWithDigit) {
            return;
        }
        Enumeration enumeration = trafoSystem.elements();
        while (enumeration.hasMoreElements()) {
            TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
            if (!trafoPunkt.isOn() || punktTable.contains(trafoPunkt.getPunkt())) continue;
            this.addError(new GeomException(trafoPunkt.getPunkt(), trafoSystem.getBounds(), "Punkt " + trafoPunkt.getPunkt().nr + " im " + trafoSystem.getExceptionableName() + " nicht berechenbar"));
        }
    }

    private void markBedingungConfig(Riss riss, PunktTable punktTable) {
        block6: for (int i = 0; i < riss.size(); ++i) {
            Bedingung bedingung = (Bedingung)riss.elementAt(i);
            if (!bedingung.isOn()) continue;
            switch (bedingung.ba) {
                case 0: 
                case 3: 
                case 5: {
                    if (punktTable.contains(bedingung.p1) && punktTable.contains(bedingung.p2)) continue block6;
                    this.addError(new GeomException(DPoint.getMiddle(bedingung.p1, bedingung.p2), new DLine(bedingung.p1, bedingung.p2), riss.toDebugString() + ", " + bedingung.getExceptionableName() + " nicht berechenbar"));
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (punktTable.contains(bedingung.p1) && punktTable.contains(bedingung.p2) && punktTable.contains(bedingung.p3)) continue block6;
                    this.addError(new GeomException(bedingung.p2, new DLine(bedingung.p1, bedingung.p3), riss.toDebugString() + ", " + bedingung.getExceptionableName() + " nicht berechenbar"));
                    continue block6;
                }
                case 4: 
                case 6: {
                    if (punktTable.contains(bedingung.p1) && punktTable.contains(bedingung.p2) && punktTable.contains(bedingung.p3)) continue block6;
                    this.addError(new GeomException(bedingung.p3, new DLine(bedingung.p1, bedingung.p3), riss.toDebugString() + ", " + bedingung.getExceptionableName() + " nicht berechenbar"));
                    continue block6;
                }
                case 9: {
                    if (punktTable.contains(bedingung.p1)) continue block6;
                    this.addError(new GeomException(bedingung.p1, bedingung.p1, riss.toDebugString() + ", " + bedingung.getExceptionableName() + " nicht berechenbar"));
                }
            }
        }
    }

    private int checkBedConfig(Riss riss, PunktTable punktTable, Hashtable hashtable) {
        int n = punktTable.size();
        Enumeration enumeration = riss.elements();
        while (enumeration.hasMoreElements()) {
            Bedingung bedingung = (Bedingung)enumeration.nextElement();
            if (!bedingung.isOn() || bedingung.ba != 1) continue;
            Schnitt schnitt = (Schnitt)hashtable.get(bedingung.getP2());
            if (schnitt == null) {
                schnitt = new Schnitt(this);
                schnitt.s = bedingung.getP2();
                schnitt.p1 = bedingung.getP1();
                schnitt.p2 = bedingung.getP3();
                hashtable.put(bedingung.getP2(), schnitt);
                continue;
            }
            if (schnitt.p3 != null || schnitt.p1 == bedingung.getP1() || schnitt.p2 == bedingung.getP1() || schnitt.p1 == bedingung.getP3() || schnitt.p2 == bedingung.getP3()) continue;
            schnitt.p3 = bedingung.getP1();
            schnitt.p4 = bedingung.getP3();
            punktTable.put(bedingung.getP2());
        }
        return punktTable.size() - n;
    }

    /*
     * Unable to fully structure code
     */
    private int checkMessConfig(Riss var1_1, PunktTable var2_2, Hashtable var3_3) {
        var4_4 = var2_2.size();
        var5_5 = false;
        var6_6 = false;
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        block8: for (var10_10 = 0; var10_10 < var1_1.size(); ++var10_10) {
            var11_11 = (Messung)var1_1.elementAt(var10_10);
            if (!var11_11.isOn() || var11_11.isFehler()) continue;
            var12_12 = var11_11.getMessungsArt();
            var13_13 = var11_11.getWerteBelegung();
            switch (var12_12) {
                case 230: {
                    if (var11_11.ps != null && (var5_5 = this.testPolarSystem(var1_1, var10_10, var2_2))) {
                        var2_2.put(var11_11.ps);
                    }
                    if (!var5_5 || var13_13 != 3) continue block8;
                    var2_2.put(var11_11.pz);
                    continue block8;
                }
                case 210: {
                    var6_6 = this.testOrthoSystem(var1_1, var10_10, var2_2);
                    var7_7 = null;
                    var8_8 = null;
                    var9_9 = var11_11;
                    if (var11_11.l2 == 0.0) {
                        var7_7 = var11_11.ps;
                    } else if (var11_11.pz != null && var11_11.pz.nr != 0L) {
                        var7_7 = var11_11.pz;
                    }
                    var14_14 = var11_11.getReferenz();
                    if (var14_14.l2 != 0.0) ** GOTO lbl35
                    var8_8 = var14_14.ps;
                    ** GOTO lbl37
lbl35:
                    // 1 sources

                    if (var14_14.pz != null && var14_14.pz.nr != 0L) {
                        var8_8 = var11_11.pz;
                    }
                }
lbl37:
                // 5 sources

                case 200: {
                    if (!var6_6) continue block8;
                    if (var13_13 >= 1) {
                        if (var11_11.pz != null && var11_11.pz.nr > 0L) {
                            var2_2.put(var11_11.pz);
                        }
                        if (var11_11.ps == null || var11_11.ps.nr <= 0L) continue block8;
                        var2_2.put(var11_11.ps);
                        continue block8;
                    }
                    if (var7_7 != null && var8_8 != null) {
                        var15_15 = (Schnitt)var3_3.get(var11_11.getP1());
                        if (var15_15 == null) {
                            var15_15 = new Schnitt(this);
                            var15_15.s = var11_11.getP1();
                            var15_15.p1 = var7_7;
                            var15_15.p2 = var8_8;
                            var3_3.put(var11_11.getP1(), var15_15);
                            continue block8;
                        }
                        if (var15_15.p3 != null || var15_15.p1 == var7_7 || var15_15.p2 == var7_7 || var15_15.p1 == var8_8 || var15_15.p2 == var8_8) continue block8;
                        var15_15.p3 = var7_7;
                        var15_15.p4 = var8_8;
                        var2_2.put(var11_11.ps);
                        continue block8;
                    }
                    if (var7_7 == null) {
                        this.addError(new GeomException(var11_11.ps, new DLine(var9_9.ps, var9_9.getReferenz().ps), "Fluchtpunkt " + var11_11.ps.nr + " ist in einer Ortholinie mit seitlichem Anfangsma\u00df enthalten, dort den Fu\u00dfpunkt setzen"));
                    }
                    if (var8_8 != null) continue block8;
                    this.addError(new GeomException(var11_11.ps, new DLine(var9_9.ps, var9_9.getReferenz().ps), "Fluchtpunkt " + var11_11.ps.nr + " ist in einer Ortholinie mit seitlichem Endma\u00df enthalten, dort den Fu\u00dfpunkt setzen"));
                    continue block8;
                }
                case 290: {
                    if (var6_6 && var13_13 >= 1) {
                        if (var11_11.pz != null && var11_11.pz.nr > 0L) {
                            var2_2.put(var11_11.pz);
                        }
                        if (var11_11.ps != null && var11_11.ps.nr > 0L) {
                            var2_2.put(var11_11.ps);
                        }
                    }
                    var6_6 = false;
                    continue block8;
                }
                case 240: {
                    if (!var6_6) continue block8;
                    var2_2.put(var11_11.ps);
                    continue block8;
                }
                case 260: {
                    if (!var2_2.contains(var11_11.ps) || !var2_2.contains(var11_11.getReferenz().ps)) continue block8;
                    var2_2.put(var11_11.pz);
                }
            }
        }
        return var2_2.size() - var4_4;
    }

    private boolean testPolarSystem(Riss riss, int n, PunktTable punktTable) {
        int n2 = 0;
        Messung messung = (Messung)riss.elementAt(n);
        if (messung.ps != null && punktTable.contains(messung.ps)) {
            ++n2;
        }
        if (messung.pz != null && messung.getWerteBelegung() == 3 && punktTable.contains(messung.pz)) {
            ++n2;
        }
        if (n2 >= 2) {
            return true;
        }
        ++n;
        while (n < riss.size()) {
            messung = (Messung)riss.elementAt(n);
            if (messung.isOn() && !messung.isFehler() && messung.getMessungsArt() == 230) {
                if (messung.ps != null) break;
                if (messung.pz != null && messung.getWerteBelegung() == 3 && punktTable.contains(messung.pz)) {
                    ++n2;
                }
                if (n2 >= 2) break;
            }
            ++n;
        }
        return n2 >= 2;
    }

    private boolean testOrthoSystem(Riss riss, int n, PunktTable punktTable) {
        int n2 = 0;
        while (n < riss.size()) {
            int n3;
            Messung messung = (Messung)riss.elementAt(n);
            if (messung.isOn() && !messung.isFehler() && ((n3 = messung.getMessungsArt()) == 210 || n3 == 200 || n3 == 290)) {
                if (messung.ps != null && punktTable.contains(messung.ps) || messung.pz != null && punktTable.contains(messung.pz)) {
                    ++n2;
                }
                if (n2 >= 2 || n3 == 290) break;
            }
            ++n;
        }
        return n2 >= 2;
    }

    private int checkTrafoConfig(TrafoSystem trafoSystem, PunktTable punktTable) {
        TrafoPunkt trafoPunkt;
        if (trafoSystem.getRissInfo().getTyp() == 9 && !checkWithDigit) {
            return 0;
        }
        int n = punktTable.size();
        int n2 = 0;
        Enumeration enumeration = trafoSystem.elements();
        while (enumeration.hasMoreElements()) {
            trafoPunkt = (TrafoPunkt)enumeration.nextElement();
            if (!trafoPunkt.isOn()) continue;
            if (punktTable.contains(trafoPunkt.getPunkt())) {
                n2 += 2;
            }
            if (n2 < 6) continue;
            break;
        }
        if (n2 >= trafoSystem.getParameter()) {
            enumeration = trafoSystem.elements();
            while (enumeration.hasMoreElements()) {
                trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                if (!trafoPunkt.isOn()) continue;
                punktTable.put(trafoPunkt.getPunkt());
            }
        }
        return punktTable.size() - n;
    }

    public boolean checkKatasterNachweis() {
        KatasterParameter.USE_GEWICHTE = useGewichte;
        this.resetErrors();
        this.setBorderValues(0L, DataBase.MK.size());
        this.showProgress(false);
        OrthoLinie orthoLinie = new OrthoLinie();
        int n = 0;
        int n2 = 0;
        int n3 = Math.max(DataBase.MK.size() / 100, 2);
        Enumeration enumeration = DataBase.MK.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            for (int i = 0; i < riss.size(); ++i) {
                Messung messung = (Messung)riss.elementAt(i);
                switch (messung.getMessungsArt()) {
                    case 240: {
                        double d = messung.l2;
                        messung = (Messung)messung.clone();
                        messung.l1 = d;
                        messung.l2 = 0.0;
                    }
                    case 220: 
                    case 260: {
                        double d = messung.l1 - DataBase.getStrecke(messung.ps, messung.pz);
                        double d2 = this.db.getKatasterStreckenGenauigkeit(messung.l1, messung.getGewichte().getG1());
                        if (!(d > d2)) break;
                        this.addError(new GeomException(DPoint.getMiddle(messung.ps, messung.pz), new DLine(messung.ps, messung.pz), this.createBemerkung(messung.ps, messung.pz, messung.l1, DataBase.getStrecke(messung.ps, messung.pz), d2, riss, "unzul.Streckenabweichung")));
                        break;
                    }
                    case 210: {
                        orthoLinie = new OrthoLinie();
                        orthoLinie.setAnfangsPunkt(messung.pz != null && messung.pz.nr != 0L ? messung.pz : messung.ps);
                        orthoLinie.setAnfangsMasse(messung.l1, messung.pz != null && messung.pz.nr != 0L ? 0.0 : messung.l2);
                        n = i;
                        break;
                    }
                    case 290: {
                        double d2;
                        double d;
                        orthoLinie.setEndPunkt(messung.pz != null && messung.pz.nr != 0L ? messung.pz : messung.ps);
                        orthoLinie.setEndOrdinate(messung.pz != null && messung.pz.nr != 0L ? 0.0 : messung.l2);
                        Messung messung2 = null;
                        Messung messung3 = null;
                        n2 = i;
                        block12: for (int j = n; j <= n2; ++j) {
                            Messung messung4 = (Messung)riss.elementAt(j);
                            int n4 = messung4.getMessungsArt();
                            switch (n4) {
                                case 240: {
                                    double d3 = messung.l1;
                                    Punkt punkt = messung4.ps;
                                    messung4 = (Messung)messung4.clone();
                                    messung4.ps = punkt;
                                    messung4.l1 = d3;
                                }
                                case 200: 
                                case 210: 
                                case 290: {
                                    Messung messung5 = orthoLinie.getMessungOf(messung4.ps);
                                    Messung messung6 = null;
                                    d = Math.abs(messung4.l2 - messung5.l2);
                                    d2 = this.db.getKatasterStreckenGenauigkeit(Math.abs(messung4.l2), messung4.getGewichte().getG2());
                                    if (d > d2) {
                                        this.addError(new GeomException(DPoint.getMiddle(messung4.pz != null ? messung4.pz : messung4.ps, messung4.ps), new DLine(messung4.pz != null ? messung4.pz : messung4.ps, messung4.ps), this.createBemerkung(messung4.ps, null, messung5.l2, messung4.l2, d2, riss, "unzul.Abweichnung der Ordinate")));
                                    }
                                    if (messung4.getWerteBelegung() > 0) {
                                        d = Math.abs(messung4.l1 - messung5.l1);
                                        if (d > (d2 = this.db.getKatasterStreckenGenauigkeit(Math.abs(messung4.l1 - orthoLinie.getAnfangsMass()), messung4.getGewichte().getG1()))) {
                                            this.addError(new GeomException(messung4.pz != null ? messung4.pz : messung4.ps, new DLine(messung4.pz != null ? messung4.pz : messung4.ps, orthoLinie.getAnfangsNullPunkt()), this.createBemerkung(messung4.ps, null, messung4.l1, messung5.l1, d2, riss, "unzul.Abweichnung der Abzisse")));
                                        }
                                        if (messung3 != null && messung4.pz != null && messung4.pz.nr == 0L && (d = Math.abs(messung4.l1 - messung3.l1 - (messung5.l1 - messung2.l1))) > (d2 = this.db.getKatasterStreckenGenauigkeit(Math.abs(messung4.l1 - messung3.l1), messung4.getGewichte().getG1()))) {
                                            this.addError(new GeomException(DPoint.getMiddle(messung4.pz != null ? messung4.pz : messung4.ps, messung3.pz != null ? messung3.pz : messung3.ps), new DLine(messung4.pz != null ? messung4.pz : messung4.ps, messung3.pz != null ? messung3.pz : messung3.ps), this.createBemerkung(messung4.ps, messung3.ps, Math.abs(messung4.l1 - messung3.l1), Math.abs(messung5.l1 - messung2.l1), d2, riss, "unzul.Differenz der Abzissenma\u00dfe")));
                                        }
                                    }
                                    if (messung4.pz != null && messung4.pz.nr != 0L) {
                                        messung6 = orthoLinie.getMessungOf(messung4.pz);
                                        d = Math.abs(messung6.l2);
                                        if (d > (d2 = this.db.getKatasterStreckenGenauigkeit(0.0, messung4.getGewichte().getG2()))) {
                                            this.addError(new GeomException(messung4.pz, messung4.pz, this.createBemerkung(messung4.pz, null, 0.0, messung6.l2, d2, riss, "unzul.Abweichnung der Ordinate")));
                                        }
                                        if ((d = messung4.l1 - messung6.l1) > (d2 = this.db.getKatasterStreckenGenauigkeit(messung4.l1 - orthoLinie.getAnfangsMass(), messung4.getGewichte().getG1()))) {
                                            this.addError(new GeomException(messung4.pz, new DLine(messung4.pz, orthoLinie.getAnfangsNullPunkt()), this.createBemerkung(messung4.pz, null, messung4.l1, messung6.l1, d2, riss, "unzul.Abweichnung der Abzisse")));
                                        }
                                        if ((d = Math.abs(messung5.l1 - messung6.l1)) > (d2 = this.db.getKatasterStreckenGenauigkeit(0.0, messung4.getGewichte().getG1()))) {
                                            this.addError(new GeomException(messung4.pz, new DLine(messung4.pz, messung4.ps), this.createBemerkung(messung4.pz, messung4.pz, 0.0, Math.abs(messung5.l1 - messung6.l1), d2, riss, "unzul.Abweichnung der Aufwinklung")));
                                        }
                                        if (messung3 != null && (d = Math.abs(messung4.l1 - messung3.l1 - (messung6.l1 - messung2.l1))) > (d2 = this.db.getKatasterStreckenGenauigkeit(Math.abs(messung4.l1 - messung3.l1), messung4.getGewichte().getG1()))) {
                                            this.addError(new GeomException(messung4.pz, new DLine(messung4.pz, messung3.pz != null ? messung3.pz : messung3.ps), this.createBemerkung(messung4.pz, messung3.ps, Math.abs(messung4.l1 - messung3.l1), Math.abs(messung6.l1 - messung2.l1), d2, riss, "unzul.Differenz der Abzissenma\u00dfe")));
                                        }
                                    }
                                    if (n4 == 210 || messung4.getWerteBelegung() <= 0) continue block12;
                                    messung3 = messung4;
                                    messung2 = messung6 != null ? messung6 : messung5;
                                }
                            }
                        }
                        break;
                    }
                }
                if (i % n3 != 0) continue;
                this.showProgress(i);
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    public boolean checkPunktLageGenauigkeit() {
        int n = 0;
        this.resetErrors();
        this.setBorderValues(0L, DataBase.P.size());
        this.showProgress(false);
        int n2 = Math.max(DataBase.P.size() / 100, 2);
        CountTable countTable = new CountTable();
        if (checkKatAufnahme) {
            this.setControlledPoints(countTable, DataBase.MG);
            this.setControlledPoints(countTable, DataBase.MP);
            this.setControlledPoints(countTable, DataBase.MM);
        }
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            PunktParameter punktParameter = punkt.getParameter();
            if (punkt.isOn()) {
                int n3;
                float f = punkt.getSP();
                float f2 = punkt.getLSP();
                float f3 = punkt.getDS();
                if (checkLagegenauigkeit && (punkt.isLageFestgelegt() || punkt.isStandPunkt())) {
                    if ((double)f2 > DataBase.KPG) {
                        this.addError(new GeomException(punkt, punkt, this.createBemerkung(punkt, f2, DataBase.KPG, "unzul\u00e4ssige Lagegenauigkeit")));
                    }
                }
                if (checkKatAufnahme && punkt.isKatasterNeuElement() && punkt.isLageFestgelegt() && countTable.getCount(punkt) < 3) {
                    this.addError(new GeomException(punkt, punkt, "unzul. Punktbestimmung, der Punkt " + punkt.nr + " hat zu wenig Aufnahmeelemente"));
                }
                if (checkKontrolliertheit && punkt.isKatasterNeuElement()) {
                    if (punkt.isLageFestgelegt() || punkt.isStandPunkt()) {
                        if (f2 == 0.0f) {
                            this.addError(new GeomException(punkt, punkt, "unzul. Punktbestimmung, der Punkt " + punkt.nr + " wurde unkontrolliert bestimmt"));
                        }
                    } else if (f == 0.0f) {
                        this.addError(new GeomException(punkt, punkt, "unzul. Punktbestimmung, der Punkt " + punkt.nr + " wurde unkontrolliert bestimmt"));
                    }
                }
                if (checkLageabweichung && punkt.getPs() == 2) {
                    double d;
                    double d2 = punkt.getKafPa() == 7 ? DataBase.KFPG : (d = DataBase.KAPG);
                    if ((double)f3 > d) {
                        this.addError(new GeomException(punkt, punkt, this.createBemerkung(punkt, f3, d, "unzul\u00e4ssige Lageabweichung")));
                    }
                }
                if (checkFestpunkte && punkt.getPs() == 1) {
                    if (!DataBase.MG.contains(punkt)) {
                        if (!DataBase.MP.contains(punkt)) {
                            if (!DataBase.MM.contains(punkt)) {
                                if (!DataBase.MK.contains(punkt)) {
                                    if (!DataBase.ME.contains(punkt)) {
                                        if (!DataBase.MV.contains(punkt)) {
                                            if (!DataBase.HN.contains(punkt)) {
                                                if (!DataBase.HP.contains(punkt)) {
                                                    if (!DataBase.BH.contains(punkt)) {
                                                        if (!DataBase.BB.contains(punkt)) {
                                                            if (!DataBase.T.contains(punkt)) {
                                                                this.addError(new GeomException(punkt, punkt, "Der Punkt " + punkt.nr + " wurde nicht verwendet"));
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (checkLG && punkt.isKatasterPunkt()) {
                    if (punktParameter.getKafPa() == 7) {
                        if (punktParameter.getKafLg() != 1) {
                            this.addError(new GeomException(punkt, punkt, "Der AP-Punkt " + punkt.nr + " besitzt die ung\u00fcltige Lagegenauigkeitsstufe:" + punktParameter.getOutLg()));
                        }
                    } else if (punktParameter.getKafLg() != 1 && punktParameter.getKafLg() != 2) {
                        this.addError(new GeomException(punkt, punkt, "Der Punkt " + punkt.nr + " besitzt die ung\u00fcltige Lagegenauigkeitsstufe:" + punktParameter.getOutLg()));
                    }
                }
                if (checkLgLzk && punkt.isKatasterPunkt() && punktParameter.getLz() == 2 && (n3 = punktParameter.getKafLg()) != 1 && n3 != 2) {
                    this.addError(new GeomException(punkt, punkt, "Der Punkt " + punkt.nr + " besitzt eine zu geringe Lagegenauigkeitsstufe " + punktParameter.getOutLg() + " f\u00fcr die Lagezuverl\u00e4ssigkeit 2"));
                }
                if (n % n2 == 0) {
                    this.showProgress(n);
                }
            }
            ++n;
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void setControlledPoints(CountTable countTable, DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            this.setControlledPoints(countTable, (Riss)enumeration.nextElement());
        }
    }

    private void setControlledPoints(CountTable countTable, DataContainer dataContainer) {
        int n = 0;
        Enumeration enumeration = dataContainer.elements();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            int n2 = messung.getWerteBelegung();
            switch (messung.getMessungsArt()) {
                case 210: {
                    n = n2 > 0 ? 1 : 0;
                    break;
                }
                case 200: {
                    if (messung.ps != null) {
                        countTable.put(messung.ps);
                        if (n2 > 0) {
                            countTable.put(messung.ps);
                        }
                    }
                    if (messung.pz != null) {
                        countTable.put(messung.pz);
                        if (n2 > 0) {
                            countTable.put(messung.pz);
                        }
                    }
                    if (n2 <= 0) break;
                    ++n;
                    break;
                }
                case 290: {
                    if (n2 > 0) {
                        ++n;
                    }
                    if (n < 2) break;
                    countTable.put(messung.ps);
                    if (messung.pz != null) {
                        countTable.put(messung.pz);
                    }
                    if (n2 > 0) {
                        countTable.put(messung.ps);
                        if (messung.pz != null) {
                            countTable.put(messung.pz);
                        }
                    }
                    messung = messung.getReferenz();
                    countTable.put(messung.ps);
                    if (messung.pz != null) {
                        countTable.put(messung.pz);
                    }
                    if (messung.getWerteBelegung() <= 0) break;
                    countTable.put(messung.ps);
                    if (messung.pz == null) break;
                    countTable.put(messung.pz);
                    break;
                }
                case 220: 
                case 240: 
                case 260: {
                    if (messung.ps != null) {
                        countTable.put(messung.ps);
                    }
                    if (messung.pz == null) break;
                    countTable.put(messung.pz);
                    break;
                }
                case 230: 
                case 270: 
                case 280: {
                    if (messung.ps != null) {
                        countTable.put(messung.ps);
                        if (n2 > 0) {
                            countTable.put(messung.ps);
                        }
                    } else {
                        Punkt punkt = messung.getReferenz().ps;
                        countTable.put(punkt);
                        if (n2 > 0) {
                            countTable.put(punkt);
                        }
                    }
                    if (messung.pz == null) break;
                    countTable.put(messung.pz);
                    if (n2 <= 0) break;
                    countTable.put(messung.pz);
                }
            }
        }
    }

    public boolean checkArt() {
        int n;
        Object object;
        Object object2;
        int n2;
        int n3;
        Hashtable hashtable;
        block40: {
            Cloneable cloneable;
            block37: {
                this.resetErrors();
                Hashtable hashtable2 = new Hashtable();
                Hashtable hashtable3 = checkGrenzpunktArt ? this.db.getLinien() : new Hashtable();
                hashtable = checkLineOska ? this.db.getOskaLinien() : new Hashtable();
                this.setBorderValues(0L, hashtable3.size() + (checkUmringArt ? DataBase.FLST.size() : 0) + hashtable.size() + (checkPointOska ? DataBase.P.size() : 0));
                n3 = Math.max((hashtable3.size() + (checkUmringArt ? DataBase.FLST.size() : 0) + hashtable.size() + (checkPointOska ? DataBase.P.size() : 0)) / 100, 2);
                this.showProgress(false);
                n2 = 0;
                if (!checkGrenzpunktArt) break block37;
                object2 = hashtable3.elements();
                while (object2.hasMoreElements()) {
                    block39: {
                        block38: {
                            object = (Linie)object2.nextElement();
                            if (((Linie)object).getLa() != 2) break block38;
                            PunktParameter punktParameter = ((Linie)object).pa.getParameter();
                            cloneable = ((Linie)object).pe.getParameter();
                            switch (((Linie)object).getEb()) {
                                case 1: {
                                    if (((PunktParameter)cloneable).getEb() == 41) {
                                        if (punktParameter.getEb() == 41) {
                                            this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Grenze verl\u00e4uft zwischen den festzustellenden Grenzpunkten " + ((Linie)object).pa.nr + " und " + ((Linie)object).pe.nr + ", sie mu\u00df als festzustellende Grenze markiert werden"));
                                            break;
                                        }
                                        this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Grenze verl\u00e4uft zum festzustellenden Grenzpunkt " + ((Linie)object).pe.nr + ",  sie mu\u00df als festzustellende Grenze markiert werden"));
                                        break;
                                    }
                                    if (punktParameter.getEb() == 41) {
                                        this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Grenze verl\u00e4uft zum festzustellenden Grenzpunkt " + ((Linie)object).pa.nr + ", sie mu\u00df als festzustellende Grenze markiert werden"));
                                        break;
                                    }
                                    break block39;
                                }
                                case 41: {
                                    if (punktParameter.getEb() != 41 && ((PunktParameter)cloneable).getEb() != 41) {
                                        this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Grenze verl\u00e4uft nicht zwischen festzustellenden Grenzpunkten, sie mu\u00df als festgestellte Grenze markiert werden"));
                                        break;
                                    }
                                    break block39;
                                }
                                case 48: {
                                    break;
                                }
                                case 49: {
                                    break;
                                }
                                default: {
                                    this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Grenze ist mit einer falschen Ebene markiert"));
                                    break;
                                }
                            }
                            break block39;
                        }
                        if (((Linie)object).getLa() == 3) {
                            switch (((Linie)object).getEb()) {
                                case 2: 
                                case 42: {
                                    this.testGebaeudePunkt(((Linie)object).pa);
                                    this.testGebaeudePunkt(((Linie)object).pe);
                                    break;
                                }
                                default: {
                                    this.addError(new GeomException(DPoint.getMiddle(((Linie)object).pa, ((Linie)object).pe), new DLine(((Linie)object).pa, ((Linie)object).pe), "Die Geb\u00e4udekante ist mit einer falschen Ebene markiert"));
                                }
                            }
                        }
                    }
                    if (n2 % n3 == 0) {
                        this.showProgress(n2);
                    }
                    ++n2;
                }
            }
            if (checkUmringArt) {
                object2 = DataBase.FLST.elements();
                while (object2.hasMoreElements()) {
                    object = (Flurstueck)object2.nextElement();
                    int n4 = this.exceptions.size();
                    cloneable = ((Flurstueck)object).getKatasterNachweisLinien(this.exceptions);
                    if (this.exceptions.size() - n4 > 0) {
                        errors += this.exceptions.size() - n4;
                        this.addError(null);
                    }
                    if (n2 % n3 == 0) {
                        this.showProgress(n2);
                    }
                    ++n2;
                }
            }
            if (!checkPointOska) break block40;
            object2 = DataBase.P.elements();
            while (object2.hasMoreElements()) {
                block42: {
                    block41: {
                        object = (Punkt)object2.nextElement();
                        PunktParameter punktParameter = ((Punkt)object).getParameter(1);
                        if (punktParameter.getModPa() <= 0) break block41;
                        int n5 = punktParameter.getModVa();
                        if (n5 == 30 || n5 == 35) break block42;
                        int n6 = punktParameter.getOska();
                        if (n6 != (n = Oska.createOska(punktParameter.getModPa(), punktParameter.getModVa()))) {
                            this.addError(new GeomException((DPoint)object, (GeomElement)object, "Der Punkt " + ((Punkt)object).nr + " hat falschen Oska: " + n6 + ", Soll: " + n));
                        }
                    }
                    if (n2 % n3 == 0) {
                        this.showProgress(n2);
                    }
                }
                ++n2;
            }
        }
        if (checkLineOska) {
            object2 = new Hashtable();
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                Linie linie = (Linie)object.nextElement();
                Object object3 = linie.getArtEbeneHashKey();
                Linie linie2 = ((Hashtable)object2).put(object3, linie);
                if (linie2 != null && linie.getOska() != linie2.getOska()) {
                    n = 0;
                    switch (linie.getLa()) {
                        case 2: {
                            n = linie.getOska() == 235 || linie2.getOska() == 235 || linie.getOska() == 239 || linie2.getOska() == 239 || linie.getOska() == 242 || linie2.getOska() == 242 || linie.getOska() == 245 || linie2.getOska() == 245 ? 1 : 0;
                            break;
                        }
                        case 3: {
                            n = 1;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    if (n != 0) {
                        this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), linie.getExceptionableName() + " hat unterschiedliche OSKA: " + IFormat.i04.format(linie.getOska()) + "!=" + IFormat.i04.format(linie2.getOska())));
                    }
                }
                if (n2 % n3 == 0) {
                    this.showProgress(n2);
                }
                ++n2;
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void testGebaeudePunkt(Punkt punkt) {
        switch (punkt.getKafPa()) {
            case -1: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.addError(new GeomException(punkt, punkt, "Den Punkt " + punkt.nr + " erreichen Geb\u00e4udekanten, er ist mit ung\u00fcltiger Punktart markiert"));
            }
        }
    }

    public boolean checkTeilung() {
        int n;
        Punkt punkt;
        this.resetErrors();
        this.setBorderValues(0L, DataBase.P.size() + DataBase.ME.size());
        this.showProgress(false);
        int n2 = Math.max((DataBase.P.size() + DataBase.ME.size()) / 100, 2);
        int n3 = 0;
        Object object = DataBase.P.elements();
        while (object.hasMoreElements()) {
            LinieSearchTable linieSearchTable;
            punkt = (Punkt)object.nextElement();
            PunktParameter punktParameter = punkt.getParameter();
            if (punkt.getKafPa() == 1) {
                linieSearchTable = this.db.getGrenzen(punkt);
                int n4 = linieSearchTable.countLinienOfEbene(1);
                int n5 = linieSearchTable.countLinienOfEbene(48);
                n = linieSearchTable.countLinienOfEbene(41);
                int n6 = linieSearchTable.countLinienOfEbene(49);
                int n7 = n4 + n + n6;
                switch (punktParameter.getEb()) {
                    case 1: 
                    case 41: 
                    case 49: {
                        if (n5 <= 0 || punktParameter.getLz() == 2) break;
                        this.addError(new GeomException(punkt, punkt, "Auf den Punkt " + punkt.nr + " wurde eine neue Grenze gezogen, seine Lage mu\u00df mit dem Katasternachweis gepr\u00fcft werden"));
                        break;
                    }
                    case 48: {
                        if (n7 == 0) {
                            if (n5 <= 1) {
                                this.addError(new GeomException(punkt, punkt, "Den neuen Grenzpunkt " + punkt.nr + (n5 == 0 ? " erreichen keine neue Grenzen" : " erreicht nur eine neue Grenze")));
                            }
                        } else if (n7 == 1) {
                            this.addError(new GeomException(punkt, punkt, "Der neue Grenzpunkt " + punkt.nr + " wurde in eine vorhandene Grenze eingebunden, die Angabe der zweiten Grenze fehlt"));
                        } else if (n7 == 2) {
                            if (!punkt.isInLinie()) {
                                this.addError(new GeomException(punkt, punkt, "Der neue Grenzpunkt " + punkt.nr + " wurde in eine vorhandene Grenzen eingebunden, er mu\u00df eingerechnet werden"));
                            }
                        } else {
                            this.addError(new GeomException(punkt, punkt, "Den neuen Grenzpunkt " + punkt.nr + " erreichen mehr als zwei vorhandene Grenzen"));
                        }
                        if ((n7 != 2 || n5 != 0) && (n7 != 0 || n5 != 2) || !punkt.isInLinie()) break;
                        boolean bl = false;
                        Linie linie = null;
                        double d = Double.MAX_VALUE;
                        Object object2 = linieSearchTable.elements();
                        while (object2.hasMoreElements()) {
                            Punkt punkt2;
                            PunktParameter punktParameter2;
                            Linie linie2 = (Linie)object2.nextElement();
                            if (linie2.getLaenge() < d) {
                                linie = linie2;
                                d = linie2.getLaenge();
                            }
                            if ((punktParameter2 = (punkt2 = linie2.pa == punkt ? linie2.pe : linie2.pa).getParameter(1)).getModVa() != 88) continue;
                            bl = true;
                            break;
                        }
                        if (bl || linie == null) break;
                        object2 = linie.pa == punkt ? linie.pe : linie.pa;
                        this.addError(new GeomException((DPoint)object2, (GeomElement)object2, "Der Grenzpunkt " + ((Punkt)object2).nr + " wurde durch den Punkt " + punkt.nr + " indirekt abgemarkt, er mu\u00df die Vermarkungsart " + GeoNumberFormat.nr03n.format(88L).toString() + " erhalten"));
                    }
                }
            }
            if (punktParameter.getPst() > 0) {
                linieSearchTable = this.db.getGrenzen(punkt);
                if (linieSearchTable.size() == 0) {
                    linieSearchTable = this.db.getGebaeudeLinien(punkt);
                }
                if (linieSearchTable.size() > 0) {
                    this.addError(new GeomException(punkt, punkt, "Der Punkt " + punkt.nr + " ist historisch, es d\u00fcrfen keine Linien auf ihn gezogen werden"));
                }
            }
            if (n3 % n2 == 0) {
                this.showProgress(n3);
            }
            ++n3;
        }
        object = null;
        punkt = null;
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = DataBase.ME.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            for (n = 0; n < riss.size(); ++n) {
                Messung messung = (Messung)riss.elementAt(n);
                switch (messung.getMessungsArt()) {
                    case 210: {
                        object = messung.ps;
                        break;
                    }
                    case 200: {
                        if (messung.ps.getParameter().getEb() != 48) break;
                        bl2 = true;
                        break;
                    }
                    case 290: {
                        punkt = messung.ps;
                        if (bl2) {
                            if (((Punkt)object).getParameter().getLz() != 2) {
                                this.addError(new GeomException((DPoint)object, new DLine((DPoint)object, punkt), "In die Linie " + ((Punkt)object).nr + " - " + punkt.nr + " wurden Neupunkte eingerechnet, der Punkt " + ((Punkt)object).nr + " mu\u00df mit dem Katasternachweis kontrolliert werden"));
                            }
                            if (punkt.getParameter().getLz() != 2) {
                                this.addError(new GeomException(punkt, new DLine((DPoint)object, punkt), "In die Linie " + ((Punkt)object).nr + " - " + punkt.nr + " wurden Neupunkte eingerechnet, der Punkt " + punkt.nr + " mu\u00df mit dem Katasternachweis kontrolliert werden"));
                            }
                        }
                        bl = false;
                    }
                }
                if (n3 % n2 != 0) continue;
                this.showProgress(n3);
            }
            ++n3;
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void checkFlurArea(Flurstueck flurstueck, double d) {
        if (flurstueck == null || d == 0.0) {
            return;
        }
        if ((int)Math.rint(Math.abs(flurstueck.getPolygonFlaeche()) - d) != 0) {
            this.addError(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "Die Fl\u00e4che der Flur " + flurstueck.getNummer() + " weicht von der Summe der Flurst\u00fccke um " + IFormat.f_1.format(Math.abs(flurstueck.getPolygonFlaeche()) - d) + "m\u02db ab."));
        }
    }

    private void checkFlstArea(Flurstueck flurstueck) {
        int n = flurstueck.getArt();
        Vector vector = null;
        if (FlurstueckArt.getTeil(n) == 8) {
            vector = DataBase.FLST.getTeileFrom(flurstueck);
        } else if (FlurstueckArt.getTeil(n) == 9) {
            vector = DataBase.FLST.getNutzstueckeFrom(flurstueck);
        } else {
            return;
        }
        double d = Math.abs(flurstueck.getPolygonFlaeche());
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            Flurstueck flurstueck2 = (Flurstueck)vector.elementAt(i);
            double d3 = Math.abs(flurstueck2.getPolygonFlaeche());
            if (d3 == 0.0) {
                this.addError(new GeomException(flurstueck2.getHashPoint(), flurstueck2.getPolygon(), "Die Fl\u00e4che " + flurstueck.getExceptionableName() + " besitzt kein geschlossenen Umring"));
            }
            d2 += d3;
        }
        if ((int)Math.rint(d - d2) != 0) {
            this.addError(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "Die Fl\u00e4che " + flurstueck.getExceptionableName() + " weicht von der Summe der Teile um " + IFormat.f_1.format(d - d2) + "m\u02db ab."));
        }
    }

    private void checkLineCount(CountTable countTable, Flurstueck flurstueck) {
        Enumeration enumeration = countTable.keys();
        while (enumeration.hasMoreElements()) {
            Linie.HashKey hashKey = (Linie.HashKey)enumeration.nextElement();
            Linie linie = hashKey.getLinie();
            int n = countTable.getCount(hashKey);
            if (n == 1) {
                this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Die " + linie.getExceptionableName() + " ist nur in einem Teilst\u00fcck des Objekts " + flurstueck.getExceptionableName() + " enthalten"));
                continue;
            }
            if (n <= 2 || linie.getLa() == 0) continue;
            this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Die " + linie.getExceptionableName() + " ist in mehr als zwei Teilst\u00fccken des Objekts " + flurstueck.getExceptionableName() + " enthalten"));
        }
    }

    private void addFlstLines(CountTable countTable, Flurstueck flurstueck, boolean bl) {
        for (int i = 0; i < flurstueck.size(); ++i) {
            Linie linie = (Linie)flurstueck.elementAt(i);
            if (linie.isEnde() || !bl && linie.getLa() != 2) continue;
            countTable.put(linie.getHashKey());
        }
    }

    public boolean checkFlurstuecke() {
        DPolygon dPolygon;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.resetErrors();
        int n = 0;
        int n2 = 0;
        if (checkFlstUmring) {
            n += 4;
        }
        if (checkFlstSchleife) {
            ++n;
        }
        if (checkFreiePunkte) {
            ++n;
        }
        if (checkFlaecheSumme) {
            ++n;
        }
        if (checkObjectKoo) {
            n2 += 2 * DataBase.FLST.size() + DataBase.GEB.size();
        }
        if (checkUeberbau) {
            n2 += DataBase.GEB.size();
        }
        if (checkMultiArea) {
            ++n;
        }
        if (checkBuchArea) {
            ++n;
        }
        if (checkLineLength) {
            n2 += DataBase.FLST.size() + DataBase.GEB.size() + DataBase.TOP.size();
        }
        this.setBorderValues(0L, DataBase.FLST.size() * n + n2);
        this.showProgress(false);
        int n3 = 0;
        if (checkFlstUmring) {
            Object object6;
            Object object7;
            object5 = new CountTable();
            object4 = DataBase.FLST.getFluren().elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                object7 = DataBase.FLST.getStammstueckeFrom(((Flurstueck)object3).getGemarkung(), ((Flurstueck)object3).getFlur());
                object2 = ((Vector)object7).elements();
                while (object2.hasMoreElements()) {
                    object6 = (Flurstueck)object2.nextElement();
                    this.addFlstLines((CountTable)object5, (Flurstueck)object6, false);
                    if (++n3 % 2 != 0) continue;
                    this.showProgress(n3);
                }
                if (((Hashtable)object5).size() <= 0) continue;
                this.addFlstLines((CountTable)object5, (Flurstueck)object3, false);
                this.checkLineCount((CountTable)object5, (Flurstueck)object3);
                ((Hashtable)object5).clear();
            }
            object4 = DataBase.FLST.elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                if ((((Flurstueck)object3).isFlurstueck() || ((Flurstueck)object3).isTeilstueck()) && ((Flurstueck)object3).hasTeile()) {
                    this.addFlstLines((CountTable)object5, (Flurstueck)object3, true);
                    object7 = DataBase.FLST.getTeilstueckeFrom((Flurstueck)object3).elements();
                    while (object7.hasMoreElements()) {
                        object2 = (Flurstueck)object7.nextElement();
                        this.addFlstLines((CountTable)object5, (Flurstueck)object2, true);
                    }
                    this.checkLineCount((CountTable)object5, (Flurstueck)object3);
                    ((Hashtable)object5).clear();
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            object4 = DataBase.FLST.elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                if (!((Flurstueck)object3).isGemarkung() && ((GObject)object3).hasAusgestaltung()) {
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " hat unzul\u00e4ssige Ausgestaltungslinien"));
                }
                boolean bl = false;
                ((Hashtable)object5).clear();
                object2 = ((DataContainer)object3).elements();
                while (object2.hasMoreElements()) {
                    object6 = (Linie)object2.nextElement();
                    if (((Linie)object6).isEnde()) continue;
                    if (((Linie)object6).getArt() == 0) {
                        if (bl) {
                            this.addError(new GeomException(((DataContainer)object3).getHashPoint(), new DLine(((Linie)object6).pa, ((Linie)object6).pe), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " enth\u00e4lt aufeinanderfolgende Ankerlinien, " + ((Linie)object6).getExceptionableName()));
                        }
                        bl = true;
                        ((CountTable)object5).put(((Linie)object6).getHashKey());
                        continue;
                    }
                    bl = false;
                }
                object2 = ((Hashtable)object5).keys();
                while (object2.hasMoreElements()) {
                    object6 = (Linie.HashKey)object2.nextElement();
                    if (((CountTable)object5).getCount(object6) >= 2) continue;
                    Linie linie = ((Linie.HashKey)object6).getLinie();
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), new DLine(linie.pa, linie.pe), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " enth\u00e4lt " + linie.getExceptionableName() + " der Art 0, Linie ist aber keine Ankerlinie"));
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkFlstSchleife) {
            object5 = DataBase.FLST.elements();
            while (object5.hasMoreElements()) {
                object4 = (Flurstueck)object5.nextElement();
                object3 = ((GObject)object4).getPolygon();
                if (object3 == null || ((DPolygon)object3).npoints <= 2) continue;
                double d = ((DPolygon)object3).getAngleSum();
                double d2 = ((DPolygon)object3).getArea();
                d = d2 > 0.0 ? (d /= (double)((DPolygon)object3).npoints - 2.0) : (d -= (double)(((DPolygon)object3).npoints + 1) * Math.PI);
                double d3 = (double)((DPolygon)object3).npoints * 1.0E-8;
                if (!(Math.abs(d - Math.PI) > d3)) continue;
                this.addError(new GeomException(((DataContainer)object4).getHashPoint(), ((GObject)object4).getPolygon(), "Das Objekt " + ((DataContainer)object4).getExceptionableName() + " hat eine Schleife im Polygon"));
            }
        }
        if (checkFreiePunkte) {
            object5 = new PunktTable();
            object4 = DataBase.P.elements();
            while (object4.hasMoreElements()) {
                object3 = (Punkt)object4.nextElement();
                if (!this.isGrenzpunkt((Punkt)object3) || ((Punkt)object3).getParameter().getPst() > 0) continue;
                if (DataBase.PI.get(((Punkt)object3).nr) != null) continue;
                ((LongHashList)object5).put((LongHashObject)object3);
            }
            object4 = DataBase.FLST.elements();
            while (object4.hasMoreElements()) {
                object3 = (Flurstueck)object4.nextElement();
                if (!((Flurstueck)object3).isAbstractFlurstueck() || ((Flurstueck)object3).isStammstueck() && FlurstueckArt.getTeil(((Flurstueck)object3).getArt()) == 8 || ((Flurstueck)object3).isVereinigungTeilstueck()) continue;
                LongHashList longHashList = new LongHashList();
                object2 = new DPolygon();
                Punkt punkt = null;
                boolean bl = false;
                block19: for (int i = 0; i < ((DataContainer)object3).size(); ++i) {
                    object = (Linie)((DataContainer)object3).elementAt(i);
                    switch (((Linie)object).getLs()) {
                        case 1: {
                            punkt = ((Linie)object).pa;
                        }
                        case 0: {
                            longHashList.put(((Linie)object).pa);
                            ((DPolygon)object2).addPoint(((Linie)object).pa);
                            continue block19;
                        }
                        case 9: {
                            if (((Linie)object).pa != punkt) continue block19;
                            bl = true;
                        }
                    }
                }
                if (!bl) continue;
                Enumeration enumeration = ((LongHashList)object5).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Punkt)enumeration.nextElement();
                    if (longHashList.get(((Punkt)object).nr) != null || !((DPolygon)object2).contains((DPoint)object)) continue;
                    this.addError(new GeomException((DPoint)object, (GeomElement)object, "Der Punkt " + ((Punkt)object).nr + " liegt innerhalb der Fl\u00e4che: " + ((DataContainer)object3).getExceptionableName()));
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkFlaecheSumme) {
            int n4 = 0;
            double d = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            Flurstueck flurstueck = null;
            object = null;
            dPolygon = null;
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
                if (flurstueck2.isGemarkung()) continue;
                if (flurstueck2.getGemarkung() * 1000 + flurstueck2.getFlur() != n4) {
                    if (flurstueck2.isFlur()) {
                        this.checkFlurArea(flurstueck, d);
                        d = 0.0;
                        flurstueck = flurstueck2;
                        n4 = flurstueck2.getGemarkung() * 1000 + flurstueck2.getFlur();
                    } else {
                        this.addError(new GeomException(flurstueck2.getHashPoint(), flurstueck2.getPolygon(), "Das Flurst\u00fcck " + flurstueck2.getExceptionableName() + " geh\u00f6rt keiner Flur an"));
                        continue;
                    }
                }
                if (flurstueck2.isFlurstueck()) {
                    double d6 = Math.abs(flurstueck2.getPolygonFlaeche());
                    if (d6 == 0.0) {
                        this.addError(new GeomException(flurstueck2.getHashPoint(), flurstueck2.getPolygon(), "Das Flurst\u00fcck " + flurstueck2.getExceptionableName() + " besitzt kein geschlossenen Umring"));
                    }
                    d += d6;
                    if (FlurstueckArt.isTeilbar(flurstueck2.getArt())) {
                        this.checkFlstArea(flurstueck2);
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            this.checkFlurArea(flurstueck, d);
        }
        if (checkObjectKoo) {
            DataBaseChecker dataBaseChecker = this;
            GeomGrid geomGrid = new GeomGrid(dataBaseChecker.db.getBounds(), 20, 20);
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Flurstueck)enumeration.nextElement();
                try {
                    geomGrid.addElement(((DataContainer)object3).getBounds(), object3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Flurstueck)enumeration.nextElement();
                DPolygon dPolygon2 = ((GObject)object3).getPolygon();
                if (dPolygon2 == null) {
                    if (((Flurstueck)object3).getArt() > 0) {
                        this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " besitzt kein geschlossenen Umring"));
                    }
                } else if (!dPolygon2.contains(((Flurstueck)object3).y, ((Flurstueck)object3).x)) {
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Die Objektkoordinate des Objekts " + ((DataContainer)object3).getExceptionableName() + " liegt au\u00dferhalb des Umringspolygons"));
                } else {
                    boolean bl;
                    boolean bl2 = FlurstueckArt.isFlurstueck(((Flurstueck)object3).getArt());
                    boolean bl3 = bl = ((Flurstueck)object3).getNutzung() >= 0;
                    if (bl2 || bl) {
                        Enumeration enumeration2 = geomGrid.elements(((DataContainer)object3).getBounds());
                        while (enumeration2.hasMoreElements()) {
                            Flurstueck flurstueck = (Flurstueck)enumeration2.nextElement();
                            if (object3 == flurstueck || (!bl2 || !FlurstueckArt.isFlurstueck(flurstueck.getArt())) && (!bl || flurstueck.getNutzung() < 0) || !((DRectangle)(object = flurstueck.getBounds())).contains(((Flurstueck)object3).y, ((Flurstueck)object3).x) || (dPolygon = flurstueck.getPolygon()) == null || !dPolygon.contains(((Flurstueck)object3).y, ((Flurstueck)object3).x)) continue;
                            this.addError(new GeomException(((DataContainer)object3).getHashPoint(), new DLine(((DataContainer)object3).getHashPoint(), flurstueck.getHashPoint()), "Die Objektkoordinate des Objekts " + ((DataContainer)object3).getExceptionableName() + " liegt innerhalb des Objektumrings " + flurstueck.getExceptionableName()));
                        }
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            geomGrid.removeAllElements();
            geomGrid = null;
            enumeration = DataBase.GEB.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Gebaeude)enumeration.nextElement();
                DPolygon dPolygon3 = ((GObject)object3).getPolygon();
                if (dPolygon3 == null) {
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " besitzt kein geschlossenen Umring"));
                } else if (!dPolygon3.contains(((Gebaeude)object3).y, ((Gebaeude)object3).x)) {
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Die Objektkoordinate des Objekts " + ((DataContainer)object3).getExceptionableName() + " liegt au\u00dferhalb des Umringspolygons"));
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkMultiArea) {
            Linie linie = null;
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Linie linie2;
                object3 = (Flurstueck)enumeration.nextElement();
                PunktTable punktTable = new PunktTable(((DataContainer)object3).size());
                for (int i = 0; i < ((DataContainer)object3).size() && !(linie2 = (Linie)((DataContainer)object3).elementAt(i)).isEnde(); ++i) {
                    if (punktTable.put(linie2.pa) == null || linie2.getLa() == 0 || linie == null || linie.getLa() == 0) continue;
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " besitzt identische Punkte im Umring, mehrere Teilfl\u00e4chen m\u00f6glich"));
                }
                try {
                    if (((Flurstueck)object3).getArt() != 781 && ((GObject)object3).isMultiArea()) {
                        this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Das Objekt " + ((DataContainer)object3).getExceptionableName() + " besitzt mehrere Teilfl\u00e4chen"));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.addError(new GeomException(((DataContainer)object3).getHashPoint(), ((GObject)object3).getPolygon(), "Verkettungsproblem im Objekt " + ((DataContainer)object3).getExceptionableName() + ", falsche Ankerlinienn"));
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkBuchArea) {
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                double d;
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                double d7 = flurstueck.getBuchFlaeche();
                if (d7 == 0.0 || (d = flurstueck.getGeoFlaeche()) == 0.0) continue;
                int n5 = (int)Math.rint(d / d7 * 100.0);
                int n6 = (int)Math.rint(d - d7);
                if (n5 < minBuchArea || n5 > maxBuchArea) {
                    this.addError(new GeomException(flurstueck.getHashPoint(), flurstueck.getPolygon(), "Das Objekt " + flurstueck.getExceptionableName() + " hat eine Istfl\u00e4che von " + n5 + "% Buch:" + (int)Math.rint(d7) + " Ist:" + (int)Math.rint(d) + " Diff:" + n6));
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkLineLength) {
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                this.checkLength((GObject)enumeration.nextElement());
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            enumeration = DataBase.GEB.elements();
            while (enumeration.hasMoreElements()) {
                this.checkLength((GObject)enumeration.nextElement());
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            enumeration = DataBase.TOP.elements();
            while (enumeration.hasMoreElements()) {
                this.checkLength((GObject)enumeration.nextElement());
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    private void checkLength(GObject gObject) {
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            if (linie.pa == linie.pe) {
                this.addError(new GeomException(linie.pa, linie.pa, linie.getExceptionableName() + " im Objekt " + gObject.getExceptionableName() + " hat die L\u00e4nge 0"));
                continue;
            }
            if (!(linie.getS() < minLineLength)) continue;
            this.addError(new GeomException(linie.pa, linie.pa, linie.getExceptionableName() + " im Objekt " + gObject.getExceptionableName() + " unterschreitet minimale L\u00e4nge, Ist: " + IFormat.f_3.format(linie.getS())));
        }
    }

    public boolean checkObjAttribute() {
        Flurstueck flurstueck;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Cloneable cloneable;
        Object object6;
        this.resetErrors();
        int n2 = 0;
        if (checkAlb || checkGebSoll || checkFlstNutzung || checkFlstLagebez) {
            n2 += DataBase.FLST.size();
        }
        if (checkGebNutzung || checkGebLage || checkGebPseudo) {
            n2 += DataBase.GEB.size();
        }
        if (checkStrassenland) {
            n2 += DataBase.FLST.size() * 3;
        }
        this.setBorderValues(0L, n2);
        this.showProgress(false);
        int n3 = 0;
        if (checkAlb || checkGebSoll || checkFlstNutzung || checkFlstLagebez) {
            object6 = DataBase.FLST.elements();
            while (object6.hasMoreElements()) {
                int n4;
                cloneable = (Flurstueck)object6.nextElement();
                if (checkFlstNutzung && ((Flurstueck)cloneable).getNutzung() != -1) {
                    object5 = NutzungsArt.getNutzungsArt(((Flurstueck)cloneable).getNutzung());
                    if (object5 == null) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " hat ung\u00fcltige Nutzungsart '" + ((Flurstueck)cloneable).getNutzung() + "'"));
                    } else if (((NutzungsArt)object5).getUnderGroupLevels() > flstNutzungUnderGroup) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Nutzungsart '" + ((Flurstueck)cloneable).getNutzung() + "' des Flurst\u00fccks " + ((Flurstueck)cloneable).getObjectName() + " hat ung\u00fcltige Spezialisierungsstufe"));
                    }
                }
                if (checkGebSoll && ((Flurstueck)cloneable).isFortfuehrung() && FlurstueckArt.isFlurstueck(((Flurstueck)cloneable).getArt())) {
                    if (((Flurstueck)cloneable).hasTeile()) {
                        object5 = DataBase.FLST.getTeileFrom((Flurstueck)cloneable);
                        for (n4 = 0; n4 < ((Vector)object5).size(); ++n4) {
                            Flurstueck flurstueck2 = (Flurstueck)((Vector)object5).elementAt(n4);
                            if (flurstueck2.getBerechnungsArt() >= 10 || flurstueck2.getNutzung() <= 0 || flurstueck2.getNutzung() >= 300) continue;
                            this.addError(new GeomException(flurstueck2.getHashPoint(), flurstueck2.getHashPoint(), "Geb\u00e4udefl\u00e4che " + flurstueck2.getObjectName() + " ist nicht als Sollfl\u00e4che berechnet"));
                        }
                    } else if (((Flurstueck)cloneable).getBerechnungsArt() < 10 && ((Flurstueck)cloneable).getNutzung() > 0 && ((Flurstueck)cloneable).getNutzung() < 300) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Geb\u00e4udefl\u00e4che " + ((Flurstueck)cloneable).getObjectName() + " ist nicht als Sollfl\u00e4che berechnet"));
                    }
                }
                if (checkFlstLagebez && ((Flurstueck)cloneable).hasLage()) {
                    object5 = (Lage)((Flurstueck)cloneable).getLage();
                    Gemarkung gemarkung = Gemarkung.getGemarkung(((Flurstueck)cloneable).getGemarkung());
                    if (gemarkung == null) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Gemarkung " + ((Flurstueck)cloneable).getGemarkung() + " nicht gefunden"));
                    } else {
                        try {
                            ((Lage)object5).checkEntLage(gemarkung.getGemeinde());
                        }
                        catch (Exception exception) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " hat ung\u00fcltige Lagebezeichnung, " + exception.getMessage()));
                        }
                    }
                }
                if (checkAlb && FlurstueckArt.isFlurstueck(((Flurstueck)cloneable).getArt())) {
                    object5 = DataBase.ALB.getFlurstueck((Flurstueck)cloneable);
                    if (object5 == null) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Kein ALB-Nachweis f\u00fcr Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " gefunden"));
                        continue;
                    }
                    n4 = FlurstueckArt.isFortfuehrung(((Flurstueck)cloneable).getArt());
                    boolean bl = FlurstueckArt.getTeil(((Flurstueck)cloneable).getArt()) == 8;
                    n = FlurstueckArt.getTeil(((Flurstueck)cloneable).getArt()) == 9 ? 1 : 0;
                    boolean bl2 = false;
                    if (((Flurstueck)cloneable).getPruefzeichen() != ((Flurstueck)object5).getPruefzeichen() && n4 != 0) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Pr\u00fcfzeichen unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName()));
                    }
                    if (((Flurstueck)cloneable).getAktualitaet() != ((Flurstueck)object5).getAktualitaet() && n4 != 0) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Aktualit\u00e4t unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName()));
                    }
                    object4 = (Lage)((Flurstueck)cloneable).getLage();
                    object3 = (Lage)((Flurstueck)object5).getLage();
                    if (object4 == null) {
                        if (n4 != 0 && !bl) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Lagebezeichnung f\u00fcr Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fehlt"));
                        }
                    } else if (!((Lage)object4).toDatString().equals(((Lage)object3).toDatString())) {
                        bl2 = true;
                        if (n4 == 0) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Stra\u00dfenschl\u00fcssel unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fortf\u00fchren"));
                        }
                    } else if (!((Lage)object4).getBezeichnung().equals(((Lage)object3).getBezeichnung())) {
                        bl2 = true;
                        if (n4 == 0) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Lagebezeichnung unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fortf\u00fchren"));
                        }
                    }
                    if (bl) {
                        bl2 = true;
                        if (n4 == 0) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " hat Teile, es mu\u00df fortgef\u00fchrt werden"));
                        }
                    } else if (n != 0) {
                        object2 = DataBase.FLST.getNutzstueckeFrom((Flurstueck)cloneable);
                        object = DataBase.ALB.getNutzstueckeFrom((Flurstueck)cloneable);
                        if (((Vector)object2).size() != ((Vector)object).size()) {
                            bl2 = true;
                            if (n4 == 0) {
                                this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Anzahl der Nutzungsarten unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fortf\u00fchren"));
                            }
                        } else {
                            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                                flurstueck = (Flurstueck)((Vector)object2).elementAt(i);
                                Flurstueck flurstueck3 = (Flurstueck)((Vector)object).elementAt(i);
                                if (flurstueck.getNutzung() == flurstueck3.getNutzung()) continue;
                                bl2 = true;
                                if (n4 != 0) continue;
                                this.addError(new GeomException(flurstueck.getHashPoint(), flurstueck.getHashPoint(), "Die Nutzungsart " + flurstueck.getNutzung() + " unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fortf\u00fchren"));
                            }
                        }
                    } else if (((Flurstueck)cloneable).getNutzung() != ((Flurstueck)object5).getNutzung()) {
                        bl2 = true;
                        if (n4 == 0) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Nutzungsart unterscheidet sich zum ALB, Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " fortf\u00fchren"));
                        }
                    }
                    if (n4 != 0 && !bl2) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Das Flurst\u00fcck " + ((Flurstueck)cloneable).getObjectName() + " unterscheidet sich nicht zum ALB, Fortf\u00fchrung nicht notwendig"));
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkGebNutzung || checkGebLage || checkGebPseudo) {
            DataBaseChecker dataBaseChecker = this;
            object6 = dataBaseChecker.db.gebaeude();
            while (object6.hasMoreElements()) {
                cloneable = (Gebaeude)object6.nextElement();
                object5 = ((Gebaeude)cloneable).getLeitzeichen();
                if (object5 == null) continue;
                if (checkGebPseudo && ((GebaeudeKennzeichen)object5).isPseudoNummer()) {
                    int n5 = ((DataContainer)cloneable).getOska();
                    if (n5 >= 1200 && n5 <= 1399) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Pseudohausnummer f\u00fcr Wohngeb\u00e4ude " + ((Gebaeude)cloneable).getObjectName() + " nicht zul\u00e4ssig"));
                    } else if (((GebaeudeKennzeichen)object5).getLfdNummer() == 1) {
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Pseudohausnummer f\u00fcr Hauptgeb\u00e4ude " + ((Gebaeude)cloneable).getObjectName() + " nicht zul\u00e4ssig"));
                    }
                }
                if (checkGebNutzung || checkGebLage) {
                    DRectangle dRectangle = ((DataContainer)cloneable).getBounds();
                    DataBaseChecker dataBaseChecker2 = this;
                    Enumeration enumeration = dataBaseChecker2.db.flurstuecke();
                    while (enumeration.hasMoreElements()) {
                        Flurstueck flurstueck4 = (Flurstueck)enumeration.nextElement();
                        if (checkGebNutzung && ((GebaeudeKennzeichen)object5).getLfdNummer() == 1 && flurstueck4.getNutzung() != -1 && flurstueck4.contains(((Gebaeude)cloneable).y, ((Gebaeude)cloneable).x) && ((DataContainer)cloneable).getOska() / 10 != flurstueck4.getNutzung()) {
                            this.addError(new GeomException(flurstueck4.getHashPoint(), new DLine(flurstueck4.getHashPoint(), ((DataContainer)cloneable).getHashPoint()), "Das Hauptgeb\u00e4ude " + ((Gebaeude)cloneable).getObjectName() + " mit Oska " + ((DataContainer)cloneable).getOska() + " liegt auf der Nutzungsart " + flurstueck4.getNutzung() + ". Oska bzw. Nutzung ung\u00fcltig"));
                        }
                        if (!checkGebLage || !flurstueck4.hasLage() || !flurstueck4.contains(((Gebaeude)cloneable).y, ((Gebaeude)cloneable).x)) continue;
                        Lage lage = (Lage)flurstueck4.getLage();
                        if (!lage.hasStrasse(((GebaeudeKennzeichen)object5).getStrasse())) {
                            this.addError(new GeomException(flurstueck4.getHashPoint(), new DLine(flurstueck4.getHashPoint(), ((DataContainer)cloneable).getHashPoint()), "Stra\u00dfenschl\u00fcssel " + ((GebaeudeKennzeichen)object5).getStrasseAsString() + " des Geb\u00e4udes " + ((Gebaeude)cloneable).getObjectName() + " stimmt nicht mit dem Flurst\u00fcck " + flurstueck4.getObjectName() + " \u00fcberein."));
                        }
                        if (((GebaeudeKennzeichen)object5).isPseudoNummer()) continue;
                        object4 = Gemeinde.getGemeinde(((GebaeudeKennzeichen)object5).getGemeinde());
                        if (object4 == null) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Gemeinde " + ((GebaeudeKennzeichen)object5).getGemeinde() + " nicht vorhanden"));
                            continue;
                        }
                        object3 = ((Gemeinde)object4).getStrasse(((GebaeudeKennzeichen)object5).getStrasse());
                        if (object3 == null) {
                            this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), ((DataContainer)cloneable).getHashPoint(), "Stra\u00dfenschl\u00fcssel " + ((GebaeudeKennzeichen)object5).getStrasse() + " nicht in Gemeinde " + ((Gemeinde)object4).getNummer() + " gefunden"));
                            continue;
                        }
                        object2 = lage.getBezeichnung();
                        object = null;
                        object = ((GebaeudeKennzeichen)object5).createEntLage(((Strasse)object3).getName());
                        if (((String)object2).indexOf((String)object) >= 0) continue;
                        this.addError(new GeomException(((DataContainer)cloneable).getHashPoint(), new DLine(((DataContainer)cloneable).getHashPoint(), flurstueck4.getHashPoint()), "Geb\u00e4udelage " + (String)object + " ist nicht in Flurst\u00fcckslage " + (String)object2 + ", " + flurstueck4.getObjectName() + " enthalten"));
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        if (checkStrassenland) {
            object6 = new Hashtable();
            cloneable = new Hashtable();
            object5 = new Hashtable();
            DataBaseChecker dataBaseChecker = this;
            Object object7 = dataBaseChecker.db.flurstuecke();
            while (object7.hasMoreElements()) {
                Flurstueck flurstueck5 = (Flurstueck)object7.nextElement();
                n = flurstueck5.getArt();
                if (FlurstueckArt.getTeil(n) == 9) {
                    Vector vector = DataBase.FLST.getNutzstueckeFrom(flurstueck5);
                    double d = 0.0;
                    double d2 = 0.0;
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        flurstueck = (Flurstueck)enumeration.nextElement();
                        if (flurstueck.getNutzung() >= 500 && flurstueck.getNutzung() < 600) {
                            d += flurstueck.getFlaeche();
                            continue;
                        }
                        d2 += flurstueck.getFlaeche();
                    }
                    if (d > d2) {
                        if (flurstueck5.getOska() != 239) {
                            this.addError(new GeomException(flurstueck5.getHashPoint(), flurstueck5.getHashPoint(), "Das Flurst\u00fcck " + flurstueck5.getObjectName() + " hat mehr als 50% Stra\u00dfenland, falscher Objektschl\u00fcssel " + flurstueck5.getOska()));
                        }
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            flurstueck = (Flurstueck)enumeration.nextElement();
                            this.testStrassenUmring(flurstueck, (Hashtable)object6, (Hashtable)cloneable, (Hashtable)object5);
                        }
                    } else {
                        if (flurstueck5.getOska() != 233) {
                            this.addError(new GeomException(flurstueck5.getHashPoint(), flurstueck5.getHashPoint(), "Das Flurst\u00fcck " + flurstueck5.getObjectName() + " hat falschen Objektschl\u00fcssel " + flurstueck5.getOska()));
                        }
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            flurstueck = (Flurstueck)enumeration.nextElement();
                            this.testAndereUmring(flurstueck, (Hashtable)object6, (Hashtable)cloneable);
                        }
                    }
                } else if (n == 700 || n == 601 || n == 701 || n == 801) {
                    if (flurstueck5.getNutzung() >= 500 && flurstueck5.getNutzung() < 600) {
                        if (flurstueck5.getOska() != 239) {
                            this.addError(new GeomException(flurstueck5.getHashPoint(), flurstueck5.getHashPoint(), "Das Flurst\u00fcck " + flurstueck5.getObjectName() + " ist Stra\u00dfenland, falscher Objektschl\u00fcssel " + flurstueck5.getOska()));
                        }
                        this.testStrassenUmring(flurstueck5, (Hashtable)object6, (Hashtable)cloneable, (Hashtable)object5);
                    } else {
                        if (flurstueck5.getOska() != 233) {
                            this.addError(new GeomException(flurstueck5.getHashPoint(), flurstueck5.getHashPoint(), "Das Flurst\u00fcck " + flurstueck5.getObjectName() + " hat falschen Objektschl\u00fcssel " + flurstueck5.getOska()));
                        }
                        this.testAndereUmring(flurstueck5, (Hashtable)object6, (Hashtable)cloneable);
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            while (((Hashtable)object5).size() > 0) {
                object7 = null;
                Object object8 = ((Hashtable)object5).elements();
                while (object8.hasMoreElements()) {
                    object7 = (Linie)object8.nextElement();
                }
                ((Hashtable)object5).remove(((Linie)object7).getArtEbeneHashKey());
                object8 = ((Linie)object7).getPa();
                Punkt punkt = ((Linie)object7).getPe();
                if (this.isGrenze((Punkt)object8, punkt)) {
                    this.addError(new GeomException(DPoint.getMiddle((DPoint)object8, punkt), new DLine((DPoint)object8, punkt), "Linie liegt im Stra\u00dfenland, falscher Oska " + ((Linie)object7).getOska()));
                    continue;
                }
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(object7);
                boolean bl = false;
                do {
                    Linie linie;
                    bl = false;
                    object3 = ((Hashtable)object5).elements();
                    while (object3.hasMoreElements()) {
                        linie = (Linie)object3.nextElement();
                        bl = false;
                        if (object8 == linie.pa) {
                            object8 = linie.pe;
                            bl = true;
                        } else if (object8 == linie.pe) {
                            object8 = linie.pa;
                            bl = true;
                        } else if (punkt == linie.pa) {
                            punkt = linie.pe;
                            bl = true;
                        } else if (punkt == linie.pe) {
                            punkt = linie.pa;
                            bl = true;
                        }
                        if (!bl) continue;
                        vector.addElement(linie);
                        ((Hashtable)object5).remove(linie.getArtEbeneHashKey());
                        break;
                    }
                    if (!bl || !this.isGrenze((Punkt)object8, punkt)) continue;
                    object3 = vector.elements();
                    while (object3.hasMoreElements()) {
                        linie = (Linie)object3.nextElement();
                        this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie liegt im Stra\u00dfenland, falscher Oska " + linie.getOska()));
                    }
                } while (bl);
            }
            object7 = new Hashtable();
            DataBaseChecker dataBaseChecker3 = this;
            Enumeration enumeration = dataBaseChecker3.db.flurstuecke();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck6 = (Flurstueck)enumeration.nextElement();
                if (flurstueck6.getNutzung() == 922) {
                    Enumeration enumeration2 = flurstueck6.elements();
                    while (enumeration2.hasMoreElements()) {
                        Linie linie = (Linie)enumeration2.nextElement();
                        if (linie.isEnde() || linie.getArt() != 2) continue;
                        object3 = linie.getArtEbeneHashKey();
                        if (linie.getOska() != 245) {
                            this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie in " + flurstueck6.getExceptionableName() + " begrenzt Marksteinschutzfl\u00e4che, falscher Oska " + linie.getOska()));
                        }
                        ((Hashtable)object7).put(object3, linie);
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
            DataBaseChecker dataBaseChecker4 = this;
            enumeration = dataBaseChecker4.db.flurstuecke();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck7 = (Flurstueck)enumeration.nextElement();
                if (flurstueck7.getNutzung() != 922) {
                    Enumeration enumeration3 = flurstueck7.elements();
                    while (enumeration3.hasMoreElements()) {
                        Linie linie = (Linie)enumeration3.nextElement();
                        if (linie.isEnde() || linie.getArt() != 2) continue;
                        object3 = linie.getArtEbeneHashKey();
                        Linie linie2 = (Linie)((Hashtable)object7).get(object3);
                        if (linie.getOska() == 245) {
                            if (linie2 != null) continue;
                            this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie in " + flurstueck7.getExceptionableName() + " begrenzt keine Marksteinschutzfl\u00e4che, falscher Oska " + linie.getOska()));
                            continue;
                        }
                        if (linie2 == null) continue;
                        this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie in " + flurstueck7.getExceptionableName() + " grenzt an eine Marksteinschutzfl\u00e4che, falscher Oska " + linie.getOska()));
                    }
                }
                if (++n3 % 2 != 0) continue;
                this.showProgress(n3);
            }
        }
        this.showProgress(true);
        return errors > 0;
    }

    private boolean isGrenze(Punkt punkt, Punkt punkt2) {
        return this.isGrenzpunkt(punkt) && this.isGrenzpunkt(punkt2);
    }

    private boolean isGrenzpunkt(Punkt punkt) {
        int n = punkt.getKafPa();
        int n2 = punkt.getOska();
        if (n >= 0) {
            return n == 1;
        }
        if (n2 >= 0) {
            return pa2.get(new Integer(n2)) != null;
        }
        return false;
    }

    private void testAndereUmring(Flurstueck flurstueck, Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = flurstueck.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.isEnde() || linie.getArt() != 2) continue;
            Object object = linie.getArtEbeneHashKey();
            if (linie.getOska() == 239) {
                this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie liegt nicht im Stra\u00dfenland, falscher Oska " + linie.getOska()));
                continue;
            }
            Linie linie2 = (Linie)hashtable.get(object);
            if (linie2 != null && linie2.getOska() == 239) {
                this.addError(new GeomException(DPoint.getMiddle(linie2.pa, linie2.pe), new DLine(linie2.pa, linie2.pe), "Linie liegt nicht im Stra\u00dfenland, falscher Oska " + linie2.getOska()));
            }
            hashtable2.put(object, linie);
        }
    }

    private void testStrassenUmring(Flurstueck flurstueck, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Enumeration enumeration = flurstueck.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.isEnde() || linie.getArt() != 2) continue;
            Object object = linie.getArtEbeneHashKey();
            Linie linie2 = (Linie)hashtable.get(object);
            if (linie2 != null && (linie2.getOska() != 239 || linie.getOska() != 239)) {
                hashtable3.put(object, linie);
            }
            hashtable.put(object, linie);
            if (linie.getOska() == 239) {
                linie2 = (Linie)hashtable2.get(object);
                if (linie2 == null) continue;
                this.addError(new GeomException(DPoint.getMiddle(linie.pa, linie.pe), new DLine(linie.pa, linie.pe), "Linie liegt nicht im Stra\u00dfenland, falscher Oska " + linie.getOska()));
                continue;
            }
            hashtable2.put(object, linie);
        }
    }

    private void addError(GeomException geomException) {
        if (this.saveErrors && geomException != null) {
            this.exceptions.addException(geomException);
            ++errors;
        }
        this.setLabelText(errors + " Fehler");
        this.showProgress();
    }

    private void resetErrors() {
        errors = 0;
        this.setLabelText("0 Fehler");
    }

    private class Schnitt {
        Punkt s;
        Punkt p1;
        Punkt p2;
        Punkt p3;
        Punkt p4;

        private Schnitt(DataBaseChecker dataBaseChecker) {
        }
    }
}

