/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBaseChecker;
import de.geocalc.text.IFormat;
import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;

public class DataCheckAufnahmeDetailDialog
extends IOptionDialog {
    private Checkbox gpsLageCheckbox;
    private Checkbox polLageCheckbox;
    private Checkbox nivHoeheCheckbox;
    private Checkbox polHoeheCheckbox;
    private TextField lageCountTextField;
    private TextField hoeheCountTextField;
    private TextField minLspTextField;
    private TextField minHlspTextField;

    public DataCheckAufnahmeDetailDialog(IFrame iFrame, String string) {
        super(iFrame, string);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.gpsLageCheckbox = new Checkbox("GPS-Lageaufnahme", DataBaseChecker.checkAufnahmeGpsLage);
        iPanel.add(this.gpsLageCheckbox);
        this.gpsLageCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.gpsLageCheckbox, gridBagConstraints);
        this.polLageCheckbox = new Checkbox("polare Lageaufnahme", DataBaseChecker.checkAufnahmePolLage);
        iPanel.add(this.polLageCheckbox);
        this.polLageCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.polLageCheckbox, gridBagConstraints);
        Label label = new Label("Anzahl der notwendigen Lagekontrollen:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.lageCountTextField = new TextField(Integer.toString(DataBaseChecker.checkAufnahmeLageCount));
        iPanel.add(this.lageCountTextField);
        this.lageCountTextField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lageCountTextField, gridBagConstraints);
        label = new Label("Lagegenauigkeit der Kontrollpunkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.minLspTextField = new TextField(IFormat.f_3.format(DataBaseChecker.minAufnahmeLLsp));
        iPanel.add(this.minLspTextField);
        this.minLspTextField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.minLspTextField, gridBagConstraints);
        this.nivHoeheCheckbox = new Checkbox("Nivellement", DataBaseChecker.checkAufnahmeNivHoehe);
        iPanel.add(this.nivHoeheCheckbox);
        this.nivHoeheCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.nivHoeheCheckbox, gridBagConstraints);
        this.polHoeheCheckbox = new Checkbox("polare H\u00f6henaufnahme", DataBaseChecker.checkAufnahmePolHoehe);
        iPanel.add(this.polHoeheCheckbox);
        this.polHoeheCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.polHoeheCheckbox, gridBagConstraints);
        label = new Label("Anzahl der notwendigen H\u00f6henkontrollen:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.hoeheCountTextField = new TextField(Integer.toString(DataBaseChecker.checkAufnahmeHoeheCount));
        iPanel.add(this.hoeheCountTextField);
        this.hoeheCountTextField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.hoeheCountTextField, gridBagConstraints);
        label = new Label("H\u00f6hengenauigkeit der Kontrollpunkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.minHlspTextField = new TextField(IFormat.f_3.format(DataBaseChecker.minAufnahmeHLsp));
        iPanel.add(this.minHlspTextField);
        this.minHlspTextField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.minHlspTextField, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected void setOptions() {
        DataBaseChecker.checkAufnahmeGpsLage = this.gpsLageCheckbox.getState();
        DataBaseChecker.checkAufnahmePolLage = this.polLageCheckbox.getState();
        try {
            DataBaseChecker.checkAufnahmeLageCount = Integer.parseInt(this.lageCountTextField.getText());
            DataBaseChecker.minAufnahmeLLsp = new Double(this.minLspTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataBaseChecker.checkAufnahmeNivHoehe = this.nivHoeheCheckbox.getState();
        DataBaseChecker.checkAufnahmePolHoehe = this.polHoeheCheckbox.getState();
        try {
            DataBaseChecker.checkAufnahmeHoeheCount = Integer.parseInt(this.hoeheCountTextField.getText());
            DataBaseChecker.minAufnahmeHLsp = new Double(this.minHlspTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

