/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IChecker;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataBaseChecker;
import de.geocalc.kafplot.DataCheckArtDetailDialog;
import de.geocalc.kafplot.DataCheckAufnahmeDetailDialog;
import de.geocalc.kafplot.DataCheckConfigDetailDialog;
import de.geocalc.kafplot.DataCheckKatasternachweisDetailDialog;
import de.geocalc.kafplot.DataCheckLagegenauigkeitDetailDialog;
import de.geocalc.kafplot.DataCheckNummerDetailDialog;
import de.geocalc.kafplot.DataCheckObjectAttributeDetailDialog;
import de.geocalc.kafplot.DataCheckObjectDetailDialog;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.io.ErrorWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;

public class DataCheckDialog
extends IDialog
implements ActionListener {
    private static final String DO_COMMAND = "Pr\u00fcfen";
    private static final String OK_COMMAND = "OK";
    private static final String TAKE_COMMAND = "Anzeigen";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String DETAIL_COMMAND = "...";
    private static final String NUMMER_DETAIL_COMMAND = "_nr";
    private static final String AUFNAHME_DETAIL_COMMAND = "_auf";
    private static final String CONFIG_DETAIL_COMMAND = "_cf";
    private static final String KATASTERNACHWEIS_DETAIL_COMMAND = "_kn";
    private static final String LAGEGENAUIGKEIT_DETAIL_COMMAND = "_lg";
    private static final String ART_DETAIL_COMMAND = "_art";
    private static final String FLST_DETAIL_COMMAND = "_flst";
    private static final String OBJATT_DETAIL_COMMAND = "_objatt";
    private static final String NO_ERROR = "        0 Fehler";
    private Checkbox nrCheckbox;
    private Checkbox aufnahmeCheckbox;
    private Checkbox configCheckbox;
    private Checkbox katNachwCheckbox;
    private Checkbox punktLageGenauigkeitCheckbox;
    private Checkbox artCheckbox;
    private Checkbox teilungCheckbox;
    private Checkbox flstCheckbox;
    private Checkbox objAttCheckbox;
    private Label nrLabel;
    private Label aufnahmeLabel;
    private Label configLabel;
    private Label katNachwLabel;
    private Label punktLageGenauigkeitLabel;
    private Label artLabel;
    private Label teilungLabel;
    private Label flstLabel;
    private Label objAttLabel;
    private IChecker nrChecker;
    private IChecker aufnahmeChecker;
    private IChecker configChecker;
    private IChecker katNachwChecker;
    private IChecker punktLageGenauigkeitChecker;
    private IChecker artChecker;
    private IChecker teilungChecker;
    private IChecker flstChecker;
    private IChecker objAttChecker;
    private IProgressBar progressBar;
    private DataBase db;
    private DataBaseChecker checker;
    private ExceptionList exceptions;

    public DataCheckDialog(IFrame iFrame, String string, DataBase dataBase) {
        this(iFrame, string, dataBase, false);
    }

    public DataCheckDialog(IFrame iFrame, String string, DataBase dataBase, boolean bl) {
        super(iFrame, string, !bl);
        this.db = dataBase;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createCheckPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
        this.exceptions = new ExceptionList();
        if (bl) {
            this.setVisible(true);
            this.check();
            this.saveErrors();
            this.endDialog();
        }
    }

    public void check() {
        boolean bl;
        this.exceptions.removeAllElements();
        DataBaseChecker.checkNummer = this.nrCheckbox.getState();
        DataBaseChecker.checkAufnahme = this.aufnahmeCheckbox.getState();
        DataBaseChecker.checkConfig = this.configCheckbox.getState();
        DataBaseChecker.checkKatNachw = this.katNachwCheckbox.getState();
        DataBaseChecker.checkPunktLage = this.punktLageGenauigkeitCheckbox.getState();
        DataBaseChecker.checkArt = this.artCheckbox.getState();
        DataBaseChecker.checkTeilung = this.teilungCheckbox.getState();
        DataBaseChecker.checkObjGeom = this.flstCheckbox.getState();
        DataBaseChecker.checkObjAtt = this.objAttCheckbox.getState();
        this.checker = new DataBaseChecker(this.db);
        this.checker.setProgressBar(this.progressBar);
        this.checker.setExceptionList(this.exceptions);
        this.nrChecker.setState(0);
        this.aufnahmeChecker.setState(0);
        this.configChecker.setState(0);
        this.katNachwChecker.setState(0);
        this.punktLageGenauigkeitChecker.setState(0);
        this.artChecker.setState(0);
        this.teilungChecker.setState(0);
        this.flstChecker.setState(0);
        if (DataBaseChecker.checkNummer) {
            this.checker.setProgressLabel(this.nrLabel);
            bl = this.checker.checkNummer();
            this.nrChecker.setState(bl ? 11 : 10);
        } else {
            this.nrChecker.setState(21);
        }
        if (DataBaseChecker.checkAufnahme) {
            this.checker.setProgressLabel(this.aufnahmeLabel);
            bl = this.checker.checkAufnahme();
            this.aufnahmeChecker.setState(bl ? 11 : 10);
        } else {
            this.configChecker.setState(21);
        }
        if (DataBaseChecker.checkConfig) {
            this.checker.setProgressLabel(this.configLabel);
            bl = this.checker.checkConfig();
            this.configChecker.setState(bl ? 11 : 10);
        } else {
            this.configChecker.setState(21);
        }
        if (DataBaseChecker.checkKatNachw) {
            this.checker.setProgressLabel(this.katNachwLabel);
            bl = this.checker.checkKatasterNachweis();
            this.katNachwChecker.setState(bl ? 11 : 10);
        } else {
            this.katNachwChecker.setState(21);
        }
        if (DataBaseChecker.checkPunktLage) {
            this.checker.setProgressLabel(this.punktLageGenauigkeitLabel);
            bl = this.checker.checkPunktLageGenauigkeit();
            this.punktLageGenauigkeitChecker.setState(bl ? 11 : 10);
        } else {
            this.punktLageGenauigkeitChecker.setState(21);
        }
        if (DataBaseChecker.checkArt) {
            this.checker.setProgressLabel(this.artLabel);
            bl = this.checker.checkArt();
            this.artChecker.setState(bl ? 11 : 10);
        } else {
            this.artChecker.setState(21);
        }
        if (DataBaseChecker.checkTeilung) {
            this.checker.setProgressLabel(this.teilungLabel);
            bl = this.checker.checkTeilung();
            this.teilungChecker.setState(bl ? 11 : 10);
        } else {
            this.teilungChecker.setState(21);
        }
        if (DataBaseChecker.checkObjGeom) {
            this.checker.setProgressLabel(this.flstLabel);
            bl = this.checker.checkFlurstuecke();
            this.flstChecker.setState(bl ? 11 : 10);
        } else {
            this.flstChecker.setState(21);
        }
        if (DataBaseChecker.checkObjAtt) {
            this.checker.setProgressLabel(this.objAttLabel);
            bl = this.checker.checkObjAttribute();
            this.objAttChecker.setState(bl ? 11 : 10);
        } else {
            this.objAttChecker.setState(21);
        }
    }

    private IPanel createCheckPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.nrCheckbox = new Checkbox("Punktnummern", DataBaseChecker.checkNummer);
        iPanel.add(this.nrCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nrCheckbox, gridBagConstraints);
        Button button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(NUMMER_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.nrLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.nrLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.nrLabel, gridBagConstraints);
        this.nrChecker = new IChecker();
        iPanel.add(this.nrChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.nrChecker, gridBagConstraints);
        this.aufnahmeCheckbox = new Checkbox("Aufnahme", DataBaseChecker.checkAufnahme);
        iPanel.add(this.aufnahmeCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.aufnahmeCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(AUFNAHME_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.aufnahmeLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.aufnahmeLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.aufnahmeLabel, gridBagConstraints);
        this.aufnahmeChecker = new IChecker();
        iPanel.add(this.aufnahmeChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.aufnahmeChecker, gridBagConstraints);
        this.configCheckbox = new Checkbox("Konfiguration", DataBaseChecker.checkConfig);
        iPanel.add(this.configCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.configCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(CONFIG_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.configLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.configLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.configLabel, gridBagConstraints);
        this.configChecker = new IChecker();
        iPanel.add(this.configChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.configChecker, gridBagConstraints);
        this.katNachwCheckbox = new Checkbox("Katasternachweis", DataBaseChecker.checkKatNachw);
        iPanel.add(this.katNachwCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.katNachwCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(KATASTERNACHWEIS_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.katNachwLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.katNachwLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.katNachwLabel, gridBagConstraints);
        this.katNachwChecker = new IChecker();
        iPanel.add(this.katNachwChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.katNachwChecker, gridBagConstraints);
        this.punktLageGenauigkeitCheckbox = new Checkbox("Punktlagegenauigkeit", DataBaseChecker.checkPunktLage);
        iPanel.add(this.punktLageGenauigkeitCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.punktLageGenauigkeitCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(LAGEGENAUIGKEIT_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.punktLageGenauigkeitLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.punktLageGenauigkeitLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.punktLageGenauigkeitLabel, gridBagConstraints);
        this.punktLageGenauigkeitChecker = new IChecker();
        iPanel.add(this.punktLageGenauigkeitChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.punktLageGenauigkeitChecker, gridBagConstraints);
        this.artCheckbox = new Checkbox("Arten und Ebenen", DataBaseChecker.checkArt);
        iPanel.add(this.artCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.artCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(ART_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.artLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.artLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.artLabel, gridBagConstraints);
        this.artChecker = new IChecker();
        iPanel.add(this.artChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.artChecker, gridBagConstraints);
        this.teilungCheckbox = new Checkbox("Teilungsmessung", DataBaseChecker.checkTeilung);
        iPanel.add(this.teilungCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.teilungCheckbox, gridBagConstraints);
        this.teilungLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.teilungLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.teilungLabel, gridBagConstraints);
        this.teilungChecker = new IChecker();
        iPanel.add(this.teilungChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.teilungChecker, gridBagConstraints);
        this.flstCheckbox = new Checkbox("Objektgeometrie", DataBaseChecker.checkObjGeom);
        iPanel.add(this.flstCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.flstCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(FLST_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.flstLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.flstLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.flstLabel, gridBagConstraints);
        this.flstChecker = new IChecker();
        iPanel.add(this.flstChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.flstChecker, gridBagConstraints);
        this.objAttCheckbox = new Checkbox("Objektattribute", DataBaseChecker.checkObjAtt);
        iPanel.add(this.objAttCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.objAttCheckbox, gridBagConstraints);
        button = new Button(DETAIL_COMMAND);
        iPanel.add(button);
        button.setActionCommand(OBJATT_DETAIL_COMMAND);
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.objAttLabel = new Label(NO_ERROR, 2);
        iPanel.add(this.objAttLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.objAttLabel, gridBagConstraints);
        this.objAttChecker = new IChecker();
        iPanel.add(this.objAttChecker);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.objAttChecker, gridBagConstraints);
        this.progressBar = new IProgressBar();
        iPanel.add(this.progressBar);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button(DO_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(TAKE_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        Button button3 = new Button(OK_COMMAND);
        button3.addActionListener(this);
        panel.add(button3);
        Button button4 = new Button(ABORT_COMMAND);
        button4.addActionListener(this);
        panel.add(button4);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(OK_COMMAND) || string.equals(TAKE_COMMAND)) {
            if (this.checker != null) {
                this.saveErrors();
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                }
            }
            if (string.equals(OK_COMMAND)) {
                this.endDialog();
            }
        } else if (string.equals(ABORT_COMMAND)) {
            this.doAbortAction();
        } else if (string.equals(NUMMER_DETAIL_COMMAND)) {
            DataCheckNummerDetailDialog dataCheckNummerDetailDialog = new DataCheckNummerDetailDialog(this.parent, "Pr\u00fcfung Punktnummern");
            dataCheckNummerDetailDialog.setModal(false);
            dataCheckNummerDetailDialog.setVisible(true);
        } else if (string.equals(AUFNAHME_DETAIL_COMMAND)) {
            DataCheckAufnahmeDetailDialog dataCheckAufnahmeDetailDialog = new DataCheckAufnahmeDetailDialog(this.parent, "Pr\u00fcfung Aufnahme");
            dataCheckAufnahmeDetailDialog.setModal(false);
            dataCheckAufnahmeDetailDialog.setVisible(true);
        } else if (string.equals(CONFIG_DETAIL_COMMAND)) {
            DataCheckConfigDetailDialog dataCheckConfigDetailDialog = new DataCheckConfigDetailDialog(this.parent, "Pr\u00fcfung Konfiguration");
            dataCheckConfigDetailDialog.setModal(false);
            dataCheckConfigDetailDialog.setVisible(true);
        } else if (string.equals(KATASTERNACHWEIS_DETAIL_COMMAND)) {
            DataCheckKatasternachweisDetailDialog dataCheckKatasternachweisDetailDialog = new DataCheckKatasternachweisDetailDialog(this.parent, "Pr\u00fcfung Katasternachweis");
            dataCheckKatasternachweisDetailDialog.setModal(false);
            dataCheckKatasternachweisDetailDialog.setVisible(true);
        } else if (string.equals(LAGEGENAUIGKEIT_DETAIL_COMMAND)) {
            DataCheckLagegenauigkeitDetailDialog dataCheckLagegenauigkeitDetailDialog = new DataCheckLagegenauigkeitDetailDialog(this.parent, "Pr\u00fcfung Lagegenauigkeit");
            dataCheckLagegenauigkeitDetailDialog.setModal(false);
            dataCheckLagegenauigkeitDetailDialog.setVisible(true);
        } else if (string.equals(ART_DETAIL_COMMAND)) {
            DataCheckArtDetailDialog dataCheckArtDetailDialog = new DataCheckArtDetailDialog(this.parent, "Pr\u00fcfung Arten und Ebenen");
            dataCheckArtDetailDialog.setModal(false);
            dataCheckArtDetailDialog.setVisible(true);
        } else if (string.equals(FLST_DETAIL_COMMAND)) {
            DataCheckObjectDetailDialog dataCheckObjectDetailDialog = new DataCheckObjectDetailDialog(this.parent, "Pr\u00fcfung Objektgeometrie");
            dataCheckObjectDetailDialog.setModal(false);
            dataCheckObjectDetailDialog.setVisible(true);
        } else if (string.equals(OBJATT_DETAIL_COMMAND)) {
            DataCheckObjectAttributeDetailDialog dataCheckObjectAttributeDetailDialog = new DataCheckObjectAttributeDetailDialog(this.parent, "Pr\u00fcfung Objektattribute");
            dataCheckObjectAttributeDetailDialog.setModal(false);
            dataCheckObjectAttributeDetailDialog.setVisible(true);
        }
    }

    @Override
    protected void doStandardAction() {
        this.check();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    private void saveErrors() {
        if (this.checker != null) {
            DataBase.ERR.removeAllElements();
            Object object = this.exceptions.elements();
            while (object.hasMoreElements()) {
                DataBase.ERR.addElement(new ErrorObject("DataCheck", (GeomException)object.nextElement()));
            }
            object = new ErrorWriter(new File(KafPlotProperties.getCheckFileName() + ".err"), this.exceptions);
            ((ErrorWriter)object).setHeader("#Datencheck am " + new Date().toString());
            try {
                ((ErrorWriter)object).write();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

