/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataBaseChecker;
import de.geocalc.kafplot.PunktNummer;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class DataCheckNummerDetailDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private Checkbox nrIdCheckbox;
    private Checkbox umnumCheckbox;
    private Checkbox nbCheckbox;
    private Choice nrChoice;

    public DataCheckNummerDetailDialog(IFrame iFrame, String string) {
        super(iFrame, string);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.nrIdCheckbox = new Checkbox("Eindeutigkeit der Ausgabenummer", DataBaseChecker.checkNummerId);
        iPanel.add(this.nrIdCheckbox);
        this.nrIdCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.nrIdCheckbox, gridBagConstraints);
        this.nbCheckbox = new Checkbox("Nummerierungsbezirk der Ausgabenummer", DataBaseChecker.checkNummerNb);
        iPanel.add(this.nbCheckbox);
        this.nbCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.nbCheckbox, gridBagConstraints);
        this.umnumCheckbox = new Checkbox("umnummerierte Punktnummern", DataBaseChecker.checkUmnum);
        iPanel.add(this.umnumCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.umnumCheckbox.addItemListener(this);
        gridBagLayout.setConstraints(this.umnumCheckbox, gridBagConstraints);
        Label label = new Label("Punktnummernbildung f\u00fcr amtliche Punkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.nrChoice = new Choice();
        iPanel.add(this.nrChoice);
        this.nrChoice.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        int n = DataBase.model.getModel();
        this.nrChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.nrChoice.addItem(stringArray[i]);
        }
        this.nrChoice.select(PunktNummer.getLengthAsString(DataBaseChecker.nummerMode, n));
        gridBagLayout.setConstraints(this.nrChoice, gridBagConstraints);
        return iPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.umnumCheckbox.setEnabled(this.nrIdCheckbox.getState() || this.nbCheckbox.getState());
        this.nrChoice.setEnabled(this.nrIdCheckbox.getState() || this.nbCheckbox.getState());
        super.itemStateChanged(itemEvent);
    }

    @Override
    protected void setOptions() {
        DataBaseChecker.checkNummerId = this.nrIdCheckbox.getState();
        DataBaseChecker.checkNummerNb = this.nbCheckbox.getState();
        DataBaseChecker.checkUmnum = this.umnumCheckbox.getState();
        DataBaseChecker.nummerMode = PunktNummer.getLength(this.nrChoice.getSelectedItem());
    }
}

