/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IViewport;
import de.geocalc.geodata.Feature;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.Koordinate2D;
import de.geocalc.kafplot.OskaObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class DataContainer
implements PunktContainer,
OskaObject,
Exceptionable,
Cloneable,
Feature,
Koordinate2D {
    private Vector objects;
    private DRectangle dataRect = new DRectangle();
    private Color color;
    public double x = 0.0;
    public double y = 0.0;
    public double xt = 0.0;
    public double yt = 0.0;
    private boolean isVisible = true;
    private int oska = 0;
    private int folie = 0;
    private boolean isOn = true;

    public Object clone() throws CloneNotSupportedException {
        DataContainer dataContainer = (DataContainer)super.clone();
        dataContainer.objects = (Vector)this.objects.clone();
        return dataContainer;
    }

    public abstract int getId();

    @Override
    public void setX(double d) {
        this.x = d;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setY(double d) {
        this.y = d;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setXT(double d) {
        this.xt = d;
    }

    public double getXT() {
        return this.xt;
    }

    public void setYT(double d) {
        this.yt = d;
    }

    public double getYT() {
        return this.yt;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void setOn(boolean bl) {
        this.isOn = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean contains(Punkt punkt) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PunktContainer) || !((PunktContainer)e).contains(punkt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PunktContainer)) continue;
            PunktTable punktTable2 = ((PunktContainer)e).getPunkte();
            Enumeration enumeration2 = punktTable2.elements();
            while (enumeration2.hasMoreElements()) {
                punktTable.put((Punkt)enumeration2.nextElement());
            }
        }
        return punktTable;
    }

    public DPoint getPoint() {
        return new DPoint(this.y, this.x);
    }

    public abstract void initGeom();

    public Object firstElement() {
        if (this.objects == null) {
            throw new NoSuchElementException();
        }
        return this.objects.firstElement();
    }

    public Object elementAt(int n) {
        if (this.objects == null) {
            throw new NoSuchElementException();
        }
        return this.objects.elementAt(n);
    }

    public Object lastElement() {
        if (this.objects == null) {
            throw new NoSuchElementException();
        }
        return this.objects.lastElement();
    }

    public Enumeration elements() {
        if (this.objects == null) {
            return new Enumeration(this){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }
        return this.objects.elements();
    }

    public void addElement(Object object) {
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(object);
    }

    public void insertElementAt(Object object, int n) {
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.insertElementAt(object, n);
    }

    public void setElementAt(Object object, int n) {
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.setElementAt(object, n);
    }

    public int size() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    public boolean contains(Object object) {
        if (this.objects == null) {
            return false;
        }
        return this.objects.contains(object);
    }

    public int indexOf(Object object) {
        if (this.objects == null) {
            return -1;
        }
        return this.objects.indexOf(object);
    }

    public void removeElement(Object object) {
        if (this.objects == null) {
            return;
        }
        this.objects.removeElement(object);
    }

    public void removeElementAt(int n) {
        if (this.objects == null) {
            return;
        }
        this.objects.removeElementAt(n);
    }

    public void removeAllElements() {
        if (this.objects == null) {
            return;
        }
        this.objects.removeAllElements();
        this.dataRect = new DRectangle();
    }

    public void packMemory() {
        if (this.objects != null) {
            this.objects.trimToSize();
        }
    }

    public void removeData(Vector vector) {
        if (this.objects == null) {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            for (int j = vector.size() - 1; j >= 0; --j) {
                if (vector.elementAt(j) != this.elementAt(i)) continue;
                this.removeElementAt(i);
                vector.removeElementAt(j);
                if (vector.size() != 0) continue;
                return;
            }
        }
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isViewable(IViewport iViewport) {
        if (this.dataRect == null) {
            return false;
        }
        return iViewport.intersects(this.dataRect);
    }

    public final DPoint getHashPoint() {
        return this.hasTextLocation() ? new DPoint(this.yt, this.xt) : new DPoint(this.y, this.x);
    }

    @Override
    public final void setOska(int n) {
        this.oska = n;
    }

    @Override
    public final int getOska() {
        return this.oska;
    }

    public final String getOskaAsString() {
        return Integer.toString(this.oska);
    }

    @Override
    public final void setFolie(int n) {
        this.folie = n;
    }

    @Override
    public final int getFolie() {
        return this.folie;
    }

    public final String getFolieAsString() {
        return IFormat.i03.format(this.folie).toString();
    }

    public boolean hasLocation() {
        return this.y != 0.0 && !Double.isNaN(this.y) && !Double.isInfinite(this.y) && this.x != 0.0 && !Double.isNaN(this.x) && !Double.isInfinite(this.x);
    }

    public void removeLocation() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public void setLocation(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    public boolean hasTextLocation() {
        return this.yt != 0.0 && this.xt != 0.0;
    }

    public abstract String getName();

    public abstract void writeObject(DataOutput var1) throws IOException;

    protected void setBounds(DRectangle dRectangle) {
        this.dataRect = dRectangle;
    }

    protected void setBounds(double d, double d2, double d3, double d4) {
        this.dataRect.y = d;
        this.dataRect.x = d2;
        this.dataRect.width = d3;
        this.dataRect.height = d4;
    }

    @Override
    public DRectangle getBounds() {
        return this.dataRect;
    }

    public DDimension getSize() {
        return new DDimension(this.dataRect.width, this.dataRect.height);
    }

    public boolean boundsContains(double d, double d2) {
        return this.dataRect != null ? this.dataRect.contains(d, d2) : false;
    }

    @Override
    public abstract String getClassName();

    @Override
    public abstract String getObjectName();

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public abstract String toDebugString();
}

