/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geodata.Feature;
import de.geocalc.geodata.FeatureVector;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.ObjectEnumerator;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DataContainerTable
extends Vector
implements PunktContainer,
FeatureVector {
    private DRectangle dataRect;

    public DataContainerTable() {
        super(50, 200);
    }

    @Override
    public abstract void put(Feature var1) throws GeomException;

    @Override
    public Vector getFeatureParts(Feature feature) {
        return new Vector();
    }

    public void remove(DataContainer dataContainer) {
        super.removeElement(dataContainer);
    }

    public void removeData(Vector vector) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (vector.size() == 0) {
                return;
            }
            ((DataContainer)enumeration.nextElement()).removeData(vector);
        }
    }

    @Override
    public boolean contains(Punkt punkt) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (!((PunktContainer)enumeration.nextElement()).contains(punkt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PunktTable punktTable2 = ((DataContainer)enumeration.nextElement()).getPunkte();
            Enumeration enumeration2 = punktTable2.elements();
            while (enumeration2.hasMoreElements()) {
                punktTable.put((Punkt)enumeration.nextElement());
            }
        }
        return punktTable;
    }

    @Override
    public DRectangle getBounds() {
        return this.dataRect;
    }

    public int countObjects() {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            n += ((DataContainer)enumeration.nextElement()).size();
        }
        return n;
    }

    public Enumeration objects() {
        return this.dataObjects();
    }

    public Enumeration dataObjects() {
        return new ObjectEnumerator(this);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((DataContainer)enumeration.nextElement()).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DatContainer datContainer = (DatContainer)enumeration.nextElement();
            if (KafkaIOProperties.writeMenge && !KafkaIOProperties.getMenge().intersect(((PunktContainer)((Object)datContainer)).getPunkte(), KafkaIOProperties.writeFullMengeObjects ? PunktTable.INTERSECT_ALL : PunktTable.INTERSECT_ONE)) continue;
            datContainer.writeDatContainer(printWriter);
        }
    }

    public void sort() {
        Object[] objectArray = (Object[])this.elementData.clone();
        DataContainerTable.mergeSort(objectArray, this.elementData, 0, this.elementCount);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray2[j - 1]).compareTo((Comparable)objectArray2[j]) > 0; --j) {
                    DataContainerTable.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = n + n2 >> 1;
        DataContainerTable.mergeSort(objectArray2, objectArray, n, n4);
        DataContainerTable.mergeSort(objectArray2, objectArray, n4, n2);
        if (((Comparable)objectArray[n4 - 1]).compareTo((Comparable)objectArray[n4]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n6 >= n2 || n5 < n4 && ((Comparable)objectArray[n5]).compareTo(objectArray[n6]) <= 0 ? objectArray[n5++] : objectArray[n6++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

