/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import java.awt.Color;
import java.util.Enumeration;

public final class Ebene
implements IntegerHashObject {
    public static final int OHNE = -1;
    public static final int UNDEF = 0;
    public static final int GRENZEN = 1;
    public static final int GEBAEUDE = 2;
    public static final int GRENZEINRICHTUNGEN = 3;
    public static final int STRASSEN = 4;
    public static final int GELAENDE = 5;
    public static final int HOEHEN = 6;
    public static final int NUTZUNGSARTEN = 7;
    public static final int GEWAESSER = 8;
    public static final int KONSTRUKTIONEN = 9;
    public static final int VERKEHR = 10;
    public static final int EISENBAHN = 11;
    public static final int STRASSENBAHN = 12;
    public static final int HOEHENFESTPUNKTE = 18;
    public static final int LAGEFESTPUNKTE = 19;
    public static final int GRENZEN_FZG = 41;
    public static final int GEBAEUDE_NEU = 42;
    public static final int NUTZUNG = 47;
    public static final int GRENZEN_NEU = 48;
    public static final int GRENZEN_DIG = 49;
    public static final int RISS = 50;
    public static final int BODENSCHAETZUNG = 61;
    public static final int LAGEFESTPUNKTE_NEU = 59;
    private static IntegerHashList ebenen = new IntegerHashList(21);
    private int eb;
    private String name;
    private Color color;
    private Color fcolor;

    public static Ebene getEbene(int n) {
        return (Ebene)ebenen.get(n);
    }

    public static int getEbene(String string) {
        Enumeration enumeration = ebenen.elements();
        while (enumeration.hasMoreElements()) {
            Ebene ebene = (Ebene)enumeration.nextElement();
            if (!ebene.getName().equals(string)) continue;
            return ebene.getNummer();
        }
        return 0;
    }

    public static String getEbeneName(int n) {
        Ebene ebene = Ebene.getEbene(n);
        if (ebene != null) {
            return ebene.getName();
        }
        return "Ohne";
    }

    public static Color getColor(int n) {
        Ebene ebene = Ebene.getEbene(n);
        if (ebene != null) {
            return ebene.getColor();
        }
        return Color.black;
    }

    public static Color getFlaecheColor(int n) {
        Ebene ebene = Ebene.getEbene(n);
        if (ebene != null) {
            return ebene.getFlaecheColor();
        }
        return Color.lightGray;
    }

    public static String getItem(int n) {
        return IFormat.i02.format(n) + "  " + Ebene.getEbeneName(n);
    }

    public static String toIdString(int n) {
        return n > 0 ? Integer.toString(n) : "";
    }

    public static String toString(int n) {
        return Ebene.getEbeneName(n);
    }

    public static Enumeration ebenen() {
        return ebenen.elements();
    }

    public static Enumeration sortedElements() {
        return ebenen.sortedElements();
    }

    public static int getDefaultEbene(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: 
            case 8: {
                return 19;
            }
            case 9: {
                return 18;
            }
        }
        return 0;
    }

    public static int getChangeKatEbene(int n) {
        switch (n) {
            case 41: 
            case 48: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 59: {
                return 19;
            }
        }
        return n;
    }

    public Ebene(int n, String string, Color color, Color color2) {
        this.eb = n;
        this.name = string;
        this.color = color;
        this.fcolor = color2;
    }

    @Override
    public final int intHashKey() {
        return this.eb;
    }

    public int getNummer() {
        return this.eb;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getFlaecheColor() {
        return this.fcolor;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.eb)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("ebene", stringArray);
    }

    static {
        ebenen.put(new Ebene(0, "ohne", new Color(176, 176, 176), new Color(192, 192, 192)));
        ebenen.put(new Ebene(1, "Grenzen", new Color(0, 0, 0), new Color(255, 255, 208)));
        ebenen.put(new Ebene(2, "Geb\u00e4ude", new Color(255, 96, 96), new Color(255, 192, 192)));
        ebenen.put(new Ebene(3, "Grenzeinrichtungen", new Color(240, 160, 0), new Color(240, 224, 128)));
        ebenen.put(new Ebene(4, "Stra\u00dfen", new Color(208, 0, 208), new Color(255, 176, 255)));
        ebenen.put(new Ebene(5, "Gel\u00e4nde", new Color(208, 112, 0), new Color(255, 192, 176)));
        ebenen.put(new Ebene(6, "H\u00f6hen", new Color(208, 112, 0), new Color(255, 192, 176)));
        ebenen.put(new Ebene(7, "Nutzungsarten", new Color(0, 208, 64), new Color(176, 255, 192)));
        ebenen.put(new Ebene(8, "Gew\u00e4sser", new Color(0, 0, 255), new Color(192, 192, 255)));
        ebenen.put(new Ebene(9, "Konstruktionen", new Color(255, 224, 0), new Color(255, 255, 224)));
        ebenen.put(new Ebene(10, "Verkehr", new Color(255, 128, 192), new Color(255, 240, 240)));
        ebenen.put(new Ebene(11, "Eisenbahn", new Color(128, 128, 128), new Color(240, 240, 240)));
        ebenen.put(new Ebene(12, "Stra\u00dfenbahn", new Color(128, 128, 128), new Color(240, 240, 240)));
        ebenen.put(new Ebene(18, "H\u00f6henfestpunkte", new Color(128, 128, 128), new Color(240, 240, 240)));
        ebenen.put(new Ebene(19, "Lagefestpunkte", new Color(0, 0, 0), new Color(240, 240, 240)));
        ebenen.put(new Ebene(41, "festzustellende Grenzen", new Color(32, 32, 32), new Color(255, 255, 208)));
        ebenen.put(new Ebene(42, "neue Geb\u00e4ude", new Color(224, 0, 0), new Color(255, 124, 124)));
        ebenen.put(new Ebene(47, "Nutzung", new Color(80, 176, 176), new Color(255, 255, 208)));
        ebenen.put(new Ebene(48, "neue Grenzen", new Color(224, 0, 0), new Color(255, 255, 208)));
        ebenen.put(new Ebene(49, "digitalisierte Grenzen", new Color(160, 160, 160), new Color(255, 255, 208)));
        ebenen.put(new Ebene(50, "Riss", new Color(0, 192, 192), new Color(192, 240, 240)));
        ebenen.put(new Ebene(61, "Bodensch\u00e4tzung", new Color(120, 175, 75), new Color(190, 220, 175)));
        ebenen.put(new Ebene(59, "neue Lagefestpunkte", new Color(224, 0, 0), new Color(255, 255, 208)));
    }
}

