/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.Hoehestatus;
import de.geocalc.kafplot.Koostatus;
import de.geocalc.kafplot.Lagestatus;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.util.Sortable;
import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EdbsImportOptionDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private static final String HELP_TEXT = "Die Punkte k\u00f6nnen mehrere Koordinaten in unterschiedlichen Systemen enthalten. W\u00e4hlen Sie die zu \u00fcbernehmenden Systeme aus. Sind mehrere Systeme ausgew\u00e4hlt, wird das mit dem h\u00f6herwertigen Status \u00fcbernommen.";
    private Hashtable lsTable;
    private Hashtable hsTable;
    private List lstatusList;
    private List hstatusList;
    private FlowText helpText;
    private Checkbox generateOskaCheckbox;

    public EdbsImportOptionDialog(IFrame iFrame, String string, Hashtable hashtable, Hashtable hashtable2) {
        super(iFrame, string, false);
        this.lsTable = hashtable;
        this.hsTable = hashtable2;
        this.createList(this.lstatusList, hashtable);
        this.createList(this.hstatusList, hashtable2);
        this.pack();
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        Label label = new Label("Lagestatus:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("H\u00f6henstatus:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.lstatusList = new List(10, true);
        iPanel.add(this.lstatusList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lstatusList, gridBagConstraints);
        this.hstatusList = new List(10, true);
        iPanel.add(this.hstatusList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hstatusList, gridBagConstraints);
        this.helpText = new FlowText(HELP_TEXT, false);
        iPanel.add(this.helpText);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.helpText, gridBagConstraints);
        this.generateOskaCheckbox = new Checkbox("Oskaschl\u00fcssel generieren", EdbsIOProperties.isInStandardGenerateOska());
        iPanel.add(this.generateOskaCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.generateOskaCheckbox, gridBagConstraints);
        return iPanel;
    }

    private void createList(List list, Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Vector<Sortable> vector = new Vector<Sortable>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Sortable sortable = (Sortable)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!sortable.isLt((Sortable)vector.elementAt(i))) continue;
                vector.insertElementAt(sortable, i);
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(sortable);
        }
        for (int i = 0; i < vector.size(); ++i) {
            list.add(GeoNumberFormat.nr03n.format(((Koostatus)vector.elementAt(i)).getValue()).toString());
            list.select(i);
        }
    }

    @Override
    public void setOptions() {
        int n;
        for (n = 0; n < this.lstatusList.getItemCount(); ++n) {
            if (this.lstatusList.isSelected(n)) continue;
            this.lsTable.remove(new Lagestatus(Integer.parseInt(this.lstatusList.getItem(n))));
        }
        for (n = 0; n < this.hstatusList.getItemCount(); ++n) {
            if (this.hstatusList.isSelected(n)) continue;
            this.hsTable.remove(new Hoehestatus(Integer.parseInt(this.hstatusList.getItem(n))));
        }
        EdbsIOProperties.setInGenerateOska(this.generateOskaCheckbox.getState());
    }
}

